/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.grpc.metrics;

import org.apache.hadoop.ozone.grpc.metrics.GrpcMetrics;
import org.apache.hadoop.ozone.shaded.io.grpc.ForwardingServerCall;
import org.apache.hadoop.ozone.shaded.io.grpc.Metadata;
import org.apache.hadoop.ozone.shaded.io.grpc.ServerCall;
import org.apache.hadoop.ozone.shaded.io.grpc.ServerCallHandler;
import org.apache.hadoop.ozone.shaded.io.grpc.ServerInterceptor;
import org.apache.hadoop.shaded.com.google.protobuf.AbstractMessage;

public class GrpcMetricsServerResponseInterceptor
implements ServerInterceptor {
    private final GrpcMetrics grpcMetrics;

    public GrpcMetricsServerResponseInterceptor(GrpcMetrics grpcMetrics) {
        this.grpcMetrics = grpcMetrics;
    }

    @Override
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata headers, ServerCallHandler<ReqT, RespT> serverCallHandler) {
        return serverCallHandler.startCall(new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(serverCall){

            @Override
            public void sendMessage(RespT message) {
                long messageSize = 0L;
                if (message instanceof AbstractMessage) {
                    AbstractMessage parsedMessage = (AbstractMessage)message;
                    messageSize += (long)parsedMessage.getSerializedSize();
                } else {
                    GrpcMetricsServerResponseInterceptor.this.grpcMetrics.incrUnknownMessagesSent();
                }
                GrpcMetricsServerResponseInterceptor.this.grpcMetrics.incrSentBytes(messageSize);
                super.sendMessage(message);
            }
        }, headers);
    }
}

