/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.io;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyOutputStreamSemaphore {
    public static final Logger LOG = LoggerFactory.getLogger(KeyOutputStreamSemaphore.class);
    private final Semaphore requestSemaphore;

    KeyOutputStreamSemaphore(int maxConcurrentWritePerKey) {
        LOG.debug("Initializing semaphore with maxConcurrentWritePerKey = {}", (Object)maxConcurrentWritePerKey);
        if (maxConcurrentWritePerKey > 0) {
            this.requestSemaphore = new Semaphore(maxConcurrentWritePerKey);
        } else {
            if (maxConcurrentWritePerKey == 0) {
                throw new IllegalArgumentException("Invalid config. ozone.client.key.write.concurrency cannot be set to 0");
            }
            this.requestSemaphore = null;
        }
    }

    public int getQueueLength() {
        return this.requestSemaphore != null ? this.requestSemaphore.getQueueLength() : 0;
    }

    public void acquire() throws IOException {
        if (this.requestSemaphore != null) {
            try {
                LOG.debug("Acquiring semaphore");
                this.requestSemaphore.acquire();
                LOG.debug("Acquired semaphore");
            }
            catch (InterruptedException e) {
                String errMsg = "Write aborted. Interrupted waiting for KeyOutputStream semaphore: " + e.getMessage();
                LOG.error(errMsg);
                Thread.currentThread().interrupt();
                throw new InterruptedIOException(errMsg);
            }
        }
    }

    public void release() {
        if (this.requestSemaphore != null) {
            LOG.debug("Releasing semaphore");
            this.requestSemaphore.release();
            LOG.debug("Released semaphore");
        }
    }
}

