/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.io;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.client.ContainerBlockID;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.client.StandaloneReplicationConfig;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.OzoneClientConfig;
import org.apache.hadoop.hdds.scm.XceiverClientFactory;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.storage.BlockExtendedInputStream;
import org.apache.hadoop.hdds.scm.storage.BlockLocationInfo;
import org.apache.hadoop.hdds.scm.storage.ByteReaderStrategy;
import org.apache.hadoop.ozone.client.io.BadDataLocationException;
import org.apache.hadoop.ozone.client.io.BlockInputStreamFactory;
import org.apache.hadoop.ozone.client.io.ECBlockInputStreamProxy;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.ozone.shaded.com.google.common.collect.ImmutableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ECBlockInputStream
extends BlockExtendedInputStream {
    private static final Logger LOG = LoggerFactory.getLogger(ECBlockInputStream.class);
    private final ECReplicationConfig repConfig;
    private final int ecChunkSize;
    private final long stripeSize;
    private final BlockInputStreamFactory streamFactory;
    private final XceiverClientFactory xceiverClientFactory;
    private final Function<BlockID, BlockLocationInfo> refreshFunction;
    private final BlockLocationInfo blockInfo;
    private final DatanodeDetails[] dataLocations;
    private final BlockExtendedInputStream[] blockStreams;
    private final Map<Integer, LinkedList<DatanodeDetails>> spareDataLocations = new TreeMap<Integer, LinkedList<DatanodeDetails>>();
    private final List<DatanodeDetails> failedLocations = new ArrayList<DatanodeDetails>();
    private final int maxLocations;
    private final String string;
    private long position = 0L;
    private boolean closed = false;
    private boolean seeked = false;
    private OzoneClientConfig config;

    protected ECReplicationConfig getRepConfig() {
        return this.repConfig;
    }

    protected DatanodeDetails[] getDataLocations() {
        return this.dataLocations;
    }

    protected long getStripeSize() {
        return this.stripeSize;
    }

    protected int availableDataLocations(int expectedLocations) {
        int count = 0;
        for (int i = 0; i < this.repConfig.getData() && i < expectedLocations; ++i) {
            if (this.dataLocations[i] == null) continue;
            ++count;
        }
        return count;
    }

    public ECBlockInputStream(ECReplicationConfig repConfig, BlockLocationInfo blockInfo, XceiverClientFactory xceiverClientFactory, Function<BlockID, BlockLocationInfo> refreshFunction, BlockInputStreamFactory streamFactory, OzoneClientConfig config) {
        this.repConfig = repConfig;
        this.ecChunkSize = repConfig.getEcChunkSize();
        this.blockInfo = blockInfo;
        this.streamFactory = streamFactory;
        this.xceiverClientFactory = xceiverClientFactory;
        this.refreshFunction = refreshFunction;
        this.maxLocations = repConfig.getData() + repConfig.getParity();
        this.dataLocations = new DatanodeDetails[repConfig.getRequiredNodes()];
        this.blockStreams = new BlockExtendedInputStream[repConfig.getRequiredNodes()];
        this.config = config;
        this.stripeSize = (long)this.ecChunkSize * (long)repConfig.getData();
        this.setBlockLocations(this.blockInfo.getPipeline());
        this.string = this.getClass().getSimpleName() + "{" + this.blockIdForDebug() + "}@" + Integer.toHexString(this.hashCode());
        LOG.debug("{}: config: {}, locations: {} / {}", new Object[]{this, repConfig, this.dataLocations, this.spareDataLocations});
    }

    public synchronized boolean hasSufficientLocations() {
        int expectedDataBlocks = this.calculateExpectedDataBlocks(this.repConfig);
        return expectedDataBlocks == this.availableDataLocations(expectedDataBlocks);
    }

    protected int calculateExpectedDataBlocks(ECReplicationConfig rConfig) {
        return ECBlockInputStreamProxy.expectedDataLocations(rConfig, this.getLength());
    }

    protected int currentStreamIndex() {
        return (int)(this.position / (long)this.ecChunkSize % (long)this.repConfig.getData());
    }

    protected BlockExtendedInputStream getOrOpenStream(int locationIndex) throws IOException {
        BlockExtendedInputStream stream = this.blockStreams[locationIndex];
        if (stream == null) {
            DatanodeDetails dataLocation = this.dataLocations[locationIndex];
            Pipeline pipeline = Pipeline.newBuilder().setReplicationConfig(StandaloneReplicationConfig.getInstance(HddsProtos.ReplicationFactor.ONE)).setNodes(Arrays.asList(dataLocation)).setId(PipelineID.valueOf(dataLocation.getUuid())).setReplicaIndexes(ImmutableMap.of(dataLocation, locationIndex + 1)).setState(Pipeline.PipelineState.CLOSED).build();
            BlockLocationInfo blkInfo = new BlockLocationInfo.Builder().setBlockID(this.blockInfo.getBlockID()).setLength(ECBlockInputStream.internalBlockLength(locationIndex + 1, this.repConfig, this.blockInfo.getLength())).setPipeline(this.blockInfo.getPipeline()).setToken(this.blockInfo.getToken()).setPartNumber(this.blockInfo.getPartNumber()).build();
            this.blockStreams[locationIndex] = stream = this.streamFactory.create(StandaloneReplicationConfig.getInstance(HddsProtos.ReplicationFactor.ONE), blkInfo, pipeline, this.blockInfo.getToken(), this.xceiverClientFactory, this.ecPipelineRefreshFunction(locationIndex + 1, this.refreshFunction), this.config);
            LOG.debug("{}: created stream [{}]: {}", new Object[]{this, locationIndex, stream});
        }
        return stream;
    }

    protected Function<BlockID, BlockLocationInfo> ecPipelineRefreshFunction(int replicaIndex, Function<BlockID, BlockLocationInfo> refreshFunc) {
        return blockID -> {
            BlockLocationInfo blockLocationInfo = (BlockLocationInfo)refreshFunc.apply((BlockID)blockID);
            if (blockLocationInfo == null) {
                return null;
            }
            Pipeline ecPipeline = blockLocationInfo.getPipeline();
            DatanodeDetails curIndexNode = ecPipeline.getNodes().stream().filter(dn -> ecPipeline.getReplicaIndex((DatanodeDetails)dn) == replicaIndex).findAny().orElse(null);
            if (curIndexNode == null) {
                return null;
            }
            Pipeline pipeline = Pipeline.newBuilder().setReplicationConfig(StandaloneReplicationConfig.getInstance(HddsProtos.ReplicationFactor.ONE)).setNodes(Collections.singletonList(curIndexNode)).setId(PipelineID.randomId()).setReplicaIndexes(Collections.singletonMap(curIndexNode, replicaIndex)).setState(Pipeline.PipelineState.CLOSED).build();
            blockLocationInfo.setPipeline(pipeline);
            return blockLocationInfo;
        };
    }

    public static long internalBlockLength(int index, ECReplicationConfig repConfig, long length) {
        if (index <= 0) {
            throw new IllegalArgumentException("Index must start from 1.");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("Block length cannot be negative.");
        }
        long ecChunkSize = repConfig.getEcChunkSize();
        long stripeSize = ecChunkSize * (long)repConfig.getData();
        long lastStripe = length % stripeSize;
        long blockSize = (length - lastStripe) / (long)repConfig.getData();
        long lastCell = lastStripe / ecChunkSize + 1L;
        long lastCellLength = lastStripe % ecChunkSize;
        if (index > repConfig.getData()) {
            index = 1;
        }
        if ((long)index < lastCell) {
            return blockSize + ecChunkSize;
        }
        if ((long)index == lastCell) {
            return blockSize + lastCellLength;
        }
        return blockSize;
    }

    private void setBlockLocations(Pipeline pipeline) {
        for (DatanodeDetails node : pipeline.getNodes()) {
            int index = pipeline.getReplicaIndex(node);
            this.addBlockLocation(index, node);
        }
    }

    private void addBlockLocation(int index, DatanodeDetails location) {
        if (index > this.maxLocations) {
            throw new IndexOutOfBoundsException("The index " + index + " is greater than the EC Replication Config (" + this.repConfig + ")");
        }
        int arrayIndex = index - 1;
        if (this.dataLocations[arrayIndex] == null) {
            this.dataLocations[arrayIndex] = location;
        } else {
            this.spareDataLocations.computeIfAbsent(arrayIndex, k -> new LinkedList()).add(location);
        }
    }

    protected long blockLength() {
        return this.blockInfo.getLength();
    }

    protected long remaining() {
        return this.blockLength() - this.position;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        return this.read(ByteBuffer.wrap(b, off, len));
    }

    @Override
    public synchronized int read(ByteBuffer byteBuffer) throws IOException {
        while (true) {
            int currentBufferPosition = byteBuffer.position();
            long currentPosition = this.getPos();
            try {
                return super.read(byteBuffer);
            }
            catch (BadDataLocationException e) {
                int failedIndex = e.getFailedLocationIndex();
                if (LOG.isDebugEnabled()) {
                    String cause = e.getCause() != null ? " due to " + e.getCause().getMessage() : "";
                    LOG.debug("{}: read [{}] failed from {}{}", new Object[]{this, failedIndex, this.dataLocations[failedIndex], cause});
                }
                this.closeStream(failedIndex);
                if (this.shouldRetryFailedRead(failedIndex)) {
                    byteBuffer.position(currentBufferPosition);
                    this.seek(currentPosition);
                    continue;
                }
                e.addFailedLocations(this.failedLocations);
                throw e;
            }
            break;
        }
    }

    protected boolean shouldRetryFailedRead(int failedIndex) {
        Deque spareLocations = this.spareDataLocations.get(failedIndex);
        if (spareLocations != null && !spareLocations.isEmpty()) {
            DatanodeDetails spare;
            this.failedLocations.add(this.dataLocations[failedIndex]);
            this.dataLocations[failedIndex] = spare = (DatanodeDetails)spareLocations.removeFirst();
            LOG.debug("{}: switching [{}] to spare {}", new Object[]{this, failedIndex, spare});
            return true;
        }
        return false;
    }

    @Override
    protected synchronized int readWithStrategy(ByteReaderStrategy strategy) throws IOException {
        Preconditions.checkArgument(strategy != null);
        this.checkOpen();
        if (this.remaining() == 0L) {
            return -1;
        }
        int totalRead = 0;
        while (strategy.getTargetLength() > 0 && this.remaining() > 0L) {
            int currentIndex = this.currentStreamIndex();
            try {
                BlockExtendedInputStream stream = this.getOrOpenStream(currentIndex);
                int read = this.readFromStream(stream, strategy);
                LOG.trace("{}: read {} bytes for [{}]", new Object[]{this, read, currentIndex});
                totalRead += read;
                this.position += (long)read;
            }
            catch (IOException ioe) {
                throw new BadDataLocationException(this.dataLocations[currentIndex], currentIndex, (Throwable)ioe);
            }
        }
        return totalRead;
    }

    @Override
    public synchronized long getLength() {
        return this.blockInfo.getLength();
    }

    @Override
    public BlockID getBlockID() {
        return this.blockInfo.getBlockID();
    }

    protected void seekStreamIfNecessary(BlockExtendedInputStream stream, long partialChunkSize) throws IOException {
        long basePosition;
        long streamPosition;
        if (this.seeked && (streamPosition = (basePosition = this.position / this.stripeSize * (long)this.ecChunkSize) + partialChunkSize) != stream.getPos()) {
            stream.seek(streamPosition);
        }
    }

    private int readFromStream(BlockExtendedInputStream stream, ByteReaderStrategy strategy) throws IOException {
        long partialPosition = this.position % (long)this.ecChunkSize;
        this.seekStreamIfNecessary(stream, partialPosition);
        long ecLimit = (long)this.ecChunkSize - partialPosition;
        long bufLimit = strategy.getTargetLength();
        int expectedRead = (int)Math.min(Math.min(ecLimit, bufLimit), this.remaining());
        int actualRead = strategy.readFromBlock(stream, expectedRead);
        if (actualRead == -1) {
            throw new IOException("Expected to read " + expectedRead + " but got EOF from blockGroup " + stream.getBlockID() + " index " + this.currentStreamIndex() + 1);
        }
        return actualRead;
    }

    private void checkOpen() throws IOException {
        if (this.closed) {
            throw new IOException(": Stream is closed! Block: " + this.blockInfo.getBlockID());
        }
    }

    @Override
    public synchronized void close() {
        LOG.debug("{}: close", (Object)this);
        this.closeStreams();
        this.closed = true;
    }

    protected synchronized void closeStreams() {
        for (int i = 0; i < this.blockStreams.length; ++i) {
            this.closeStream(i);
        }
        this.seeked = true;
    }

    protected void closeStream(int i) {
        if (this.blockStreams[i] != null) {
            try {
                this.blockStreams[i].close();
                this.blockStreams[i] = null;
                LOG.debug("{}: closed stream [{}]", (Object)this, (Object)i);
            }
            catch (IOException e) {
                LOG.error("{}: failed to close stream [{}]: {}", new Object[]{this, i, this.blockStreams[i], e});
            }
        }
    }

    public synchronized void unbuffer() {
        LOG.trace("{}: unbuffer", (Object)this);
        for (BlockExtendedInputStream stream : this.blockStreams) {
            if (stream == null) continue;
            stream.unbuffer();
        }
    }

    @Override
    public synchronized void seek(long pos) throws IOException {
        LOG.trace("{}: seek({})", (Object)this, (Object)pos);
        this.checkOpen();
        if (pos < 0L || pos > this.getLength()) {
            if (pos == 0L) {
                return;
            }
            throw new EOFException("EOF encountered at pos: " + pos + " for block: " + this.blockInfo.getBlockID());
        }
        this.position = pos;
        this.seeked = true;
    }

    @Override
    public synchronized long getPos() {
        return this.position;
    }

    protected synchronized void setPos(long pos) {
        LOG.trace("{}: setPos({})", (Object)this, (Object)pos);
        this.position = pos;
    }

    @Override
    public synchronized boolean seekToNewSource(long l) throws IOException {
        return false;
    }

    protected ContainerBlockID blockIdForDebug() {
        return this.getBlockID().getContainerBlockID();
    }

    public String toString() {
        return this.string;
    }
}

