/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.function.Supplier;
import org.apache.hadoop.fs.Syncable;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.ContainerClientMetrics;
import org.apache.hadoop.hdds.scm.OzoneClientConfig;
import org.apache.hadoop.hdds.scm.StreamBufferArgs;
import org.apache.hadoop.hdds.scm.XceiverClientFactory;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.storage.BlockOutputStream;
import org.apache.hadoop.hdds.scm.storage.BufferPool;
import org.apache.hadoop.hdds.scm.storage.RatisBlockOutputStream;
import org.apache.hadoop.hdds.security.token.OzoneBlockTokenIdentifier;
import org.apache.hadoop.ozone.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.ozone.util.MetricUtil;
import org.apache.hadoop.security.token.Token;
import org.apache.ratis.util.JavaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockOutputStreamEntry
extends OutputStream {
    public static final Logger LOG = LoggerFactory.getLogger(BlockOutputStreamEntry.class);
    private final OzoneClientConfig config;
    private BlockOutputStream outputStream;
    private BlockID blockID;
    private final String key;
    private final XceiverClientFactory xceiverClientManager;
    private final Pipeline pipeline;
    private final long length;
    private long currentPosition;
    private final Token<OzoneBlockTokenIdentifier> token;
    private final BufferPool bufferPool;
    private final ContainerClientMetrics clientMetrics;
    private final StreamBufferArgs streamBufferArgs;
    private final Supplier<ExecutorService> executorServiceSupplier;
    private volatile boolean isHandlingRetry;
    private AtomicInteger inflightCalls = new AtomicInteger();

    BlockOutputStreamEntry(Builder b) {
        this.config = b.config;
        this.outputStream = null;
        this.blockID = b.blockID;
        this.key = b.key;
        this.xceiverClientManager = b.xceiverClientManager;
        this.pipeline = b.pipeline;
        this.token = b.token;
        this.length = b.length;
        this.currentPosition = 0L;
        this.bufferPool = b.bufferPool;
        this.clientMetrics = b.clientMetrics;
        this.streamBufferArgs = b.streamBufferArgs;
        this.executorServiceSupplier = b.executorServiceSupplier;
        this.isHandlingRetry = b.forRetry;
    }

    public String toString() {
        return JavaUtils.getClassSimpleName(this.getClass()) + ":" + this.key + " " + this.blockID;
    }

    void checkStream() throws IOException {
        if (!this.isInitialized()) {
            this.createOutputStream();
        }
    }

    void registerCallReceived() {
        this.inflightCalls.incrementAndGet();
    }

    boolean registerCallFinished() {
        return this.inflightCalls.decrementAndGet() == 0;
    }

    void waitForRetryHandling(Condition retryHandlingCond) throws InterruptedException {
        while (this.isHandlingRetry) {
            LOG.info("{} : Block to wait for retry handling.", (Object)this);
            retryHandlingCond.await();
            LOG.info("{} : Done waiting for retry handling.", (Object)this);
        }
    }

    void finishRetryHandling(Condition retryHandlingCond) {
        LOG.info("{}: Exiting retry handling mode", (Object)this);
        this.isHandlingRetry = false;
        retryHandlingCond.signalAll();
    }

    void waitForAllPendingFlushes() throws IOException {
        this.outputStream.waitForAllPendingFlushes();
    }

    void createOutputStream() throws IOException {
        this.outputStream = new RatisBlockOutputStream(this.blockID, this.length, this.xceiverClientManager, this.pipeline, this.bufferPool, this.config, this.token, this.clientMetrics, this.streamBufferArgs, this.executorServiceSupplier);
    }

    ContainerClientMetrics getClientMetrics() {
        return this.clientMetrics;
    }

    Supplier<ExecutorService> getExecutorServiceSupplier() {
        return this.executorServiceSupplier;
    }

    StreamBufferArgs getStreamBufferArgs() {
        return this.streamBufferArgs;
    }

    @Override
    public void write(int b) throws IOException {
        this.checkStream();
        this.getOutputStream().write(b);
        this.incCurrentPosition();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkStream();
        this.getOutputStream().write(b, off, len);
        this.incCurrentPosition(len);
    }

    void writeOnRetry(long len) throws IOException {
        this.checkStream();
        BlockOutputStream out = (BlockOutputStream)this.getOutputStream();
        out.writeOnRetry(len);
        this.incCurrentPosition(len);
        LOG.info("{}: Finish retrying with len {}, currentPosition {}", new Object[]{this, len, this.currentPosition});
    }

    @Override
    public void flush() throws IOException {
        if (this.isInitialized()) {
            this.getOutputStream().flush();
        }
    }

    void hsync() throws IOException {
        if (this.isInitialized()) {
            OutputStream out = this.getOutputStream();
            if (!(out instanceof Syncable)) {
                throw new UnsupportedOperationException(out.getClass() + " is not " + Syncable.class.getSimpleName());
            }
            MetricUtil.captureLatencyNs(this.clientMetrics::addDataNodeHsyncLatency, () -> ((Syncable)out).hsync());
        }
    }

    @Override
    public void close() throws IOException {
        if (this.isInitialized()) {
            this.getOutputStream().close();
            this.blockID = ((BlockOutputStream)this.getOutputStream()).getBlockID();
        }
    }

    boolean isClosed() {
        if (this.isInitialized()) {
            return ((BlockOutputStream)this.getOutputStream()).isClosed();
        }
        return false;
    }

    void cleanup(boolean invalidateClient) throws IOException {
        this.checkStream();
        BlockOutputStream out = (BlockOutputStream)this.getOutputStream();
        out.cleanup(invalidateClient);
    }

    long getTotalAckDataLength() {
        if (this.isInitialized()) {
            BlockOutputStream out = (BlockOutputStream)this.getOutputStream();
            this.blockID = out.getBlockID();
            return out.getTotalAckDataLength();
        }
        return 0L;
    }

    long getWrittenDataLength() {
        if (this.isInitialized()) {
            BlockOutputStream out = (BlockOutputStream)this.getOutputStream();
            return out.getWrittenDataLength();
        }
        return 0L;
    }

    Collection<DatanodeDetails> getFailedServers() {
        if (this.isInitialized()) {
            BlockOutputStream out = (BlockOutputStream)this.getOutputStream();
            return out.getFailedServers();
        }
        return Collections.emptyList();
    }

    boolean isInitialized() {
        return this.getOutputStream() != null;
    }

    long getLength() {
        return this.length;
    }

    Token<OzoneBlockTokenIdentifier> getToken() {
        return this.token;
    }

    long getRemaining() {
        return this.getLength() - this.getCurrentPosition();
    }

    void incCurrentPosition(long len) {
        this.currentPosition += len;
    }

    void incCurrentPosition() {
        ++this.currentPosition;
    }

    void resetToAckedPosition() {
        this.currentPosition = this.getTotalAckDataLength();
    }

    @VisibleForTesting
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @VisibleForTesting
    public BlockID getBlockID() {
        return this.blockID;
    }

    @VisibleForTesting
    protected void updateBlockID(BlockID id) {
        this.blockID = id;
    }

    OzoneClientConfig getConf() {
        return this.config;
    }

    XceiverClientFactory getXceiverClientManager() {
        return this.xceiverClientManager;
    }

    @VisibleForTesting
    public Pipeline getPipeline() {
        return this.pipeline;
    }

    Pipeline getPipelineForOMLocationReport() {
        return this.getPipeline();
    }

    long getCurrentPosition() {
        return this.currentPosition;
    }

    BufferPool getBufferPool() {
        return this.bufferPool;
    }

    public static class Builder {
        private BlockID blockID;
        private String key;
        private XceiverClientFactory xceiverClientManager;
        private Pipeline pipeline;
        private long length;
        private BufferPool bufferPool;
        private Token<OzoneBlockTokenIdentifier> token;
        private OzoneClientConfig config;
        private ContainerClientMetrics clientMetrics;
        private StreamBufferArgs streamBufferArgs;
        private Supplier<ExecutorService> executorServiceSupplier;
        private boolean forRetry;

        public Pipeline getPipeline() {
            return this.pipeline;
        }

        public long getLength() {
            return this.length;
        }

        public Builder setBlockID(BlockID bID) {
            this.blockID = bID;
            return this;
        }

        public Builder setKey(String keys2) {
            this.key = keys2;
            return this;
        }

        public Builder setXceiverClientManager(XceiverClientFactory xClientManager) {
            this.xceiverClientManager = xClientManager;
            return this;
        }

        public Builder setPipeline(Pipeline ppln) {
            this.pipeline = ppln;
            return this;
        }

        public Builder setLength(long len) {
            this.length = len;
            return this;
        }

        public Builder setBufferPool(BufferPool pool) {
            this.bufferPool = pool;
            return this;
        }

        public Builder setConfig(OzoneClientConfig clientConfig) {
            this.config = clientConfig;
            return this;
        }

        public Builder setToken(Token<OzoneBlockTokenIdentifier> bToken) {
            this.token = bToken;
            return this;
        }

        public Builder setClientMetrics(ContainerClientMetrics clientMetrics) {
            this.clientMetrics = clientMetrics;
            return this;
        }

        public Builder setStreamBufferArgs(StreamBufferArgs streamBufferArgs) {
            this.streamBufferArgs = streamBufferArgs;
            return this;
        }

        public Builder setExecutorServiceSupplier(Supplier<ExecutorService> executorServiceSupplier) {
            this.executorServiceSupplier = executorServiceSupplier;
            return this;
        }

        public Builder setForRetry(boolean forRetry) {
            this.forRetry = forRetry;
            return this;
        }

        public BlockOutputStreamEntry build() {
            return new BlockOutputStreamEntry(this);
        }
    }
}

