/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.utils.TransactionInfo;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.lock.OMLockDetails;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMDirectoriesPurgeResponseWithFSO;
import org.apache.hadoop.ozone.om.snapshot.SnapshotUtils;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.ratis.server.protocol.TermIndex;

public class OMDirectoriesPurgeRequestWithFSO
extends OMKeyRequest {
    public OMDirectoriesPurgeRequestWithFSO(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest, BucketLayout.FILE_SYSTEM_OPTIMIZED);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        block17: {
            purgeDirsRequest = this.getOmRequest().getPurgeDirectoriesRequest();
            fromSnapshot = purgeDirsRequest.hasSnapshotTableKey() != false ? purgeDirsRequest.getSnapshotTableKey() : null;
            purgeRequests = purgeDirsRequest.getDeletedPathList();
            lockSet = new HashSet<Pair>();
            volBucketInfoMap = new HashMap<Pair<String, String>, OmBucketInfo>();
            omMetadataManager = (OmMetadataManagerImpl)ozoneManager.getMetadataManager();
            openKeyInfoMap = new HashMap<String, OmKeyInfo>();
            omMetrics = ozoneManager.getMetrics();
            deletingServiceMetrics = ozoneManager.getDeletionMetrics();
            omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            try {
                v0 = fromSnapshotInfo = fromSnapshot != null ? SnapshotUtils.getSnapshotInfo(ozoneManager, fromSnapshot) : null;
                if (purgeDirsRequest.hasExpectedPreviousSnapshotID()) {
                    expectedPreviousSnapshotId = purgeDirsRequest.getExpectedPreviousSnapshotID().hasUuid() != false ? HddsUtils.fromProtobuf((HddsProtos.UUID)purgeDirsRequest.getExpectedPreviousSnapshotID().getUuid()) : null;
                    SnapshotUtils.validatePreviousSnapshotId(fromSnapshotInfo, omMetadataManager.getSnapshotChainManager(), expectedPreviousSnapshotId);
                }
            }
            catch (IOException e) {
                OMKeyRequest.LOG.error("Error occurred while performing OMDirectoriesPurge. ", (Throwable)e);
                return new OMDirectoriesPurgeResponseWithFSO(this.createErrorOMResponse(omResponse, e));
            }
            try {
                try {
                    numSubDirMoved = 0;
                    numSubFilesMoved = 0;
                    numDirsDeleted = 0;
                    for (OzoneManagerProtocolProtos.PurgePathRequest path : purgeRequests) {
                        for (OzoneManagerProtocolProtos.KeyInfo key : path.getMarkDeletedSubDirsList()) {
                            keyInfo = OmKeyInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyInfo)key);
                            volumeName = keyInfo.getVolumeName();
                            volBucketPair = Pair.of((Object)volumeName, (Object)(bucketName = keyInfo.getBucketName()));
                            if (!lockSet.contains(volBucketPair)) {
                                omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                                lockSet.add(volBucketPair);
                            }
                            omMetrics.decNumKeys();
                            ++numSubDirMoved;
                            omBucketInfo = this.getBucketInfo(omMetadataManager, volumeName, bucketName);
                            if (omBucketInfo == null || omBucketInfo.getObjectID() != path.getBucketId()) continue;
                            omBucketInfo.incrUsedNamespace(-1L);
                            ozoneDbKey = omMetadataManager.getOzonePathKey(path.getVolumeId(), path.getBucketId(), keyInfo.getParentObjectID(), keyInfo.getFileName());
                            omMetadataManager.getDirectoryTable().addCacheEntry(new CacheKey((Object)ozoneDbKey), CacheValue.get((long)context.getIndex()));
                            volBucketInfoMap.putIfAbsent((Pair<String, String>)volBucketPair, omBucketInfo);
                        }
                        for (OzoneManagerProtocolProtos.KeyInfo key : path.getDeletedSubFilesList()) {
                            keyInfo = OmKeyInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyInfo)key);
                            volumeName = keyInfo.getVolumeName();
                            volBucketPair = Pair.of((Object)volumeName, (Object)(bucketName = keyInfo.getBucketName()));
                            if (!lockSet.contains(volBucketPair)) {
                                omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                                lockSet.add(volBucketPair);
                            }
                            if ((hsyncClientId = (String)keyInfo.getMetadata().get("hsyncClientId")) != null) {
                                parentId = keyInfo.getParentObjectID();
                                dbOpenKey = omMetadataManager.getOpenFileName(path.getVolumeId(), path.getBucketId(), parentId, keyInfo.getFileName(), hsyncClientId);
                                openKeyInfo = (OmKeyInfo)omMetadataManager.getOpenKeyTable(this.getBucketLayout()).get((Object)dbOpenKey);
                                if (openKeyInfo != null) {
                                    openKeyInfo.getMetadata().put("deletedHsyncKey", "true");
                                    openKeyInfoMap.put(dbOpenKey, openKeyInfo);
                                }
                            }
                            omMetrics.decNumKeys();
                            ++numSubFilesMoved;
                            omBucketInfo = this.getBucketInfo(omMetadataManager, volumeName, bucketName);
                            if (omBucketInfo == null || omBucketInfo.getObjectID() != path.getBucketId()) continue;
                            omBucketInfo.incrUsedBytes(-OMDirectoriesPurgeRequestWithFSO.sumBlockLengths(keyInfo));
                            omBucketInfo.incrUsedNamespace(-1L);
                            ozoneDbKey = omMetadataManager.getOzonePathKey(path.getVolumeId(), path.getBucketId(), keyInfo.getParentObjectID(), keyInfo.getFileName());
                            omMetadataManager.getFileTable().addCacheEntry(new CacheKey((Object)ozoneDbKey), CacheValue.get((long)context.getIndex()));
                            volBucketInfoMap.putIfAbsent((Pair<String, String>)volBucketPair, omBucketInfo);
                        }
                        if (!path.hasDeletedDir()) continue;
                        ++numDirsDeleted;
                    }
                    deletingServiceMetrics.incrNumSubDirectoriesMoved(numSubDirMoved);
                    deletingServiceMetrics.incrNumSubFilesMoved(numSubFilesMoved);
                    deletingServiceMetrics.incrNumDirPurged(numDirsDeleted);
                    if (fromSnapshotInfo != null) {
                        fromSnapshotInfo.setLastTransactionInfo(TransactionInfo.valueOf((TermIndex)context.getTermIndex()).toByteString());
                        omMetadataManager.getSnapshotInfoTable().addCacheEntry(new CacheKey((Object)fromSnapshotInfo.getTableKey()), CacheValue.get((long)context.getIndex(), (Object)fromSnapshotInfo));
                    }
                    break block17;
                }
                catch (IOException ex) {
                    throw new IllegalStateException(ex);
                }
            }
            catch (Throwable var30_34) {
                lockSet.stream().forEach((Consumer<Pair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$0(org.apache.hadoop.ozone.om.OmMetadataManagerImpl org.apache.commons.lang3.tuple.Pair ), (Lorg/apache/commons/lang3/tuple/Pair;)V)((OmMetadataManagerImpl)omMetadataManager));
                ** for (entry : volBucketInfoMap.entrySet())
            }
lbl-1000:
            // 1 sources

            {
                entry.setValue(((OmBucketInfo)entry.getValue()).copyObject());
                continue;
            }
lbl92:
            // 1 sources

            throw var30_34;
        }
        lockSet.stream().forEach((Consumer<Pair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$0(org.apache.hadoop.ozone.om.OmMetadataManagerImpl org.apache.commons.lang3.tuple.Pair ), (Lorg/apache/commons/lang3/tuple/Pair;)V)((OmMetadataManagerImpl)omMetadataManager));
        for (Map.Entry<K, OmBucketInfo> entry : volBucketInfoMap.entrySet()) {
            entry.setValue(((OmBucketInfo)entry.getValue()).copyObject());
        }
        return new OMDirectoriesPurgeResponseWithFSO(omResponse.build(), purgeRequests, this.getBucketLayout(), volBucketInfoMap, fromSnapshotInfo, openKeyInfoMap);
    }

    private static /* synthetic */ void lambda$0(OmMetadataManagerImpl omMetadataManagerImpl, Pair e) {
        OMLockDetails oMLockDetails = omMetadataManagerImpl.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{(String)e.getKey(), (String)e.getValue()});
    }
}

