/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.snapshot;

import java.io.IOException;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.shell.Handler;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.bucket.BucketUri;
import picocli.CommandLine;

@CommandLine.Command(name="rename", description={"Rename a snapshot"})
public class RenameSnapshotHandler
extends Handler {
    @CommandLine.Mixin
    private BucketUri snapshotPath;
    @CommandLine.Parameters(description={"Current snapshot name"}, index="1", arity="1")
    private String snapshotOldName;
    @CommandLine.Parameters(description={"New snapshot name"}, index="2", arity="1")
    private String snapshotNewName;

    @Override
    protected OzoneAddress getAddress() {
        return this.snapshotPath.getValue();
    }

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        String volumeName = this.snapshotPath.getValue().getVolumeName();
        String bucketName = this.snapshotPath.getValue().getBucketName();
        OmUtils.validateSnapshotName((String)this.snapshotNewName);
        client.getObjectStore().renameSnapshot(volumeName, bucketName, this.snapshotOldName, this.snapshotNewName);
        if (this.isVerbose()) {
            this.out().format("Renamed snapshot from'%s' to %s under '%s/%s'.%n", this.snapshotOldName, this.snapshotNewName, volumeName, bucketName);
        }
    }
}

