/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.keys;

import java.io.IOException;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.bucket.BucketHandler;
import picocli.CommandLine;

@CommandLine.Command(name="rename", description={"renames an existing key"})
public class RenameKeyHandler
extends BucketHandler {
    @CommandLine.Parameters(index="1", arity="1..1", description={"The existing key to be renamed"})
    private String fromKey;
    @CommandLine.Parameters(index="2", arity="1..1", description={"The new desired name of the key"})
    private String toKey;

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        String volumeName = address.getVolumeName();
        String bucketName = address.getBucketName();
        OzoneVolume vol = client.getObjectStore().getVolume(volumeName);
        OzoneBucket bucket = vol.getBucket(bucketName);
        bucket.renameKey(this.fromKey, this.toKey);
        if (this.isVerbose()) {
            this.out().printf("Renamed Key : %s to %s%n", this.fromKey, this.toKey);
        }
    }
}

