/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.io;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.time.Clock;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.apache.hadoop.hdds.client.ContainerBlockID;
import org.apache.hadoop.hdds.scm.ByteStringConversion;
import org.apache.hadoop.hdds.scm.ContainerClientMetrics;
import org.apache.hadoop.hdds.scm.OzoneClientConfig;
import org.apache.hadoop.hdds.scm.StreamBufferArgs;
import org.apache.hadoop.hdds.scm.XceiverClientFactory;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.storage.BufferPool;
import org.apache.hadoop.hdds.security.token.OzoneBlockTokenIdentifier;
import org.apache.hadoop.ozone.client.io.BlockOutputStreamEntry;
import org.apache.hadoop.ozone.client.io.KeyMetadataAware;
import org.apache.hadoop.ozone.client.io.KeyOutputStream;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.OmMultipartCommitUploadPartInfo;
import org.apache.hadoop.ozone.om.protocol.OzoneManagerProtocol;
import org.apache.hadoop.ozone.util.MetricUtil;
import org.apache.hadoop.security.token.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockOutputStreamEntryPool
implements KeyMetadataAware {
    public static final Logger LOG = LoggerFactory.getLogger(BlockOutputStreamEntryPool.class);
    private final List<BlockOutputStreamEntry> streamEntries = new ArrayList<BlockOutputStreamEntry>();
    private final OzoneClientConfig config;
    private int currentStreamIndex;
    private final OzoneManagerProtocol omClient;
    private final OmKeyArgs keyArgs;
    private final XceiverClientFactory xceiverClientFactory;
    private final BufferPool bufferPool;
    private OmMultipartCommitUploadPartInfo commitUploadPartInfo;
    private final long openID;
    private final ExcludeList excludeList;
    private final ContainerClientMetrics clientMetrics;
    private final StreamBufferArgs streamBufferArgs;
    private final Supplier<ExecutorService> executorServiceSupplier;
    private ContainerBlockID lastUpdatedBlockId = new ContainerBlockID(-1L, -1L);

    public BlockOutputStreamEntryPool(KeyOutputStream.Builder b) {
        this.config = b.getClientConfig();
        this.xceiverClientFactory = b.getXceiverManager();
        this.currentStreamIndex = 0;
        this.omClient = b.getOmClient();
        OmKeyInfo info = b.getOpenHandler().getKeyInfo();
        this.keyArgs = new OmKeyArgs.Builder().setVolumeName(info.getVolumeName()).setBucketName(info.getBucketName()).setKeyName(info.getKeyName()).setReplicationConfig(b.getReplicationConfig()).setDataSize(info.getDataSize()).setIsMultipartKey(b.isMultipartKey()).setMultipartUploadID(b.getMultipartUploadID()).setMultipartUploadPartNumber(b.getMultipartNumber()).build();
        this.openID = b.getOpenHandler().getId();
        this.excludeList = this.createExcludeList();
        this.streamBufferArgs = b.getStreamBufferArgs();
        this.bufferPool = new BufferPool(this.streamBufferArgs.getStreamBufferSize(), (int)(this.streamBufferArgs.getStreamBufferMaxSize() / (long)this.streamBufferArgs.getStreamBufferSize()), ByteStringConversion.createByteBufferConversion((boolean)b.isUnsafeByteBufferConversionEnabled()));
        this.clientMetrics = b.getClientMetrics();
        this.executorServiceSupplier = b.getExecutorServiceSupplier();
    }

    ExcludeList createExcludeList() {
        return new ExcludeList(this.getConfig().getExcludeNodesExpiryTime(), Clock.system(ZoneOffset.UTC));
    }

    public synchronized void addPreallocateBlocks(OmKeyLocationInfoGroup version, long openVersion) {
        for (OmKeyLocationInfo subKeyInfo : version.getLocationList(Long.valueOf(openVersion))) {
            this.addKeyLocationInfo(subKeyInfo, false);
        }
    }

    BlockOutputStreamEntry createStreamEntry(OmKeyLocationInfo subKeyInfo, boolean forRetry) {
        return new BlockOutputStreamEntry.Builder().setBlockID(subKeyInfo.getBlockID()).setKey(this.keyArgs.getKeyName()).setXceiverClientManager(this.xceiverClientFactory).setPipeline(subKeyInfo.getPipeline()).setConfig(this.config).setLength(subKeyInfo.getLength()).setBufferPool(this.bufferPool).setToken((Token<OzoneBlockTokenIdentifier>)subKeyInfo.getToken()).setClientMetrics(this.clientMetrics).setStreamBufferArgs(this.streamBufferArgs).setExecutorServiceSupplier(this.executorServiceSupplier).setForRetry(forRetry).build();
    }

    private synchronized void addKeyLocationInfo(OmKeyLocationInfo subKeyInfo, boolean forRetry) {
        Preconditions.checkNotNull((Object)subKeyInfo.getPipeline());
        this.streamEntries.add(this.createStreamEntry(subKeyInfo, forRetry));
    }

    @VisibleForTesting
    public List<OmKeyLocationInfo> getLocationInfoList() {
        List<OmKeyLocationInfo> currBlocksLocationInfoList;
        List<OmKeyLocationInfo> locationInfoList = currBlocksLocationInfoList = this.getOmKeyLocationInfos(this.streamEntries);
        return locationInfoList;
    }

    private List<OmKeyLocationInfo> getOmKeyLocationInfos(List<BlockOutputStreamEntry> streams) {
        ArrayList<OmKeyLocationInfo> locationInfoList = new ArrayList<OmKeyLocationInfo>();
        for (BlockOutputStreamEntry streamEntry : streams) {
            long length = streamEntry.getCurrentPosition();
            if (length != 0L) {
                OmKeyLocationInfo info = new OmKeyLocationInfo.Builder().setBlockID(streamEntry.getBlockID()).setLength(streamEntry.getCurrentPosition()).setOffset(0L).setToken(streamEntry.getToken()).setPipeline(streamEntry.getPipeline()).build();
                locationInfoList.add(info);
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("block written " + streamEntry.getBlockID() + ", length " + length + " bcsID " + streamEntry.getBlockID().getBlockCommitSequenceId());
        }
        return locationInfoList;
    }

    public BufferPool getBufferPool() {
        return this.bufferPool;
    }

    OzoneClientConfig getConfig() {
        return this.config;
    }

    ContainerClientMetrics getClientMetrics() {
        return this.clientMetrics;
    }

    StreamBufferArgs getStreamBufferArgs() {
        return this.streamBufferArgs;
    }

    public Supplier<ExecutorService> getExecutorServiceSupplier() {
        return this.executorServiceSupplier;
    }

    synchronized void discardPreallocatedBlocks(long containerID, PipelineID pipelineId) {
        if (this.currentStreamIndex + 1 < this.streamEntries.size()) {
            ListIterator<BlockOutputStreamEntry> streamEntryIterator = this.streamEntries.listIterator(this.currentStreamIndex + 1);
            while (streamEntryIterator.hasNext()) {
                BlockOutputStreamEntry streamEntry = streamEntryIterator.next();
                Preconditions.checkArgument((streamEntry.getCurrentPosition() == 0L ? 1 : 0) != 0);
                if (!streamEntry.getPipeline().getId().equals((Object)pipelineId) && (containerID == -1L || streamEntry.getBlockID().getContainerID() != containerID)) continue;
                streamEntryIterator.remove();
            }
        }
    }

    @VisibleForTesting
    List<BlockOutputStreamEntry> getStreamEntries() {
        return this.streamEntries;
    }

    @VisibleForTesting
    XceiverClientFactory getXceiverClientFactory() {
        return this.xceiverClientFactory;
    }

    String getKeyName() {
        return this.keyArgs.getKeyName();
    }

    synchronized long getKeyLength() {
        return this.streamEntries.stream().mapToLong(BlockOutputStreamEntry::getCurrentPosition).sum();
    }

    private void allocateNewBlock(boolean forRetry) throws IOException {
        if (!this.excludeList.isEmpty()) {
            LOG.debug("Allocating block with {}", (Object)this.excludeList);
        }
        OmKeyLocationInfo subKeyInfo = this.omClient.allocateBlock(this.keyArgs, this.openID, this.excludeList);
        this.addKeyLocationInfo(subKeyInfo, forRetry);
    }

    void commitKey(long offset) throws IOException {
        if (this.keyArgs != null) {
            long length = this.getKeyLength();
            Preconditions.checkArgument((offset == length ? 1 : 0) != 0, (Object)("Expected offset: " + offset + " expected len: " + length));
            this.keyArgs.setDataSize(length);
            this.keyArgs.setLocationInfoList(this.getLocationInfoList());
            if (this.keyArgs.getIsMultipartKey()) {
                this.commitUploadPartInfo = this.omClient.commitMultipartUploadPart(this.keyArgs, this.openID);
            } else {
                this.omClient.commitKey(this.keyArgs, this.openID);
            }
        } else {
            LOG.warn("Closing KeyOutputStream, but key args is null");
        }
    }

    void hsyncKey(long offset) throws IOException {
        if (this.keyArgs != null) {
            this.keyArgs.setDataSize(offset);
            this.keyArgs.setLocationInfoList(this.getLocationInfoList());
            if (this.keyArgs.getIsMultipartKey()) {
                throw new IOException("Hsync is unsupported for multipart keys.");
            }
            if (this.keyArgs.getLocationInfoList().isEmpty()) {
                MetricUtil.captureLatencyNs(arg_0 -> ((ContainerClientMetrics)this.clientMetrics).addOMHsyncLatency(arg_0), () -> this.omClient.hsyncKey(this.keyArgs, this.openID));
            } else {
                ContainerBlockID lastBLockId = ((OmKeyLocationInfo)this.keyArgs.getLocationInfoList().get(this.keyArgs.getLocationInfoList().size() - 1)).getBlockID().getContainerBlockID();
                if (!this.lastUpdatedBlockId.equals((Object)lastBLockId)) {
                    MetricUtil.captureLatencyNs(arg_0 -> ((ContainerClientMetrics)this.clientMetrics).addOMHsyncLatency(arg_0), () -> this.omClient.hsyncKey(this.keyArgs, this.openID));
                    this.lastUpdatedBlockId = lastBLockId;
                }
            }
        } else {
            LOG.warn("Closing KeyOutputStream, but key args is null");
        }
    }

    BlockOutputStreamEntry getCurrentStreamEntry() {
        if (this.streamEntries.isEmpty() || this.streamEntries.size() <= this.currentStreamIndex) {
            return null;
        }
        return this.streamEntries.get(this.currentStreamIndex);
    }

    synchronized BlockOutputStreamEntry allocateBlockIfNeeded(boolean forRetry) throws IOException {
        BlockOutputStreamEntry streamEntry = this.getCurrentStreamEntry();
        if (streamEntry != null && streamEntry.isClosed()) {
            ++this.currentStreamIndex;
        }
        if (this.streamEntries.size() <= this.currentStreamIndex) {
            Preconditions.checkNotNull((Object)this.omClient);
            this.allocateNewBlock(forRetry);
        }
        Preconditions.checkArgument((this.currentStreamIndex < this.streamEntries.size() ? 1 : 0) != 0, (String)"currentStreamIndex(%s) must be < streamEntries.size(%s)", (int)this.currentStreamIndex, (int)this.streamEntries.size());
        return this.streamEntries.get(this.currentStreamIndex);
    }

    long computeBufferData() {
        return this.bufferPool.computeBufferData();
    }

    void cleanup() {
        if (this.excludeList != null) {
            this.excludeList.clear();
        }
        if (this.bufferPool != null) {
            this.bufferPool.clearBufferPool();
        }
        if (this.streamEntries != null) {
            this.streamEntries.clear();
        }
    }

    public OmMultipartCommitUploadPartInfo getCommitUploadPartInfo() {
        return this.commitUploadPartInfo;
    }

    public ExcludeList getExcludeList() {
        return this.excludeList;
    }

    boolean isEmpty() {
        return this.streamEntries.isEmpty();
    }

    @Override
    public Map<String, String> getMetadata() {
        if (this.keyArgs != null) {
            return this.keyArgs.getMetadata();
        }
        return null;
    }

    long getDataSize() {
        return this.keyArgs.getDataSize();
    }
}

