/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.hadoop.ozone.recon.ReconUtils;
import org.apache.ozone.recon.schema.UtilizationSchemaDefinition;
import org.apache.ozone.recon.schema.generated.tables.ContainerCountBySizeTable;
import org.apache.ozone.recon.schema.generated.tables.FileCountBySizeTable;
import org.apache.ozone.recon.schema.generated.tables.daos.ContainerCountBySizeDao;
import org.apache.ozone.recon.schema.generated.tables.daos.FileCountBySizeDao;
import org.apache.ozone.recon.schema.generated.tables.pojos.ContainerCountBySize;
import org.apache.ozone.recon.schema.generated.tables.pojos.FileCountBySize;
import org.jooq.DSLContext;
import org.jooq.Record1;
import org.jooq.Record3;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.TableLike;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/utilization")
@Produces(value={"application/json"})
public class UtilizationEndpoint {
    private FileCountBySizeDao fileCountBySizeDao;
    private UtilizationSchemaDefinition utilizationSchemaDefinition;
    private ContainerCountBySizeDao containerCountBySizeDao;
    private static final Logger LOG = LoggerFactory.getLogger(UtilizationEndpoint.class);

    @Inject
    public UtilizationEndpoint(FileCountBySizeDao fileCountBySizeDao, ContainerCountBySizeDao containerCountBySizeDao, UtilizationSchemaDefinition utilizationSchemaDefinition) {
        this.utilizationSchemaDefinition = utilizationSchemaDefinition;
        this.fileCountBySizeDao = fileCountBySizeDao;
        this.containerCountBySizeDao = containerCountBySizeDao;
    }

    @GET
    @Path(value="/fileCount")
    public Response getFileCounts(@QueryParam(value="volume") String volume, @QueryParam(value="bucket") String bucket, @QueryParam(value="fileSize") long fileSize) {
        Record3 recordToFind;
        FileCountBySize record;
        DSLContext dslContext = this.utilizationSchemaDefinition.getDSLContext();
        List<Object> resultSet = volume != null && bucket != null && fileSize > 0L ? ((record = (FileCountBySize)this.fileCountBySizeDao.findById(recordToFind = dslContext.newRecord(FileCountBySizeTable.FILE_COUNT_BY_SIZE.VOLUME, FileCountBySizeTable.FILE_COUNT_BY_SIZE.BUCKET, FileCountBySizeTable.FILE_COUNT_BY_SIZE.FILE_SIZE).value1((Object)volume).value2((Object)bucket).value3((Object)fileSize))) != null ? Collections.singletonList(record) : Collections.emptyList()) : (volume != null && bucket != null ? dslContext.select(new SelectFieldOrAsterisk[0]).from((TableLike)FileCountBySizeTable.FILE_COUNT_BY_SIZE).where(FileCountBySizeTable.FILE_COUNT_BY_SIZE.VOLUME.eq((Object)volume)).and(FileCountBySizeTable.FILE_COUNT_BY_SIZE.BUCKET.eq((Object)bucket)).fetchInto(FileCountBySize.class) : (volume != null ? this.fileCountBySizeDao.fetchByVolume(volume) : this.fileCountBySizeDao.findAll()));
        return Response.ok((Object)resultSet).build();
    }

    @GET
    @Path(value="/containerCount")
    public Response getContainerCounts(@QueryParam(value="containerSize") long upperBound) {
        DSLContext dslContext = this.utilizationSchemaDefinition.getDSLContext();
        Long containerSizeUpperBound = ReconUtils.getContainerSizeUpperBound(upperBound);
        try {
            Record1 recordToFind;
            ContainerCountBySize record2;
            List<Object> resultSet = upperBound > 0L ? ((record2 = (ContainerCountBySize)this.containerCountBySizeDao.findById((recordToFind = dslContext.newRecord(ContainerCountBySizeTable.CONTAINER_COUNT_BY_SIZE.CONTAINER_SIZE).value1((Object)containerSizeUpperBound)).value1())) != null ? Collections.singletonList(record2) : Collections.emptyList()) : this.containerCountBySizeDao.findAll().stream().filter(record -> record.getCount() > 0L).collect(Collectors.toList());
            return Response.ok(resultSet).build();
        }
        catch (Exception e) {
            LOG.error("Error retrieving container counts", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

