/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.client.DecommissionUtils;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.container.placement.metrics.SCMNodeStat;
import org.apache.hadoop.hdds.scm.node.DatanodeInfo;
import org.apache.hadoop.hdds.scm.node.NodeStatus;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineNotFoundException;
import org.apache.hadoop.hdds.scm.protocol.StorageContainerLocationProtocol;
import org.apache.hadoop.hdds.scm.server.OzoneStorageContainerManager;
import org.apache.hadoop.ozone.ClientVersion;
import org.apache.hadoop.ozone.recon.api.types.DatanodeMetadata;
import org.apache.hadoop.ozone.recon.api.types.DatanodePipeline;
import org.apache.hadoop.ozone.recon.api.types.DatanodeStorageReport;
import org.apache.hadoop.ozone.recon.api.types.DatanodesResponse;
import org.apache.hadoop.ozone.recon.api.types.RemoveDataNodesResponseWrapper;
import org.apache.hadoop.ozone.recon.scm.ReconContainerManager;
import org.apache.hadoop.ozone.recon.scm.ReconNodeManager;
import org.apache.hadoop.ozone.recon.scm.ReconPipelineManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/datanodes")
@Produces(value={"application/json"})
public class NodeEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(NodeEndpoint.class);
    private ReconNodeManager nodeManager;
    private ReconPipelineManager pipelineManager;
    private ReconContainerManager reconContainerManager;
    private StorageContainerLocationProtocol scmClient;
    private String errorMessage = "Error getting pipeline and container metrics for ";

    @Inject
    NodeEndpoint(OzoneStorageContainerManager reconSCM, StorageContainerLocationProtocol scmClient) {
        this.nodeManager = (ReconNodeManager)reconSCM.getScmNodeManager();
        this.reconContainerManager = (ReconContainerManager)reconSCM.getContainerManager();
        this.pipelineManager = (ReconPipelineManager)reconSCM.getPipelineManager();
        this.scmClient = scmClient;
    }

    @GET
    public Response getDatanodes() {
        ArrayList<DatanodeMetadata> datanodes = new ArrayList<DatanodeMetadata>();
        List datanodeDetails = this.nodeManager.getAllNodes();
        datanodeDetails.forEach(datanode -> {
            DatanodeStorageReport storageReport = this.getStorageReport((DatanodeDetails)datanode);
            HddsProtos.NodeState nodeState = null;
            try {
                nodeState = this.nodeManager.getNodeStatus((DatanodeDetails)datanode).getHealth();
            }
            catch (NodeNotFoundException e) {
                LOG.warn("Cannot get nodeState for datanode {}", datanode, (Object)e);
            }
            HddsProtos.NodeOperationalState nodeOpState = datanode.getPersistedOpState();
            String hostname = datanode.getHostName();
            Set pipelineIDs = this.nodeManager.getPipelines((DatanodeDetails)datanode);
            ArrayList<DatanodePipeline> pipelines = new ArrayList<DatanodePipeline>();
            AtomicInteger leaderCount = new AtomicInteger();
            AtomicInteger openContainers = new AtomicInteger();
            DatanodeMetadata.Builder builder = DatanodeMetadata.newBuilder();
            pipelineIDs.forEach(pipelineID -> {
                try {
                    Pipeline pipeline = this.pipelineManager.getPipeline((PipelineID)pipelineID);
                    String leaderNode = pipeline.getLeaderNode().getHostName();
                    DatanodePipeline datanodePipeline = new DatanodePipeline(pipelineID.getId(), pipeline.getReplicationConfig(), leaderNode);
                    pipelines.add(datanodePipeline);
                    if (datanode.getUuid().equals(pipeline.getLeaderId())) {
                        leaderCount.getAndIncrement();
                    }
                    int openContainerPerPipeline = this.reconContainerManager.getPipelineToOpenContainer().getOrDefault(pipelineID, 0);
                    openContainers.getAndAdd(openContainerPerPipeline);
                }
                catch (PipelineNotFoundException ex) {
                    LOG.warn("Cannot get pipeline {} for datanode {}, pipeline not found", new Object[]{pipelineID.getId(), hostname, ex});
                }
                catch (IOException ioEx) {
                    LOG.warn("Cannot get leader node of pipeline with id {}.", (Object)pipelineID.getId(), (Object)ioEx);
                }
            });
            try {
                builder.setContainers(this.nodeManager.getContainerCount((DatanodeDetails)datanode));
                builder.setOpenContainers(openContainers.get());
            }
            catch (NodeNotFoundException ex) {
                LOG.warn("Cannot get containers, datanode {} not found.", (Object)datanode.getUuid(), (Object)ex);
            }
            DatanodeInfo dnInfo = (DatanodeInfo)datanode;
            datanodes.add(builder.setHostname(this.nodeManager.getHostName((DatanodeDetails)datanode)).setDatanodeStorageReport(storageReport).setLastHeartbeat(this.nodeManager.getLastHeartbeat((DatanodeDetails)datanode)).setState(nodeState).setOperationalState(nodeOpState).setPipelines(pipelines).setLeaderCount(leaderCount.get()).setUuid(datanode.getUuidString()).setVersion(this.nodeManager.getVersion((DatanodeDetails)datanode)).setSetupTime(this.nodeManager.getSetupTime((DatanodeDetails)datanode)).setRevision(this.nodeManager.getRevision((DatanodeDetails)datanode)).setLayoutVersion(dnInfo.getLastKnownLayoutVersion().getMetadataLayoutVersion()).setNetworkLocation(datanode.getNetworkLocation()).build());
        });
        DatanodesResponse datanodesResponse = new DatanodesResponse(datanodes.size(), datanodes);
        return Response.ok((Object)datanodesResponse).build();
    }

    private DatanodeStorageReport getStorageReport(DatanodeDetails datanode) {
        SCMNodeStat nodeStat = this.nodeManager.getNodeStat(datanode).get();
        long capacity = nodeStat.getCapacity().get();
        long used = nodeStat.getScmUsed().get();
        long remaining = nodeStat.getRemaining().get();
        long committed = nodeStat.getCommitted().get();
        return new DatanodeStorageReport(capacity, used, remaining, committed);
    }

    @PUT
    @Path(value="/remove")
    @Consumes(value={"application/json"})
    public Response removeDatanodes(List<String> uuids) {
        ArrayList<DatanodeMetadata> failedDatanodes = new ArrayList<DatanodeMetadata>();
        ArrayList<DatanodeMetadata> notFoundDatanodes = new ArrayList<DatanodeMetadata>();
        ArrayList<DatanodeMetadata> removedDatanodes = new ArrayList<DatanodeMetadata>();
        HashMap<String, String> failedNodeErrorResponseMap = new HashMap<String, String>();
        Preconditions.checkNotNull(uuids, (Object)"Datanode list argument should not be null");
        Preconditions.checkArgument((!uuids.isEmpty() ? 1 : 0) != 0, (Object)"Datanode list argument should not be empty");
        try {
            for (String uuid : uuids) {
                DatanodeDetails nodeByUuid = this.nodeManager.getNodeByUuid(uuid);
                try {
                    if (this.preChecksSuccess(nodeByUuid, failedNodeErrorResponseMap)) {
                        removedDatanodes.add(DatanodeMetadata.newBuilder().setHostname(this.nodeManager.getHostName(nodeByUuid)).setUuid(uuid).setState(this.nodeManager.getNodeStatus(nodeByUuid).getHealth()).build());
                        this.nodeManager.removeNode(nodeByUuid);
                        LOG.info("Node {} removed successfully !!!", (Object)uuid);
                        continue;
                    }
                    failedDatanodes.add(DatanodeMetadata.newBuilder().setHostname(this.nodeManager.getHostName(nodeByUuid)).setUuid(uuid).setOperationalState(nodeByUuid.getPersistedOpState()).setState(this.nodeManager.getNodeStatus(nodeByUuid).getHealth()).build());
                }
                catch (NodeNotFoundException nnfe) {
                    LOG.error("Selected node {} not found : {} ", (Object)uuid, (Object)nnfe);
                    notFoundDatanodes.add(DatanodeMetadata.newBuilder().setHostname("").setState(HddsProtos.NodeState.DEAD).setUuid(uuid).build());
                }
            }
        }
        catch (Exception exp) {
            LOG.error("Unexpected Error while removing datanodes : {} ", (Throwable)exp);
            throw new WebApplicationException((Throwable)exp, Response.Status.INTERNAL_SERVER_ERROR);
        }
        RemoveDataNodesResponseWrapper removeDataNodesResponseWrapper = new RemoveDataNodesResponseWrapper();
        if (!failedDatanodes.isEmpty()) {
            DatanodesResponse failedNodesResp = new DatanodesResponse(failedDatanodes.size(), Collections.emptyList());
            failedNodesResp.setFailedNodeErrorResponseMap(failedNodeErrorResponseMap);
            removeDataNodesResponseWrapper.getDatanodesResponseMap().put("failedDatanodes", failedNodesResp);
        }
        if (!notFoundDatanodes.isEmpty()) {
            DatanodesResponse notFoundNodesResp = new DatanodesResponse(notFoundDatanodes.size(), notFoundDatanodes);
            removeDataNodesResponseWrapper.getDatanodesResponseMap().put("notFoundDatanodes", notFoundNodesResp);
        }
        if (!removedDatanodes.isEmpty()) {
            DatanodesResponse removedNodesResp = new DatanodesResponse(removedDatanodes.size(), removedDatanodes);
            removeDataNodesResponseWrapper.getDatanodesResponseMap().put("removedDatanodes", removedNodesResp);
        }
        return Response.ok((Object)removeDataNodesResponseWrapper).build();
    }

    private boolean preChecksSuccess(DatanodeDetails nodeByUuid, Map<String, String> failedNodeErrorResponseMap) throws NodeNotFoundException {
        if (null == nodeByUuid) {
            throw new NodeNotFoundException();
        }
        NodeStatus nodeStatus = null;
        AtomicBoolean isContainerOrPipeLineOpen = new AtomicBoolean(false);
        try {
            nodeStatus = this.nodeManager.getNodeStatus(nodeByUuid);
            if (nodeStatus.isDead()) {
                this.checkContainers(nodeByUuid, isContainerOrPipeLineOpen);
                if (isContainerOrPipeLineOpen.get()) {
                    failedNodeErrorResponseMap.put(nodeByUuid.getUuidString(), "Open Containers/Pipelines");
                    return false;
                }
                this.checkPipelines(nodeByUuid, isContainerOrPipeLineOpen);
                if (isContainerOrPipeLineOpen.get()) {
                    failedNodeErrorResponseMap.put(nodeByUuid.getUuidString(), "Open Containers/Pipelines");
                    return false;
                }
                return true;
            }
        }
        catch (NodeNotFoundException e) {
            LOG.error("Node : {} not found", (Object)nodeByUuid);
            return false;
        }
        failedNodeErrorResponseMap.put(nodeByUuid.getUuidString(), "DataNode should be in DEAD node status.");
        return false;
    }

    private void checkPipelines(DatanodeDetails nodeByUuid, AtomicBoolean isContainerOrPipeLineOpen) {
        this.nodeManager.getPipelines(nodeByUuid).forEach(id -> {
            try {
                Pipeline pipeline = this.pipelineManager.getPipeline((PipelineID)id);
                if (pipeline.isOpen()) {
                    LOG.warn("Pipeline : {} is still open for datanode: {}, pre-check failed, datanode not eligible for remove.", (Object)id.getId(), (Object)nodeByUuid.getUuid());
                    isContainerOrPipeLineOpen.set(true);
                    return;
                }
            }
            catch (PipelineNotFoundException pipelineNotFoundException) {
                LOG.warn("Pipeline {} is not managed by PipelineManager.", id, (Object)pipelineNotFoundException);
            }
        });
    }

    private void checkContainers(DatanodeDetails nodeByUuid, AtomicBoolean isContainerOrPipeLineOpen) throws NodeNotFoundException {
        this.nodeManager.getContainers(nodeByUuid).forEach(id -> {
            try {
                ContainerInfo container = this.reconContainerManager.getContainer((ContainerID)id);
                if (container.getState() == HddsProtos.LifeCycleState.OPEN) {
                    LOG.warn("Container : {} is still open for datanode: {}, pre-check failed, datanode not eligible for remove.", (Object)container.getContainerID(), (Object)nodeByUuid.getUuid());
                    isContainerOrPipeLineOpen.set(true);
                    return;
                }
            }
            catch (ContainerNotFoundException cnfe) {
                LOG.warn("Container {} is not managed by ContainerManager.", id, (Object)cnfe);
            }
        });
    }

    @GET
    @Path(value="/decommission/info")
    public Response getDatanodesDecommissionInfo() {
        try {
            return this.getDecommissionStatusResponse(null, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @GET
    @Path(value="/decommission/info/datanode")
    public Response getDecommissionInfoForDatanode(@QueryParam(value="uuid") String uuid, @QueryParam(value="ipAddress") String ipAddress) {
        if (StringUtils.isEmpty((CharSequence)uuid)) {
            Preconditions.checkNotNull((Object)ipAddress, (Object)"Either uuid or ipAddress of a datanode should be provided !!!");
            Preconditions.checkArgument((!ipAddress.isEmpty() ? 1 : 0) != 0, (Object)"Either uuid or ipAddress of a datanode should be provided !!!");
        }
        try {
            return this.getDecommissionStatusResponse(uuid, ipAddress);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Response getDecommissionStatusResponse(String uuid, String ipAddress) throws IOException {
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK);
        HashMap<String, List<Map<String, Object>>> responseMap = new HashMap<String, List<Map<String, Object>>>();
        Stream allNodes = this.scmClient.queryNode(HddsProtos.NodeOperationalState.DECOMMISSIONING, null, HddsProtos.QueryScope.CLUSTER, "", ClientVersion.CURRENT_VERSION).stream();
        List decommissioningNodes = DecommissionUtils.getDecommissioningNodesList(allNodes, (String)uuid, (String)ipAddress);
        String metricsJson = this.scmClient.getMetrics("Hadoop:service=StorageContainerManager,name=NodeDecommissionMetrics");
        int numDecomNodes = -1;
        JsonNode jsonNode = null;
        if (metricsJson != null) {
            jsonNode = DecommissionUtils.getBeansJsonNode((String)metricsJson);
            numDecomNodes = DecommissionUtils.getNumDecomNodes((JsonNode)jsonNode);
        }
        List<Map<String, Object>> dnDecommissionInfo = this.getDecommissioningNodesDetails(decommissioningNodes, jsonNode, numDecomNodes);
        try {
            responseMap.put("DatanodesDecommissionInfo", dnDecommissionInfo);
            builder.entity(responseMap);
            return builder.build();
        }
        catch (Exception exception) {
            LOG.error("Unexpected Error: {}", (Throwable)exception);
            throw new WebApplicationException((Throwable)exception, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private List<Map<String, Object>> getDecommissioningNodesDetails(List<HddsProtos.Node> decommissioningNodes, JsonNode jsonNode, int numDecomNodes) throws IOException {
        ArrayList<Map<String, Object>> decommissioningNodesDetails = new ArrayList<Map<String, Object>>();
        for (HddsProtos.Node node : decommissioningNodes) {
            DatanodeDetails datanode = DatanodeDetails.getFromProtoBuf((HddsProtos.DatanodeDetailsProto)node.getNodeID());
            LinkedHashMap<String, Object> datanodeMap = new LinkedHashMap<String, Object>();
            datanodeMap.put("datanodeDetails", datanode);
            datanodeMap.put("metrics", this.getCounts(datanode, jsonNode, numDecomNodes));
            datanodeMap.put("containers", this.getContainers(datanode));
            decommissioningNodesDetails.add(datanodeMap);
        }
        return decommissioningNodesDetails;
    }

    private Map<String, Object> getCounts(DatanodeDetails datanode, JsonNode counts, int numDecomNodes) {
        LinkedHashMap<String, Object> countsMap = new LinkedHashMap();
        String errMsg = this.getErrorMessage() + datanode.getHostName();
        try {
            countsMap = DecommissionUtils.getCountsMap((DatanodeDetails)datanode, (JsonNode)counts, (int)numDecomNodes, countsMap, (String)errMsg);
            if (countsMap != null) {
                return countsMap;
            }
            LOG.error(errMsg);
        }
        catch (IOException e) {
            LOG.error(errMsg + ": {} ", (Throwable)e);
        }
        return countsMap;
    }

    private Map<String, Object> getContainers(DatanodeDetails datanode) throws IOException {
        Map containers = this.scmClient.getContainersOnDecomNode(datanode);
        return containers.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().map(ContainerID::toString).collect(Collectors.toList())));
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

