/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.ratis.retrypolicy;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.ratis.conf.RatisClientConfig;
import org.apache.hadoop.hdds.ratis.retrypolicy.RetryPolicyCreator;
import org.apache.ratis.client.retry.RequestTypeDependentRetryPolicy;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.exceptions.GroupMismatchException;
import org.apache.ratis.protocol.exceptions.NotReplicatedException;
import org.apache.ratis.protocol.exceptions.ResourceUnavailableException;
import org.apache.ratis.protocol.exceptions.StateMachineException;
import org.apache.ratis.protocol.exceptions.TimeoutIOException;
import org.apache.ratis.retry.ExceptionDependentRetry;
import org.apache.ratis.retry.ExponentialBackoffRetry;
import org.apache.ratis.retry.MultipleLinearRandomRetry;
import org.apache.ratis.retry.RetryPolicies;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.util.TimeDuration;

public class RequestTypeDependentRetryPolicyCreator
implements RetryPolicyCreator {
    private static final Class[] NO_RETRY_EXCEPTIONS = new Class[]{NotReplicatedException.class, GroupMismatchException.class, StateMachineException.class};

    @Override
    public RetryPolicy create(ConfigurationSource conf) {
        RatisClientConfig ratisClientConfig = (RatisClientConfig)conf.getObject(RatisClientConfig.class);
        ExponentialBackoffRetry exponentialBackoffRetry = RequestTypeDependentRetryPolicyCreator.createExponentialBackoffPolicy(ratisClientConfig);
        MultipleLinearRandomRetry multipleLinearRandomRetry = MultipleLinearRandomRetry.parseCommaSeparated((String)ratisClientConfig.getMultilinearPolicy());
        return RequestTypeDependentRetryPolicy.newBuilder().setRetryPolicy(RaftProtos.RaftClientRequestProto.TypeCase.WRITE, (RetryPolicy)RequestTypeDependentRetryPolicyCreator.createExceptionDependentPolicy(exponentialBackoffRetry, multipleLinearRandomRetry, (RetryPolicy)exponentialBackoffRetry)).setRetryPolicy(RaftProtos.RaftClientRequestProto.TypeCase.WATCH, (RetryPolicy)RequestTypeDependentRetryPolicyCreator.createExceptionDependentPolicy(exponentialBackoffRetry, multipleLinearRandomRetry, RetryPolicies.noRetry())).setTimeout(RaftProtos.RaftClientRequestProto.TypeCase.WRITE, RequestTypeDependentRetryPolicyCreator.toTimeDuration(ratisClientConfig.getWriteRequestTimeout())).setTimeout(RaftProtos.RaftClientRequestProto.TypeCase.WATCH, RequestTypeDependentRetryPolicyCreator.toTimeDuration(ratisClientConfig.getWatchRequestTimeout())).build();
    }

    private static ExponentialBackoffRetry createExponentialBackoffPolicy(RatisClientConfig ratisClientConfig) {
        return ExponentialBackoffRetry.newBuilder().setBaseSleepTime(RequestTypeDependentRetryPolicyCreator.toTimeDuration(ratisClientConfig.getExponentialPolicyBaseSleep())).setMaxSleepTime(RequestTypeDependentRetryPolicyCreator.toTimeDuration(ratisClientConfig.getExponentialPolicyMaxSleep())).setMaxAttempts(ratisClientConfig.getExponentialPolicyMaxRetries()).build();
    }

    private static ExceptionDependentRetry createExceptionDependentPolicy(ExponentialBackoffRetry exponentialBackoffRetry, MultipleLinearRandomRetry multipleLinearRandomRetry, RetryPolicy timeoutPolicy) {
        ExceptionDependentRetry.Builder builder = ExceptionDependentRetry.newBuilder();
        for (Class c : NO_RETRY_EXCEPTIONS) {
            builder.setExceptionToPolicy(c, RetryPolicies.noRetry());
        }
        return builder.setExceptionToPolicy(ResourceUnavailableException.class, (RetryPolicy)exponentialBackoffRetry).setExceptionToPolicy(TimeoutIOException.class, timeoutPolicy).setDefaultPolicy((RetryPolicy)multipleLinearRandomRetry).build();
    }

    private static TimeDuration toTimeDuration(Duration duration) {
        return RequestTypeDependentRetryPolicyCreator.toTimeDuration(duration.toMillis());
    }

    private static TimeDuration toTimeDuration(long milliseconds) {
        return TimeDuration.valueOf((long)milliseconds, (TimeUnit)TimeUnit.MILLISECONDS);
    }
}

