/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.Principal;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.server.OzoneAdmins;
import org.apache.hadoop.hdds.utils.DBCheckpointMetrics;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.hdds.utils.db.DBCheckpoint;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.ozone.lock.BootstrapStateHandler;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBCheckpointServlet
extends HttpServlet
implements BootstrapStateHandler {
    private static final String FIELD_NAME = "toExcludeSST[]";
    private static final Logger LOG = LoggerFactory.getLogger(DBCheckpointServlet.class);
    private static final long serialVersionUID = 1L;
    private transient DBStore dbStore;
    private transient DBCheckpointMetrics dbMetrics;
    private boolean aclEnabled;
    private boolean isSpnegoEnabled;
    private transient OzoneAdmins admins;
    private transient BootstrapStateHandler.Lock lock;
    private transient File bootstrapTempData;

    public void initialize(DBStore store, DBCheckpointMetrics metrics, boolean omAclEnabled, Collection<String> allowedAdminUsers, Collection<String> allowedAdminGroups, boolean isSpnegoAuthEnabled) throws ServletException {
        this.dbStore = store;
        this.dbMetrics = metrics;
        if (this.dbStore == null) {
            LOG.error("Unable to set metadata snapshot request. DB Store is null");
            throw new ServletException("DB Store is null");
        }
        this.aclEnabled = omAclEnabled;
        this.admins = new OzoneAdmins(allowedAdminUsers, allowedAdminGroups);
        this.isSpnegoEnabled = isSpnegoAuthEnabled;
        this.lock = new Lock();
        File dbLocation = this.dbStore.getDbLocation();
        if (dbLocation == null) {
            throw new NullPointerException("dblocation null");
        }
        String tempData = dbLocation.getParent();
        if (tempData == null) {
            throw new NullPointerException("tempData dir is null");
        }
        this.bootstrapTempData = Paths.get(tempData, "temp-bootstrap-data").toFile();
        if (this.bootstrapTempData.exists()) {
            try {
                FileUtils.cleanDirectory((File)this.bootstrapTempData);
            }
            catch (IOException e) {
                LOG.error("Failed to clean-up: {} dir.", (Object)this.bootstrapTempData);
                throw new ServletException("Failed to clean-up: " + this.bootstrapTempData);
            }
        }
        if (!this.bootstrapTempData.exists() && !this.bootstrapTempData.mkdirs()) {
            throw new ServletException("Failed to make:" + this.bootstrapTempData);
        }
    }

    private boolean hasPermission(UserGroupInformation user) {
        if (this.aclEnabled && this.isSpnegoEnabled) {
            return this.admins.isAdmin(user);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateSnapshotCheckpoint(HttpServletRequest request, HttpServletResponse response, boolean isFormData) {
        String[] sstParam;
        if (this.dbStore == null) {
            LOG.error("Unable to process metadata snapshot request. DB Store is null");
            response.setStatus(500);
            return;
        }
        if (this.aclEnabled) {
            Principal userPrincipal = request.getUserPrincipal();
            if (userPrincipal == null) {
                String remoteUser = request.getRemoteUser();
                LOG.error("Permission denied: Unauthorized access to /dbCheckpoint, no user principal found. Current login user is {}.", (Object)(remoteUser != null ? "'" + remoteUser + "'" : "UNKNOWN"));
                response.setStatus(403);
                return;
            }
            String userPrincipalName = userPrincipal.getName();
            UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)userPrincipalName);
            if (!this.hasPermission(ugi)) {
                LOG.error("Permission denied: User principal '{}' does not have access to /dbCheckpoint.\nThis can happen when Ozone Manager is started with a different user.\n Please append '{}' to OM 'ozone.administrators' config and restart OM to grant current user access to this endpoint.", (Object)userPrincipalName, (Object)userPrincipalName);
                response.setStatus(403);
                return;
            }
            LOG.debug("Granted user principal '{}' access to /dbCheckpoint.", (Object)userPrincipalName);
        }
        DBCheckpoint checkpoint = null;
        boolean flush = false;
        String flushParam = request.getParameter("flushBeforeCheckpoint");
        if (StringUtils.isNotEmpty((CharSequence)flushParam)) {
            flush = Boolean.parseBoolean(flushParam);
        }
        ArrayList<String> receivedSstList = new ArrayList<String>();
        ArrayList<String> excludedSstList = new ArrayList<String>();
        String[] stringArray = sstParam = isFormData ? DBCheckpointServlet.parseFormDataParameters(request) : request.getParameterValues("toExcludeSST");
        if (sstParam != null) {
            receivedSstList.addAll(Arrays.stream(sstParam).filter(s -> s.endsWith(".sst")).distinct().collect(Collectors.toList()));
            LOG.info("Received excluding SST {}", receivedSstList);
        }
        Path tmpdir = null;
        try (BootstrapStateHandler.Lock lock = this.getBootstrapStateLock().lock();){
            tmpdir = Files.createTempDirectory(this.bootstrapTempData.toPath(), "bootstrap-data-", new FileAttribute[0]);
            checkpoint = this.getCheckpoint(tmpdir, flush);
            if (checkpoint == null || checkpoint.getCheckpointLocation() == null) {
                LOG.error("Unable to process metadata snapshot request. Checkpoint request returned null.");
                response.setStatus(500);
                return;
            }
            this.dbMetrics.setLastCheckpointCreationTimeTaken(checkpoint.checkpointCreationTimeTaken());
            Path file = checkpoint.getCheckpointLocation().getFileName();
            if (file == null) {
                return;
            }
            response.setContentType("application/x-tar");
            response.setHeader("Content-Disposition", "attachment; filename=\"" + file + ".tar\"");
            Instant start = Instant.now();
            this.writeDbDataToStream(checkpoint, request, (OutputStream)response.getOutputStream(), receivedSstList, excludedSstList, tmpdir);
            Instant end = Instant.now();
            long duration = Duration.between(start, end).toMillis();
            LOG.info("Time taken to write the checkpoint to response output stream: {} milliseconds", (Object)duration);
            LOG.info("Excluded SST {} from the latest checkpoint.", excludedSstList);
            if (!excludedSstList.isEmpty()) {
                this.dbMetrics.incNumIncrementalCheckpoint();
            }
            this.dbMetrics.setLastCheckpointStreamingNumSSTExcluded(excludedSstList.size());
            this.dbMetrics.setLastCheckpointStreamingTimeTaken(duration);
            this.dbMetrics.incNumCheckpoints();
        }
        catch (Exception e) {
            LOG.error("Unable to process metadata snapshot request. ", (Throwable)e);
            response.setStatus(500);
            this.dbMetrics.incNumCheckpointFails();
        }
        finally {
            try {
                if (tmpdir != null) {
                    FileUtils.deleteDirectory((File)tmpdir.toFile());
                }
            }
            catch (IOException e) {
                LOG.error("unable to delete: " + tmpdir);
            }
            if (checkpoint != null) {
                try {
                    checkpoint.cleanupCheckpoint();
                }
                catch (IOException e) {
                    LOG.error("Error trying to clean checkpoint at {} .", (Object)checkpoint.getCheckpointLocation().toString());
                }
            }
        }
    }

    public DBCheckpoint getCheckpoint(Path ignoredTmpdir, boolean flush) throws IOException {
        return this.dbStore.getCheckpoint(flush);
    }

    private static String[] parseFormDataParameters(HttpServletRequest request) {
        ServletFileUpload upload = new ServletFileUpload();
        ArrayList<String> sstParam = new ArrayList<String>();
        try {
            FileItemIterator iter = upload.getItemIterator(request);
            while (iter.hasNext()) {
                FileItemStream item = iter.next();
                if (!item.isFormField() || !FIELD_NAME.equals(item.getFieldName())) continue;
                sstParam.add(Streams.asString((InputStream)item.openStream()));
            }
        }
        catch (Exception e) {
            LOG.warn("Exception occured during form data parsing {}", (Object)e.getMessage());
        }
        return sstParam.isEmpty() ? null : sstParam.toArray(new String[0]);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        LOG.info("Received GET request to obtain DB checkpoint snapshot");
        this.generateSnapshotCheckpoint(request, response, false);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        LOG.info("Received POST request to obtain DB checkpoint snapshot");
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            response.setStatus(400);
            return;
        }
        this.generateSnapshotCheckpoint(request, response, true);
    }

    public void writeDbDataToStream(DBCheckpoint checkpoint, HttpServletRequest ignoredRequest, OutputStream destination, List<String> toExcludeList, List<String> excludedList, Path tmpdir) throws IOException, InterruptedException {
        Objects.requireNonNull(toExcludeList);
        Objects.requireNonNull(excludedList);
        HddsServerUtil.writeDBCheckpointToStream(checkpoint, destination, toExcludeList, excludedList);
    }

    public DBStore getDbStore() {
        return this.dbStore;
    }

    public BootstrapStateHandler.Lock getBootstrapStateLock() {
        return this.lock;
    }

    public static class Lock
    extends BootstrapStateHandler.Lock {
        public BootstrapStateHandler.Lock lock() throws InterruptedException {
            return this;
        }

        public void unlock() {
        }
    }
}

