/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline.choose.algorithms;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hdds.scm.PipelineChoosePolicy;
import org.apache.hadoop.hdds.scm.PipelineRequestInformation;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.choose.algorithms.RandomPipelineChoosePolicy;

public class HealthyPipelineChoosePolicy
implements PipelineChoosePolicy {
    private PipelineChoosePolicy randomPolicy = new RandomPipelineChoosePolicy();

    @Override
    public Pipeline choosePipeline(List<Pipeline> pipelineList, PipelineRequestInformation pri) {
        Pipeline fallback = null;
        while (!pipelineList.isEmpty()) {
            Pipeline pipeline = this.randomPolicy.choosePipeline(pipelineList, pri);
            if (pipeline.isHealthy()) {
                return pipeline;
            }
            fallback = pipeline;
            pipelineList.remove(pipeline);
        }
        return fallback;
    }

    @Override
    public int choosePipelineIndex(List<Pipeline> pipelineList, PipelineRequestInformation pri) {
        ArrayList<Pipeline> mutableList = new ArrayList<Pipeline>(pipelineList);
        Pipeline pipeline = this.choosePipeline(mutableList, pri);
        return pipelineList.indexOf(pipeline);
    }
}

