/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication.health;

import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.ReplicationManagerReport;
import org.apache.hadoop.hdds.scm.container.replication.ContainerCheckRequest;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManager;
import org.apache.hadoop.hdds.scm.container.replication.health.AbstractCheck;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClosedWithUnhealthyReplicasHandler
extends AbstractCheck {
    public static final Logger LOG = LoggerFactory.getLogger(ClosedWithUnhealthyReplicasHandler.class);
    private final ReplicationManager replicationManager;

    public ClosedWithUnhealthyReplicasHandler(ReplicationManager replicationManager) {
        this.replicationManager = replicationManager;
    }

    @Override
    public boolean handle(ContainerCheckRequest request) {
        ContainerInfo containerInfo = request.getContainerInfo();
        if (containerInfo.getReplicationType() != HddsProtos.ReplicationType.EC) {
            return false;
        }
        if (containerInfo.getState() != HddsProtos.LifeCycleState.CLOSED) {
            return false;
        }
        LOG.debug("Checking container {} in ClosedWithUnhealthyReplicasHandler", (Object)containerInfo);
        Set<ContainerReplica> replicas = request.getContainerReplicas();
        Set closedIndexes = replicas.stream().filter(replica -> replica.getState() == StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED).map(ContainerReplica::getReplicaIndex).collect(Collectors.toSet());
        boolean foundUnhealthy = false;
        for (ContainerReplica replica2 : replicas) {
            if (replica2.getState() != StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.UNHEALTHY) continue;
            if (!closedIndexes.contains(replica2.getReplicaIndex())) {
                LOG.warn("Not handling container {} because replica index {} is under replicated. Not deleting UNHEALTHY replica [{}].", new Object[]{containerInfo.containerID(), replica2.getReplicaIndex(), replica2});
                return false;
            }
            foundUnhealthy = true;
            if (request.isReadOnly()) continue;
            this.sendDeleteCommand(containerInfo, replica2);
        }
        if (foundUnhealthy) {
            request.getReport().incrementAndSample(ReplicationManagerReport.HealthState.OVER_REPLICATED, containerInfo.containerID());
        }
        LOG.debug("Returning {} for container {}", (Object)foundUnhealthy, (Object)containerInfo);
        return foundUnhealthy;
    }

    private void sendDeleteCommand(ContainerInfo containerInfo, ContainerReplica replica) {
        LOG.debug("Trying to delete UNHEALTHY replica [{}]", (Object)replica);
        try {
            this.replicationManager.sendDeleteCommand(containerInfo, replica.getReplicaIndex(), replica.getDatanodeDetails(), true);
        }
        catch (NotLeaderException e) {
            LOG.warn("Failed to delete UNHEALTHY replica [{}]", (Object)replica, (Object)e);
        }
    }
}

