/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.StorageUnit;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.PlacementPolicy;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.replication.CommandTargetOverloadedException;
import org.apache.hadoop.hdds.scm.container.replication.ContainerHealthResult;
import org.apache.hadoop.hdds.scm.container.replication.ContainerReplicaOp;
import org.apache.hadoop.hdds.scm.container.replication.QuasiClosedStuckReplicaCount;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManager;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManagerMetrics;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManagerUtil;
import org.apache.hadoop.hdds.scm.container.replication.UnhealthyReplicationHandler;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.pipeline.InsufficientDatanodesException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuasiClosedStuckUnderReplicationHandler
implements UnhealthyReplicationHandler {
    public static final Logger LOG = LoggerFactory.getLogger(QuasiClosedStuckUnderReplicationHandler.class);
    private final PlacementPolicy placementPolicy;
    private final ReplicationManager replicationManager;
    private final long currentContainerSize;
    private final ReplicationManagerMetrics metrics;

    public QuasiClosedStuckUnderReplicationHandler(PlacementPolicy placementPolicy, ConfigurationSource conf, ReplicationManager replicationManager) {
        this.placementPolicy = placementPolicy;
        this.currentContainerSize = (long)conf.getStorageSize("ozone.scm.container.size", "5GB", StorageUnit.BYTES);
        this.replicationManager = replicationManager;
        this.metrics = replicationManager.getMetrics();
    }

    @Override
    public int processAndSendCommands(Set<ContainerReplica> replicas, List<ContainerReplicaOp> pendingOps, ContainerHealthResult result, int remainingMaintenanceRedundancy) throws IOException {
        ContainerInfo containerInfo = result.getContainerInfo();
        LOG.debug("Handling under replicated QuasiClosed Stuck Ratis container {}", (Object)containerInfo);
        int pendingAdd = 0;
        for (ContainerReplicaOp op : pendingOps) {
            if (op.getOpType() != ContainerReplicaOp.PendingOpType.ADD) continue;
            ++pendingAdd;
        }
        if (pendingAdd > 0) {
            LOG.debug("Container {} has pending add operations. No more replication will be scheduled until they complete", (Object)containerInfo);
            return 0;
        }
        QuasiClosedStuckReplicaCount replicaCount = new QuasiClosedStuckReplicaCount(replicas, remainingMaintenanceRedundancy);
        List<QuasiClosedStuckReplicaCount.MisReplicatedOrigin> misReplicatedOrigins = replicaCount.getUnderReplicatedReplicas();
        if (misReplicatedOrigins.isEmpty()) {
            LOG.debug("Container {} is not under replicated", (Object)containerInfo);
            return 0;
        }
        int totalRequiredReplicas = 0;
        int totalCommandsSent = 0;
        Throwable firstException = null;
        ArrayList<ContainerReplicaOp> mutablePendingOps = new ArrayList<ContainerReplicaOp>(pendingOps);
        for (QuasiClosedStuckReplicaCount.MisReplicatedOrigin origin : misReplicatedOrigins) {
            List<DatanodeDetails> targets;
            totalRequiredReplicas += origin.getReplicaDelta();
            try {
                targets = this.getTargets(containerInfo, replicas, origin.getReplicaDelta(), mutablePendingOps);
            }
            catch (SCMException e) {
                if (firstException == null) {
                    firstException = e;
                }
                LOG.warn("Cannot replicate container {} because no suitable targets were found.", (Object)containerInfo, (Object)e);
                continue;
            }
            List<DatanodeDetails> sourceDatanodes = origin.getSources().stream().map(ContainerReplica::getDatanodeDetails).collect(Collectors.toList());
            for (DatanodeDetails target : targets) {
                try {
                    this.replicationManager.sendThrottledReplicationCommand(containerInfo, sourceDatanodes, target, 0);
                    mutablePendingOps.add(ContainerReplicaOp.create(ContainerReplicaOp.PendingOpType.ADD, target, 0));
                    ++totalCommandsSent;
                }
                catch (CommandTargetOverloadedException e) {
                    LOG.warn("Cannot replicate container {} because all sources are overloaded.", (Object)containerInfo);
                    if (firstException != null) continue;
                    firstException = e;
                }
            }
        }
        if (firstException != null || totalCommandsSent < totalRequiredReplicas) {
            LOG.info("A command was not sent for all required new replicas for container {}. Total sent {}, required {} ", new Object[]{containerInfo, totalCommandsSent, totalRequiredReplicas});
            this.metrics.incrPartialReplicationTotal();
            if (firstException != null) {
                throw firstException;
            }
            throw new InsufficientDatanodesException(totalRequiredReplicas, totalCommandsSent);
        }
        return totalCommandsSent;
    }

    private List<DatanodeDetails> getTargets(ContainerInfo containerInfo, Set<ContainerReplica> replicas, int additionalRequired, List<ContainerReplicaOp> pendingOps) throws IOException {
        LOG.debug("Need {} target datanodes for container {}. Current replicas: {}.", new Object[]{additionalRequired, containerInfo, replicas});
        ReplicationManagerUtil.ExcludedAndUsedNodes excludedAndUsedNodes = ReplicationManagerUtil.getExcludedAndUsedNodes(containerInfo, new ArrayList<ContainerReplica>(replicas), Collections.emptySet(), pendingOps, this.replicationManager);
        List<DatanodeDetails> excluded = excludedAndUsedNodes.getExcludedNodes();
        List<DatanodeDetails> used = excludedAndUsedNodes.getUsedNodes();
        LOG.debug("UsedList: {}, size {}. ExcludeList: {}, size: {}. ", new Object[]{used, used.size(), excluded, excluded.size()});
        return ReplicationManagerUtil.getTargetDatanodes(this.placementPolicy, additionalRequired, used, excluded, this.currentContainerSize, containerInfo);
    }
}

