/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.ozoneimpl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Instant;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.impl.ContainerSet;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.interfaces.Handler;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.keyvalue.TarContainerPacker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerController {
    private final ContainerSet containerSet;
    private final Map<ContainerProtos.ContainerType, Handler> handlers;
    private static final Logger LOG = LoggerFactory.getLogger(ContainerController.class);

    public ContainerController(ContainerSet containerSet, Map<ContainerProtos.ContainerType, Handler> handlers) {
        this.containerSet = containerSet;
        this.handlers = handlers;
    }

    public Container getContainer(long containerId) {
        return this.containerSet.getContainer(containerId);
    }

    public String getContainerLocation(long containerId) {
        Container<?> cont = this.containerSet.getContainer(containerId);
        if (cont != null) {
            return ((ContainerData)cont.getContainerData()).getContainerPath();
        }
        return "nonexistent";
    }

    public void markContainerForClose(long containerId) throws IOException {
        Container<?> container = this.containerSet.getContainer(containerId);
        if (container == null) {
            Set<Long> missingContainerSet = this.containerSet.getMissingContainerSet();
            String warning = missingContainerSet.contains(containerId) ? "The Container is in the MissingContainerSet hence we can't close it. ContainerID: " + containerId : "The Container is not found. ContainerID: " + containerId;
            LOG.warn(warning);
            throw new ContainerNotFoundException(warning);
        }
        if (container.getContainerState() == ContainerProtos.ContainerDataProto.State.OPEN) {
            this.getHandler(container).markContainerForClose(container);
        }
    }

    public void markContainerUnhealthy(long containerId, Container.ScanResult reason) throws IOException {
        Container<?> container = this.containerSet.getContainer(containerId);
        if (container != null) {
            this.getHandler(container).markContainerUnhealthy(container, reason);
        } else {
            LOG.warn("Container {} not found, may be deleted, skip mark UNHEALTHY", (Object)containerId);
        }
    }

    public StorageContainerDatanodeProtocolProtos.ContainerReportsProto getContainerReport() throws IOException {
        return this.containerSet.getContainerReport();
    }

    public void quasiCloseContainer(long containerId, String reason) throws IOException {
        Container<?> container = this.containerSet.getContainer(containerId);
        this.getHandler(container).quasiCloseContainer(container, reason);
    }

    public void closeContainer(long containerId) throws IOException {
        Container<?> container = this.containerSet.getContainer(containerId);
        this.getHandler(container).closeContainer(container);
    }

    public void addFinalizedBlock(long containerId, long localId) {
        Container<?> container = this.containerSet.getContainer(containerId);
        if (container != null) {
            this.getHandler(container).addFinalizedBlock(container, localId);
        }
    }

    public boolean isFinalizedBlockExist(long containerId, long localId) {
        Container<?> container = this.containerSet.getContainer(containerId);
        if (container != null) {
            return this.getHandler(container).isFinalizedBlockExist(container, localId);
        }
        return false;
    }

    public Container importContainer(ContainerData containerData, InputStream rawContainerStream, TarContainerPacker packer) throws IOException {
        return this.handlers.get(containerData.getContainerType()).importContainer(containerData, rawContainerStream, packer);
    }

    public void exportContainer(ContainerProtos.ContainerType type, long containerId, OutputStream outputStream, TarContainerPacker packer) throws IOException {
        this.handlers.get(type).exportContainer(this.containerSet.getContainer(containerId), outputStream, packer);
    }

    public void deleteContainer(long containerId, boolean force) throws IOException {
        Container<?> container = this.containerSet.getContainer(containerId);
        if (container != null) {
            this.getHandler(container).deleteContainer(container, force);
        }
    }

    private Handler getHandler(Container container) {
        return this.handlers.get(container.getContainerType());
    }

    public Iterable<Container<?>> getContainers() {
        return this.containerSet;
    }

    public Iterator<Container<?>> getContainers(HddsVolume volume) {
        return this.containerSet.getContainerIterator(volume);
    }

    public long getContainerCount(HddsVolume volume) {
        return this.containerSet.containerCount(volume);
    }

    void updateDataScanTimestamp(long containerId, Instant timestamp) throws IOException {
        Container<?> container = this.containerSet.getContainer(containerId);
        if (container != null) {
            container.updateDataScanTimestamp(timestamp);
        } else {
            LOG.warn("Container {} not found, may be deleted, skip update DataScanTimestamp", (Object)containerId);
        }
    }
}

