/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.metadata;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.utils.db.BatchOperationHandler;
import org.apache.hadoop.hdds.utils.db.DBDefinition;
import org.apache.hadoop.hdds.utils.db.DBProfile;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.DBStoreBuilder;
import org.apache.hadoop.hdds.utils.db.managed.ManagedColumnFamilyOptions;
import org.apache.hadoop.hdds.utils.db.managed.ManagedDBOptions;
import org.apache.hadoop.ozone.container.common.statemachine.DatanodeConfiguration;
import org.apache.hadoop.ozone.container.common.utils.db.DatanodeDBProfile;
import org.apache.hadoop.ozone.container.metadata.DBStoreManager;
import org.rocksdb.InfoLogLevel;

public abstract class AbstractRDBStore<DEF extends DBDefinition>
implements DBStoreManager {
    private final DEF dbDef;
    private final ManagedColumnFamilyOptions cfOptions;
    private static DatanodeDBProfile dbProfile;
    private final boolean openReadOnly;
    private volatile DBStore store;

    protected AbstractRDBStore(DEF dbDef, ConfigurationSource config, boolean openReadOnly) throws IOException {
        dbProfile = DatanodeDBProfile.getProfile((DBProfile)config.getEnum("hdds.db.profile", (Enum)DBStoreBuilder.HDDS_DEFAULT_DB_PROFILE));
        this.cfOptions = dbProfile.getColumnFamilyOptions(config);
        this.dbDef = dbDef;
        this.openReadOnly = openReadOnly;
        this.start(config);
    }

    @Override
    public void start(ConfigurationSource config) throws IOException {
        if (this.store == null) {
            ManagedDBOptions options = dbProfile.getDBOptions();
            options.setCreateIfMissing(true);
            options.setCreateMissingColumnFamilies(true);
            DatanodeConfiguration dc = (DatanodeConfiguration)((Object)config.getObject(DatanodeConfiguration.class));
            InfoLogLevel level = InfoLogLevel.valueOf((String)(dc.getRocksdbLogLevel() + "_LEVEL"));
            options.setInfoLogLevel(level);
            options.setMaxLogFileSize(dc.getRocksdbLogMaxFileSize());
            options.setKeepLogFileNum((long)dc.getRocksdbLogMaxFileNum());
            this.store = this.initDBStore(DBStoreBuilder.newBuilder((ConfigurationSource)config, this.dbDef).setDBOptions(options).setDefaultCFOptions(this.cfOptions).setOpenReadOnly(this.openReadOnly), options, config);
        }
    }

    protected abstract DBStore initDBStore(DBStoreBuilder var1, ManagedDBOptions var2, ConfigurationSource var3) throws IOException;

    @Override
    public synchronized void stop() throws Exception {
        if (this.store != null) {
            this.store.close();
            this.store = null;
        }
    }

    @Override
    public DBStore getStore() {
        return this.store;
    }

    @Override
    public synchronized boolean isClosed() {
        if (this.store == null) {
            return true;
        }
        return this.store.isClosed();
    }

    @Override
    public BatchOperationHandler getBatchHandler() {
        return this.store;
    }

    @Override
    public void close() throws IOException {
        this.store.close();
        this.cfOptions.close();
    }

    @Override
    public void flushDB() throws IOException {
        this.store.flushDB();
    }

    @Override
    public void flushLog(boolean sync) throws IOException {
        this.store.flushLog(sync);
    }

    @Override
    public void compactDB() throws IOException {
        this.store.compactDB();
    }

    @VisibleForTesting
    public DatanodeDBProfile getDbProfile() {
        return dbProfile;
    }

    protected DEF getDbDef() {
        return this.dbDef;
    }
}

