/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.volume;

import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutFeature;
import org.apache.hadoop.hdfs.server.datanode.checker.VolumeCheckResult;
import org.apache.hadoop.ozone.container.common.statemachine.DatanodeConfiguration;
import org.apache.hadoop.ozone.container.common.utils.DatanodeStoreCache;
import org.apache.hadoop.ozone.container.common.utils.HddsVolumeUtil;
import org.apache.hadoop.ozone.container.common.utils.RawDB;
import org.apache.hadoop.ozone.container.common.utils.StorageVolumeUtil;
import org.apache.hadoop.ozone.container.common.volume.DbVolume;
import org.apache.hadoop.ozone.container.common.volume.MutableVolumeSet;
import org.apache.hadoop.ozone.container.common.volume.StorageVolume;
import org.apache.hadoop.ozone.container.common.volume.VolumeIOStats;
import org.apache.hadoop.ozone.container.common.volume.VolumeInfoMetrics;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerController;
import org.apache.hadoop.ozone.container.upgrade.VersionedDatanodeFeatures;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class HddsVolume
extends StorageVolume {
    private static final Logger LOG = LoggerFactory.getLogger(HddsVolume.class);
    public static final String HDDS_VOLUME_DIR = "hdds";
    public static final String TMP_CONTAINER_DELETE_DIR_NAME = "deleted-containers";
    private final VolumeIOStats volumeIOStats;
    private final VolumeInfoMetrics volumeInfoMetrics;
    private ContainerController controller;
    private final AtomicLong committedBytes = new AtomicLong();
    private final StorageVolume.VolumeType type = StorageVolume.VolumeType.DATA_VOLUME;
    private DbVolume dbVolume;
    private File dbParentDir;
    private File deletedContainerDir;
    private AtomicBoolean dbLoaded = new AtomicBoolean(false);
    private final AtomicBoolean dbLoadFailure = new AtomicBoolean(false);

    private HddsVolume(Builder b) throws IOException {
        super(b);
        if (!b.getFailedVolume() && this.getVolumeInfo().isPresent()) {
            this.setState(StorageVolume.VolumeState.NOT_INITIALIZED);
            ConfigurationSource conf = this.getConf();
            int[] intervals = conf.getInts("ozone.volume.io.percentiles.intervals.seconds");
            this.volumeIOStats = new VolumeIOStats(b.getVolumeRootStr(), this.getStorageDir().toString(), intervals);
            this.volumeInfoMetrics = new VolumeInfoMetrics(b.getVolumeRootStr(), this);
            LOG.info("Creating HddsVolume: {} of storage type: {}, {}", new Object[]{this.getStorageDir(), b.getStorageType(), this.getCurrentUsage()});
            this.initialize();
        } else {
            this.setState(StorageVolume.VolumeState.FAILED);
            this.volumeIOStats = null;
            this.volumeInfoMetrics = new VolumeInfoMetrics(b.getVolumeRootStr(), this);
        }
    }

    @Override
    public void createWorkingDir(String dirName, MutableVolumeSet dbVolumeSet) throws IOException {
        super.createWorkingDir(dirName, dbVolumeSet);
        if (VersionedDatanodeFeatures.isFinalized(HDDSLayoutFeature.DATANODE_SCHEMA_V3)) {
            this.createDbStore(dbVolumeSet);
        }
    }

    @Override
    public void createTmpDirs(String workDirName) throws IOException {
        super.createTmpDirs(workDirName);
        this.deletedContainerDir = this.createTmpSubdirIfNeeded(TMP_CONTAINER_DELETE_DIR_NAME);
        this.cleanDeletedContainerDir();
    }

    public File getHddsRootDir() {
        return super.getStorageDir();
    }

    public StorageVolume.VolumeType getType() {
        return this.type;
    }

    public VolumeIOStats getVolumeIOStats() {
        return this.volumeIOStats;
    }

    public VolumeInfoMetrics getVolumeInfoStats() {
        return this.volumeInfoMetrics;
    }

    @Override
    public void failVolume() {
        super.failVolume();
        if (this.volumeIOStats != null) {
            this.volumeIOStats.unregister();
        }
        this.closeDbStore();
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.volumeIOStats != null) {
            this.volumeIOStats.unregister();
        }
        if (this.volumeInfoMetrics != null) {
            this.volumeInfoMetrics.unregister();
        }
        this.closeDbStore();
        this.cleanDeletedContainerDir();
    }

    public void cleanDeletedContainerDir() {
        if (this.deletedContainerDir == null) {
            return;
        }
        if (!this.deletedContainerDir.exists()) {
            LOG.warn("Unable to clear deleted containers from {}. Directory does not exist.", (Object)this.deletedContainerDir);
            return;
        }
        if (!this.deletedContainerDir.isDirectory()) {
            LOG.warn("Unable to clear deleted containers from {}. Location is not a directory", (Object)this.deletedContainerDir);
            return;
        }
        File[] containerDirs = this.deletedContainerDir.listFiles(File::isDirectory);
        if (containerDirs == null) {
            LOG.warn("Failed to clear container delete directory {}. Directory could not be accessed.", (Object)this.deletedContainerDir);
            return;
        }
        for (File containerDir : containerDirs) {
            try {
                if (containerDir.isDirectory()) {
                    FileUtils.deleteDirectory((File)containerDir);
                    continue;
                }
                FileUtils.delete((File)containerDir);
            }
            catch (IOException ex) {
                LOG.warn("Failed to remove container directory {}.", (Object)this.deletedContainerDir, (Object)ex);
            }
        }
    }

    @Override
    public synchronized VolumeCheckResult check(@Nullable Boolean unused) throws Exception {
        VolumeCheckResult result = super.check(unused);
        DatanodeConfiguration df = (DatanodeConfiguration)((Object)this.getConf().getObject(DatanodeConfiguration.class));
        if (this.isDbLoadFailure()) {
            LOG.warn("Volume {} failed to access RocksDB: RocksDB parent directory is null, the volume might not have been loaded properly.", (Object)this.getStorageDir());
            return VolumeCheckResult.FAILED;
        }
        if (result != VolumeCheckResult.HEALTHY || !df.getContainerSchemaV3Enabled() || !this.isDbLoaded()) {
            return result;
        }
        File dbFile = new File(this.dbParentDir, "container.db");
        if (!dbFile.exists() || !dbFile.canRead()) {
            LOG.warn("Volume {} failed health check. Could not access RocksDB at {}", (Object)this.getStorageDir(), (Object)dbFile);
            return VolumeCheckResult.FAILED;
        }
        return VolumeCheckResult.HEALTHY;
    }

    public long incCommittedBytes(long delta) {
        return this.committedBytes.addAndGet(delta);
    }

    public long getCommittedBytes() {
        return this.committedBytes.get();
    }

    public void setDbVolume(DbVolume dbVolume) {
        this.dbVolume = dbVolume;
    }

    public DbVolume getDbVolume() {
        return this.dbVolume;
    }

    public File getDbParentDir() {
        return this.dbParentDir;
    }

    @VisibleForTesting
    public void setDbParentDir(File dbParentDir) {
        this.dbParentDir = dbParentDir;
    }

    public File getDeletedContainerDir() {
        return this.deletedContainerDir;
    }

    @VisibleForTesting
    public void setDeletedContainerDir(File deletedContainerDir) {
        this.deletedContainerDir = deletedContainerDir;
    }

    public boolean isDbLoaded() {
        return this.dbLoaded.get();
    }

    public boolean isDbLoadFailure() {
        return this.dbLoadFailure.get();
    }

    public void loadDbStore(boolean readOnly) throws IOException {
        if (!this.getStorageState().equals((Object)StorageVolume.VolumeState.NORMAL)) {
            return;
        }
        if (this.dbLoaded.get()) {
            LOG.warn("Schema V3 db is already loaded from {} for volume {}", (Object)this.getDbParentDir(), (Object)this.getStorageID());
            return;
        }
        File clusterIdDir = new File(this.dbVolume == null ? this.getStorageDir() : this.dbVolume.getStorageDir(), this.getClusterID());
        if (!clusterIdDir.exists()) {
            throw new IOException("Working dir " + clusterIdDir.getAbsolutePath() + " not created for HddsVolume: " + this.getStorageDir().getAbsolutePath());
        }
        File storageIdDir = new File(clusterIdDir, this.getStorageID());
        if (!storageIdDir.exists()) {
            throw new IOException("Db parent dir " + storageIdDir.getAbsolutePath() + " not found for HddsVolume: " + this.getStorageDir().getAbsolutePath());
        }
        File containerDBFile = new File(storageIdDir, "container.db");
        if (!containerDBFile.exists()) {
            throw new IOException("Db dir " + storageIdDir.getAbsolutePath() + " not found for HddsVolume: " + this.getStorageDir().getAbsolutePath());
        }
        String containerDBPath = containerDBFile.getAbsolutePath();
        try {
            HddsVolumeUtil.initPerDiskDBStore(containerDBPath, this.getConf(), readOnly);
        }
        catch (Throwable e) {
            this.dbLoadFailure.set(true);
            throw new IOException("Can't init db instance under path " + containerDBPath + " for volume " + this.getStorageID(), e);
        }
        this.dbParentDir = storageIdDir;
        this.dbLoaded.set(true);
        LOG.info("SchemaV3 db is loaded at {} for volume {}", (Object)containerDBPath, (Object)this.getStorageID());
    }

    public void setController(ContainerController controller) {
        this.controller = controller;
    }

    public long getContainers() {
        if (this.controller != null) {
            return this.controller.getContainerCount(this);
        }
        return 0L;
    }

    public void createDbStore(MutableVolumeSet dbVolumeSet) throws IOException {
        File clusterIdDir;
        String workingDirName;
        DbVolume chosenDbVolume = null;
        String string = workingDirName = this.getWorkingDirName() == null ? this.getClusterID() : this.getWorkingDirName();
        if (dbVolumeSet == null || dbVolumeSet.getVolumesList().isEmpty()) {
            clusterIdDir = new File(this.getStorageDir(), workingDirName);
        } else {
            List<DbVolume> dbVolumeList = StorageVolumeUtil.getDbVolumesList(dbVolumeSet.getVolumesList());
            chosenDbVolume = dbVolumeList.get(ThreadLocalRandom.current().nextInt(dbVolumeList.size()));
            clusterIdDir = new File(chosenDbVolume.getStorageDir(), workingDirName);
        }
        if (!clusterIdDir.exists()) {
            throw new IOException("The working dir " + clusterIdDir.getAbsolutePath() + " is missing for volume " + this.getStorageID());
        }
        File storageIdDir = new File(clusterIdDir, this.getStorageID());
        if (!storageIdDir.mkdirs() && !storageIdDir.exists()) {
            throw new IOException("Can't make subdir under " + clusterIdDir.getAbsolutePath() + " for volume " + this.getStorageID());
        }
        String containerDBPath = new File(storageIdDir, "container.db").getAbsolutePath();
        try {
            HddsVolumeUtil.initPerDiskDBStore(containerDBPath, this.getConf(), false);
            this.dbLoaded.set(true);
            this.dbLoadFailure.set(false);
            LOG.info("SchemaV3 db is created and loaded at {} for volume {}", (Object)containerDBPath, (Object)this.getStorageID());
        }
        catch (IOException e) {
            this.dbLoadFailure.set(true);
            String errMsg = "Can't create db instance under path " + containerDBPath + " for volume " + this.getStorageID();
            LOG.error(errMsg, (Throwable)e);
            throw new IOException(errMsg);
        }
        this.dbVolume = chosenDbVolume;
        this.dbParentDir = storageIdDir;
        if (chosenDbVolume != null) {
            chosenDbVolume.addHddsDbStorePath(this.getStorageID(), containerDBPath);
        }
        if (!VersionedDatanodeFeatures.SchemaV3.isFinalizedAndEnabled(this.getConf())) {
            this.closeDbStore();
        }
    }

    private void closeDbStore() {
        if (!this.dbLoaded.get()) {
            return;
        }
        String containerDBPath = new File(this.dbParentDir, "container.db").getAbsolutePath();
        DatanodeStoreCache.getInstance().removeDB(containerDBPath);
        this.dbLoaded.set(false);
        this.dbLoadFailure.set(false);
        LOG.info("SchemaV3 db is stopped at {} for volume {}", (Object)containerDBPath, (Object)this.getStorageID());
    }

    public void compactDb() {
        File dbFile = new File(this.getDbParentDir(), "container.db");
        String dbFilePath = dbFile.getAbsolutePath();
        try {
            RawDB rawDB = DatanodeStoreCache.getInstance().getDB(dbFilePath, this.getConf());
            long start = Time.monotonicNowNanos();
            rawDB.getStore().compactionIfNeeded();
            this.volumeInfoMetrics.dbCompactTimesNanoSecondsIncr(Time.monotonicNowNanos() - start);
        }
        catch (Exception e) {
            LOG.warn("compact rocksdb error in {}", (Object)dbFilePath, (Object)e);
        }
    }

    public static class Builder
    extends StorageVolume.Builder<Builder> {
        public Builder(String volumeRootStr) {
            super(volumeRootStr, HddsVolume.HDDS_VOLUME_DIR);
        }

        @Override
        public Builder getThis() {
            return this;
        }

        @Override
        public HddsVolume build() throws IOException {
            return new HddsVolume(this);
        }
    }
}

