/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.client.retry;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.ratis.client.retry.ClientRetryEvent;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.retry.RetryPolicies;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.TimeDuration;

public final class RequestTypeDependentRetryPolicy
implements RetryPolicy {
    private final Map<RaftProtos.RaftClientRequestProto.TypeCase, RetryPolicy> retryPolicyMap;
    private final Map<RaftProtos.RaftClientRequestProto.TypeCase, TimeDuration> timeoutMap;
    private final Supplier<String> myString;

    public static Builder newBuilder() {
        return new Builder();
    }

    private RequestTypeDependentRetryPolicy(EnumMap<RaftProtos.RaftClientRequestProto.TypeCase, RetryPolicy> map, EnumMap<RaftProtos.RaftClientRequestProto.TypeCase, TimeDuration> timeoutMap) {
        this.retryPolicyMap = Collections.unmodifiableMap(map);
        this.timeoutMap = timeoutMap;
        this.myString = () -> {
            StringBuilder b = new StringBuilder(JavaUtils.getClassSimpleName(this.getClass())).append("{");
            map.forEach((key, value) -> b.append(key).append("->").append(value).append(", "));
            b.setLength(b.length() - 2);
            return b.append("}").toString();
        };
    }

    @Override
    public RetryPolicy.Action handleAttemptFailure(RetryPolicy.Event event) {
        if (!(event instanceof ClientRetryEvent)) {
            return RetryPolicies.retryForeverNoSleep().handleAttemptFailure(event);
        }
        ClientRetryEvent clientEvent = (ClientRetryEvent)event;
        TimeDuration timeout2 = this.timeoutMap.get(clientEvent.getRequest().getType().getTypeCase());
        if (timeout2 != null && clientEvent.isRequestTimeout(timeout2)) {
            return NO_RETRY_ACTION;
        }
        return Optional.ofNullable(this.retryPolicyMap.get(clientEvent.getRequest().getType().getTypeCase())).orElse(RetryPolicies.retryForeverNoSleep()).handleAttemptFailure(event);
    }

    public String toString() {
        return this.myString.get();
    }

    public static class Builder {
        private final EnumMap<RaftProtos.RaftClientRequestProto.TypeCase, RetryPolicy> retryPolicyMap = new EnumMap(RaftProtos.RaftClientRequestProto.TypeCase.class);
        private EnumMap<RaftProtos.RaftClientRequestProto.TypeCase, TimeDuration> timeoutMap = new EnumMap(RaftProtos.RaftClientRequestProto.TypeCase.class);

        public Builder setRetryPolicy(RaftProtos.RaftClientRequestProto.TypeCase type, RetryPolicy policy) {
            RetryPolicy previous = this.retryPolicyMap.put(type, policy);
            Preconditions.assertNull((Object)previous, () -> "The retryPolicy for type " + type + " is already set to " + previous);
            return this;
        }

        public Builder setTimeout(RaftProtos.RaftClientRequestProto.TypeCase type, TimeDuration timeout2) {
            TimeDuration previous = this.timeoutMap.put(type, timeout2);
            Preconditions.assertNull((Object)previous, () -> "The timeout for type " + type + " is already set to " + previous);
            return this;
        }

        public RequestTypeDependentRetryPolicy build() {
            return new RequestTypeDependentRetryPolicy(this.retryPolicyMap, this.timeoutMap);
        }
    }
}

