/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.org.bouncycastle.tsp.ers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.tsp.PartialHashtree;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.operator.DigestCalculator;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.tsp.ers.ByteArrayComparator;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.tsp.ers.ERSData;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.tsp.ers.ExpUtil;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.tsp.ers.IndexedHash;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.tsp.ers.SortedHashList;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.tsp.ers.SortedIndexedHashList;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.util.io.Streams;

class ERSUtil {
    private static final Comparator<byte[]> hashComp = new ByteArrayComparator();

    private ERSUtil() {
    }

    static byte[] calculateDigest(DigestCalculator digestCalculator, byte[] byArray) {
        try {
            OutputStream outputStream2 = digestCalculator.getOutputStream();
            outputStream2.write(byArray);
            outputStream2.close();
            return digestCalculator.getDigest();
        }
        catch (IOException iOException) {
            throw ExpUtil.createIllegalState("unable to calculate hash: " + iOException.getMessage(), iOException);
        }
    }

    static byte[] calculateBranchHash(DigestCalculator digestCalculator, byte[] byArray, byte[] byArray2) {
        if (hashComp.compare(byArray, byArray2) <= 0) {
            return ERSUtil.calculateDigest(digestCalculator, byArray, byArray2);
        }
        return ERSUtil.calculateDigest(digestCalculator, byArray2, byArray);
    }

    static byte[] calculateBranchHash(DigestCalculator digestCalculator, byte[][] byArray) {
        if (byArray.length == 2) {
            return ERSUtil.calculateBranchHash(digestCalculator, byArray[0], byArray[1]);
        }
        return ERSUtil.calculateDigest(digestCalculator, ERSUtil.buildIndexedHashList(byArray).iterator());
    }

    static byte[] calculateDigest(DigestCalculator digestCalculator, byte[] byArray, byte[] byArray2) {
        try {
            OutputStream outputStream2 = digestCalculator.getOutputStream();
            outputStream2.write(byArray);
            outputStream2.write(byArray2);
            outputStream2.close();
            return digestCalculator.getDigest();
        }
        catch (IOException iOException) {
            throw ExpUtil.createIllegalState("unable to calculate hash: " + iOException.getMessage(), iOException);
        }
    }

    static byte[] calculateDigest(DigestCalculator digestCalculator, Iterator<byte[]> iterator2) {
        try {
            OutputStream outputStream2 = digestCalculator.getOutputStream();
            while (iterator2.hasNext()) {
                outputStream2.write(iterator2.next());
            }
            outputStream2.close();
            return digestCalculator.getDigest();
        }
        catch (IOException iOException) {
            throw ExpUtil.createIllegalState("unable to calculate hash: " + iOException.getMessage(), iOException);
        }
    }

    static byte[] calculateDigest(DigestCalculator digestCalculator, InputStream inputStream2) {
        try {
            OutputStream outputStream2 = digestCalculator.getOutputStream();
            Streams.pipeAll(inputStream2, outputStream2);
            outputStream2.close();
            return digestCalculator.getDigest();
        }
        catch (IOException iOException) {
            throw ExpUtil.createIllegalState("unable to calculate hash: " + iOException.getMessage(), iOException);
        }
    }

    static byte[] computeNodeHash(DigestCalculator digestCalculator, PartialHashtree partialHashtree) {
        byte[][] byArray = partialHashtree.getValues();
        if (byArray.length > 1) {
            return ERSUtil.calculateDigest(digestCalculator, ERSUtil.buildIndexedHashList(byArray).iterator());
        }
        return byArray[0];
    }

    static List<byte[]> buildIndexedHashList(byte[][] byArray) {
        SortedHashList sortedHashList = new SortedHashList();
        for (int i = 0; i != byArray.length; ++i) {
            sortedHashList.add(byArray[i]);
        }
        return sortedHashList.toList();
    }

    static List<byte[]> buildHashList(DigestCalculator digestCalculator, List<ERSData> list, byte[] byArray) {
        SortedHashList sortedHashList = new SortedHashList();
        for (int i = 0; i != list.size(); ++i) {
            sortedHashList.add(list.get(i).getHash(digestCalculator, byArray));
        }
        return sortedHashList.toList();
    }

    static List<IndexedHash> buildIndexedHashList(DigestCalculator digestCalculator, List<ERSData> list, byte[] byArray) {
        SortedIndexedHashList sortedIndexedHashList = new SortedIndexedHashList();
        for (int i = 0; i != list.size(); ++i) {
            byte[] byArray2 = list.get(i).getHash(digestCalculator, byArray);
            sortedIndexedHashList.add(new IndexedHash(i, byArray2));
        }
        return sortedIndexedHashList.toList();
    }

    static byte[] concatPreviousHashes(DigestCalculator digestCalculator, byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            return byArray2;
        }
        try {
            OutputStream outputStream2 = digestCalculator.getOutputStream();
            outputStream2.write(byArray2);
            outputStream2.write(byArray);
            outputStream2.close();
            return digestCalculator.getDigest();
        }
        catch (IOException iOException) {
            throw new IllegalStateException("unable to hash data");
        }
    }
}

