/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.org.bouncycastle.math.ec.endo;

import java.math.BigInteger;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.math.ec.ECCurve;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.math.ec.ECPointMap;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.math.ec.ScaleXPointMap;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.math.ec.endo.EndoUtil;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.math.ec.endo.GLVEndomorphism;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.math.ec.endo.GLVTypeBParameters;

public class GLVTypeBEndomorphism
implements GLVEndomorphism {
    protected final GLVTypeBParameters parameters;
    protected final ECPointMap pointMap;

    public GLVTypeBEndomorphism(ECCurve eCCurve, GLVTypeBParameters gLVTypeBParameters) {
        this.parameters = gLVTypeBParameters;
        this.pointMap = new ScaleXPointMap(eCCurve.fromBigInteger(gLVTypeBParameters.getBeta()));
    }

    @Override
    public BigInteger[] decomposeScalar(BigInteger bigInteger) {
        return EndoUtil.decomposeScalar(this.parameters.getSplitParams(), bigInteger);
    }

    @Override
    public ECPointMap getPointMap() {
        return this.pointMap;
    }

    @Override
    public boolean hasEfficientPointMap() {
        return true;
    }
}

