/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.org.bouncycastle.crypto.digests;

import org.apache.hadoop.ozone.shaded.org.bouncycastle.crypto.DataLengthException;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.crypto.ExtendedDigest;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.crypto.OutputLengthException;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.util.Arrays;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.util.Longs;

abstract class AsconBaseDigest
implements ExtendedDigest {
    protected long x0;
    protected long x1;
    protected long x2;
    protected long x3;
    protected long x4;
    protected final int CRYPTO_BYTES = 32;
    protected final int ASCON_HASH_RATE = 8;
    protected int ASCON_PB_ROUNDS = 12;
    protected final byte[] m_buf = new byte[8];
    protected int m_bufPos = 0;

    AsconBaseDigest() {
    }

    private void round(long l) {
        long l2 = this.x0 ^ this.x1 ^ this.x2 ^ this.x3 ^ l ^ this.x1 & (this.x0 ^ this.x2 ^ this.x4 ^ l);
        long l3 = this.x0 ^ this.x2 ^ this.x3 ^ this.x4 ^ l ^ (this.x1 ^ this.x2 ^ l) & (this.x1 ^ this.x3);
        long l4 = this.x1 ^ this.x2 ^ this.x4 ^ l ^ this.x3 & this.x4;
        long l5 = this.x0 ^ this.x1 ^ this.x2 ^ l ^ (this.x0 ^ 0xFFFFFFFFFFFFFFFFL) & (this.x3 ^ this.x4);
        long l6 = this.x1 ^ this.x3 ^ this.x4 ^ (this.x0 ^ this.x4) & this.x1;
        this.x0 = l2 ^ Longs.rotateRight(l2, 19) ^ Longs.rotateRight(l2, 28);
        this.x1 = l3 ^ Longs.rotateRight(l3, 39) ^ Longs.rotateRight(l3, 61);
        this.x2 = l4 ^ Longs.rotateRight(l4, 1) ^ Longs.rotateRight(l4, 6) ^ 0xFFFFFFFFFFFFFFFFL;
        this.x3 = l5 ^ Longs.rotateRight(l5, 10) ^ Longs.rotateRight(l5, 17);
        this.x4 = l6 ^ Longs.rotateRight(l6, 7) ^ Longs.rotateRight(l6, 41);
    }

    protected void p(int n) {
        if (n == 12) {
            this.round(240L);
            this.round(225L);
            this.round(210L);
            this.round(195L);
        }
        if (n >= 8) {
            this.round(180L);
            this.round(165L);
        }
        this.round(150L);
        this.round(135L);
        this.round(120L);
        this.round(105L);
        this.round(90L);
        this.round(75L);
    }

    protected abstract long pad(int var1);

    protected abstract long loadBytes(byte[] var1, int var2);

    protected abstract long loadBytes(byte[] var1, int var2, int var3);

    protected abstract void setBytes(long var1, byte[] var3, int var4);

    protected abstract void setBytes(long var1, byte[] var3, int var4, int var5);

    @Override
    public int getDigestSize() {
        return 32;
    }

    @Override
    public int getByteLength() {
        return 8;
    }

    @Override
    public void update(byte by) {
        this.m_buf[this.m_bufPos] = by;
        if (++this.m_bufPos == 8) {
            this.x0 ^= this.loadBytes(this.m_buf, 0);
            this.p(this.ASCON_PB_ROUNDS);
            this.m_bufPos = 0;
        }
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        int n3;
        if (n + n2 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        int n4 = 8 - this.m_bufPos;
        if (n2 < n4) {
            System.arraycopy(byArray, n, this.m_buf, this.m_bufPos, n2);
            this.m_bufPos += n2;
            return;
        }
        int n5 = 0;
        if (this.m_bufPos > 0) {
            System.arraycopy(byArray, n, this.m_buf, this.m_bufPos, n4);
            n5 += n4;
            this.x0 ^= this.loadBytes(this.m_buf, 0);
            this.p(this.ASCON_PB_ROUNDS);
        }
        while ((n3 = n2 - n5) >= 8) {
            this.x0 ^= this.loadBytes(byArray, n + n5);
            this.p(this.ASCON_PB_ROUNDS);
            n5 += 8;
        }
        System.arraycopy(byArray, n + n5, this.m_buf, 0, n3);
        this.m_bufPos = n3;
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        return this.hash(byArray, n, 32);
    }

    protected void padAndAbsorb() {
        this.x0 ^= this.loadBytes(this.m_buf, 0, this.m_bufPos);
        this.x0 ^= this.pad(this.m_bufPos);
        this.p(12);
    }

    protected void squeeze(byte[] byArray, int n, int n2) {
        while (n2 > 8) {
            this.setBytes(this.x0, byArray, n);
            this.p(this.ASCON_PB_ROUNDS);
            n += 8;
            n2 -= 8;
        }
        this.setBytes(this.x0, byArray, n, n2);
        this.reset();
    }

    protected int hash(byte[] byArray, int n, int n2) {
        if (32 + n > byArray.length) {
            throw new OutputLengthException("output buffer is too short");
        }
        this.padAndAbsorb();
        this.squeeze(byArray, n, n2);
        return n2;
    }

    @Override
    public void reset() {
        Arrays.clear(this.m_buf);
        this.m_bufPos = 0;
    }
}

