/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.org.apache.thrift.protocol;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Stack;
import org.apache.hadoop.ozone.shaded.org.apache.thrift.TException;
import org.apache.hadoop.ozone.shaded.org.apache.thrift.protocol.TField;
import org.apache.hadoop.ozone.shaded.org.apache.thrift.protocol.TList;
import org.apache.hadoop.ozone.shaded.org.apache.thrift.protocol.TMap;
import org.apache.hadoop.ozone.shaded.org.apache.thrift.protocol.TMessage;
import org.apache.hadoop.ozone.shaded.org.apache.thrift.protocol.TProtocol;
import org.apache.hadoop.ozone.shaded.org.apache.thrift.protocol.TProtocolFactory;
import org.apache.hadoop.ozone.shaded.org.apache.thrift.protocol.TSet;
import org.apache.hadoop.ozone.shaded.org.apache.thrift.protocol.TStruct;
import org.apache.hadoop.ozone.shaded.org.apache.thrift.transport.TTransport;
import org.apache.hadoop.ozone.shaded.org.apache.thrift.transport.TTransportException;

public class TSimpleJSONProtocol
extends TProtocol {
    private static final byte[] COMMA = new byte[]{44};
    private static final byte[] COLON = new byte[]{58};
    private static final byte[] LBRACE = new byte[]{123};
    private static final byte[] RBRACE = new byte[]{125};
    private static final byte[] LBRACKET = new byte[]{91};
    private static final byte[] RBRACKET = new byte[]{93};
    private static final char QUOTE = '\"';
    private static final TStruct ANONYMOUS_STRUCT = new TStruct();
    private static final TField ANONYMOUS_FIELD = new TField();
    private static final TMessage EMPTY_MESSAGE = new TMessage();
    private static final TSet EMPTY_SET = new TSet();
    private static final TList EMPTY_LIST = new TList();
    private static final TMap EMPTY_MAP = new TMap();
    private static final String LIST = "list";
    private static final String SET = "set";
    private static final String MAP = "map";
    protected final Context BASE_CONTEXT = new Context();
    protected Stack<Context> writeContextStack_ = new Stack();
    protected Context writeContext_ = this.BASE_CONTEXT;

    protected void pushWriteContext(Context c) {
        this.writeContextStack_.push(this.writeContext_);
        this.writeContext_ = c;
    }

    protected void popWriteContext() {
        this.writeContext_ = this.writeContextStack_.pop();
    }

    protected void resetWriteContext() {
        while (!this.writeContextStack_.isEmpty()) {
            this.popWriteContext();
        }
    }

    protected void assertContextIsNotMapKey(String invalidKeyType) throws CollectionMapKeyException {
        if (this.writeContext_.isMapKey()) {
            throw new CollectionMapKeyException("Cannot serialize a map with keys that are of type " + invalidKeyType);
        }
    }

    public TSimpleJSONProtocol(TTransport trans) {
        super(trans);
    }

    @Override
    public void writeMessageBegin(TMessage message) throws TException {
        this.resetWriteContext();
        this.trans_.write(LBRACKET);
        this.pushWriteContext(new ListContext());
        this.writeString(message.name);
        this.writeByte(message.type);
        this.writeI32(message.seqid);
    }

    @Override
    public void writeMessageEnd() throws TException {
        this.popWriteContext();
        this.trans_.write(RBRACKET);
    }

    @Override
    public void writeStructBegin(TStruct struct) throws TException {
        this.writeContext_.write();
        this.trans_.write(LBRACE);
        this.pushWriteContext(new StructContext());
    }

    @Override
    public void writeStructEnd() throws TException {
        this.popWriteContext();
        this.trans_.write(RBRACE);
    }

    @Override
    public void writeFieldBegin(TField field) throws TException {
        this.writeString(field.name);
    }

    @Override
    public void writeFieldEnd() throws TException {
    }

    @Override
    public void writeFieldStop() throws TException {
    }

    @Override
    public void writeMapBegin(TMap map) throws TException {
        this.assertContextIsNotMapKey(MAP);
        this.writeContext_.write();
        this.trans_.write(LBRACE);
        this.pushWriteContext(new MapContext());
    }

    @Override
    public void writeMapEnd() throws TException {
        this.popWriteContext();
        this.trans_.write(RBRACE);
    }

    @Override
    public void writeListBegin(TList list) throws TException {
        this.assertContextIsNotMapKey(LIST);
        this.writeContext_.write();
        this.trans_.write(LBRACKET);
        this.pushWriteContext(new ListContext());
    }

    @Override
    public void writeListEnd() throws TException {
        this.popWriteContext();
        this.trans_.write(RBRACKET);
    }

    @Override
    public void writeSetBegin(TSet set) throws TException {
        this.assertContextIsNotMapKey(SET);
        this.writeContext_.write();
        this.trans_.write(LBRACKET);
        this.pushWriteContext(new ListContext());
    }

    @Override
    public void writeSetEnd() throws TException {
        this.popWriteContext();
        this.trans_.write(RBRACKET);
    }

    @Override
    public void writeBool(boolean b) throws TException {
        this.writeByte(b ? (byte)1 : 0);
    }

    @Override
    public void writeByte(byte b) throws TException {
        this.writeI32(b);
    }

    @Override
    public void writeI16(short i16) throws TException {
        this.writeI32(i16);
    }

    @Override
    public void writeI32(int i32) throws TException {
        if (this.writeContext_.isMapKey()) {
            this.writeString(Integer.toString(i32));
        } else {
            this.writeContext_.write();
            this._writeStringData(Integer.toString(i32));
        }
    }

    public void _writeStringData(String s2) throws TException {
        byte[] b = s2.getBytes(StandardCharsets.UTF_8);
        this.trans_.write(b);
    }

    @Override
    public void writeI64(long i64) throws TException {
        if (this.writeContext_.isMapKey()) {
            this.writeString(Long.toString(i64));
        } else {
            this.writeContext_.write();
            this._writeStringData(Long.toString(i64));
        }
    }

    @Override
    public void writeDouble(double dub) throws TException {
        if (this.writeContext_.isMapKey()) {
            this.writeString(Double.toString(dub));
        } else {
            this.writeContext_.write();
            this._writeStringData(Double.toString(dub));
        }
    }

    @Override
    public void writeString(String str) throws TException {
        this.writeContext_.write();
        int length = str.length();
        StringBuffer escape = new StringBuffer(length + 16);
        escape.append('\"');
        block8: for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    escape.append('\\');
                    escape.append(c);
                    continue block8;
                }
                case '\b': {
                    escape.append('\\');
                    escape.append('b');
                    continue block8;
                }
                case '\f': {
                    escape.append('\\');
                    escape.append('f');
                    continue block8;
                }
                case '\n': {
                    escape.append('\\');
                    escape.append('n');
                    continue block8;
                }
                case '\r': {
                    escape.append('\\');
                    escape.append('r');
                    continue block8;
                }
                case '\t': {
                    escape.append('\\');
                    escape.append('t');
                    continue block8;
                }
                default: {
                    if (c < ' ') {
                        String hex = Integer.toHexString(c);
                        escape.append('\\');
                        escape.append('u');
                        for (int j = 4; j > hex.length(); --j) {
                            escape.append('0');
                        }
                        escape.append(hex);
                        continue block8;
                    }
                    escape.append(c);
                }
            }
        }
        escape.append('\"');
        this._writeStringData(escape.toString());
    }

    @Override
    public void writeBinary(ByteBuffer bin) throws TException {
        this.writeString(new String(bin.array(), bin.position() + bin.arrayOffset(), bin.limit() - bin.position() - bin.arrayOffset(), StandardCharsets.UTF_8));
    }

    @Override
    public TMessage readMessageBegin() throws TException {
        throw new TException("Not implemented");
    }

    @Override
    public void readMessageEnd() throws TException {
        throw new TException("Not implemented");
    }

    @Override
    public TStruct readStructBegin() throws TException {
        throw new TException("Not implemented");
    }

    @Override
    public void readStructEnd() throws TException {
        throw new TException("Not implemented");
    }

    @Override
    public TField readFieldBegin() throws TException {
        throw new TException("Not implemented");
    }

    @Override
    public void readFieldEnd() throws TException {
        throw new TException("Not implemented");
    }

    @Override
    public TMap readMapBegin() throws TException {
        throw new TException("Not implemented");
    }

    @Override
    public void readMapEnd() throws TException {
        throw new TException("Not implemented");
    }

    @Override
    public TList readListBegin() throws TException {
        throw new TException("Not implemented");
    }

    @Override
    public void readListEnd() throws TException {
        throw new TException("Not implemented");
    }

    @Override
    public TSet readSetBegin() throws TException {
        throw new TException("Not implemented");
    }

    @Override
    public void readSetEnd() throws TException {
        throw new TException("Not implemented");
    }

    @Override
    public boolean readBool() throws TException {
        throw new TException("Not implemented");
    }

    @Override
    public byte readByte() throws TException {
        throw new TException("Not implemented");
    }

    @Override
    public short readI16() throws TException {
        throw new TException("Not implemented");
    }

    @Override
    public int readI32() throws TException {
        throw new TException("Not implemented");
    }

    @Override
    public long readI64() throws TException {
        throw new TException("Not implemented");
    }

    @Override
    public double readDouble() throws TException {
        throw new TException("Not implemented");
    }

    @Override
    public String readString() throws TException {
        throw new TException("Not implemented");
    }

    public String readStringBody(int size) throws TException {
        throw new TException("Not implemented");
    }

    @Override
    public ByteBuffer readBinary() throws TException {
        throw new TException("Not implemented");
    }

    @Override
    public int getMinSerializedSize(byte type) throws TException {
        switch (type) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 1;
            }
            case 6: {
                return 1;
            }
            case 8: {
                return 1;
            }
            case 10: {
                return 1;
            }
            case 11: {
                return 2;
            }
            case 12: {
                return 2;
            }
            case 13: {
                return 2;
            }
            case 14: {
                return 2;
            }
            case 15: {
                return 2;
            }
        }
        throw new TTransportException(0, "unrecognized type code");
    }

    public static class CollectionMapKeyException
    extends TException {
        public CollectionMapKeyException(String message) {
            super(message);
        }
    }

    protected class MapContext
    extends StructContext {
        protected boolean isKey;

        protected MapContext() {
            this.isKey = true;
        }

        @Override
        protected void write() throws TException {
            super.write();
            this.isKey = !this.isKey;
        }

        @Override
        protected boolean isMapKey() {
            return this.isKey;
        }
    }

    protected class StructContext
    extends Context {
        protected boolean first_;
        protected boolean colon_;

        protected StructContext() {
            this.first_ = true;
            this.colon_ = true;
        }

        @Override
        protected void write() throws TException {
            if (this.first_) {
                this.first_ = false;
                this.colon_ = true;
            } else {
                TSimpleJSONProtocol.this.trans_.write(this.colon_ ? COLON : COMMA);
                this.colon_ = !this.colon_;
            }
        }
    }

    protected class ListContext
    extends Context {
        protected boolean first_;

        protected ListContext() {
            this.first_ = true;
        }

        @Override
        protected void write() throws TException {
            if (this.first_) {
                this.first_ = false;
            } else {
                TSimpleJSONProtocol.this.trans_.write(COMMA);
            }
        }
    }

    protected class Context {
        protected Context() {
        }

        protected void write() throws TException {
        }

        protected boolean isMapKey() {
            return false;
        }
    }

    public static class Factory
    implements TProtocolFactory {
        @Override
        public TProtocol getProtocol(TTransport trans) {
            return new TSimpleJSONProtocol(trans);
        }
    }
}

