/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.baggage;

import java.util.HashMap;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.JaegerSpan;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.JaegerSpanContext;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.baggage.Restriction;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.metrics.Metrics;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.spi.BaggageRestrictionManager;

public class BaggageSetter {
    private final BaggageRestrictionManager restrictionManager;
    private final Metrics metrics;

    public BaggageSetter(BaggageRestrictionManager restrictionManager, Metrics metrics) {
        this.restrictionManager = restrictionManager;
        this.metrics = metrics;
    }

    public JaegerSpanContext setBaggage(JaegerSpan jaegerSpan, String key, String value) {
        Restriction restriction = this.restrictionManager.getRestriction(jaegerSpan.getServiceName(), key);
        boolean truncated = false;
        String prevItem = null;
        if (!restriction.isKeyAllowed()) {
            this.metrics.baggageUpdateFailure.inc(1L);
            this.logFields(jaegerSpan, key, value, prevItem, truncated, restriction.isKeyAllowed());
            return jaegerSpan.context();
        }
        if (value != null && value.length() > restriction.getMaxValueLength()) {
            truncated = true;
            value = value.substring(0, restriction.getMaxValueLength());
            this.metrics.baggageTruncate.inc(1L);
        }
        prevItem = jaegerSpan.getBaggageItem(key);
        this.logFields(jaegerSpan, key, value, prevItem, truncated, restriction.isKeyAllowed());
        this.metrics.baggageUpdateSuccess.inc(1L);
        return jaegerSpan.context().withBaggageItem(key, value);
    }

    private void logFields(JaegerSpan jaegerSpan, String key, String value, String prevItem, boolean truncated, boolean valid) {
        if (!jaegerSpan.context().isSampled()) {
            return;
        }
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("event", "baggage");
        fields.put("key", key);
        fields.put("value", value);
        if (prevItem != null) {
            fields.put("override", "true");
        }
        if (truncated) {
            fields.put("truncated", "true");
        }
        if (!valid) {
            fields.put("invalid", "true");
        }
        jaegerSpan.log(fields);
    }
}

