/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.io.jaegertracing.internal;

import org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.JaegerSpanContext;
import org.apache.hadoop.ozone.shaded.io.opentracing.Scope;
import org.apache.hadoop.ozone.shaded.io.opentracing.ScopeManager;
import org.apache.hadoop.ozone.shaded.io.opentracing.Span;
import org.apache.hadoop.ozone.shaded.io.opentracing.util.ThreadLocalScopeManager;
import org.slf4j.MDC;

public class MDCScopeManager
implements ScopeManager {
    private final ScopeManager wrappedScopeManager;
    private final String mdcTraceIdKey;
    private final String mdcSpanIdKey;
    private final String mdcSampledKey;

    private MDCScopeManager(Builder builder) {
        this.wrappedScopeManager = builder.scopeManager;
        this.mdcTraceIdKey = builder.mdcTraceIdKey;
        this.mdcSpanIdKey = builder.mdcSpanIdKey;
        this.mdcSampledKey = builder.mdcSampledKey;
    }

    @Override
    public Scope activate(Span span) {
        return new MDCScope(this.wrappedScopeManager.activate(span), span);
    }

    @Override
    public Span activeSpan() {
        return this.wrappedScopeManager.activeSpan();
    }

    private class MDCScope
    implements Scope {
        private final Scope wrappedScope;
        private final String previousTraceId;
        private final String previousSpanId;
        private final String previousSampled;

        MDCScope(Scope scope, Span span) {
            this.wrappedScope = scope;
            this.previousTraceId = MDC.get((String)MDCScopeManager.this.mdcTraceIdKey);
            this.previousSpanId = MDC.get((String)MDCScopeManager.this.mdcSpanIdKey);
            this.previousSampled = MDC.get((String)MDCScopeManager.this.mdcSampledKey);
            if (span.context() instanceof JaegerSpanContext) {
                this.putContext((JaegerSpanContext)span.context());
            }
        }

        protected void putContext(JaegerSpanContext spanContext) {
            this.replace(MDCScopeManager.this.mdcTraceIdKey, spanContext.toTraceId());
            this.replace(MDCScopeManager.this.mdcSpanIdKey, spanContext.toSpanId());
            this.replace(MDCScopeManager.this.mdcSampledKey, String.valueOf(spanContext.isSampled()));
        }

        private void replace(String key, String value) {
            if (value == null) {
                MDC.remove((String)key);
            } else {
                MDC.put((String)key, (String)value);
            }
        }

        @Override
        public void close() {
            this.wrappedScope.close();
            this.replace(MDCScopeManager.this.mdcTraceIdKey, this.previousTraceId);
            this.replace(MDCScopeManager.this.mdcSpanIdKey, this.previousSpanId);
            this.replace(MDCScopeManager.this.mdcSampledKey, this.previousSampled);
        }
    }

    public static class Builder {
        private ScopeManager scopeManager = new ThreadLocalScopeManager();
        private String mdcTraceIdKey = "traceId";
        private String mdcSpanIdKey = "spanId";
        private String mdcSampledKey = "sampled";

        public Builder withScopeManager(ScopeManager scopeManager) {
            this.scopeManager = scopeManager;
            return this;
        }

        public Builder withMDCTraceIdKey(String mdcTraceIdKey) {
            this.mdcTraceIdKey = mdcTraceIdKey;
            return this;
        }

        public Builder withMDCSpanIdKey(String mdcSpanIdKey) {
            this.mdcSpanIdKey = mdcSpanIdKey;
            return this;
        }

        public Builder withMDCSampledKey(String mdcSampledKey) {
            this.mdcSampledKey = mdcSampledKey;
            return this;
        }

        public MDCScopeManager build() {
            return new MDCScopeManager(this);
        }
    }
}

