/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.security;

import java.util.Collection;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class OzoneDelegationTokenSelector
extends AbstractDelegationTokenSelector<OzoneTokenIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneDelegationTokenSelector.class);

    public OzoneDelegationTokenSelector() {
        super(OzoneTokenIdentifier.KIND_NAME);
    }

    public Token<OzoneTokenIdentifier> selectToken(Text service, Collection<Token<? extends TokenIdentifier>> tokens) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Getting token for service {}", (Object)service);
        }
        Token<OzoneTokenIdentifier> token = this.getSelectedTokens(service, tokens);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Got tokens: {} for service {}", token, (Object)service);
        }
        return token;
    }

    private Token<OzoneTokenIdentifier> getSelectedTokens(Text service, Collection<Token<? extends TokenIdentifier>> tokens) {
        if (service == null) {
            return null;
        }
        for (Token<? extends TokenIdentifier> token : tokens) {
            if (!OzoneTokenIdentifier.KIND_NAME.equals((Object)token.getKind()) || !token.getService().toString().contains(service.toString())) continue;
            return token;
        }
        return null;
    }
}

