/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.audit.Auditable;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.GDPRSymmetricKey;
import org.apache.hadoop.ozone.shaded.com.google.common.annotations.VisibleForTesting;

public final class OmKeyArgs
implements Auditable {
    private final String volumeName;
    private final String bucketName;
    private final String keyName;
    private final String ownerName;
    private long dataSize;
    private final ReplicationConfig replicationConfig;
    private List<OmKeyLocationInfo> locationInfoList;
    private final boolean isMultipartKey;
    private final String multipartUploadID;
    private final int multipartUploadPartNumber;
    private final Map<String, String> metadata;
    private final boolean sortDatanodesInPipeline;
    private final List<OzoneAcl> acls;
    private final boolean latestVersionLocation;
    private final boolean recursive;
    private final boolean headOp;
    private final boolean forceUpdateContainerCacheFromSCM;
    private final Map<String, String> tags;
    private Long expectedDataGeneration = null;

    private OmKeyArgs(Builder b) {
        this.volumeName = b.volumeName;
        this.bucketName = b.bucketName;
        this.keyName = b.keyName;
        this.dataSize = b.dataSize;
        this.replicationConfig = b.replicationConfig;
        this.locationInfoList = b.locationInfoList;
        this.isMultipartKey = b.isMultipartKey;
        this.multipartUploadID = b.multipartUploadID;
        this.multipartUploadPartNumber = b.multipartUploadPartNumber;
        this.metadata = b.metadata;
        this.acls = b.acls;
        this.sortDatanodesInPipeline = b.sortDatanodesInPipeline;
        this.latestVersionLocation = b.latestVersionLocation;
        this.recursive = b.recursive;
        this.headOp = b.headOp;
        this.forceUpdateContainerCacheFromSCM = b.forceUpdateContainerCacheFromSCM;
        this.ownerName = b.ownerName;
        this.tags = b.tags;
        this.expectedDataGeneration = b.expectedDataGeneration;
    }

    public boolean getIsMultipartKey() {
        return this.isMultipartKey;
    }

    public String getMultipartUploadID() {
        return this.multipartUploadID;
    }

    public int getMultipartUploadPartNumber() {
        return this.multipartUploadPartNumber;
    }

    public ReplicationConfig getReplicationConfig() {
        return this.replicationConfig;
    }

    public List<OzoneAcl> getAcls() {
        return this.acls;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public String getOwner() {
        return this.ownerName;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public void setDataSize(long size) {
        this.dataSize = size;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setLocationInfoList(List<OmKeyLocationInfo> locationInfoList) {
        this.locationInfoList = locationInfoList;
    }

    public List<OmKeyLocationInfo> getLocationInfoList() {
        return this.locationInfoList;
    }

    public boolean getSortDatanodes() {
        return this.sortDatanodesInPipeline;
    }

    public boolean getLatestVersionLocation() {
        return this.latestVersionLocation;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public boolean isHeadOp() {
        return this.headOp;
    }

    public boolean isForceUpdateContainerCacheFromSCM() {
        return this.forceUpdateContainerCacheFromSCM;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public Long getExpectedDataGeneration() {
        return this.expectedDataGeneration;
    }

    @Override
    public Map<String, String> toAuditMap() {
        LinkedHashMap<String, String> auditMap = new LinkedHashMap<String, String>();
        auditMap.put("volume", this.volumeName);
        auditMap.put("bucket", this.bucketName);
        auditMap.put("key", this.keyName);
        auditMap.put("owner", this.ownerName);
        auditMap.put("dataSize", String.valueOf(this.dataSize));
        auditMap.put("replicationConfig", this.replicationConfig != null ? this.replicationConfig.toString() : null);
        return auditMap;
    }

    @VisibleForTesting
    public void addLocationInfo(OmKeyLocationInfo locationInfo) {
        if (this.locationInfoList == null) {
            this.locationInfoList = new ArrayList<OmKeyLocationInfo>();
        }
        this.locationInfoList.add(locationInfo);
    }

    public Builder toBuilder() {
        Builder builder = new Builder().setVolumeName(this.volumeName).setBucketName(this.bucketName).setKeyName(this.keyName).setOwnerName(this.ownerName).setDataSize(this.dataSize).setReplicationConfig(this.replicationConfig).setLocationInfoList(this.locationInfoList).setIsMultipartKey(this.isMultipartKey).setMultipartUploadID(this.multipartUploadID).setMultipartUploadPartNumber(this.multipartUploadPartNumber).addAllMetadata(this.metadata).setSortDatanodesInPipeline(this.sortDatanodesInPipeline).setHeadOp(this.headOp).setLatestVersionLocation(this.latestVersionLocation).setAcls(this.acls).setForceUpdateContainerCacheFromSCM(this.forceUpdateContainerCacheFromSCM).addAllTags(this.tags);
        if (this.expectedDataGeneration != null) {
            builder.setExpectedDataGeneration(this.expectedDataGeneration);
        }
        return builder;
    }

    @Nonnull
    public OzoneManagerProtocolProtos.KeyArgs toProtobuf() {
        OzoneManagerProtocolProtos.KeyArgs.Builder builder = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(this.getVolumeName()).setBucketName(this.getBucketName()).setKeyName(this.getKeyName()).setDataSize(this.getDataSize()).setSortDatanodes(this.getSortDatanodes()).setLatestVersionLocation(this.getLatestVersionLocation()).setHeadOp(this.isHeadOp()).setForceUpdateContainerCacheFromSCM(this.isForceUpdateContainerCacheFromSCM());
        if (this.multipartUploadPartNumber != 0) {
            builder.setMultipartNumber(this.multipartUploadPartNumber);
        }
        if (this.expectedDataGeneration != null) {
            builder.setExpectedDataGeneration(this.expectedDataGeneration);
        }
        return builder.build();
    }

    public static class Builder {
        private String volumeName;
        private String bucketName;
        private String keyName;
        private String ownerName;
        private long dataSize;
        private ReplicationConfig replicationConfig;
        private List<OmKeyLocationInfo> locationInfoList;
        private boolean isMultipartKey;
        private String multipartUploadID;
        private int multipartUploadPartNumber;
        private final Map<String, String> metadata = new HashMap<String, String>();
        private boolean sortDatanodesInPipeline;
        private boolean latestVersionLocation;
        private List<OzoneAcl> acls;
        private boolean recursive;
        private boolean headOp;
        private boolean forceUpdateContainerCacheFromSCM;
        private final Map<String, String> tags = new HashMap<String, String>();
        private Long expectedDataGeneration = null;

        public Builder setVolumeName(String volume) {
            this.volumeName = volume;
            return this;
        }

        public Builder setBucketName(String bucket) {
            this.bucketName = bucket;
            return this;
        }

        public Builder setKeyName(String key) {
            this.keyName = key;
            return this;
        }

        public Builder setOwnerName(String owner) {
            this.ownerName = owner;
            return this;
        }

        public Builder setDataSize(long size) {
            this.dataSize = size;
            return this;
        }

        public Builder setReplicationConfig(ReplicationConfig replConfig) {
            this.replicationConfig = replConfig;
            return this;
        }

        public Builder setLocationInfoList(List<OmKeyLocationInfo> locationInfos) {
            this.locationInfoList = locationInfos;
            return this;
        }

        public Builder setAcls(List<OzoneAcl> listOfAcls) {
            this.acls = listOfAcls;
            return this;
        }

        public Builder setIsMultipartKey(boolean isMultipart) {
            this.isMultipartKey = isMultipart;
            return this;
        }

        public Builder setMultipartUploadID(String uploadID) {
            this.multipartUploadID = uploadID;
            return this;
        }

        public Builder setMultipartUploadPartNumber(int multipartUploadPartNumber) {
            this.multipartUploadPartNumber = multipartUploadPartNumber;
            return this;
        }

        public Builder addMetadata(String key, String value) {
            this.metadata.put(key, value);
            return this;
        }

        public Builder addAllMetadata(Map<String, String> metadatamap) {
            this.metadata.putAll(metadatamap);
            return this;
        }

        public Builder addAllMetadataGdpr(Map<String, String> metadatamap) {
            this.addAllMetadata(metadatamap);
            if (Boolean.parseBoolean(this.metadata.get("gdprEnabled"))) {
                GDPRSymmetricKey.newDefaultInstance().acceptKeyDetails(this.metadata::put);
            }
            return this;
        }

        public Builder addTag(String key, String value) {
            this.tags.put(key, value);
            return this;
        }

        public Builder addAllTags(Map<String, String> tagmap) {
            this.tags.putAll(tagmap);
            return this;
        }

        public Builder setSortDatanodesInPipeline(boolean sort) {
            this.sortDatanodesInPipeline = sort;
            return this;
        }

        public Builder setLatestVersionLocation(boolean latest) {
            this.latestVersionLocation = latest;
            return this;
        }

        public Builder setRecursive(boolean isRecursive) {
            this.recursive = isRecursive;
            return this;
        }

        public Builder setHeadOp(boolean isHeadOp) {
            this.headOp = isHeadOp;
            return this;
        }

        public Builder setForceUpdateContainerCacheFromSCM(boolean value) {
            this.forceUpdateContainerCacheFromSCM = value;
            return this;
        }

        public Builder setExpectedDataGeneration(long generation) {
            this.expectedDataGeneration = generation;
            return this;
        }

        public OmKeyArgs build() {
            return new OmKeyArgs(this);
        }
    }
}

