/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.ha;

import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.utils.LegacyHadoopConfigurationSource;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.exceptions.OMLeaderNotReadyException;
import org.apache.hadoop.ozone.om.exceptions.OMNotLeaderException;
import org.apache.hadoop.ozone.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.ratis.protocol.exceptions.StateMachineException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OMFailoverProxyProviderBase<T>
implements FailoverProxyProvider<T>,
Closeable {
    public static final Logger LOG = LoggerFactory.getLogger(OMFailoverProxyProviderBase.class);
    private final ConfigurationSource conf;
    private final Class<T> protocolClass;
    private Map<String, FailoverProxyProvider.ProxyInfo<T>> omProxies;
    private List<String> omNodeIDList;
    private Map<String, InetSocketAddress> omNodeAddressMap;
    private String currentProxyOMNodeId;
    private int currentProxyIndex;
    private String nextProxyOMNodeId;
    private int nextProxyIndex;
    private Set<String> attemptedOMs = new HashSet<String>();
    private String lastAttemptedOM;
    private int numAttemptsOnSameOM = 0;
    private final long waitBetweenRetries;
    private Set<String> accessControlExceptionOMs = new HashSet<String>();
    private boolean performFailoverDone;
    private final UserGroupInformation ugi;

    public OMFailoverProxyProviderBase(ConfigurationSource configuration, UserGroupInformation ugi, String omServiceId, Class<T> protocol) throws IOException {
        this.conf = configuration;
        this.protocolClass = protocol;
        this.performFailoverDone = true;
        this.ugi = ugi;
        this.waitBetweenRetries = this.conf.getLong("ozone.client.wait.between.retries.millis", 2000L);
        this.loadOMClientConfigs(this.conf, omServiceId);
        Preconditions.checkNotNull(this.omProxies);
        Preconditions.checkNotNull(this.omNodeIDList);
        Preconditions.checkNotNull(this.omNodeAddressMap);
        this.nextProxyIndex = 0;
        this.nextProxyOMNodeId = this.omNodeIDList.get(this.nextProxyIndex);
        this.currentProxyIndex = 0;
        this.currentProxyOMNodeId = this.nextProxyOMNodeId;
    }

    protected abstract void loadOMClientConfigs(ConfigurationSource var1, String var2) throws IOException;

    protected T createOMProxy(InetSocketAddress omAddress) throws IOException {
        Configuration hadoopConf = LegacyHadoopConfigurationSource.asHadoopConfiguration(this.getConf());
        RPC.setProtocolEngine((Configuration)hadoopConf, this.getInterface(), ProtobufRpcEngine.class);
        RetryPolicy connectionRetryPolicy = RetryPolicies.failoverOnNetworkException((int)0);
        return (T)RPC.getProtocolProxy(this.getInterface(), (long)RPC.getProtocolVersion(this.protocolClass), (InetSocketAddress)omAddress, (UserGroupInformation)this.ugi, (Configuration)hadoopConf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)hadoopConf), (int)((int)OmUtils.getOMClientRpcTimeOut(this.getConf())), (RetryPolicy)connectionRetryPolicy).getProxy();
    }

    protected synchronized boolean shouldFailover(Exception ex) {
        Throwable unwrappedException = HddsUtils.getUnwrappedException(ex);
        if (unwrappedException instanceof AccessControlException || unwrappedException instanceof SecretManager.InvalidToken) {
            if (this.accessControlExceptionOMs.contains(this.nextProxyOMNodeId)) {
                this.accessControlExceptionOMs.clear();
                return false;
            }
            this.accessControlExceptionOMs.add(this.nextProxyOMNodeId);
            if (this.accessControlExceptionOMs.containsAll(this.omNodeIDList)) {
                return false;
            }
        } else {
            StateMachineException smEx;
            Throwable cause;
            if (HddsUtils.shouldNotFailoverOnRpcException(unwrappedException)) {
                return false;
            }
            if (ex instanceof StateMachineException && (cause = (smEx = (StateMachineException)ex).getCause()) instanceof OMException) {
                OMException omEx = (OMException)cause;
                return omEx.getResult() != OMException.ResultCodes.NOT_SUPPORTED_OPERATION_WHEN_PREPARED;
            }
        }
        return true;
    }

    @VisibleForTesting
    public synchronized String getCurrentProxyOMNodeId() {
        return this.currentProxyOMNodeId;
    }

    @VisibleForTesting
    public RetryPolicy getRetryPolicy(final int maxFailovers) {
        RetryPolicy retryPolicy = new RetryPolicy(){

            public RetryPolicy.RetryAction shouldRetry(Exception exception, int retries, int failovers, boolean isIdempotentOrAtMostOnce) throws Exception {
                String omNodeId = OMFailoverProxyProviderBase.this.getCurrentProxyOMNodeId();
                if (LOG.isDebugEnabled()) {
                    if (exception.getCause() != null) {
                        LOG.debug("RetryProxy: OM {}: {}: {}", new Object[]{omNodeId, exception.getCause().getClass().getSimpleName(), exception.getCause().getMessage()});
                    } else {
                        LOG.debug("RetryProxy: OM {}: {}", (Object)omNodeId, (Object)exception.getMessage());
                    }
                }
                if (exception instanceof ServiceException) {
                    OMNotLeaderException notLeaderException = OMFailoverProxyProviderBase.getNotLeaderException(exception);
                    if (notLeaderException != null) {
                        String suggestedLeaderAddress = notLeaderException.getSuggestedLeaderAddress();
                        String suggestedNodeId = notLeaderException.getSuggestedLeaderNodeId();
                        if (suggestedLeaderAddress != null && suggestedNodeId != null && OMFailoverProxyProviderBase.this.omNodeAddressMap.containsKey(suggestedNodeId) && ((InetSocketAddress)OMFailoverProxyProviderBase.this.omNodeAddressMap.get(suggestedNodeId)).toString().equals(suggestedLeaderAddress)) {
                            OMFailoverProxyProviderBase.this.setNextOmProxy(suggestedNodeId);
                            return this.getRetryAction(RetryPolicy.RetryAction.RetryDecision.FAILOVER_AND_RETRY, failovers);
                        }
                        OMFailoverProxyProviderBase.this.selectNextOmProxy();
                        return this.getRetryAction(RetryPolicy.RetryAction.RetryDecision.FAILOVER_AND_RETRY, failovers);
                    }
                    OMLeaderNotReadyException leaderNotReadyException = OMFailoverProxyProviderBase.getLeaderNotReadyException(exception);
                    if (leaderNotReadyException != null) {
                        OMFailoverProxyProviderBase.this.setNextOmProxy(omNodeId);
                        return this.getRetryAction(RetryPolicy.RetryAction.RetryDecision.FAILOVER_AND_RETRY, failovers);
                    }
                }
                if (!OMFailoverProxyProviderBase.this.shouldFailover(exception)) {
                    return RetryPolicy.RetryAction.FAIL;
                }
                OMFailoverProxyProviderBase.this.selectNextOmProxy();
                return this.getRetryAction(RetryPolicy.RetryAction.RetryDecision.FAILOVER_AND_RETRY, failovers);
            }

            private RetryPolicy.RetryAction getRetryAction(RetryPolicy.RetryAction.RetryDecision fallbackAction, int failovers) {
                if (failovers < maxFailovers) {
                    return new RetryPolicy.RetryAction(fallbackAction, OMFailoverProxyProviderBase.this.getWaitTime());
                }
                LOG.error("Failed to connect to OMs: {}. Attempted {} failovers.", (Object)OMFailoverProxyProviderBase.this.omNodeIDList, (Object)maxFailovers);
                return RetryPolicy.RetryAction.FAIL;
            }
        };
        return retryPolicy;
    }

    public final Class<T> getInterface() {
        return this.protocolClass;
    }

    public synchronized void performFailover(T currentProxy) {
        LOG.debug("Failing over OM from {}:{} to {}:{}", new Object[]{this.currentProxyOMNodeId, this.currentProxyIndex, this.nextProxyOMNodeId, this.nextProxyIndex});
        this.currentProxyOMNodeId = this.nextProxyOMNodeId;
        this.currentProxyIndex = this.nextProxyIndex;
        this.performFailoverDone = true;
    }

    public void setNextOmProxy(String newLeaderOMNodeId) {
        if (newLeaderOMNodeId == null) {
            LOG.debug("No suggested leader nodeId. Performing failover to next peer node");
            this.selectNextOmProxy();
        } else if (this.updateLeaderOMNodeId(newLeaderOMNodeId)) {
            LOG.debug("Failing over OM proxy to nodeId: {}", (Object)newLeaderOMNodeId);
        }
    }

    public synchronized void selectNextOmProxy() {
        if (this.performFailoverDone) {
            this.performFailoverDone = false;
            int newProxyIndex = this.incrementNextProxyIndex();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Incrementing OM proxy index to {}, nodeId: {}", (Object)newProxyIndex, (Object)this.omNodeIDList.get(newProxyIndex));
            }
        }
    }

    private synchronized int incrementNextProxyIndex() {
        this.lastAttemptedOM = this.nextProxyOMNodeId;
        this.attemptedOMs.add(this.nextProxyOMNodeId);
        this.nextProxyIndex = (this.nextProxyIndex + 1) % this.omProxies.size();
        this.nextProxyOMNodeId = this.omNodeIDList.get(this.nextProxyIndex);
        return this.nextProxyIndex;
    }

    private synchronized boolean updateLeaderOMNodeId(String newLeaderOMNodeId) {
        if (!this.nextProxyOMNodeId.equals(newLeaderOMNodeId)) {
            if (this.omProxies.containsKey(newLeaderOMNodeId)) {
                this.lastAttemptedOM = this.nextProxyOMNodeId;
                this.nextProxyOMNodeId = newLeaderOMNodeId;
                this.nextProxyIndex = this.omNodeIDList.indexOf(this.nextProxyOMNodeId);
                return true;
            }
        } else {
            this.lastAttemptedOM = this.nextProxyOMNodeId;
        }
        return false;
    }

    public synchronized long getWaitTime() {
        if (this.nextProxyOMNodeId.equals(this.lastAttemptedOM)) {
            this.attemptedOMs.clear();
            ++this.numAttemptsOnSameOM;
            return this.waitBetweenRetries * (long)this.numAttemptsOnSameOM;
        }
        this.numAttemptsOnSameOM = 0;
        for (String omNodeID : this.omProxies.keySet()) {
            if (this.attemptedOMs.contains(omNodeID)) continue;
            return 0L;
        }
        this.attemptedOMs.clear();
        return this.waitBetweenRetries;
    }

    public List<FailoverProxyProvider.ProxyInfo> getOMProxies() {
        return new ArrayList<FailoverProxyProvider.ProxyInfo>(this.omProxies.values());
    }

    public Map<String, FailoverProxyProvider.ProxyInfo<T>> getOMProxyMap() {
        return this.omProxies;
    }

    public static OMLeaderNotReadyException getLeaderNotReadyException(Exception exception) {
        IOException ioException;
        Throwable cause = exception.getCause();
        if (cause instanceof RemoteException && (ioException = ((RemoteException)cause).unwrapRemoteException()) instanceof OMLeaderNotReadyException) {
            return (OMLeaderNotReadyException)ioException;
        }
        return null;
    }

    public static OMNotLeaderException getNotLeaderException(Exception exception) {
        IOException ioException;
        Throwable cause = exception.getCause();
        if (cause instanceof RemoteException && (ioException = ((RemoteException)cause).unwrapRemoteException()) instanceof OMNotLeaderException) {
            return (OMNotLeaderException)ioException;
        }
        return null;
    }

    protected ConfigurationSource getConf() {
        return this.conf;
    }

    protected synchronized void setOmProxies(Map<String, FailoverProxyProvider.ProxyInfo<T>> omProxies) {
        this.omProxies = omProxies;
    }

    protected synchronized void setOmNodeIDList(List<String> omNodeIDList) {
        this.omNodeIDList = omNodeIDList;
    }

    protected synchronized List<String> getOmNodeIDList() {
        return this.omNodeIDList;
    }

    protected synchronized void setOmNodeAddressMap(Map<String, InetSocketAddress> map) {
        this.omNodeAddressMap = map;
    }
}

