/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.ozone.client.OzoneKey;
import org.apache.hadoop.ozone.client.OzoneKeyLocation;
import org.apache.hadoop.ozone.client.io.OzoneInputStream;
import org.apache.hadoop.ozone.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.ratis.util.function.CheckedSupplier;

public class OzoneKeyDetails
extends OzoneKey {
    private final List<OzoneKeyLocation> ozoneKeyLocations;
    private final FileEncryptionInfo feInfo;
    private final CheckedSupplier<OzoneInputStream, IOException> contentSupplier;
    private final Long generation;

    public OzoneKeyDetails(String volumeName, String bucketName, String keyName, long size, long creationTime, long modificationTime, List<OzoneKeyLocation> ozoneKeyLocations, ReplicationConfig replicationConfig, Map<String, String> metadata, FileEncryptionInfo feInfo, CheckedSupplier<OzoneInputStream, IOException> contentSupplier, boolean isFile, String owner, Map<String, String> tags, Long generation) {
        super(volumeName, bucketName, keyName, size, creationTime, modificationTime, replicationConfig, metadata, isFile, owner, tags);
        this.ozoneKeyLocations = ozoneKeyLocations;
        this.feInfo = feInfo;
        this.contentSupplier = contentSupplier;
        this.generation = generation;
    }

    public OzoneKeyDetails(String volumeName, String bucketName, String keyName, long size, long creationTime, long modificationTime, List<OzoneKeyLocation> ozoneKeyLocations, ReplicationConfig replicationConfig, Map<String, String> metadata, FileEncryptionInfo feInfo, CheckedSupplier<OzoneInputStream, IOException> contentSupplier, boolean isFile, String owner, Map<String, String> tags) {
        this(volumeName, bucketName, keyName, size, creationTime, modificationTime, ozoneKeyLocations, replicationConfig, metadata, feInfo, contentSupplier, isFile, owner, tags, null);
    }

    public List<OzoneKeyLocation> getOzoneKeyLocations() {
        return this.ozoneKeyLocations;
    }

    public FileEncryptionInfo getFileEncryptionInfo() {
        return this.feInfo;
    }

    public Long getGeneration() {
        return this.generation;
    }

    @JsonIgnore
    public OzoneInputStream getContent() throws IOException {
        return this.contentSupplier.get();
    }
}

