/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.cli;

import java.io.PrintWriter;
import java.util.function.Supplier;
import org.apache.hadoop.hdds.cli.GenericParentCommand;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.shaded.picocli.CommandLine;
import org.apache.ratis.util.MemoizedSupplier;

@CommandLine.Command(mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public abstract class AbstractSubcommand {
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;
    private final Supplier<GenericParentCommand> rootSupplier = MemoizedSupplier.valueOf(() -> AbstractSubcommand.findRootCommand(this.spec));

    protected CommandLine.Model.CommandSpec spec() {
        return this.spec;
    }

    protected GenericParentCommand rootCommand() {
        return this.rootSupplier.get();
    }

    protected boolean isVerbose() {
        return this.rootCommand().isVerbose();
    }

    protected OzoneConfiguration getOzoneConf() {
        return this.rootCommand().getOzoneConf();
    }

    static GenericParentCommand findRootCommand(CommandLine.Model.CommandSpec spec) {
        Object root = spec.root().userObject();
        return root instanceof GenericParentCommand ? (GenericParentCommand)root : new NoParentCommand();
    }

    protected PrintWriter out() {
        return this.spec().commandLine().getOut();
    }

    protected PrintWriter err() {
        return this.spec().commandLine().getErr();
    }

    private static class NoParentCommand
    implements GenericParentCommand {
        private final OzoneConfiguration conf = new OzoneConfiguration();

        private NoParentCommand() {
        }

        @Override
        public boolean isVerbose() {
            return false;
        }

        @Override
        public OzoneConfiguration getOzoneConf() {
            return this.conf;
        }
    }
}

