/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.ozone;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderTokenIssuer;
import org.apache.hadoop.fs.LeaseRecoverable;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.SafeMode;
import org.apache.hadoop.fs.SafeModeAction;
import org.apache.hadoop.fs.StorageStatistics;
import org.apache.hadoop.fs.ozone.BasicOzoneFileSystem;
import org.apache.hadoop.fs.ozone.CapableOzoneFSDataStreamOutput;
import org.apache.hadoop.fs.ozone.CapableOzoneFSInputStream;
import org.apache.hadoop.fs.ozone.CapableOzoneFSOutputStream;
import org.apache.hadoop.fs.ozone.LeaseRecoveryClientDNHandler;
import org.apache.hadoop.fs.ozone.OzoneClientAdapter;
import org.apache.hadoop.fs.ozone.OzoneClientAdapterImpl;
import org.apache.hadoop.fs.ozone.OzoneFSDataStreamOutput;
import org.apache.hadoop.fs.ozone.OzoneFSOutputStream;
import org.apache.hadoop.fs.ozone.OzoneFSStorageStatistics;
import org.apache.hadoop.fs.ozone.OzonePathCapabilities;
import org.apache.hadoop.fs.ozone.Statistic;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.scm.storage.BlockLocationInfo;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.LeaseKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.security.token.DelegationTokenIssuer;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class OzoneFileSystem
extends BasicOzoneFileSystem
implements KeyProviderTokenIssuer,
LeaseRecoverable,
SafeMode {
    private OzoneFSStorageStatistics storageStatistics = new OzoneFSStorageStatistics();
    private boolean forceRecovery;

    public OzoneFileSystem() {
        String force = System.getProperty("OZONE.CLIENT.RECOVER.LEASE.FORCE");
        this.forceRecovery = Strings.isNullOrEmpty((String)force) ? false : Boolean.parseBoolean(force);
    }

    public KeyProvider getKeyProvider() throws IOException {
        return this.getAdapter().getKeyProvider();
    }

    public URI getKeyProviderUri() throws IOException {
        return this.getAdapter().getKeyProviderUri();
    }

    public DelegationTokenIssuer[] getAdditionalTokenIssuers() throws IOException {
        KeyProvider keyProvider;
        try {
            keyProvider = this.getKeyProvider();
        }
        catch (IOException ioe) {
            LOG.debug("Error retrieving KeyProvider.", (Throwable)ioe);
            return null;
        }
        if (keyProvider instanceof DelegationTokenIssuer) {
            return new DelegationTokenIssuer[]{(DelegationTokenIssuer)keyProvider};
        }
        return null;
    }

    StorageStatistics getOzoneFSOpsCountStatistics() {
        return this.storageStatistics;
    }

    @Override
    protected void incrementCounter(Statistic statistic, long count) {
        if (this.storageStatistics != null) {
            this.storageStatistics.incrementCounter(statistic, count);
        }
    }

    @Override
    protected OzoneClientAdapter createAdapter(ConfigurationSource conf, String bucketStr, String volumeStr, String omHost, int omPort) throws IOException {
        return new OzoneClientAdapterImpl(omHost, omPort, conf, volumeStr, bucketStr, this.storageStatistics);
    }

    @Override
    protected InputStream createFSInputStream(InputStream inputStream2) {
        return new CapableOzoneFSInputStream(inputStream2, this.statistics);
    }

    @Override
    protected OzoneFSOutputStream createFSOutputStream(OzoneFSOutputStream outputStream2) {
        return new CapableOzoneFSOutputStream(outputStream2, this.isHsyncEnabled());
    }

    @Override
    protected OzoneFSDataStreamOutput createFSDataStreamOutput(OzoneFSDataStreamOutput outputDataStream) {
        return new CapableOzoneFSDataStreamOutput(outputDataStream, this.isHsyncEnabled());
    }

    public boolean hasPathCapability(Path path, String capability) throws IOException {
        Path p = this.makeQualified(path);
        boolean cap = OzonePathCapabilities.hasPathCapability(p, capability);
        if (cap) {
            return cap;
        }
        return super.hasPathCapability(p, capability);
    }

    @Override
    public boolean recoverLease(Path f) throws IOException {
        LeaseKeyInfo leaseKeyInfo;
        this.statistics.incrementWriteOps(1);
        LOG.trace("recoverLease() path:{}", (Object)f);
        Path qualifiedPath = this.makeQualified(f);
        String key = this.pathToKey(qualifiedPath);
        try {
            leaseKeyInfo = this.getAdapter().recoverFilePrepare(key, this.forceRecovery);
        }
        catch (OMException e) {
            if (e.getResult() == OMException.ResultCodes.KEY_ALREADY_CLOSED) {
                return true;
            }
            throw e;
        }
        List<OmKeyLocationInfo> keyLocationInfoList = LeaseRecoveryClientDNHandler.getOmKeyLocationInfos(leaseKeyInfo, this.getAdapter(), this.forceRecovery);
        long keyLength = keyLocationInfoList.stream().mapToLong(BlockLocationInfo::getLength).sum();
        OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName(leaseKeyInfo.getKeyInfo().getVolumeName()).setBucketName(leaseKeyInfo.getKeyInfo().getBucketName()).setKeyName(leaseKeyInfo.getKeyInfo().getKeyName()).setReplicationConfig(leaseKeyInfo.getKeyInfo().getReplicationConfig()).setDataSize(keyLength).setLocationInfoList(keyLocationInfoList).build();
        this.getAdapter().recoverFile(keyArgs);
        return true;
    }

    @Override
    public boolean isFileClosed(Path f) throws IOException {
        LOG.trace("isFileClosed() path:{}", (Object)f);
        Path qualifiedPath = this.makeQualified(f);
        String key = this.pathToKey(qualifiedPath);
        return this.getAdapter().isFileClosed(key);
    }

    @Override
    public boolean setSafeMode(SafeModeAction action, boolean isChecked) throws IOException {
        return this.setSafeModeUtil(action, isChecked);
    }
}

