/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.thirdparty.com.codahale.metrics;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ratis.thirdparty.com.codahale.metrics.Clock;
import org.apache.ratis.thirdparty.com.codahale.metrics.Gauge;

public abstract class CachedGauge<T>
implements Gauge<T> {
    private final Clock clock;
    private final AtomicLong reloadAt;
    private final long timeoutNS;
    private final AtomicReference<T> value;

    protected CachedGauge(long timeout2, TimeUnit timeoutUnit) {
        this(Clock.defaultClock(), timeout2, timeoutUnit);
    }

    protected CachedGauge(Clock clock, long timeout2, TimeUnit timeoutUnit) {
        this.clock = clock;
        this.reloadAt = new AtomicLong(clock.getTick());
        this.timeoutNS = timeoutUnit.toNanos(timeout2);
        this.value = new AtomicReference();
    }

    protected abstract T loadValue();

    @Override
    public T getValue() {
        T currentValue = this.value.get();
        if (this.shouldLoad() || currentValue == null) {
            T newValue = this.loadValue();
            if (!this.value.compareAndSet(currentValue, newValue)) {
                return this.value.get();
            }
            return newValue;
        }
        return currentValue;
    }

    private boolean shouldLoad() {
        long time;
        long current;
        do {
            time = this.clock.getTick();
            current = this.reloadAt.get();
            if (current <= time) continue;
            return false;
        } while (!this.reloadAt.compareAndSet(current, time + this.timeoutNS));
        return true;
    }
}

