/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.snapshot;

import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.ozone.snapshot.SnapshotDiffReportOzone;

public class SnapshotDiffResponse {
    private final SnapshotDiffReportOzone snapshotDiffReport;
    private final JobStatus jobStatus;
    private final long waitTimeInMs;
    private final String reason;

    public SnapshotDiffResponse(SnapshotDiffReportOzone snapshotDiffReport, JobStatus jobStatus, long waitTimeInMs) {
        this.snapshotDiffReport = snapshotDiffReport;
        this.jobStatus = jobStatus;
        this.waitTimeInMs = waitTimeInMs;
        this.reason = "";
    }

    public SnapshotDiffResponse(SnapshotDiffReportOzone snapshotDiffReport, JobStatus jobStatus, long waitTimeInMs, String reason) {
        this.snapshotDiffReport = snapshotDiffReport;
        this.jobStatus = jobStatus;
        this.waitTimeInMs = waitTimeInMs;
        this.reason = reason;
    }

    public SnapshotDiffReportOzone getSnapshotDiffReport() {
        return this.snapshotDiffReport;
    }

    public JobStatus getJobStatus() {
        return this.jobStatus;
    }

    public long getWaitTimeInMs() {
        return this.waitTimeInMs;
    }

    public String getReason() {
        return this.reason;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        switch (this.jobStatus) {
            case DONE: {
                str.append(this.snapshotDiffReport.toString());
                break;
            }
            case FAILED: {
                str.append("Snapshot diff job is FAILED due to '");
                if (StringUtils.isNotEmpty(this.reason)) {
                    str.append(this.reason);
                } else {
                    str.append("Unknown reason.");
                }
                str.append("'. Please retry after ").append(this.waitTimeInMs).append(" ms.\n");
                break;
            }
            case CANCELLED: {
                str.append("Snapshot diff job has been CANCELLED.");
                break;
            }
            default: {
                str.append("Snapshot diff job is ").append((Object)this.jobStatus).append(". Please retry after ").append(this.waitTimeInMs).append(" ms.\n");
            }
        }
        return str.toString();
    }

    public static enum JobStatus {
        QUEUED,
        IN_PROGRESS,
        DONE,
        REJECTED,
        FAILED,
        CANCELLED;


        public OzoneManagerProtocolProtos.SnapshotDiffResponse.JobStatusProto toProtobuf() {
            return OzoneManagerProtocolProtos.SnapshotDiffResponse.JobStatusProto.valueOf(this.name());
        }

        public static JobStatus fromProtobuf(OzoneManagerProtocolProtos.SnapshotDiffResponse.JobStatusProto jobStatusProto) {
            return JobStatus.valueOf(jobStatusProto.name());
        }
    }
}

