/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.io.jaegertracing.internal;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.JaegerSpanContext;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.spi.Extractor;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.spi.Injector;
import org.apache.hadoop.ozone.shaded.io.opentracing.propagation.Format;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PropagationRegistry {
    private final Map<Format<?>, Injector<?>> injectors = new HashMap();
    private final Map<Format<?>, Extractor<?>> extractors = new HashMap();

    PropagationRegistry() {
    }

    <T> Injector<T> getInjector(Format<T> format) {
        return this.injectors.get(format);
    }

    <T> Extractor<T> getExtractor(Format<T> format) {
        return this.extractors.get(format);
    }

    public <T> void register(Format<T> format, Injector<T> injector) {
        this.injectors.put(format, new ExceptionCatchingInjectorDecorator<T>(injector));
    }

    public <T> void register(Format<T> format, Extractor<T> extractor) {
        this.extractors.put(format, new ExceptionCatchingExtractorDecorator<T>(extractor));
    }

    private static class ExceptionCatchingInjectorDecorator<T>
    implements Injector<T> {
        private static final Logger log = LoggerFactory.getLogger(ExceptionCatchingInjectorDecorator.class);
        private final Injector<T> decorated;

        @Override
        public void inject(JaegerSpanContext spanContext, T carrier) {
            try {
                this.decorated.inject(spanContext, carrier);
            }
            catch (RuntimeException ex) {
                log.error("Error when injecting SpanContext into carrier. Handling gracefully.", (Throwable)ex);
            }
        }

        public ExceptionCatchingInjectorDecorator(Injector<T> decorated) {
            this.decorated = decorated;
        }
    }

    private static class ExceptionCatchingExtractorDecorator<T>
    implements Extractor<T> {
        private static final Logger log = LoggerFactory.getLogger(ExceptionCatchingExtractorDecorator.class);
        private final Extractor<T> decorated;

        @Override
        public JaegerSpanContext extract(T carrier) {
            try {
                return this.decorated.extract(carrier);
            }
            catch (RuntimeException ex) {
                log.warn("Error when extracting SpanContext from carrier. Handling gracefully.", (Throwable)ex);
                return null;
            }
        }

        public ExceptionCatchingExtractorDecorator(Extractor<T> decorated) {
            this.decorated = decorated;
        }
    }
}

