/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.com.fasterxml.jackson.datatype.jsr310.deser;

import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.util.Locale;
import org.apache.hadoop.ozone.shaded.com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.hadoop.ozone.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.hadoop.ozone.shaded.com.fasterxml.jackson.databind.BeanProperty;
import org.apache.hadoop.ozone.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.hadoop.ozone.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.hadoop.ozone.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.hadoop.ozone.shaded.com.fasterxml.jackson.databind.MapperFeature;
import org.apache.hadoop.ozone.shaded.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import org.apache.hadoop.ozone.shaded.com.fasterxml.jackson.datatype.jsr310.deser.JSR310DeserializerBase;

public abstract class JSR310DateTimeDeserializerBase<T>
extends JSR310DeserializerBase<T>
implements ContextualDeserializer {
    protected final DateTimeFormatter _formatter;
    protected final JsonFormat.Shape _shape;

    protected JSR310DateTimeDeserializerBase(Class<T> supportedType, DateTimeFormatter f) {
        super(supportedType);
        this._formatter = f;
        this._shape = null;
    }

    public JSR310DateTimeDeserializerBase(Class<T> supportedType, DateTimeFormatter f, Boolean leniency) {
        super(supportedType, leniency);
        this._formatter = f;
        this._shape = null;
    }

    protected JSR310DateTimeDeserializerBase(JSR310DateTimeDeserializerBase<T> base, DateTimeFormatter f) {
        super(base);
        this._formatter = f;
        this._shape = base._shape;
    }

    protected JSR310DateTimeDeserializerBase(JSR310DateTimeDeserializerBase<T> base, Boolean leniency) {
        super(base, leniency);
        this._formatter = base._formatter;
        this._shape = base._shape;
    }

    protected JSR310DateTimeDeserializerBase(JSR310DateTimeDeserializerBase<T> base, JsonFormat.Shape shape) {
        super(base);
        this._formatter = base._formatter;
        this._shape = shape;
    }

    protected JSR310DateTimeDeserializerBase(JSR310DateTimeDeserializerBase<T> base, Boolean leniency, DateTimeFormatter formatter, JsonFormat.Shape shape) {
        super(base, leniency);
        this._formatter = formatter;
        this._shape = shape;
    }

    protected abstract JSR310DateTimeDeserializerBase<T> withDateFormat(DateTimeFormatter var1);

    @Override
    protected abstract JSR310DateTimeDeserializerBase<T> withLeniency(Boolean var1);

    protected JSR310DateTimeDeserializerBase<T> withShape(JsonFormat.Shape shape) {
        return this;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JsonFormat.Value format = this.findFormatOverrides(ctxt, property, this.handledType());
        return format == null ? this : this._withFormatOverrides(ctxt, property, format);
    }

    protected JSR310DateTimeDeserializerBase<?> _withFormatOverrides(DeserializationContext ctxt, BeanProperty property, JsonFormat.Value formatOverrides) {
        JsonFormat.Shape shape;
        Boolean leniency;
        JSR310DeserializerBase deser = this;
        if (formatOverrides.hasLenient() && (leniency = formatOverrides.getLenient()) != null) {
            deser = ((JSR310DateTimeDeserializerBase)deser).withLeniency(leniency);
        }
        if (formatOverrides.hasPattern()) {
            String pattern = formatOverrides.getPattern();
            Locale locale = formatOverrides.hasLocale() ? formatOverrides.getLocale() : ctxt.getLocale();
            DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
            if (this.acceptCaseInsensitiveValues(ctxt, formatOverrides)) {
                builder.parseCaseInsensitive();
            }
            builder.appendPattern(pattern);
            DateTimeFormatter df = locale == null ? builder.toFormatter() : builder.toFormatter(locale);
            if (!deser.isLenient()) {
                df = df.withResolverStyle(ResolverStyle.STRICT);
            }
            if (formatOverrides.hasTimeZone()) {
                df = df.withZone(formatOverrides.getTimeZone().toZoneId());
            }
            deser = ((JSR310DateTimeDeserializerBase)deser).withDateFormat(df);
        }
        if ((shape = formatOverrides.getShape()) != null && shape != this._shape) {
            deser = ((JSR310DateTimeDeserializerBase)deser).withShape(shape);
        }
        return deser;
    }

    private boolean acceptCaseInsensitiveValues(DeserializationContext ctxt, JsonFormat.Value format) {
        Boolean enabled = format.getFeature(JsonFormat.Feature.ACCEPT_CASE_INSENSITIVE_VALUES);
        if (enabled == null) {
            enabled = ctxt.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_VALUES);
        }
        return enabled;
    }

    protected void _throwNoNumericTimestampNeedTimeZone(JsonParser p, DeserializationContext ctxt) throws IOException {
        ctxt.reportInputMismatch(this.handledType(), "raw timestamp (%d) not allowed for `%s`: need additional information such as an offset or time-zone (see class Javadocs)", p.getNumberValue(), this.handledType().getName());
    }
}

