/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.lock;

import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableStat;

@InterfaceAudience.Private
@Metrics(about="Ozone Manager Lock Metrics", context="ozone")
public final class OMLockMetrics
implements MetricsSource {
    private static final String SOURCE_NAME = OMLockMetrics.class.getSimpleName();
    private final MetricsRegistry registry = new MetricsRegistry(SOURCE_NAME);
    private final MutableStat readLockWaitingTimeMsStat = this.registry.newStat("ReadLockWaitingTime", "Time (in milliseconds) spent waiting for acquiring the read lock", "Ops", "Time", true);
    private final MutableStat readLockHeldTimeMsStat = this.registry.newStat("ReadLockHeldTime", "Time (in milliseconds) spent holding the read lock", "Ops", "Time", true);
    private final MutableStat writeLockWaitingTimeMsStat = this.registry.newStat("WriteLockWaitingTime", "Time (in milliseconds) spent waiting for acquiring the write lock", "Ops", "Time", true);
    private final MutableStat writeLockHeldTimeMsStat = this.registry.newStat("WriteLockHeldTime", "Time (in milliseconds) spent holding the write lock", "Ops", "Time", true);

    private OMLockMetrics() {
    }

    public static OMLockMetrics create() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        return (OMLockMetrics)ms.register(SOURCE_NAME, "Ozone Manager Lock Metrics", (Object)new OMLockMetrics());
    }

    public void unRegister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE_NAME);
    }

    public void setReadLockWaitingTimeMsStat(long readLockWaitingTimeMs) {
        this.readLockWaitingTimeMsStat.add(readLockWaitingTimeMs);
    }

    public void setReadLockHeldTimeMsStat(long readLockHeldTimeMs) {
        this.readLockHeldTimeMsStat.add(readLockHeldTimeMs);
    }

    public void setWriteLockWaitingTimeMsStat(long writeLockWaitingTimeMs) {
        this.writeLockWaitingTimeMsStat.add(writeLockWaitingTimeMs);
    }

    public void setWriteLockHeldTimeMsStat(long writeLockHeldTimeMs) {
        this.writeLockHeldTimeMsStat.add(writeLockHeldTimeMs);
    }

    public String getReadLockWaitingTimeMsStat() {
        return this.readLockWaitingTimeMsStat.toString();
    }

    public long getLongestReadLockWaitingTimeMs() {
        return (long)this.readLockWaitingTimeMsStat.lastStat().max();
    }

    public String getReadLockHeldTimeMsStat() {
        return this.readLockHeldTimeMsStat.toString();
    }

    public long getLongestReadLockHeldTimeMs() {
        return (long)this.readLockHeldTimeMsStat.lastStat().max();
    }

    public String getWriteLockWaitingTimeMsStat() {
        return this.writeLockWaitingTimeMsStat.toString();
    }

    public long getLongestWriteLockWaitingTimeMs() {
        return (long)this.writeLockWaitingTimeMsStat.lastStat().max();
    }

    public String getWriteLockHeldTimeMsStat() {
        return this.writeLockHeldTimeMsStat.toString();
    }

    public long getLongestWriteLockHeldTimeMs() {
        return (long)this.writeLockHeldTimeMsStat.lastStat().max();
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        MetricsRecordBuilder builder = collector.addRecord(SOURCE_NAME);
        this.readLockHeldTimeMsStat.snapshot(builder, all);
        this.readLockWaitingTimeMsStat.snapshot(builder, all);
        this.writeLockHeldTimeMsStat.snapshot(builder, all);
        this.writeLockWaitingTimeMsStat.snapshot(builder, all);
    }
}

