/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.security.SecureClientLogin;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.ranger.authorization.hadoop.config.RangerAdminConfig;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.model.validation.RangerServiceDefHelper;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.plugin.util.ServiceDefUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RangerBaseService {
    private static final Logger LOG = LoggerFactory.getLogger(RangerBaseService.class);
    protected static final String ADMIN_USER_PRINCIPAL = "ranger.admin.kerberos.principal";
    protected static final String ADMIN_USER_KEYTAB = "ranger.admin.kerberos.keytab";
    protected static final String LOOKUP_PRINCIPAL = "ranger.lookup.kerberos.principal";
    protected static final String LOOKUP_KEYTAB = "ranger.lookup.kerberos.keytab";
    protected static final String RANGER_AUTH_TYPE = "hadoop.security.authentication";
    protected static final String KERBEROS_TYPE = "kerberos";
    private static final String PROP_DEFAULT_POLICY_PREFIX = "default-policy.";
    private static final String PROP_DEFAULT_POLICY_NAME_SUFFIX = "name";
    protected RangerServiceDef serviceDef;
    protected RangerService service;
    protected Map<String, String> configs;
    protected String serviceName;
    protected String serviceType;
    protected String lookUpUser;
    protected final RangerAdminConfig config = RangerAdminConfig.getInstance();

    public RangerBaseService() {
        String authType = this.config.get(RANGER_AUTH_TYPE, "simple");
        String lookupPrincipal = this.config.get(LOOKUP_PRINCIPAL);
        String lookupKeytab = this.config.get(LOOKUP_KEYTAB);
        this.lookUpUser = this.getLookupUser(authType, lookupPrincipal, lookupKeytab);
    }

    public void init(RangerServiceDef serviceDef, RangerService service) {
        this.serviceDef = serviceDef;
        this.service = service;
        this.configs = service.getConfigs();
        this.serviceName = service.getName();
        this.serviceType = service.getType();
    }

    public RangerServiceDef getServiceDef() {
        return this.serviceDef;
    }

    public RangerService getService() {
        return this.service;
    }

    public Map<String, String> getConfigs() {
        return this.configs;
    }

    public void setConfigs(Map<String, String> configs) {
        this.configs = configs;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public RangerAdminConfig getConfig() {
        return this.config;
    }

    public abstract Map<String, Object> validateConfig() throws Exception;

    public abstract List<String> lookupResource(ResourceLookupContext var1) throws Exception;

    public List<RangerPolicy> getDefaultRangerPolicies() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerBaseService.getDefaultRangerPolicies() ");
        }
        ArrayList<RangerPolicy> ret = new ArrayList<RangerPolicy>();
        try {
            RangerServiceDefHelper serviceDefHelper = new RangerServiceDefHelper(this.serviceDef);
            for (List<RangerServiceDef.RangerResourceDef> aHierarchy : serviceDefHelper.filterHierarchies_containsOnlyMandatoryResources(0)) {
                RangerPolicy policy = this.getDefaultPolicy(aHierarchy);
                if (policy == null) continue;
                ret.add(policy);
            }
        }
        catch (Exception e) {
            LOG.error("Error getting default polcies for Service: " + this.service.getName(), (Throwable)e);
        }
        Boolean additionalDefaultPolicySetup = Boolean.valueOf(this.configs.get("setup.additional.default.policies"));
        if (additionalDefaultPolicySetup.booleanValue()) {
            LOG.info(this.getServiceName() + ": looking for additional default policies in service-config");
            TreeSet<String> policyIndexes = new TreeSet<String>();
            for (String configName : this.configs.keySet()) {
                if (!configName.startsWith(PROP_DEFAULT_POLICY_PREFIX) || !configName.endsWith(PROP_DEFAULT_POLICY_NAME_SUFFIX)) continue;
                policyIndexes.add(configName.substring(PROP_DEFAULT_POLICY_PREFIX.length(), configName.length() - PROP_DEFAULT_POLICY_NAME_SUFFIX.length() - 1));
            }
            LOG.info(this.getServiceName() + ": found " + policyIndexes.size() + " additional default policies in service-config");
            for (String policyIndex : policyIndexes) {
                String policyPropertyPrefix = PROP_DEFAULT_POLICY_PREFIX + policyIndex + ".";
                String resourcePropertyPrefix = policyPropertyPrefix + "resource.";
                Map<String, RangerPolicy.RangerPolicyResource> policyResources = this.getResourcesForPrefix(resourcePropertyPrefix);
                if (MapUtils.isNotEmpty(policyResources)) {
                    this.addCustomRangerDefaultPolicies(ret, policyResources, policyPropertyPrefix);
                    continue;
                }
                LOG.warn(this.getServiceName() + ": no resources specified for default policy with prefix '" + policyPropertyPrefix + "'. Ignored");
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerBaseService.getDefaultRangerPolicies(): " + ret);
        }
        return ret;
    }

    private Map<String, RangerPolicy.RangerPolicyResource> getResourcesForPrefix(String resourcePropertyPrefix) {
        HashMap<String, RangerPolicy.RangerPolicyResource> policyResourceMap = new HashMap<String, RangerPolicy.RangerPolicyResource>();
        if (this.configs != null) {
            for (Map.Entry<String, String> entry : this.configs.entrySet()) {
                String configName = entry.getKey();
                String configValue = entry.getValue();
                if (!configName.startsWith(resourcePropertyPrefix) || !StringUtils.isNotBlank((String)configValue)) continue;
                RangerPolicy.RangerPolicyResource rPolRes = new RangerPolicy.RangerPolicyResource();
                String resourceKey = configName.substring(resourcePropertyPrefix.length());
                ArrayList<String> resourceList = new ArrayList<String>(Arrays.asList(configValue.split(",")));
                rPolRes.setIsExcludes(false);
                rPolRes.setIsRecursive(false);
                rPolRes.setValues(resourceList);
                policyResourceMap.put(resourceKey, rPolRes);
            }
        }
        return policyResourceMap;
    }

    private void addCustomRangerDefaultPolicies(List<RangerPolicy> ret, Map<String, RangerPolicy.RangerPolicyResource> policyResourceMap, String policyPropertyPrefix) throws Exception {
        String policyName = this.configs.get(policyPropertyPrefix + PROP_DEFAULT_POLICY_NAME_SUFFIX);
        String description = this.configs.get(policyPropertyPrefix + "description");
        Boolean isDenyAllElse = Boolean.valueOf(this.configs.get(policyPropertyPrefix + "isDenyAllElse"));
        if (StringUtils.isEmpty((String)description)) {
            description = "Policy for " + policyName;
        }
        RangerPolicy policy = new RangerPolicy();
        policy.setName(policyName);
        policy.setIsEnabled(true);
        policy.setVersion(1L);
        policy.setIsAuditEnabled(true);
        policy.setService(this.serviceName);
        policy.setDescription(description);
        policy.setName(policyName);
        policy.setResources(policyResourceMap);
        policy.setIsDenyAllElse(isDenyAllElse);
        int i = 1;
        while (true) {
            String policyItemPropertyPrefix = policyPropertyPrefix + "policyItem." + i + ".";
            String policyItemUsers = this.configs.get(policyItemPropertyPrefix + "users");
            String policyItemGroups = this.configs.get(policyItemPropertyPrefix + "groups");
            String policyItemRoles = this.configs.get(policyItemPropertyPrefix + "roles");
            String policyItemAccessTypes = this.configs.get(policyItemPropertyPrefix + "accessTypes");
            String isDelegateAdmin = this.configs.get(policyItemPropertyPrefix + "isDelegateAdmin");
            if (StringUtils.isEmpty((String)policyItemAccessTypes) || StringUtils.isEmpty((String)policyItemUsers) && StringUtils.isEmpty((String)policyItemGroups) && StringUtils.isEmpty((String)policyItemRoles)) break;
            RangerPolicy.RangerPolicyItem policyItem = new RangerPolicy.RangerPolicyItem();
            policyItem.setDelegateAdmin(Boolean.parseBoolean(isDelegateAdmin));
            if (StringUtils.isNotBlank((String)policyItemUsers)) {
                policyItem.setUsers(Arrays.asList(policyItemUsers.split(",")));
            }
            if (StringUtils.isNotBlank((String)policyItemGroups)) {
                policyItem.setGroups(Arrays.asList(policyItemGroups.split(",")));
            }
            if (StringUtils.isNotBlank((String)policyItemRoles)) {
                policyItem.setRoles(Arrays.asList(policyItemRoles.split(",")));
            }
            if (StringUtils.isNotBlank((String)policyItemAccessTypes)) {
                for (String accessType : Arrays.asList(policyItemAccessTypes.split(","))) {
                    RangerPolicy.RangerPolicyItemAccess polAccess = new RangerPolicy.RangerPolicyItemAccess(accessType, true);
                    policyItem.getAccesses().add(polAccess);
                }
            }
            policy.getPolicyItems().add(policyItem);
            ++i;
        }
        LOG.info(this.getServiceName() + ": adding default policy: name=" + policy.getName());
        ret.add(policy);
    }

    private RangerPolicy getDefaultPolicy(List<RangerServiceDef.RangerResourceDef> resourceHierarchy) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerBaseService.getDefaultPolicy()");
        }
        RangerPolicy policy = new RangerPolicy();
        String policyName = this.buildPolicyName(resourceHierarchy);
        policy.setIsEnabled(true);
        policy.setVersion(1L);
        policy.setName(policyName);
        policy.setService(this.service.getName());
        policy.setDescription("Policy for " + policyName);
        policy.setIsAuditEnabled(true);
        policy.setResources(this.createDefaultPolicyResource(resourceHierarchy));
        ArrayList<RangerPolicy.RangerPolicyItem> policyItems = new ArrayList<RangerPolicy.RangerPolicyItem>();
        RangerPolicy.RangerPolicyItem policyItem = this.createDefaultPolicyItem(policy.getResources());
        policyItems.add(policyItem);
        policy.setPolicyItems(policyItems);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerBaseService.getDefaultPolicy()" + policy);
        }
        return policy;
    }

    private RangerPolicy.RangerPolicyItem createDefaultPolicyItem(Map<String, RangerPolicy.RangerPolicyResource> policyResources) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerBaseService.createDefaultPolicyItem()");
        }
        RangerPolicy.RangerPolicyItem policyItem = new RangerPolicy.RangerPolicyItem();
        policyItem.setUsers(this.getUserList());
        policyItem.setGroups(this.getGroupList());
        List<RangerPolicy.RangerPolicyItemAccess> accesses = this.getAllowedAccesses(policyResources);
        policyItem.setAccesses(accesses);
        policyItem.setDelegateAdmin(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerBaseService.createDefaultPolicyItem(): " + policyItem);
        }
        return policyItem;
    }

    protected List<RangerPolicy.RangerPolicyItemAccess> getAllowedAccesses(Map<String, RangerPolicy.RangerPolicyResource> policyResources) {
        ArrayList<RangerPolicy.RangerPolicyItemAccess> ret = new ArrayList<RangerPolicy.RangerPolicyItemAccess>();
        RangerServiceDef.RangerResourceDef leafResourceDef = ServiceDefUtil.getLeafResourceDef(this.serviceDef, policyResources);
        if (leafResourceDef != null) {
            Set<String> accessTypeRestrictions = leafResourceDef.getAccessTypeRestrictions();
            for (RangerServiceDef.RangerAccessTypeDef accessTypeDef : this.serviceDef.getAccessTypes()) {
                boolean isAccessTypeAllowed = CollectionUtils.isEmpty(accessTypeRestrictions) || accessTypeRestrictions.contains(accessTypeDef.getName());
                if (!isAccessTypeAllowed) continue;
                RangerPolicy.RangerPolicyItemAccess access = new RangerPolicy.RangerPolicyItemAccess();
                access.setType(accessTypeDef.getName());
                access.setIsAllowed(true);
                ret.add(access);
            }
        }
        return ret;
    }

    protected Map<String, RangerPolicy.RangerPolicyResource> createDefaultPolicyResource(List<RangerServiceDef.RangerResourceDef> resourceHierarchy) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerBaseService.createDefaultPolicyResource()");
        }
        HashMap<String, RangerPolicy.RangerPolicyResource> resourceMap = new HashMap<String, RangerPolicy.RangerPolicyResource>();
        for (RangerServiceDef.RangerResourceDef resourceDef : resourceHierarchy) {
            RangerPolicy.RangerPolicyResource polRes = new RangerPolicy.RangerPolicyResource();
            polRes.setIsExcludes(false);
            polRes.setIsRecursive(resourceDef.getRecursiveSupported());
            polRes.setValue("*");
            resourceMap.put(resourceDef.getName(), polRes);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerBaseService.createDefaultPolicyResource():" + resourceMap);
        }
        return resourceMap;
    }

    private String buildPolicyName(List<RangerServiceDef.RangerResourceDef> resourceHierarchy) {
        StringBuilder sb = new StringBuilder("all");
        if (CollectionUtils.isNotEmpty(resourceHierarchy)) {
            int resourceDefCount = 0;
            for (RangerServiceDef.RangerResourceDef resourceDef : resourceHierarchy) {
                if (resourceDefCount > 0) {
                    sb.append(", ");
                } else {
                    sb.append(" - ");
                }
                sb.append(resourceDef.getName());
                ++resourceDefCount;
            }
        }
        return sb.toString().trim();
    }

    private List<String> getUserList() {
        Map<String, String> serviceConfig;
        ArrayList<String> ret = new ArrayList<String>();
        HashSet<String> uniqueUsers = new HashSet<String>();
        String[] users = this.config.getStrings("ranger.default.policy.users");
        if (users != null) {
            for (String user : users) {
                uniqueUsers.add(user);
            }
        }
        if ((serviceConfig = this.service.getConfigs()) != null) {
            ArrayList<String> defaultUserList;
            String defaultUsers;
            String serviceConfigUser = serviceConfig.get("username");
            if (StringUtils.isNotBlank((String)serviceConfigUser)) {
                uniqueUsers.add(serviceConfig.get("username"));
            }
            if (!StringUtils.isEmpty((String)(defaultUsers = serviceConfig.get("default.policy.users"))) && !(defaultUserList = new ArrayList<String>(Arrays.asList(StringUtils.split((String)defaultUsers, (String)",")))).isEmpty()) {
                uniqueUsers.addAll(defaultUserList);
            }
        }
        ret.addAll(uniqueUsers);
        return ret;
    }

    private List<String> getGroupList() {
        ArrayList<String> defaultGroupList;
        String defaultGroups;
        Map<String, String> serviceConfig;
        ArrayList<String> ret = new ArrayList<String>();
        HashSet<String> uniqueGroups = new HashSet<String>();
        String[] groups = this.config.getStrings("ranger.default.policy.groups");
        if (groups != null) {
            for (String group : groups) {
                uniqueGroups.add(group);
            }
        }
        if ((serviceConfig = this.service.getConfigs()) != null && !StringUtils.isEmpty((String)(defaultGroups = serviceConfig.get("default.policy.groups"))) && !(defaultGroupList = new ArrayList<String>(Arrays.asList(StringUtils.split((String)defaultGroups, (String)",")))).isEmpty()) {
            uniqueGroups.addAll(defaultGroupList);
        }
        ret.addAll(uniqueGroups);
        return ret;
    }

    protected String getLookupUser(String authType, String lookupPrincipal, String lookupKeytab) {
        String lookupUser = null;
        if (!StringUtils.isEmpty((String)authType) && authType.equalsIgnoreCase(KERBEROS_TYPE) && SecureClientLogin.isKerberosCredentialExists(lookupPrincipal, lookupKeytab)) {
            KerberosName krbName = new KerberosName(lookupPrincipal);
            try {
                lookupUser = krbName.getShortName();
            }
            catch (IOException e) {
                LOG.error("Unknown lookup user", (Throwable)e);
            }
        }
        return lookupUser;
    }
}

