/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import java.util.concurrent.Callable;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.ozone.freon.HadoopBaseFreonGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="ddsg", aliases={"dfs-directory-generator"}, description={"Create nested directories to the any dfs compatible file system."}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true, showDefaultValues=true)
public class HadoopNestedDirGenerator
extends HadoopBaseFreonGenerator
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopNestedDirGenerator.class);
    @CommandLine.Option(names={"-d", "--depth"}, description={"Number of directories to be generated recursively"}, defaultValue="5")
    private int depth;
    @CommandLine.Option(names={"-s", "--span"}, description={"Number of child directories to be created in leaf directory."}, defaultValue="10")
    private int span;
    @CommandLine.Option(names={"-l", "--name-len", "--nameLen"}, description={"Length of the random name of directory you want to create. Full name --nameLen will be removed in later versions."}, defaultValue="10")
    private int length;

    @Override
    public Void call() throws Exception {
        if (this.depth <= 0) {
            String s = "Invalid depth value, depth value should be greater than zero!";
            this.print(s);
        } else if (this.span < 0) {
            String s = "Invalid span value, span value should be greater or equal to zero!";
            this.print(s);
        } else {
            super.init();
            this.runTests(this::createDir);
        }
        return null;
    }

    private void createDir(long counter) throws Exception {
        String dirString = RandomStringUtils.randomAlphanumeric((int)this.length);
        for (int i = 1; i <= this.depth; ++i) {
            dirString = dirString.concat("/").concat(RandomStringUtils.randomAlphanumeric((int)this.length));
        }
        Path file = new Path(this.getRootPath().concat("/").concat(dirString));
        this.getFileSystem().mkdirs(file.getParent());
        String leafDir = dirString.substring(0, dirString.length() - this.length);
        String tmp = "/0";
        for (int i = 1; i <= this.span; ++i) {
            String childDir = leafDir.concat(Integer.toString(i)).concat(tmp);
            Path dir = new Path(this.getRootPath().concat("/").concat(childDir));
            this.getFileSystem().mkdirs(dir.getParent());
        }
        String message = "\nSuccessfully created directories. Total Directories with level = " + this.depth + " and span = " + this.span;
        this.print(message);
    }
}

