/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.entitylinker;

import java.io.IOException;
import java.util.Objects;
import opennlp.tools.entitylinker.EntityLinker;
import opennlp.tools.entitylinker.EntityLinkerProperties;
import opennlp.tools.util.ext.ExtensionLoader;

public class EntityLinkerFactory {
    public static synchronized EntityLinker<?> getLinker(String entityType, EntityLinkerProperties properties) throws IOException {
        if (entityType == null || properties == null) {
            throw new IllegalArgumentException("Null argument in entityLinkerFactory");
        }
        String linkerImplFullName = properties.getProperty("linker." + entityType, "");
        if (linkerImplFullName == null || linkerImplFullName.isEmpty()) {
            throw new IllegalArgumentException("linker." + entityType + "  property must be set!");
        }
        EntityLinker linker = (EntityLinker)ExtensionLoader.instantiateExtension(EntityLinker.class, (String)linkerImplFullName);
        linker.init(properties);
        return linker;
    }

    public static synchronized EntityLinker<?> getLinker(EntityLinkerProperties properties) throws IOException {
        Objects.requireNonNull(properties, "properties argument must not be null");
        String linkerImplFullName = properties.getProperty("linker", "");
        if (linkerImplFullName == null || linkerImplFullName.isEmpty()) {
            throw new IllegalArgumentException("\"linker\" property must be set!");
        }
        EntityLinker linker = (EntityLinker)ExtensionLoader.instantiateExtension(EntityLinker.class, (String)linkerImplFullName);
        linker.init(properties);
        return linker;
    }
}

