/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.doccat;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import opennlp.tools.cmdline.AbstractEvaluatorTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.doccat.DoccatEvaluationErrorListener;
import opennlp.tools.cmdline.doccat.DoccatFineGrainedReportListener;
import opennlp.tools.cmdline.doccat.DoccatModelLoader;
import opennlp.tools.cmdline.params.EvaluatorParams;
import opennlp.tools.cmdline.params.FineGrainedEvaluatorParams;
import opennlp.tools.doccat.DoccatEvaluationMonitor;
import opennlp.tools.doccat.DoccatModel;
import opennlp.tools.doccat.DocumentCategorizer;
import opennlp.tools.doccat.DocumentCategorizerEvaluator;
import opennlp.tools.doccat.DocumentCategorizerME;
import opennlp.tools.doccat.DocumentSample;
import opennlp.tools.util.ObjectStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DoccatEvaluatorTool
extends AbstractEvaluatorTool<DocumentSample, EvalToolParams> {
    private static final Logger logger = LoggerFactory.getLogger(DoccatEvaluatorTool.class);

    public DoccatEvaluatorTool() {
        super(DocumentSample.class, EvalToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "Measures the performance of the Doccat model with the reference data";
    }

    @Override
    public void run(String format, String[] args) {
        super.run(format, args);
        DoccatModel model = (DoccatModel)new DoccatModelLoader().load(((EvalToolParams)this.params).getModel());
        LinkedList<Object> listeners = new LinkedList<Object>();
        if (((EvalToolParams)this.params).getMisclassified().booleanValue()) {
            listeners.add(new DoccatEvaluationErrorListener());
        }
        DoccatFineGrainedReportListener reportListener = null;
        File reportFile = ((EvalToolParams)this.params).getReportOutputFile();
        FileOutputStream reportOutputStream = null;
        if (reportFile != null) {
            CmdLineUtil.checkOutputFile("Report Output File", reportFile);
            try {
                reportOutputStream = new FileOutputStream(reportFile);
                reportListener = new DoccatFineGrainedReportListener(reportOutputStream);
                listeners.add(reportListener);
            }
            catch (FileNotFoundException e) {
                throw new TerminateToolException(-1, "IO error while creating Doccat fine-grained report file: " + e.getMessage());
            }
        }
        DocumentCategorizerEvaluator evaluator = new DocumentCategorizerEvaluator((DocumentCategorizer)new DocumentCategorizerME(model), listeners.toArray(new DoccatEvaluationMonitor[0]));
        final PerformanceMonitor monitor = new PerformanceMonitor("doc");
        try (ObjectStream<DocumentSample> measuredSampleStream = new ObjectStream<DocumentSample>(){

            public DocumentSample read() throws IOException {
                monitor.incrementCounter();
                return (DocumentSample)DoccatEvaluatorTool.this.sampleStream.read();
            }

            public void reset() throws IOException {
                DoccatEvaluatorTool.this.sampleStream.reset();
            }

            public void close() throws IOException {
                DoccatEvaluatorTool.this.sampleStream.close();
            }
        };){
            monitor.startAndPrintThroughput();
            evaluator.evaluate((ObjectStream)measuredSampleStream);
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO error while reading test data: " + e.getMessage(), (Throwable)e);
        }
        monitor.stopAndPrintFinalResult();
        logger.info(evaluator.toString());
        if (reportListener != null) {
            logger.info("Writing fine-grained report to {}", (Object)((EvalToolParams)this.params).getReportOutputFile().getAbsolutePath());
            reportListener.writeReport();
            try {
                reportOutputStream.flush();
                ((OutputStream)reportOutputStream).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static interface EvalToolParams
    extends EvaluatorParams,
    FineGrainedEvaluatorParams {
    }
}

