/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.openjpa.persistence.kernel;

import java.util.LinkedList;
import java.util.List;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;

/**
 * Test entities as static inner classes
 */
public class StaticInnerClassesContainer {

    @Entity
    @Table(name="StaticInner")
    public static class Inner {

        @SuppressWarnings("unused")
        private int num = 0;
        private String string = null;
        private List twins = new LinkedList();

        protected Inner() {
        }

        public Inner(String string) {
            this.string = string;
        }

        public void addTwin() {
            twins.add(new Inner(string));
        }

        public String getString() {
            return string;
        }
    }
}
