/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.resolver;

import jakarta.validation.Path;
import jakarta.validation.TraversableResolver;
import java.lang.annotation.ElementType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.bval.jsr.resolver.CachingRelevant;

public class CachingTraversableResolver
implements TraversableResolver,
CachingRelevant {
    private TraversableResolver delegate;
    private Map<CacheEntry, CacheEntry> cache = new HashMap<CacheEntry, CacheEntry>();

    public static boolean needsCaching(TraversableResolver resolver) {
        return !(resolver instanceof CachingRelevant) || ((CachingRelevant)((Object)resolver)).needsCaching();
    }

    public CachingTraversableResolver(TraversableResolver delegate) {
        this.delegate = delegate;
    }

    public static TraversableResolver cacheFor(TraversableResolver traversableResolver) {
        return CachingTraversableResolver.needsCaching(traversableResolver) ? new CachingTraversableResolver(traversableResolver) : traversableResolver;
    }

    @Override
    public boolean isReachable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
        CacheEntry currentLH = new CacheEntry(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType);
        CacheEntry cachedLH = this.cache.get(currentLH);
        if (cachedLH == null) {
            currentLH.reachable = this.delegate.isReachable(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType);
            this.cache.put(currentLH, currentLH);
            cachedLH = currentLH;
        } else if (cachedLH.reachable == null) {
            cachedLH.reachable = this.delegate.isReachable(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType);
        }
        return cachedLH.reachable;
    }

    @Override
    public boolean isCascadable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
        CacheEntry currentLH = new CacheEntry(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType);
        CacheEntry cachedLH = this.cache.get(currentLH);
        if (cachedLH == null) {
            currentLH.cascadable = this.delegate.isCascadable(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType);
            this.cache.put(currentLH, currentLH);
            cachedLH = currentLH;
        } else if (cachedLH.cascadable == null) {
            cachedLH.cascadable = this.delegate.isCascadable(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType);
        }
        return cachedLH.cascadable;
    }

    @Override
    public boolean needsCaching() {
        return false;
    }

    private static class CacheEntry {
        private final Object object;
        private final Path.Node node;
        private final Class<?> type;
        private final Path path;
        private final ElementType elementType;
        private final int hashCode;
        private Boolean reachable;
        private Boolean cascadable;

        private CacheEntry(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
            this.object = traversableObject;
            this.node = traversableProperty;
            this.type = rootBeanType;
            this.path = pathToTraversableObject;
            this.elementType = elementType;
            this.hashCode = this.buildHashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !this.getClass().equals(o.getClass())) {
                return false;
            }
            CacheEntry that = (CacheEntry)o;
            return this.elementType == that.elementType && Objects.equals(this.path, that.path) && Objects.equals(this.type, that.type) && Objects.equals(this.object, that.object) && Objects.equals(this.node, that.node);
        }

        public int hashCode() {
            return this.hashCode;
        }

        private int buildHashCode() {
            return Objects.hash(new Object[]{this.object, this.node, this.type, this.path, this.elementType});
        }
    }
}

