/****************************************************************************
 * drivers/video/nxlogo320.c
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

/* Script-generated framebuffer splashscreen bitmap file.
 * Generated from drivers/video/nxlogo320.png
 * by splashscreen_converter.py
 */

/****************************************************************************
 * Included Files
 ****************************************************************************/

#include <nuttx/video/fb.h>

/****************************************************************************
 * Pre-processor Definitions
 ****************************************************************************/

/****************************************************************************
 * Private Data
 ****************************************************************************/

#ifdef CONFIG_VIDEO_FB_SPLASHSCREEN_BPP32
static const fb_pixel_t palette[] =
{
  MKRGB(0, 0, 0, 0),
  MKRGB(255, 60, 52, 227),
  MKRGB(255, 206, 227, 241),
  MKRGB(255, 255, 255, 255),
  MKRGB(255, 43, 39, 131),
  MKRGB(255, 90, 150, 189),
  MKRGB(255, 94, 174, 225),
};
#endif

#if defined(CONFIG_VIDEO_FB_SPLASHSCREEN_BPP24) || \
    defined(CONFIG_VIDEO_FB_SPLASHSCREEN_BPP16) || \
    defined(CONFIG_VIDEO_FB_SPLASHSCREEN_BPP8)
static const fb_pixel_t palette[] =
{
  MKRGB(0, 0, 0),
  MKRGB(60, 52, 227),
  MKRGB(206, 227, 241),
  MKRGB(255, 255, 255),
  MKRGB(43, 39, 131),
  MKRGB(90, 150, 189),
  MKRGB(94, 174, 225),
};
#endif

#if defined(CONFIG_VIDEO_FB_SPLASHSCREEN_GREY) || \
    defined(CONFIG_VIDEO_FB_SPLASHSCREEN_MONO)
static const fb_pixel_t palette[] =
{
};
#endif

#ifdef CONFIG_VIDEO_FB_SPLASHSCREEN_BPP32
static const struct splscr_bitmap_s bitmap[] =
{
  {154, 0},
  {2, 6},
  {10, 1},
  {154, 0},                                               /* End of row   1 */
  {153, 0},
  {2, 6},
  {12, 1},
  {153, 0},                                               /* End of row   2 */
  {152, 0},
  {2, 6},
  {14, 1},
  {152, 0},                                               /* End of row   3 */
  {151, 0},
  {2, 6},
  {16, 1},
  {151, 0},                                               /* End of row   4 */
  {150, 0},
  {2, 6},
  {6, 1},
  {3, 4},
  {9, 1},
  {150, 0},                                               /* End of row   5 */
  {149, 0},
  {2, 6},
  {6, 1},
  {5, 4},
  {9, 1},
  {149, 0},                                               /* End of row   6 */
  {148, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {3, 6},
  {2, 4},
  {9, 1},
  {148, 0},                                               /* End of row   7 */
  {147, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {3, 1},
  {2, 4},
  {9, 1},
  {147, 0},                                               /* End of row   8 */
  {146, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {2, 4},
  {9, 1},
  {146, 0},                                               /* End of row   9 */
  {145, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {7, 1},
  {2, 4},
  {9, 1},
  {145, 0},                                               /* End of row  10 */
  {144, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {9, 1},
  {2, 4},
  {9, 1},
  {144, 0},                                               /* End of row  11 */
  {143, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {11, 1},
  {2, 4},
  {9, 1},
  {143, 0},                                               /* End of row  12 */
  {142, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {13, 1},
  {2, 4},
  {9, 1},
  {142, 0},                                               /* End of row  13 */
  {141, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {15, 1},
  {2, 4},
  {9, 1},
  {141, 0},                                               /* End of row  14 */
  {140, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {17, 1},
  {2, 4},
  {9, 1},
  {140, 0},                                               /* End of row  15 */
  {139, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {19, 1},
  {2, 4},
  {9, 1},
  {139, 0},                                               /* End of row  16 */
  {138, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {21, 1},
  {2, 4},
  {9, 1},
  {138, 0},                                               /* End of row  17 */
  {137, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {23, 1},
  {2, 4},
  {9, 1},
  {137, 0},                                               /* End of row  18 */
  {136, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {25, 1},
  {2, 4},
  {9, 1},
  {136, 0},                                               /* End of row  19 */
  {135, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {27, 1},
  {2, 4},
  {9, 1},
  {135, 0},                                               /* End of row  20 */
  {134, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {29, 1},
  {2, 4},
  {9, 1},
  {134, 0},                                               /* End of row  21 */
  {133, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {31, 1},
  {2, 4},
  {9, 1},
  {133, 0},                                               /* End of row  22 */
  {132, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {33, 1},
  {2, 4},
  {9, 1},
  {132, 0},                                               /* End of row  23 */
  {131, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {35, 1},
  {2, 4},
  {9, 1},
  {131, 0},                                               /* End of row  24 */
  {130, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {37, 1},
  {2, 4},
  {9, 1},
  {130, 0},                                               /* End of row  25 */
  {129, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {39, 1},
  {2, 4},
  {9, 1},
  {129, 0},                                               /* End of row  26 */
  {128, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {41, 1},
  {2, 4},
  {9, 1},
  {128, 0},                                               /* End of row  27 */
  {127, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {43, 1},
  {2, 4},
  {9, 1},
  {127, 0},                                               /* End of row  28 */
  {126, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {45, 1},
  {2, 4},
  {9, 1},
  {126, 0},                                               /* End of row  29 */
  {125, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {47, 1},
  {2, 4},
  {9, 1},
  {125, 0},                                               /* End of row  30 */
  {124, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {49, 1},
  {2, 4},
  {9, 1},
  {124, 0},                                               /* End of row  31 */
  {123, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {51, 1},
  {2, 4},
  {9, 1},
  {123, 0},                                               /* End of row  32 */
  {122, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {53, 1},
  {2, 4},
  {9, 1},
  {122, 0},                                               /* End of row  33 */
  {121, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {55, 1},
  {2, 4},
  {9, 1},
  {121, 0},                                               /* End of row  34 */
  {120, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {57, 1},
  {2, 4},
  {9, 1},
  {120, 0},                                               /* End of row  35 */
  {119, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {59, 1},
  {2, 4},
  {9, 1},
  {119, 0},                                               /* End of row  36 */
  {118, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {61, 1},
  {2, 4},
  {9, 1},
  {56, 0},
  {10, 2},
  {52, 0},                                                /* End of row  37 */
  {117, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {63, 1},
  {2, 4},
  {9, 1},
  {53, 0},
  {14, 2},
  {50, 0},                                                /* End of row  38 */
  {116, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {65, 1},
  {2, 4},
  {9, 1},
  {50, 0},
  {18, 2},
  {48, 0},                                                /* End of row  39 */
  {115, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {67, 1},
  {2, 4},
  {9, 1},
  {48, 0},
  {20, 2},
  {47, 0},                                                /* End of row  40 */
  {114, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {24, 1},
  {10, 2},
  {35, 1},
  {2, 4},
  {9, 1},
  {46, 0},
  {22, 2},
  {46, 0},                                                /* End of row  41 */
  {113, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {23, 1},
  {14, 2},
  {34, 1},
  {2, 4},
  {9, 1},
  {45, 0},
  {23, 2},
  {45, 0},                                                /* End of row  42 */
  {48, 0},
  {11, 2},
  {53, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {23, 1},
  {17, 2},
  {33, 1},
  {2, 4},
  {9, 1},
  {43, 0},
  {25, 2},
  {44, 0},                                                /* End of row  43 */
  {46, 0},
  {14, 2},
  {51, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {23, 1},
  {19, 2},
  {33, 1},
  {2, 4},
  {9, 1},
  {42, 0},
  {26, 2},
  {43, 0},                                                /* End of row  44 */
  {44, 0},
  {18, 2},
  {48, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {23, 1},
  {21, 2},
  {33, 1},
  {2, 4},
  {9, 1},
  {40, 0},
  {28, 2},
  {42, 0},                                                /* End of row  45 */
  {43, 0},
  {20, 2},
  {46, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {23, 1},
  {23, 2},
  {33, 1},
  {2, 4},
  {9, 1},
  {39, 0},
  {28, 2},
  {42, 0},                                                /* End of row  46 */
  {42, 0},
  {22, 2},
  {44, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {23, 1},
  {25, 2},
  {8, 4},
  {25, 1},
  {2, 4},
  {9, 1},
  {37, 0},
  {30, 2},
  {41, 0},                                                /* End of row  47 */
  {42, 0},
  {23, 2},
  {42, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {24, 1},
  {26, 2},
  {9, 4},
  {24, 1},
  {2, 4},
  {9, 1},
  {36, 0},
  {14, 2},
  {2, 3},
  {14, 2},
  {41, 0},                                                /* End of row  48 */
  {41, 0},
  {25, 2},
  {1, 0},
  {9, 5},
  {30, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {24, 1},
  {28, 2},
  {9, 4},
  {24, 1},
  {2, 4},
  {9, 1},
  {34, 0},
  {12, 2},
  {8, 3},
  {12, 2},
  {2, 5},
  {38, 0},                                                /* End of row  49 */
  {40, 0},
  {27, 2},
  {11, 5},
  {27, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {25, 1},
  {28, 2},
  {10, 4},
  {24, 1},
  {2, 4},
  {9, 1},
  {33, 0},
  {11, 2},
  {10, 3},
  {11, 2},
  {3, 5},
  {37, 0},                                                /* End of row  50 */
  {39, 0},
  {29, 2},
  {12, 5},
  {24, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {25, 1},
  {11, 2},
  {6, 3},
  {13, 2},
  {10, 4},
  {24, 1},
  {2, 4},
  {9, 1},
  {31, 0},
  {11, 2},
  {12, 3},
  {11, 2},
  {3, 5},
  {36, 0},                                                /* End of row  51 */
  {39, 0},
  {29, 2},
  {12, 5},
  {23, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {26, 1},
  {10, 2},
  {8, 3},
  {12, 2},
  {11, 4},
  {24, 1},
  {2, 4},
  {9, 1},
  {30, 0},
  {11, 2},
  {12, 3},
  {11, 2},
  {4, 5},
  {35, 0},                                                /* End of row  52 */
  {38, 0},
  {31, 2},
  {12, 5},
  {21, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {27, 1},
  {10, 2},
  {9, 3},
  {12, 2},
  {11, 4},
  {24, 1},
  {2, 4},
  {9, 1},
  {28, 0},
  {11, 2},
  {14, 3},
  {10, 2},
  {5, 5},
  {34, 0},                                                /* End of row  53 */
  {38, 0},
  {12, 2},
  {5, 3},
  {14, 2},
  {12, 5},
  {20, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {27, 1},
  {10, 2},
  {11, 3},
  {11, 2},
  {12, 4},
  {24, 1},
  {2, 4},
  {9, 1},
  {27, 0},
  {11, 2},
  {14, 3},
  {10, 2},
  {6, 5},
  {33, 0},                                                /* End of row  54 */
  {37, 0},
  {11, 2},
  {8, 3},
  {14, 2},
  {12, 5},
  {18, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {28, 1},
  {10, 2},
  {12, 3},
  {11, 2},
  {12, 4},
  {24, 1},
  {2, 4},
  {9, 1},
  {25, 0},
  {11, 2},
  {15, 3},
  {10, 2},
  {7, 5},
  {32, 0},                                                /* End of row  55 */
  {37, 0},
  {10, 2},
  {10, 3},
  {13, 2},
  {12, 5},
  {17, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {29, 1},
  {9, 2},
  {13, 3},
  {11, 2},
  {12, 4},
  {25, 1},
  {2, 4},
  {9, 1},
  {24, 0},
  {11, 2},
  {15, 3},
  {10, 2},
  {7, 5},
  {32, 0},                                                /* End of row  56 */
  {36, 0},
  {10, 2},
  {11, 3},
  {14, 2},
  {12, 5},
  {15, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {30, 1},
  {9, 2},
  {14, 3},
  {11, 2},
  {12, 4},
  {25, 1},
  {2, 4},
  {9, 1},
  {22, 0},
  {11, 2},
  {15, 3},
  {11, 2},
  {8, 5},
  {31, 0},                                                /* End of row  57 */
  {36, 0},
  {10, 2},
  {12, 3},
  {13, 2},
  {12, 5},
  {14, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {31, 1},
  {9, 2},
  {14, 3},
  {11, 2},
  {12, 4},
  {26, 1},
  {2, 4},
  {9, 1},
  {21, 0},
  {11, 2},
  {15, 3},
  {11, 2},
  {8, 5},
  {31, 0},                                                /* End of row  58 */
  {36, 0},
  {9, 2},
  {14, 3},
  {13, 2},
  {12, 5},
  {12, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {32, 1},
  {8, 2},
  {16, 3},
  {11, 2},
  {12, 4},
  {26, 1},
  {2, 4},
  {9, 1},
  {19, 0},
  {11, 2},
  {15, 3},
  {11, 2},
  {10, 5},
  {30, 0},                                                /* End of row  59 */
  {36, 0},
  {9, 2},
  {14, 3},
  {13, 2},
  {12, 5},
  {11, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {33, 1},
  {8, 2},
  {16, 3},
  {11, 2},
  {12, 4},
  {27, 1},
  {2, 4},
  {9, 1},
  {18, 0},
  {11, 2},
  {15, 3},
  {11, 2},
  {10, 5},
  {30, 0},                                                /* End of row  60 */
  {36, 0},
  {8, 2},
  {16, 3},
  {13, 2},
  {12, 5},
  {9, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {34, 1},
  {8, 2},
  {17, 3},
  {11, 2},
  {12, 4},
  {27, 1},
  {2, 4},
  {9, 1},
  {16, 0},
  {11, 2},
  {15, 3},
  {11, 2},
  {11, 5},
  {30, 0},                                                /* End of row  61 */
  {36, 0},
  {8, 2},
  {16, 3},
  {13, 2},
  {12, 5},
  {8, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {35, 1},
  {8, 2},
  {17, 3},
  {11, 2},
  {12, 4},
  {28, 1},
  {2, 4},
  {9, 1},
  {15, 0},
  {11, 2},
  {15, 3},
  {11, 2},
  {12, 5},
  {29, 0},                                                /* End of row  62 */
  {36, 0},
  {8, 2},
  {17, 3},
  {13, 2},
  {12, 5},
  {6, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {36, 1},
  {8, 2},
  {18, 3},
  {11, 2},
  {12, 4},
  {28, 1},
  {2, 4},
  {9, 1},
  {13, 0},
  {11, 2},
  {15, 3},
  {11, 2},
  {13, 5},
  {29, 0},                                                /* End of row  63 */
  {36, 0},
  {8, 2},
  {17, 3},
  {13, 2},
  {12, 5},
  {5, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {37, 1},
  {8, 2},
  {18, 3},
  {11, 2},
  {12, 4},
  {29, 1},
  {2, 4},
  {9, 1},
  {12, 0},
  {11, 2},
  {15, 3},
  {11, 2},
  {13, 5},
  {29, 0},                                                /* End of row  64 */
  {36, 0},
  {8, 2},
  {18, 3},
  {13, 2},
  {12, 5},
  {3, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {38, 1},
  {8, 2},
  {19, 3},
  {11, 2},
  {12, 4},
  {29, 1},
  {2, 4},
  {9, 1},
  {10, 0},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {29, 0},                                                /* End of row  65 */
  {36, 0},
  {8, 2},
  {18, 3},
  {13, 2},
  {12, 5},
  {2, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {39, 1},
  {8, 2},
  {19, 3},
  {11, 2},
  {12, 4},
  {30, 1},
  {2, 4},
  {9, 1},
  {9, 0},
  {11, 2},
  {15, 3},
  {11, 2},
  {13, 5},
  {30, 0},                                                /* End of row  66 */
  {36, 0},
  {8, 2},
  {19, 3},
  {13, 2},
  {12, 5},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {40, 1},
  {8, 2},
  {20, 3},
  {11, 2},
  {12, 4},
  {30, 1},
  {2, 4},
  {9, 1},
  {7, 0},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {30, 0},                                                /* End of row  67 */
  {36, 0},
  {8, 2},
  {19, 3},
  {13, 2},
  {11, 5},
  {1, 4},
  {1, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {41, 1},
  {8, 2},
  {20, 3},
  {11, 2},
  {12, 4},
  {31, 1},
  {2, 4},
  {9, 1},
  {6, 0},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {30, 0},                                                /* End of row  68 */
  {36, 0},
  {8, 2},
  {20, 3},
  {13, 2},
  {9, 5},
  {3, 4},
  {5, 1},
  {2, 4},
  {2, 6},
  {42, 1},
  {8, 2},
  {21, 3},
  {11, 2},
  {12, 4},
  {31, 1},
  {2, 4},
  {9, 1},
  {4, 0},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {31, 0},                                                /* End of row  69 */
  {36, 0},
  {8, 2},
  {20, 3},
  {13, 2},
  {8, 5},
  {4, 4},
  {4, 1},
  {2, 4},
  {2, 6},
  {43, 1},
  {8, 2},
  {21, 3},
  {11, 2},
  {12, 4},
  {32, 1},
  {2, 4},
  {9, 1},
  {3, 0},
  {11, 2},
  {15, 3},
  {10, 2},
  {15, 5},
  {31, 0},                                                /* End of row  70 */
  {36, 0},
  {8, 2},
  {21, 3},
  {13, 2},
  {6, 5},
  {6, 4},
  {2, 1},
  {2, 4},
  {2, 6},
  {44, 1},
  {8, 2},
  {22, 3},
  {11, 2},
  {12, 4},
  {32, 1},
  {2, 4},
  {9, 1},
  {1, 0},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {32, 0},                                                /* End of row  71 */
  {36, 0},
  {8, 2},
  {21, 3},
  {13, 2},
  {5, 5},
  {7, 4},
  {1, 1},
  {2, 4},
  {2, 6},
  {45, 1},
  {8, 2},
  {22, 3},
  {11, 2},
  {12, 4},
  {33, 1},
  {2, 4},
  {9, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {32, 0},                                                /* End of row  72 */
  {36, 0},
  {8, 2},
  {22, 3},
  {13, 2},
  {3, 5},
  {10, 4},
  {2, 6},
  {46, 1},
  {8, 2},
  {23, 3},
  {11, 2},
  {12, 4},
  {33, 1},
  {2, 4},
  {7, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {33, 0},                                                /* End of row  73 */
  {36, 0},
  {8, 2},
  {22, 3},
  {13, 2},
  {2, 5},
  {11, 4},
  {1, 6},
  {47, 1},
  {8, 2},
  {23, 3},
  {11, 2},
  {12, 4},
  {34, 1},
  {2, 4},
  {6, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {33, 0},                                                /* End of row  74 */
  {36, 0},
  {8, 2},
  {23, 3},
  {13, 2},
  {12, 4},
  {48, 1},
  {8, 2},
  {24, 3},
  {11, 2},
  {12, 4},
  {34, 1},
  {2, 4},
  {4, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {34, 0},                                                /* End of row  75 */
  {36, 0},
  {8, 2},
  {23, 3},
  {13, 2},
  {13, 4},
  {47, 1},
  {8, 2},
  {24, 3},
  {11, 2},
  {12, 4},
  {35, 1},
  {2, 4},
  {3, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {34, 0},                                                /* End of row  76 */
  {36, 0},
  {8, 2},
  {24, 3},
  {13, 2},
  {12, 4},
  {47, 1},
  {8, 2},
  {25, 3},
  {11, 2},
  {12, 4},
  {35, 1},
  {2, 4},
  {1, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {35, 0},                                                /* End of row  77 */
  {36, 0},
  {8, 2},
  {24, 3},
  {13, 2},
  {12, 4},
  {47, 1},
  {8, 2},
  {25, 3},
  {11, 2},
  {12, 4},
  {36, 1},
  {2, 4},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {35, 0},                                                /* End of row  78 */
  {36, 0},
  {8, 2},
  {25, 3},
  {13, 2},
  {12, 4},
  {46, 1},
  {8, 2},
  {26, 3},
  {11, 2},
  {12, 4},
  {36, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {36, 0},                                                /* End of row  79 */
  {36, 0},
  {8, 2},
  {25, 3},
  {13, 2},
  {12, 4},
  {46, 1},
  {8, 2},
  {26, 3},
  {11, 2},
  {12, 4},
  {36, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {36, 0},                                                /* End of row  80 */
  {36, 0},
  {8, 2},
  {26, 3},
  {13, 2},
  {12, 4},
  {45, 1},
  {8, 2},
  {27, 3},
  {11, 2},
  {12, 4},
  {34, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {37, 0},                                                /* End of row  81 */
  {36, 0},
  {8, 2},
  {26, 3},
  {13, 2},
  {12, 4},
  {45, 1},
  {8, 2},
  {27, 3},
  {11, 2},
  {12, 4},
  {34, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {37, 0},                                                /* End of row  82 */
  {36, 0},
  {8, 2},
  {27, 3},
  {13, 2},
  {12, 4},
  {44, 1},
  {8, 2},
  {28, 3},
  {11, 2},
  {12, 4},
  {32, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {38, 0},                                                /* End of row  83 */
  {36, 0},
  {8, 2},
  {27, 3},
  {13, 2},
  {12, 4},
  {44, 1},
  {8, 2},
  {28, 3},
  {11, 2},
  {12, 4},
  {32, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {38, 0},                                                /* End of row  84 */
  {36, 0},
  {8, 2},
  {28, 3},
  {13, 2},
  {12, 4},
  {43, 1},
  {8, 2},
  {29, 3},
  {11, 2},
  {12, 4},
  {30, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {39, 0},                                                /* End of row  85 */
  {36, 0},
  {8, 2},
  {28, 3},
  {13, 2},
  {12, 4},
  {43, 1},
  {8, 2},
  {29, 3},
  {11, 2},
  {12, 4},
  {30, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {39, 0},                                                /* End of row  86 */
  {36, 0},
  {8, 2},
  {29, 3},
  {13, 2},
  {12, 4},
  {42, 1},
  {8, 2},
  {14, 3},
  {1, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {28, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {40, 0},                                                /* End of row  87 */
  {36, 0},
  {8, 2},
  {29, 3},
  {13, 2},
  {12, 4},
  {42, 1},
  {8, 2},
  {14, 3},
  {1, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {28, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {40, 0},                                                /* End of row  88 */
  {36, 0},
  {8, 2},
  {30, 3},
  {13, 2},
  {12, 4},
  {41, 1},
  {8, 2},
  {14, 3},
  {2, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {26, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {41, 0},                                                /* End of row  89 */
  {36, 0},
  {8, 2},
  {30, 3},
  {13, 2},
  {12, 4},
  {41, 1},
  {8, 2},
  {14, 3},
  {2, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {26, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {41, 0},                                                /* End of row  90 */
  {36, 0},
  {8, 2},
  {16, 3},
  {1, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {40, 1},
  {8, 2},
  {14, 3},
  {3, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {24, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {42, 0},                                                /* End of row  91 */
  {36, 0},
  {8, 2},
  {16, 3},
  {1, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {40, 1},
  {8, 2},
  {14, 3},
  {3, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {24, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {42, 0},                                                /* End of row  92 */
  {36, 0},
  {8, 2},
  {16, 3},
  {2, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {39, 1},
  {8, 2},
  {14, 3},
  {4, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {22, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {43, 0},                                                /* End of row  93 */
  {36, 0},
  {8, 2},
  {16, 3},
  {2, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {39, 1},
  {8, 2},
  {14, 3},
  {4, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {22, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {43, 0},                                                /* End of row  94 */
  {36, 0},
  {8, 2},
  {16, 3},
  {3, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {38, 1},
  {8, 2},
  {14, 3},
  {5, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {20, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {44, 0},                                                /* End of row  95 */
  {36, 0},
  {8, 2},
  {16, 3},
  {3, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {38, 1},
  {8, 2},
  {14, 3},
  {5, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {20, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {44, 0},                                                /* End of row  96 */
  {36, 0},
  {8, 2},
  {16, 3},
  {4, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {37, 1},
  {8, 2},
  {14, 3},
  {6, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {18, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {45, 0},                                                /* End of row  97 */
  {36, 0},
  {8, 2},
  {16, 3},
  {4, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {37, 1},
  {8, 2},
  {14, 3},
  {6, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {18, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {45, 0},                                                /* End of row  98 */
  {36, 0},
  {8, 2},
  {16, 3},
  {5, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {36, 1},
  {8, 2},
  {14, 3},
  {7, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {16, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {2, 4},
  {12, 5},
  {46, 0},                                                /* End of row  99 */
  {36, 0},
  {8, 2},
  {16, 3},
  {5, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {36, 1},
  {8, 2},
  {14, 3},
  {7, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {16, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {3, 4},
  {11, 5},
  {46, 0},                                                /* End of row 100 */
  {36, 0},
  {8, 2},
  {16, 3},
  {6, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {35, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {14, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {5, 4},
  {9, 5},
  {47, 0},                                                /* End of row 101 */
  {36, 0},
  {8, 2},
  {16, 3},
  {6, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {35, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {14, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {6, 4},
  {8, 5},
  {47, 0},                                                /* End of row 102 */
  {36, 0},
  {8, 2},
  {16, 3},
  {7, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {34, 1},
  {8, 2},
  {14, 3},
  {9, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {12, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {8, 4},
  {6, 5},
  {48, 0},                                                /* End of row 103 */
  {36, 0},
  {8, 2},
  {16, 3},
  {7, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {34, 1},
  {8, 2},
  {14, 3},
  {9, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {12, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {9, 4},
  {5, 5},
  {48, 0},                                                /* End of row 104 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {33, 1},
  {8, 2},
  {14, 3},
  {10, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {10, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {11, 4},
  {3, 5},
  {49, 0},                                                /* End of row 105 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {33, 1},
  {8, 2},
  {14, 3},
  {10, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {10, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {2, 5},
  {49, 0},                                                /* End of row 106 */
  {36, 0},
  {8, 2},
  {16, 3},
  {9, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {32, 1},
  {8, 2},
  {14, 3},
  {11, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {8, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {50, 0},                                                /* End of row 107 */
  {36, 0},
  {8, 2},
  {16, 3},
  {9, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {32, 1},
  {8, 2},
  {14, 3},
  {11, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {8, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {15, 4},
  {49, 0},                                                /* End of row 108 */
  {36, 0},
  {8, 2},
  {16, 3},
  {10, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {31, 1},
  {8, 2},
  {14, 3},
  {12, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {6, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {15, 4},
  {2, 1},
  {48, 0},                                                /* End of row 109 */
  {36, 0},
  {8, 2},
  {16, 3},
  {10, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {31, 1},
  {8, 2},
  {14, 3},
  {12, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {6, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {15, 4},
  {3, 1},
  {47, 0},                                                /* End of row 110 */
  {36, 0},
  {8, 2},
  {16, 3},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {30, 1},
  {8, 2},
  {14, 3},
  {13, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {4, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {6, 1},
  {46, 0},                                                /* End of row 111 */
  {36, 0},
  {8, 2},
  {16, 3},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {30, 1},
  {8, 2},
  {14, 3},
  {13, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {4, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {7, 1},
  {45, 0},                                                /* End of row 112 */
  {36, 0},
  {8, 2},
  {16, 3},
  {12, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {29, 1},
  {8, 2},
  {14, 3},
  {14, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {2, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {16, 4},
  {7, 1},
  {44, 0},                                                /* End of row 113 */
  {36, 0},
  {8, 2},
  {16, 3},
  {12, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {29, 1},
  {8, 2},
  {14, 3},
  {14, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {2, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {1, 1},
  {2, 4},
  {7, 1},
  {43, 0},                                                /* End of row 114 */
  {36, 0},
  {8, 2},
  {16, 3},
  {13, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {28, 1},
  {8, 2},
  {14, 3},
  {15, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {3, 1},
  {2, 4},
  {7, 1},
  {42, 0},                                                /* End of row 115 */
  {36, 0},
  {8, 2},
  {16, 3},
  {13, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {28, 1},
  {8, 2},
  {14, 3},
  {15, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {4, 1},
  {2, 4},
  {7, 1},
  {41, 0},                                                /* End of row 116 */
  {36, 0},
  {8, 2},
  {16, 3},
  {14, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {27, 1},
  {8, 2},
  {14, 3},
  {16, 2},
  {15, 3},
  {11, 2},
  {10, 4},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {6, 1},
  {2, 4},
  {7, 1},
  {40, 0},                                                /* End of row 117 */
  {36, 0},
  {8, 2},
  {16, 3},
  {14, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {27, 1},
  {8, 2},
  {14, 3},
  {16, 2},
  {15, 3},
  {11, 2},
  {10, 4},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {7, 1},
  {2, 4},
  {7, 1},
  {39, 0},                                                /* End of row 118 */
  {36, 0},
  {8, 2},
  {16, 3},
  {15, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {26, 1},
  {8, 2},
  {14, 3},
  {17, 2},
  {15, 3},
  {11, 2},
  {8, 4},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {9, 1},
  {2, 4},
  {7, 1},
  {38, 0},                                                /* End of row 119 */
  {35, 0},
  {1, 6},
  {8, 2},
  {16, 3},
  {15, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {26, 1},
  {8, 2},
  {14, 3},
  {17, 2},
  {15, 3},
  {11, 2},
  {8, 4},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {10, 1},
  {2, 4},
  {7, 1},
  {37, 0},                                                /* End of row 120 */
  {34, 0},
  {2, 6},
  {8, 2},
  {16, 3},
  {16, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {25, 1},
  {8, 2},
  {14, 3},
  {18, 2},
  {15, 3},
  {11, 2},
  {6, 4},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {12, 1},
  {2, 4},
  {7, 1},
  {36, 0},                                                /* End of row 121 */
  {33, 0},
  {2, 6},
  {1, 1},
  {8, 2},
  {16, 3},
  {16, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {25, 1},
  {8, 2},
  {14, 3},
  {18, 2},
  {15, 3},
  {11, 2},
  {6, 4},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {13, 1},
  {2, 4},
  {7, 1},
  {35, 0},                                                /* End of row 122 */
  {32, 0},
  {2, 6},
  {2, 1},
  {8, 2},
  {16, 3},
  {17, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {24, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {1, 4},
  {10, 2},
  {15, 3},
  {11, 2},
  {4, 4},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {15, 1},
  {2, 4},
  {7, 1},
  {34, 0},                                                /* End of row 123 */
  {31, 0},
  {2, 6},
  {3, 1},
  {8, 2},
  {16, 3},
  {17, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {24, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {1, 4},
  {10, 2},
  {15, 3},
  {11, 2},
  {4, 4},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {16, 1},
  {2, 4},
  {7, 1},
  {33, 0},                                                /* End of row 124 */
  {30, 0},
  {2, 6},
  {4, 1},
  {8, 2},
  {16, 3},
  {18, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {23, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {2, 4},
  {10, 2},
  {15, 3},
  {11, 2},
  {2, 4},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {18, 1},
  {2, 4},
  {7, 1},
  {32, 0},                                                /* End of row 125 */
  {29, 0},
  {2, 6},
  {5, 1},
  {8, 2},
  {16, 3},
  {18, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {23, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {2, 4},
  {10, 2},
  {15, 3},
  {11, 2},
  {2, 4},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {19, 1},
  {2, 4},
  {7, 1},
  {31, 0},                                                /* End of row 126 */
  {28, 0},
  {2, 6},
  {5, 1},
  {1, 4},
  {8, 2},
  {16, 3},
  {19, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {22, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {3, 4},
  {10, 2},
  {15, 3},
  {22, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {21, 1},
  {2, 4},
  {7, 1},
  {30, 0},                                                /* End of row 127 */
  {27, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {8, 2},
  {16, 3},
  {19, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {22, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {3, 4},
  {10, 2},
  {15, 3},
  {22, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {22, 1},
  {2, 4},
  {7, 1},
  {29, 0},                                                /* End of row 128 */
  {26, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {1, 6},
  {8, 2},
  {16, 3},
  {8, 2},
  {1, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {21, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {4, 4},
  {10, 2},
  {15, 3},
  {20, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {24, 1},
  {2, 4},
  {7, 1},
  {28, 0},                                                /* End of row 129 */
  {25, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {8, 2},
  {16, 3},
  {8, 2},
  {1, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {21, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {4, 4},
  {10, 2},
  {15, 3},
  {20, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {25, 1},
  {2, 4},
  {7, 1},
  {27, 0},                                                /* End of row 130 */
  {24, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {1, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {2, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {20, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {5, 4},
  {10, 2},
  {15, 3},
  {18, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {27, 1},
  {2, 4},
  {7, 1},
  {26, 0},                                                /* End of row 131 */
  {23, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {2, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {2, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {20, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {5, 4},
  {10, 2},
  {15, 3},
  {18, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {28, 1},
  {2, 4},
  {7, 1},
  {25, 0},                                                /* End of row 132 */
  {22, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {3, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {3, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {19, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {6, 4},
  {10, 2},
  {15, 3},
  {16, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {30, 1},
  {2, 4},
  {7, 1},
  {24, 0},                                                /* End of row 133 */
  {21, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {4, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {3, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {19, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {6, 4},
  {10, 2},
  {15, 3},
  {16, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {31, 1},
  {2, 4},
  {7, 1},
  {23, 0},                                                /* End of row 134 */
  {20, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {4, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {18, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {7, 4},
  {10, 2},
  {15, 3},
  {14, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {33, 1},
  {2, 4},
  {7, 1},
  {22, 0},                                                /* End of row 135 */
  {19, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {6, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {4, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {18, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {7, 4},
  {10, 2},
  {15, 3},
  {14, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {34, 1},
  {2, 4},
  {7, 1},
  {21, 0},                                                /* End of row 136 */
  {18, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {7, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {5, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {17, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {8, 4},
  {10, 2},
  {15, 3},
  {12, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {36, 1},
  {2, 4},
  {7, 1},
  {20, 0},                                                /* End of row 137 */
  {17, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {8, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {5, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {17, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {8, 4},
  {10, 2},
  {15, 3},
  {12, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {37, 1},
  {2, 4},
  {7, 1},
  {19, 0},                                                /* End of row 138 */
  {16, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {9, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {6, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {16, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {9, 4},
  {10, 2},
  {15, 3},
  {10, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {39, 1},
  {2, 4},
  {7, 1},
  {18, 0},                                                /* End of row 139 */
  {15, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {10, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {6, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {16, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {9, 4},
  {10, 2},
  {15, 3},
  {10, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {40, 1},
  {2, 4},
  {7, 1},
  {17, 0},                                                /* End of row 140 */
  {14, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {11, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {7, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {15, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {10, 4},
  {10, 2},
  {15, 3},
  {8, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {42, 1},
  {2, 4},
  {7, 1},
  {16, 0},                                                /* End of row 141 */
  {13, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {12, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {7, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {15, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {10, 4},
  {10, 2},
  {15, 3},
  {8, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {43, 1},
  {2, 4},
  {7, 1},
  {15, 0},                                                /* End of row 142 */
  {12, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {13, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {8, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {14, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {11, 4},
  {10, 2},
  {15, 3},
  {6, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {45, 1},
  {2, 4},
  {7, 1},
  {14, 0},                                                /* End of row 143 */
  {11, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {14, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {8, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {14, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {11, 4},
  {10, 2},
  {15, 3},
  {6, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {46, 1},
  {2, 4},
  {7, 1},
  {13, 0},                                                /* End of row 144 */
  {10, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {15, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {9, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {13, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {12, 4},
  {10, 2},
  {15, 3},
  {4, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {48, 1},
  {2, 4},
  {7, 1},
  {12, 0},                                                /* End of row 145 */
  {9, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {16, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {9, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {13, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {12, 4},
  {10, 2},
  {15, 3},
  {4, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {49, 1},
  {2, 4},
  {7, 1},
  {11, 0},                                                /* End of row 146 */
  {8, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {17, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {10, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {12, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {13, 4},
  {10, 2},
  {15, 3},
  {2, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {51, 1},
  {2, 4},
  {7, 1},
  {10, 0},                                                /* End of row 147 */
  {7, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {18, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {10, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {12, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {13, 4},
  {10, 2},
  {15, 3},
  {2, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {52, 1},
  {2, 4},
  {7, 1},
  {9, 0},                                                 /* End of row 148 */
  {6, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {19, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {11, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {11, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {10, 2},
  {30, 3},
  {11, 2},
  {14, 4},
  {54, 1},
  {2, 4},
  {7, 1},
  {8, 0},                                                 /* End of row 149 */
  {5, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {20, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {11, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {11, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {10, 2},
  {30, 3},
  {11, 2},
  {14, 4},
  {55, 1},
  {2, 4},
  {7, 1},
  {7, 0},                                                 /* End of row 150 */
  {4, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {21, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {12, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {10, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {1, 1},
  {10, 2},
  {28, 3},
  {11, 2},
  {14, 4},
  {57, 1},
  {2, 4},
  {7, 1},
  {6, 0},                                                 /* End of row 151 */
  {3, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {22, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {12, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {10, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {1, 1},
  {10, 2},
  {28, 3},
  {11, 2},
  {14, 4},
  {58, 1},
  {2, 4},
  {7, 1},
  {5, 0},                                                 /* End of row 152 */
  {2, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {23, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {13, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {9, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {2, 1},
  {10, 2},
  {26, 3},
  {11, 2},
  {14, 4},
  {60, 1},
  {2, 4},
  {7, 1},
  {4, 0},                                                 /* End of row 153 */
  {1, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {24, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {13, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {9, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {2, 1},
  {10, 2},
  {26, 3},
  {11, 2},
  {14, 4},
  {61, 1},
  {2, 4},
  {7, 1},
  {3, 0},                                                 /* End of row 154 */
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {25, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {8, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {3, 1},
  {10, 2},
  {24, 3},
  {11, 2},
  {14, 4},
  {63, 1},
  {2, 4},
  {7, 1},
  {2, 0},                                                 /* End of row 155 */
  {1, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {26, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {8, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {3, 1},
  {10, 2},
  {24, 3},
  {11, 2},
  {14, 4},
  {64, 1},
  {2, 4},
  {7, 1},
  {1, 0},                                                 /* End of row 156 */
  {5, 1},
  {2, 4},
  {2, 6},
  {27, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {1, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {7, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {4, 1},
  {10, 2},
  {22, 3},
  {11, 2},
  {14, 4},
  {66, 1},
  {2, 4},
  {7, 1},                                                 /* End of row 157 */
  {4, 1},
  {2, 4},
  {2, 6},
  {28, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {1, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {7, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {4, 1},
  {10, 2},
  {22, 3},
  {11, 2},
  {14, 4},
  {67, 1},
  {2, 4},
  {6, 1},                                                 /* End of row 158 */
  {3, 1},
  {2, 4},
  {2, 6},
  {29, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {2, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {6, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {5, 1},
  {10, 2},
  {20, 3},
  {11, 2},
  {14, 4},
  {69, 1},
  {2, 4},
  {5, 1},                                                 /* End of row 159 */
  {3, 1},
  {2, 4},
  {1, 6},
  {30, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {2, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {6, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {5, 1},
  {10, 2},
  {20, 3},
  {11, 2},
  {14, 4},
  {70, 1},
  {2, 4},
  {4, 1},                                                 /* End of row 160 */
  {4, 1},
  {2, 4},
  {30, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {3, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {5, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {5, 1},
  {11, 2},
  {19, 3},
  {10, 2},
  {14, 4},
  {72, 1},
  {3, 4},
  {2, 1},                                                 /* End of row 161 */
  {5, 1},
  {2, 4},
  {29, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {3, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {5, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {5, 1},
  {11, 2},
  {18, 3},
  {11, 2},
  {14, 4},
  {72, 1},
  {3, 4},
  {2, 1},                                                 /* End of row 162 */
  {6, 1},
  {2, 4},
  {28, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {4, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {4, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {4, 1},
  {11, 2},
  {19, 3},
  {10, 2},
  {14, 4},
  {72, 1},
  {2, 4},
  {2, 6},
  {2, 1},                                                 /* End of row 163 */
  {7, 1},
  {2, 4},
  {27, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {4, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {4, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {4, 1},
  {11, 2},
  {18, 3},
  {11, 2},
  {14, 4},
  {71, 1},
  {2, 4},
  {2, 6},
  {3, 1},                                                 /* End of row 164 */
  {8, 1},
  {2, 4},
  {26, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {5, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {3, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {3, 1},
  {11, 2},
  {20, 3},
  {11, 2},
  {13, 4},
  {70, 1},
  {2, 4},
  {2, 6},
  {4, 1},                                                 /* End of row 165 */
  {9, 1},
  {2, 4},
  {25, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {5, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {3, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {3, 1},
  {11, 2},
  {20, 3},
  {11, 2},
  {13, 4},
  {69, 1},
  {2, 4},
  {2, 6},
  {5, 1},                                                 /* End of row 166 */
  {1, 0},
  {9, 1},
  {2, 4},
  {24, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {6, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {2, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {2, 1},
  {11, 2},
  {22, 3},
  {11, 2},
  {13, 4},
  {67, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {1, 0},                                                 /* End of row 167 */
  {2, 0},
  {9, 1},
  {2, 4},
  {23, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {6, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {2, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {2, 1},
  {11, 2},
  {22, 3},
  {11, 2},
  {13, 4},
  {66, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {2, 0},                                                 /* End of row 168 */
  {3, 0},
  {9, 1},
  {2, 4},
  {22, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {7, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {1, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {1, 1},
  {11, 2},
  {24, 3},
  {11, 2},
  {13, 4},
  {64, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {3, 0},                                                 /* End of row 169 */
  {4, 0},
  {9, 1},
  {2, 4},
  {21, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {7, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {1, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {1, 1},
  {11, 2},
  {24, 3},
  {11, 2},
  {13, 4},
  {63, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {4, 0},                                                 /* End of row 170 */
  {5, 0},
  {9, 1},
  {2, 4},
  {20, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {8, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {11, 2},
  {26, 3},
  {11, 2},
  {13, 4},
  {61, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {5, 0},                                                 /* End of row 171 */
  {6, 0},
  {9, 1},
  {2, 4},
  {19, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {8, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {11, 2},
  {26, 3},
  {11, 2},
  {13, 4},
  {60, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {6, 0},                                                 /* End of row 172 */
  {7, 0},
  {9, 1},
  {2, 4},
  {18, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {9, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {11, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {13, 4},
  {11, 2},
  {28, 3},
  {11, 2},
  {13, 4},
  {58, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {7, 0},                                                 /* End of row 173 */
  {8, 0},
  {9, 1},
  {2, 4},
  {17, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {9, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {11, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {13, 4},
  {11, 2},
  {28, 3},
  {11, 2},
  {13, 4},
  {57, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {8, 0},                                                 /* End of row 174 */
  {9, 0},
  {9, 1},
  {2, 4},
  {16, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {10, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {10, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {12, 4},
  {11, 2},
  {30, 3},
  {11, 2},
  {13, 4},
  {55, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {9, 0},                                                 /* End of row 175 */
  {10, 0},
  {9, 1},
  {2, 4},
  {15, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {10, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {10, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {12, 4},
  {11, 2},
  {30, 3},
  {11, 2},
  {13, 4},
  {54, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {10, 0},                                                /* End of row 176 */
  {11, 0},
  {9, 1},
  {2, 4},
  {14, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {11, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {9, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {11, 4},
  {11, 2},
  {32, 3},
  {11, 2},
  {13, 4},
  {52, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {11, 0},                                                /* End of row 177 */
  {12, 0},
  {9, 1},
  {2, 4},
  {13, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {11, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {9, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {11, 4},
  {11, 2},
  {32, 3},
  {11, 2},
  {13, 4},
  {51, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {12, 0},                                                /* End of row 178 */
  {13, 0},
  {9, 1},
  {2, 4},
  {12, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {12, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {8, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {10, 4},
  {11, 2},
  {16, 3},
  {3, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {49, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {13, 0},                                                /* End of row 179 */
  {14, 0},
  {9, 1},
  {2, 4},
  {11, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {12, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {8, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {10, 4},
  {11, 2},
  {16, 3},
  {3, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {48, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {14, 0},                                                /* End of row 180 */
  {15, 0},
  {9, 1},
  {2, 4},
  {10, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {13, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {7, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {9, 4},
  {11, 2},
  {16, 3},
  {5, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {46, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {15, 0},                                                /* End of row 181 */
  {16, 0},
  {9, 1},
  {2, 4},
  {9, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {13, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {7, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {9, 4},
  {11, 2},
  {16, 3},
  {5, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {45, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {16, 0},                                                /* End of row 182 */
  {17, 0},
  {9, 1},
  {2, 4},
  {8, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {14, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {6, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {8, 4},
  {11, 2},
  {16, 3},
  {7, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {43, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {17, 0},                                                /* End of row 183 */
  {18, 0},
  {9, 1},
  {2, 4},
  {7, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {14, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {6, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {8, 4},
  {11, 2},
  {16, 3},
  {7, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {42, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {18, 0},                                                /* End of row 184 */
  {19, 0},
  {9, 1},
  {2, 4},
  {6, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {15, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {5, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {7, 4},
  {11, 2},
  {16, 3},
  {9, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {40, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {19, 0},                                                /* End of row 185 */
  {20, 0},
  {9, 1},
  {2, 4},
  {5, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {15, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {5, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {7, 4},
  {11, 2},
  {16, 3},
  {9, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {39, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {20, 0},                                                /* End of row 186 */
  {21, 0},
  {9, 1},
  {2, 4},
  {4, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {16, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {4, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {6, 4},
  {11, 2},
  {16, 3},
  {11, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {37, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {21, 0},                                                /* End of row 187 */
  {22, 0},
  {9, 1},
  {2, 4},
  {3, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {16, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {4, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {6, 4},
  {11, 2},
  {16, 3},
  {11, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {36, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {22, 0},                                                /* End of row 188 */
  {23, 0},
  {9, 1},
  {2, 4},
  {2, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {17, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {3, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {5, 4},
  {11, 2},
  {16, 3},
  {13, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {34, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {23, 0},                                                /* End of row 189 */
  {24, 0},
  {9, 1},
  {2, 4},
  {1, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {17, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {3, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {5, 4},
  {11, 2},
  {16, 3},
  {13, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {33, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {24, 0},                                                /* End of row 190 */
  {25, 0},
  {9, 1},
  {2, 4},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {18, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {2, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {4, 4},
  {11, 2},
  {16, 3},
  {15, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {31, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {25, 0},                                                /* End of row 191 */
  {26, 0},
  {9, 1},
  {1, 4},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {18, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {2, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {4, 4},
  {11, 2},
  {16, 3},
  {15, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {30, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {26, 0},                                                /* End of row 192 */
  {27, 0},
  {9, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {19, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {1, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {3, 4},
  {11, 2},
  {16, 3},
  {17, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {28, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {27, 0},                                                /* End of row 193 */
  {28, 0},
  {8, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {19, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {1, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {3, 4},
  {11, 2},
  {16, 3},
  {17, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {27, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {28, 0},                                                /* End of row 194 */
  {29, 0},
  {7, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {20, 1},
  {11, 2},
  {14, 3},
  {21, 2},
  {14, 3},
  {8, 2},
  {2, 4},
  {11, 2},
  {16, 3},
  {19, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {25, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {29, 0},                                                /* End of row 195 */
  {30, 0},
  {6, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {20, 1},
  {11, 2},
  {14, 3},
  {21, 2},
  {14, 3},
  {8, 2},
  {2, 4},
  {11, 2},
  {16, 3},
  {19, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {24, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {30, 0},                                                /* End of row 196 */
  {31, 0},
  {5, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {21, 1},
  {11, 2},
  {14, 3},
  {20, 2},
  {14, 3},
  {8, 2},
  {1, 4},
  {11, 2},
  {16, 3},
  {11, 2},
  {1, 4},
  {9, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {22, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {31, 0},                                                /* End of row 197 */
  {32, 0},
  {4, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {21, 1},
  {11, 2},
  {14, 3},
  {20, 2},
  {14, 3},
  {8, 2},
  {1, 4},
  {11, 2},
  {16, 3},
  {11, 2},
  {1, 4},
  {9, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {21, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {32, 0},                                                /* End of row 198 */
  {33, 0},
  {3, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {22, 1},
  {11, 2},
  {14, 3},
  {19, 2},
  {14, 3},
  {19, 2},
  {16, 3},
  {11, 2},
  {3, 4},
  {9, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {19, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {33, 0},                                                /* End of row 199 */
  {34, 0},
  {2, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {22, 1},
  {11, 2},
  {14, 3},
  {19, 2},
  {14, 3},
  {19, 2},
  {16, 3},
  {11, 2},
  {3, 4},
  {9, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {18, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {34, 0},                                                /* End of row 200 */
  {35, 0},
  {1, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {23, 1},
  {11, 2},
  {14, 3},
  {18, 2},
  {14, 3},
  {18, 2},
  {16, 3},
  {11, 2},
  {5, 4},
  {9, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {16, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {35, 0},                                                /* End of row 201 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {23, 1},
  {11, 2},
  {14, 3},
  {18, 2},
  {14, 3},
  {18, 2},
  {16, 3},
  {11, 2},
  {5, 4},
  {9, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {15, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {36, 0},                                                /* End of row 202 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {24, 1},
  {11, 2},
  {14, 3},
  {17, 2},
  {14, 3},
  {17, 2},
  {16, 3},
  {11, 2},
  {7, 4},
  {9, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {13, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {37, 0},                                                /* End of row 203 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {24, 1},
  {11, 2},
  {14, 3},
  {17, 2},
  {14, 3},
  {17, 2},
  {16, 3},
  {11, 2},
  {7, 4},
  {9, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {12, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {38, 0},                                                /* End of row 204 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {25, 1},
  {11, 2},
  {14, 3},
  {16, 2},
  {14, 3},
  {16, 2},
  {16, 3},
  {11, 2},
  {9, 4},
  {9, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {10, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {39, 0},                                                /* End of row 205 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {25, 1},
  {11, 2},
  {14, 3},
  {16, 2},
  {14, 3},
  {16, 2},
  {16, 3},
  {11, 2},
  {9, 4},
  {9, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {9, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {40, 0},                                                /* End of row 206 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {26, 1},
  {11, 2},
  {14, 3},
  {15, 2},
  {14, 3},
  {15, 2},
  {16, 3},
  {11, 2},
  {11, 4},
  {9, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {7, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {41, 0},                                                /* End of row 207 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {26, 1},
  {11, 2},
  {14, 3},
  {15, 2},
  {14, 3},
  {15, 2},
  {16, 3},
  {11, 2},
  {11, 4},
  {9, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {6, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {42, 0},                                                /* End of row 208 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {27, 1},
  {11, 2},
  {14, 3},
  {14, 2},
  {14, 3},
  {14, 2},
  {16, 3},
  {11, 2},
  {13, 4},
  {9, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {4, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {43, 0},                                                /* End of row 209 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {27, 1},
  {11, 2},
  {14, 3},
  {14, 2},
  {14, 3},
  {14, 2},
  {16, 3},
  {11, 2},
  {13, 4},
  {9, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {3, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {44, 0},                                                /* End of row 210 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {28, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {14, 3},
  {13, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {9, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {1, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {45, 0},                                                /* End of row 211 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {28, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {14, 3},
  {13, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {9, 2},
  {15, 3},
  {11, 2},
  {15, 4},
  {2, 6},
  {5, 1},
  {46, 0},                                                /* End of row 212 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {29, 1},
  {11, 2},
  {14, 3},
  {12, 2},
  {14, 3},
  {12, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {2, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {2, 6},
  {5, 1},
  {47, 0},                                                /* End of row 213 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {29, 1},
  {11, 2},
  {14, 3},
  {12, 2},
  {14, 3},
  {12, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {2, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {5, 1},
  {48, 0},                                                /* End of row 214 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {30, 1},
  {11, 2},
  {14, 3},
  {11, 2},
  {14, 3},
  {11, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {4, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {3, 1},
  {49, 0},                                                /* End of row 215 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {30, 1},
  {11, 2},
  {14, 3},
  {11, 2},
  {14, 3},
  {11, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {4, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {2, 1},
  {50, 0},                                                /* End of row 216 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {31, 1},
  {11, 2},
  {14, 3},
  {10, 2},
  {14, 3},
  {10, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {6, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {1, 5},
  {1, 1},
  {51, 0},                                                /* End of row 217 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {31, 1},
  {11, 2},
  {14, 3},
  {10, 2},
  {14, 3},
  {10, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {6, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {11, 4},
  {3, 5},
  {51, 0},                                                /* End of row 218 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {32, 1},
  {11, 2},
  {14, 3},
  {9, 2},
  {14, 3},
  {9, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {8, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {9, 4},
  {5, 5},
  {50, 0},                                                /* End of row 219 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {32, 1},
  {11, 2},
  {14, 3},
  {9, 2},
  {14, 3},
  {9, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {8, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {8, 4},
  {6, 5},
  {50, 0},                                                /* End of row 220 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {33, 1},
  {11, 2},
  {14, 3},
  {8, 2},
  {14, 3},
  {8, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {10, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {6, 4},
  {8, 5},
  {49, 0},                                                /* End of row 221 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {33, 1},
  {11, 2},
  {14, 3},
  {8, 2},
  {14, 3},
  {8, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {10, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {5, 4},
  {9, 5},
  {49, 0},                                                /* End of row 222 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {34, 1},
  {11, 2},
  {14, 3},
  {7, 2},
  {14, 3},
  {7, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {12, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {3, 4},
  {11, 5},
  {48, 0},                                                /* End of row 223 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {34, 1},
  {11, 2},
  {14, 3},
  {7, 2},
  {14, 3},
  {7, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {12, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {2, 4},
  {12, 5},
  {48, 0},                                                /* End of row 224 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {35, 1},
  {11, 2},
  {14, 3},
  {6, 2},
  {14, 3},
  {6, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {14, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {47, 0},                                                /* End of row 225 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {35, 1},
  {11, 2},
  {14, 3},
  {6, 2},
  {14, 3},
  {6, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {14, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {47, 0},                                                /* End of row 226 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {36, 1},
  {11, 2},
  {14, 3},
  {5, 2},
  {14, 3},
  {5, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {16, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {46, 0},                                                /* End of row 227 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {36, 1},
  {11, 2},
  {14, 3},
  {5, 2},
  {14, 3},
  {5, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {16, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {46, 0},                                                /* End of row 228 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {37, 1},
  {11, 2},
  {14, 3},
  {4, 2},
  {14, 3},
  {4, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {18, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {45, 0},                                                /* End of row 229 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {37, 1},
  {11, 2},
  {14, 3},
  {4, 2},
  {14, 3},
  {4, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {18, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {45, 0},                                                /* End of row 230 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {38, 1},
  {11, 2},
  {14, 3},
  {3, 2},
  {14, 3},
  {3, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {20, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {44, 0},                                                /* End of row 231 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {38, 1},
  {11, 2},
  {14, 3},
  {3, 2},
  {14, 3},
  {3, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {20, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {44, 0},                                                /* End of row 232 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {39, 1},
  {11, 2},
  {14, 3},
  {2, 2},
  {14, 3},
  {2, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {22, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {43, 0},                                                /* End of row 233 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {39, 1},
  {11, 2},
  {14, 3},
  {2, 2},
  {14, 3},
  {2, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {22, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {43, 0},                                                /* End of row 234 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {1, 5},
  {13, 4},
  {40, 1},
  {11, 2},
  {14, 3},
  {1, 2},
  {14, 3},
  {1, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {24, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {42, 0},                                                /* End of row 235 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {2, 5},
  {12, 4},
  {40, 1},
  {11, 2},
  {14, 3},
  {1, 2},
  {14, 3},
  {1, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {24, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {42, 0},                                                /* End of row 236 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {3, 5},
  {11, 4},
  {41, 1},
  {11, 2},
  {44, 3},
  {11, 2},
  {15, 4},
  {26, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {41, 0},                                                /* End of row 237 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {4, 5},
  {11, 4},
  {40, 1},
  {11, 2},
  {44, 3},
  {11, 2},
  {15, 4},
  {26, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {41, 0},                                                /* End of row 238 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {5, 5},
  {11, 4},
  {40, 1},
  {11, 2},
  {42, 3},
  {11, 2},
  {15, 4},
  {28, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {40, 0},                                                /* End of row 239 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {6, 5},
  {8, 4},
  {1, 1},
  {2, 4},
  {39, 1},
  {11, 2},
  {42, 3},
  {11, 2},
  {15, 4},
  {28, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {40, 0},                                                /* End of row 240 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {7, 5},
  {7, 4},
  {2, 1},
  {2, 4},
  {39, 1},
  {11, 2},
  {40, 3},
  {11, 2},
  {15, 4},
  {30, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {39, 0},                                                /* End of row 241 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {8, 5},
  {6, 4},
  {3, 1},
  {2, 4},
  {38, 1},
  {11, 2},
  {40, 3},
  {11, 2},
  {15, 4},
  {29, 1},
  {1, 4},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {39, 0},                                                /* End of row 242 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {9, 5},
  {5, 4},
  {4, 1},
  {2, 4},
  {38, 1},
  {11, 2},
  {38, 3},
  {11, 2},
  {15, 4},
  {29, 1},
  {2, 4},
  {1, 6},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {38, 0},                                                /* End of row 243 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {10, 5},
  {4, 4},
  {5, 1},
  {2, 4},
  {37, 1},
  {11, 2},
  {38, 3},
  {11, 2},
  {15, 4},
  {28, 1},
  {2, 4},
  {2, 6},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {38, 0},                                                /* End of row 244 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {11, 5},
  {3, 4},
  {6, 1},
  {2, 4},
  {37, 1},
  {11, 2},
  {36, 3},
  {11, 2},
  {15, 4},
  {28, 1},
  {2, 4},
  {2, 6},
  {2, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {37, 0},                                                /* End of row 245 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {12, 5},
  {2, 4},
  {7, 1},
  {2, 4},
  {36, 1},
  {11, 2},
  {36, 3},
  {11, 2},
  {15, 4},
  {27, 1},
  {2, 4},
  {2, 6},
  {3, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {37, 0},                                                /* End of row 246 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {13, 5},
  {1, 4},
  {8, 1},
  {2, 4},
  {36, 1},
  {11, 2},
  {34, 3},
  {11, 2},
  {15, 4},
  {27, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {36, 0},                                                /* End of row 247 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {9, 1},
  {2, 4},
  {35, 1},
  {11, 2},
  {34, 3},
  {11, 2},
  {15, 4},
  {26, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {1, 0},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {36, 0},                                                /* End of row 248 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {1, 0},
  {9, 1},
  {2, 4},
  {35, 1},
  {11, 2},
  {32, 3},
  {11, 2},
  {15, 4},
  {26, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {2, 0},
  {10, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {35, 0},                                                /* End of row 249 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {2, 0},
  {9, 1},
  {2, 4},
  {34, 1},
  {11, 2},
  {32, 3},
  {11, 2},
  {15, 4},
  {25, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {4, 0},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {35, 0},                                                /* End of row 250 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {3, 0},
  {9, 1},
  {2, 4},
  {34, 1},
  {11, 2},
  {30, 3},
  {11, 2},
  {15, 4},
  {25, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {6, 0},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {34, 0},                                                /* End of row 251 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {4, 0},
  {9, 1},
  {2, 4},
  {33, 1},
  {11, 2},
  {30, 3},
  {11, 2},
  {15, 4},
  {24, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {7, 0},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {34, 0},                                                /* End of row 252 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {5, 0},
  {9, 1},
  {2, 4},
  {33, 1},
  {11, 2},
  {28, 3},
  {11, 2},
  {15, 4},
  {24, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {9, 0},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {33, 0},                                                /* End of row 253 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {6, 0},
  {9, 1},
  {2, 4},
  {32, 1},
  {11, 2},
  {28, 3},
  {11, 2},
  {15, 4},
  {23, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {10, 0},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {33, 0},                                                /* End of row 254 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {7, 0},
  {9, 1},
  {2, 4},
  {32, 1},
  {11, 2},
  {26, 3},
  {11, 2},
  {15, 4},
  {23, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {12, 0},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {32, 0},                                                /* End of row 255 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {8, 0},
  {9, 1},
  {2, 4},
  {31, 1},
  {11, 2},
  {26, 3},
  {11, 2},
  {15, 4},
  {22, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {13, 0},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {32, 0},                                                /* End of row 256 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {9, 0},
  {9, 1},
  {2, 4},
  {31, 1},
  {11, 2},
  {24, 3},
  {11, 2},
  {15, 4},
  {22, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {15, 0},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {31, 0},                                                /* End of row 257 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {10, 0},
  {9, 1},
  {2, 4},
  {30, 1},
  {11, 2},
  {24, 3},
  {11, 2},
  {15, 4},
  {21, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {16, 0},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {31, 0},                                                /* End of row 258 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {11, 0},
  {9, 1},
  {2, 4},
  {30, 1},
  {11, 2},
  {22, 3},
  {11, 2},
  {15, 4},
  {21, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {18, 0},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {30, 0},                                                /* End of row 259 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {12, 0},
  {9, 1},
  {2, 4},
  {29, 1},
  {11, 2},
  {22, 3},
  {11, 2},
  {15, 4},
  {20, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {19, 0},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {30, 0},                                                /* End of row 260 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {13, 0},
  {9, 1},
  {2, 4},
  {29, 1},
  {11, 2},
  {20, 3},
  {11, 2},
  {15, 4},
  {20, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {21, 0},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {29, 0},                                                /* End of row 261 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {14, 0},
  {9, 1},
  {2, 4},
  {28, 1},
  {11, 2},
  {20, 3},
  {11, 2},
  {15, 4},
  {19, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {22, 0},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {29, 0},                                                /* End of row 262 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {15, 0},
  {9, 1},
  {2, 4},
  {28, 1},
  {11, 2},
  {18, 3},
  {11, 2},
  {15, 4},
  {19, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {24, 0},
  {9, 2},
  {15, 3},
  {10, 2},
  {14, 5},
  {29, 0},                                                /* End of row 263 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {16, 0},
  {9, 1},
  {2, 4},
  {27, 1},
  {11, 2},
  {18, 3},
  {11, 2},
  {15, 4},
  {18, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {25, 0},
  {9, 2},
  {15, 3},
  {10, 2},
  {14, 5},
  {29, 0},                                                /* End of row 264 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {17, 0},
  {9, 1},
  {2, 4},
  {27, 1},
  {11, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {18, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {27, 0},
  {9, 2},
  {14, 3},
  {10, 2},
  {15, 5},
  {28, 0},                                                /* End of row 265 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {18, 0},
  {9, 1},
  {2, 4},
  {26, 1},
  {11, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {17, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {28, 0},
  {9, 2},
  {14, 3},
  {10, 2},
  {15, 5},
  {28, 0},                                                /* End of row 266 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {19, 0},
  {9, 1},
  {2, 4},
  {26, 1},
  {11, 2},
  {14, 3},
  {11, 2},
  {15, 4},
  {17, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {30, 0},
  {9, 2},
  {13, 3},
  {10, 2},
  {16, 5},
  {27, 0},                                                /* End of row 267 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {20, 0},
  {9, 1},
  {2, 4},
  {25, 1},
  {11, 2},
  {14, 3},
  {11, 2},
  {15, 4},
  {16, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {31, 0},
  {9, 2},
  {13, 3},
  {9, 2},
  {17, 5},
  {27, 0},                                                /* End of row 268 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {21, 0},
  {9, 1},
  {2, 4},
  {25, 1},
  {11, 2},
  {12, 3},
  {11, 2},
  {15, 4},
  {16, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {33, 0},
  {9, 2},
  {11, 3},
  {10, 2},
  {17, 5},
  {27, 0},                                                /* End of row 269 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {22, 0},
  {9, 1},
  {2, 4},
  {24, 1},
  {12, 2},
  {10, 3},
  {12, 2},
  {15, 4},
  {15, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {34, 0},
  {9, 2},
  {11, 3},
  {10, 2},
  {17, 5},
  {27, 0},                                                /* End of row 270 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {23, 0},
  {9, 1},
  {2, 4},
  {24, 1},
  {12, 2},
  {8, 3},
  {12, 2},
  {15, 4},
  {15, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {36, 0},
  {9, 2},
  {8, 3},
  {11, 2},
  {18, 5},
  {27, 0},                                                /* End of row 271 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {24, 0},
  {9, 1},
  {2, 4},
  {23, 1},
  {14, 2},
  {4, 3},
  {14, 2},
  {15, 4},
  {14, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {37, 0},
  {11, 2},
  {4, 3},
  {13, 2},
  {18, 5},
  {27, 0},                                                /* End of row 272 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {25, 0},
  {9, 1},
  {2, 4},
  {23, 1},
  {30, 2},
  {15, 4},
  {14, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {39, 0},
  {26, 2},
  {19, 5},
  {27, 0},                                                /* End of row 273 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {26, 0},
  {9, 1},
  {2, 4},
  {22, 1},
  {30, 2},
  {15, 4},
  {13, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {40, 0},
  {26, 2},
  {18, 5},
  {28, 0},                                                /* End of row 274 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {27, 0},
  {9, 1},
  {2, 4},
  {22, 1},
  {28, 2},
  {15, 4},
  {13, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {42, 0},
  {24, 2},
  {19, 5},
  {28, 0},                                                /* End of row 275 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {28, 0},
  {9, 1},
  {2, 4},
  {21, 1},
  {28, 2},
  {15, 4},
  {12, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {43, 0},
  {23, 2},
  {20, 5},
  {28, 0},                                                /* End of row 276 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {29, 0},
  {9, 1},
  {2, 4},
  {21, 1},
  {26, 2},
  {15, 4},
  {12, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {45, 0},
  {21, 2},
  {20, 5},
  {29, 0},                                                /* End of row 277 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {30, 0},
  {9, 1},
  {2, 4},
  {20, 1},
  {26, 2},
  {15, 4},
  {11, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {46, 0},
  {20, 2},
  {21, 5},
  {29, 0},                                                /* End of row 278 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {31, 0},
  {9, 1},
  {2, 4},
  {20, 1},
  {24, 2},
  {15, 4},
  {11, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {48, 0},
  {18, 2},
  {21, 5},
  {30, 0},                                                /* End of row 279 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {32, 0},
  {9, 1},
  {2, 4},
  {20, 1},
  {22, 2},
  {16, 4},
  {10, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {51, 0},
  {14, 2},
  {23, 5},
  {30, 0},                                                /* End of row 280 */
  {50, 0},
  {32, 5},
  {33, 0},
  {9, 1},
  {2, 4},
  {20, 1},
  {20, 2},
  {16, 4},
  {10, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {55, 0},
  {8, 2},
  {25, 5},
  {31, 0},                                                /* End of row 281 */
  {50, 0},
  {32, 5},
  {34, 0},
  {9, 1},
  {2, 4},
  {21, 1},
  {16, 2},
  {18, 4},
  {9, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {61, 0},
  {28, 5},
  {31, 0},                                                /* End of row 282 */
  {50, 0},
  {32, 5},
  {35, 0},
  {9, 1},
  {2, 4},
  {22, 1},
  {12, 2},
  {19, 4},
  {9, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {62, 0},
  {27, 5},
  {32, 0},                                                /* End of row 283 */
  {50, 0},
  {32, 5},
  {36, 0},
  {9, 1},
  {2, 4},
  {23, 1},
  {8, 2},
  {20, 4},
  {9, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {64, 0},
  {26, 5},
  {32, 0},                                                /* End of row 284 */
  {50, 0},
  {32, 5},
  {37, 0},
  {9, 1},
  {2, 4},
  {24, 1},
  {25, 4},
  {9, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {66, 0},
  {23, 5},
  {34, 0},                                                /* End of row 285 */
  {50, 0},
  {32, 5},
  {38, 0},
  {9, 1},
  {2, 4},
  {25, 1},
  {21, 4},
  {10, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {67, 0},
  {23, 5},
  {34, 0},                                                /* End of row 286 */
  {50, 0},
  {32, 5},
  {39, 0},
  {9, 1},
  {2, 4},
  {26, 1},
  {17, 4},
  {11, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {69, 0},
  {20, 5},
  {36, 0},                                                /* End of row 287 */
  {50, 0},
  {32, 5},
  {40, 0},
  {9, 1},
  {2, 4},
  {27, 1},
  {13, 4},
  {12, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {70, 0},
  {20, 5},
  {36, 0},                                                /* End of row 288 */
  {50, 0},
  {32, 5},
  {41, 0},
  {9, 1},
  {2, 4},
  {50, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {72, 0},
  {17, 5},
  {38, 0},                                                /* End of row 289 */
  {50, 0},
  {32, 5},
  {42, 0},
  {9, 1},
  {2, 4},
  {48, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {74, 0},
  {14, 5},
  {40, 0},                                                /* End of row 290 */
  {50, 0},
  {32, 5},
  {43, 0},
  {9, 1},
  {2, 4},
  {46, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {129, 0},                                               /* End of row 291 */
  {50, 0},
  {32, 5},
  {44, 0},
  {9, 1},
  {2, 4},
  {44, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {130, 0},                                               /* End of row 292 */
  {50, 0},
  {32, 5},
  {45, 0},
  {9, 1},
  {2, 4},
  {42, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {131, 0},                                               /* End of row 293 */
  {50, 0},
  {32, 5},
  {46, 0},
  {9, 1},
  {2, 4},
  {40, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {132, 0},                                               /* End of row 294 */
  {129, 0},
  {9, 1},
  {2, 4},
  {38, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {133, 0},                                               /* End of row 295 */
  {130, 0},
  {9, 1},
  {2, 4},
  {36, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {134, 0},                                               /* End of row 296 */
  {131, 0},
  {9, 1},
  {2, 4},
  {34, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {135, 0},                                               /* End of row 297 */
  {132, 0},
  {9, 1},
  {2, 4},
  {32, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {136, 0},                                               /* End of row 298 */
  {133, 0},
  {9, 1},
  {2, 4},
  {30, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {137, 0},                                               /* End of row 299 */
  {134, 0},
  {9, 1},
  {2, 4},
  {28, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {138, 0},                                               /* End of row 300 */
  {135, 0},
  {9, 1},
  {2, 4},
  {26, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {139, 0},                                               /* End of row 301 */
  {136, 0},
  {9, 1},
  {2, 4},
  {24, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {140, 0},                                               /* End of row 302 */
  {137, 0},
  {9, 1},
  {2, 4},
  {22, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {141, 0},                                               /* End of row 303 */
  {138, 0},
  {9, 1},
  {2, 4},
  {20, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {142, 0},                                               /* End of row 304 */
  {139, 0},
  {9, 1},
  {2, 4},
  {18, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {143, 0},                                               /* End of row 305 */
  {140, 0},
  {9, 1},
  {2, 4},
  {16, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {144, 0},                                               /* End of row 306 */
  {141, 0},
  {9, 1},
  {2, 4},
  {14, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {145, 0},                                               /* End of row 307 */
  {142, 0},
  {9, 1},
  {2, 4},
  {12, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {146, 0},                                               /* End of row 308 */
  {143, 0},
  {9, 1},
  {2, 4},
  {10, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {147, 0},                                               /* End of row 309 */
  {144, 0},
  {9, 1},
  {2, 4},
  {8, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {148, 0},                                               /* End of row 310 */
  {145, 0},
  {9, 1},
  {2, 4},
  {6, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {149, 0},                                               /* End of row 311 */
  {146, 0},
  {9, 1},
  {2, 4},
  {4, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {150, 0},                                               /* End of row 312 */
  {147, 0},
  {9, 1},
  {2, 4},
  {2, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {151, 0},                                               /* End of row 313 */
  {148, 0},
  {9, 1},
  {4, 4},
  {2, 6},
  {5, 1},
  {152, 0},                                               /* End of row 314 */
  {149, 0},
  {9, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {153, 0},                                               /* End of row 315 */
  {150, 0},
  {9, 1},
  {2, 6},
  {5, 1},
  {154, 0},                                               /* End of row 316 */
  {151, 0},
  {7, 1},
  {2, 6},
  {5, 1},
  {155, 0},                                               /* End of row 317 */
  {152, 0},
  {12, 1},
  {156, 0},                                               /* End of row 318 */
  {153, 0},
  {10, 1},
  {157, 0},                                               /* End of row 319 */
  {154, 0},
  {8, 1},
  {158, 0},                                               /* End of row 320 */
};
#endif /* CONFIG_VIDEO_FB_SPLASHSCREEN_BPP32 */

#if defined(CONFIG_VIDEO_FB_SPLASHSCREEN_BPP24) || \
    defined(CONFIG_VIDEO_FB_SPLASHSCREEN_BPP16)
static const struct splscr_bitmap_s bitmap[] =
{
  {154, 0},
  {2, 6},
  {10, 1},
  {154, 0},                                               /* End of row   1 */
  {153, 0},
  {2, 6},
  {12, 1},
  {153, 0},                                               /* End of row   2 */
  {152, 0},
  {2, 6},
  {14, 1},
  {152, 0},                                               /* End of row   3 */
  {151, 0},
  {2, 6},
  {16, 1},
  {151, 0},                                               /* End of row   4 */
  {150, 0},
  {2, 6},
  {6, 1},
  {3, 4},
  {9, 1},
  {150, 0},                                               /* End of row   5 */
  {149, 0},
  {2, 6},
  {6, 1},
  {5, 4},
  {9, 1},
  {149, 0},                                               /* End of row   6 */
  {148, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {3, 6},
  {2, 4},
  {9, 1},
  {148, 0},                                               /* End of row   7 */
  {147, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {3, 1},
  {2, 4},
  {9, 1},
  {147, 0},                                               /* End of row   8 */
  {146, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {2, 4},
  {9, 1},
  {146, 0},                                               /* End of row   9 */
  {145, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {7, 1},
  {2, 4},
  {9, 1},
  {145, 0},                                               /* End of row  10 */
  {144, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {9, 1},
  {2, 4},
  {9, 1},
  {144, 0},                                               /* End of row  11 */
  {143, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {11, 1},
  {2, 4},
  {9, 1},
  {143, 0},                                               /* End of row  12 */
  {142, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {13, 1},
  {2, 4},
  {9, 1},
  {142, 0},                                               /* End of row  13 */
  {141, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {15, 1},
  {2, 4},
  {9, 1},
  {141, 0},                                               /* End of row  14 */
  {140, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {17, 1},
  {2, 4},
  {9, 1},
  {140, 0},                                               /* End of row  15 */
  {139, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {19, 1},
  {2, 4},
  {9, 1},
  {139, 0},                                               /* End of row  16 */
  {138, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {21, 1},
  {2, 4},
  {9, 1},
  {138, 0},                                               /* End of row  17 */
  {137, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {23, 1},
  {2, 4},
  {9, 1},
  {137, 0},                                               /* End of row  18 */
  {136, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {25, 1},
  {2, 4},
  {9, 1},
  {136, 0},                                               /* End of row  19 */
  {135, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {27, 1},
  {2, 4},
  {9, 1},
  {135, 0},                                               /* End of row  20 */
  {134, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {29, 1},
  {2, 4},
  {9, 1},
  {134, 0},                                               /* End of row  21 */
  {133, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {31, 1},
  {2, 4},
  {9, 1},
  {133, 0},                                               /* End of row  22 */
  {132, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {33, 1},
  {2, 4},
  {9, 1},
  {132, 0},                                               /* End of row  23 */
  {131, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {35, 1},
  {2, 4},
  {9, 1},
  {131, 0},                                               /* End of row  24 */
  {130, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {37, 1},
  {2, 4},
  {9, 1},
  {130, 0},                                               /* End of row  25 */
  {129, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {39, 1},
  {2, 4},
  {9, 1},
  {129, 0},                                               /* End of row  26 */
  {128, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {41, 1},
  {2, 4},
  {9, 1},
  {128, 0},                                               /* End of row  27 */
  {127, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {43, 1},
  {2, 4},
  {9, 1},
  {127, 0},                                               /* End of row  28 */
  {126, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {45, 1},
  {2, 4},
  {9, 1},
  {126, 0},                                               /* End of row  29 */
  {125, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {47, 1},
  {2, 4},
  {9, 1},
  {125, 0},                                               /* End of row  30 */
  {124, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {49, 1},
  {2, 4},
  {9, 1},
  {124, 0},                                               /* End of row  31 */
  {123, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {51, 1},
  {2, 4},
  {9, 1},
  {123, 0},                                               /* End of row  32 */
  {122, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {53, 1},
  {2, 4},
  {9, 1},
  {122, 0},                                               /* End of row  33 */
  {121, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {55, 1},
  {2, 4},
  {9, 1},
  {121, 0},                                               /* End of row  34 */
  {120, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {57, 1},
  {2, 4},
  {9, 1},
  {120, 0},                                               /* End of row  35 */
  {119, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {59, 1},
  {2, 4},
  {9, 1},
  {119, 0},                                               /* End of row  36 */
  {118, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {61, 1},
  {2, 4},
  {9, 1},
  {56, 0},
  {10, 2},
  {52, 0},                                                /* End of row  37 */
  {117, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {63, 1},
  {2, 4},
  {9, 1},
  {53, 0},
  {14, 2},
  {50, 0},                                                /* End of row  38 */
  {116, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {65, 1},
  {2, 4},
  {9, 1},
  {50, 0},
  {18, 2},
  {48, 0},                                                /* End of row  39 */
  {115, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {67, 1},
  {2, 4},
  {9, 1},
  {48, 0},
  {20, 2},
  {47, 0},                                                /* End of row  40 */
  {114, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {24, 1},
  {10, 2},
  {35, 1},
  {2, 4},
  {9, 1},
  {46, 0},
  {22, 2},
  {46, 0},                                                /* End of row  41 */
  {113, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {23, 1},
  {14, 2},
  {34, 1},
  {2, 4},
  {9, 1},
  {45, 0},
  {23, 2},
  {45, 0},                                                /* End of row  42 */
  {48, 0},
  {11, 2},
  {53, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {23, 1},
  {17, 2},
  {33, 1},
  {2, 4},
  {9, 1},
  {43, 0},
  {25, 2},
  {44, 0},                                                /* End of row  43 */
  {46, 0},
  {14, 2},
  {51, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {23, 1},
  {19, 2},
  {33, 1},
  {2, 4},
  {9, 1},
  {42, 0},
  {26, 2},
  {43, 0},                                                /* End of row  44 */
  {44, 0},
  {18, 2},
  {48, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {23, 1},
  {21, 2},
  {33, 1},
  {2, 4},
  {9, 1},
  {40, 0},
  {28, 2},
  {42, 0},                                                /* End of row  45 */
  {43, 0},
  {20, 2},
  {46, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {23, 1},
  {23, 2},
  {33, 1},
  {2, 4},
  {9, 1},
  {39, 0},
  {28, 2},
  {42, 0},                                                /* End of row  46 */
  {42, 0},
  {22, 2},
  {44, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {23, 1},
  {25, 2},
  {8, 4},
  {25, 1},
  {2, 4},
  {9, 1},
  {37, 0},
  {30, 2},
  {41, 0},                                                /* End of row  47 */
  {42, 0},
  {23, 2},
  {42, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {24, 1},
  {26, 2},
  {9, 4},
  {24, 1},
  {2, 4},
  {9, 1},
  {36, 0},
  {14, 2},
  {2, 3},
  {14, 2},
  {41, 0},                                                /* End of row  48 */
  {41, 0},
  {25, 2},
  {1, 0},
  {9, 5},
  {30, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {24, 1},
  {28, 2},
  {9, 4},
  {24, 1},
  {2, 4},
  {9, 1},
  {34, 0},
  {12, 2},
  {8, 3},
  {12, 2},
  {2, 5},
  {38, 0},                                                /* End of row  49 */
  {40, 0},
  {27, 2},
  {11, 5},
  {27, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {25, 1},
  {28, 2},
  {10, 4},
  {24, 1},
  {2, 4},
  {9, 1},
  {33, 0},
  {11, 2},
  {10, 3},
  {11, 2},
  {3, 5},
  {37, 0},                                                /* End of row  50 */
  {39, 0},
  {29, 2},
  {12, 5},
  {24, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {25, 1},
  {11, 2},
  {6, 3},
  {13, 2},
  {10, 4},
  {24, 1},
  {2, 4},
  {9, 1},
  {31, 0},
  {11, 2},
  {12, 3},
  {11, 2},
  {3, 5},
  {36, 0},                                                /* End of row  51 */
  {39, 0},
  {29, 2},
  {12, 5},
  {23, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {26, 1},
  {10, 2},
  {8, 3},
  {12, 2},
  {11, 4},
  {24, 1},
  {2, 4},
  {9, 1},
  {30, 0},
  {11, 2},
  {12, 3},
  {11, 2},
  {4, 5},
  {35, 0},                                                /* End of row  52 */
  {38, 0},
  {31, 2},
  {12, 5},
  {21, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {27, 1},
  {10, 2},
  {9, 3},
  {12, 2},
  {11, 4},
  {24, 1},
  {2, 4},
  {9, 1},
  {28, 0},
  {11, 2},
  {14, 3},
  {10, 2},
  {5, 5},
  {34, 0},                                                /* End of row  53 */
  {38, 0},
  {12, 2},
  {5, 3},
  {14, 2},
  {12, 5},
  {20, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {27, 1},
  {10, 2},
  {11, 3},
  {11, 2},
  {12, 4},
  {24, 1},
  {2, 4},
  {9, 1},
  {27, 0},
  {11, 2},
  {14, 3},
  {10, 2},
  {6, 5},
  {33, 0},                                                /* End of row  54 */
  {37, 0},
  {11, 2},
  {8, 3},
  {14, 2},
  {12, 5},
  {18, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {28, 1},
  {10, 2},
  {12, 3},
  {11, 2},
  {12, 4},
  {24, 1},
  {2, 4},
  {9, 1},
  {25, 0},
  {11, 2},
  {15, 3},
  {10, 2},
  {7, 5},
  {32, 0},                                                /* End of row  55 */
  {37, 0},
  {10, 2},
  {10, 3},
  {13, 2},
  {12, 5},
  {17, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {29, 1},
  {9, 2},
  {13, 3},
  {11, 2},
  {12, 4},
  {25, 1},
  {2, 4},
  {9, 1},
  {24, 0},
  {11, 2},
  {15, 3},
  {10, 2},
  {7, 5},
  {32, 0},                                                /* End of row  56 */
  {36, 0},
  {10, 2},
  {11, 3},
  {14, 2},
  {12, 5},
  {15, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {30, 1},
  {9, 2},
  {14, 3},
  {11, 2},
  {12, 4},
  {25, 1},
  {2, 4},
  {9, 1},
  {22, 0},
  {11, 2},
  {15, 3},
  {11, 2},
  {8, 5},
  {31, 0},                                                /* End of row  57 */
  {36, 0},
  {10, 2},
  {12, 3},
  {13, 2},
  {12, 5},
  {14, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {31, 1},
  {9, 2},
  {14, 3},
  {11, 2},
  {12, 4},
  {26, 1},
  {2, 4},
  {9, 1},
  {21, 0},
  {11, 2},
  {15, 3},
  {11, 2},
  {8, 5},
  {31, 0},                                                /* End of row  58 */
  {36, 0},
  {9, 2},
  {14, 3},
  {13, 2},
  {12, 5},
  {12, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {32, 1},
  {8, 2},
  {16, 3},
  {11, 2},
  {12, 4},
  {26, 1},
  {2, 4},
  {9, 1},
  {19, 0},
  {11, 2},
  {15, 3},
  {11, 2},
  {10, 5},
  {30, 0},                                                /* End of row  59 */
  {36, 0},
  {9, 2},
  {14, 3},
  {13, 2},
  {12, 5},
  {11, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {33, 1},
  {8, 2},
  {16, 3},
  {11, 2},
  {12, 4},
  {27, 1},
  {2, 4},
  {9, 1},
  {18, 0},
  {11, 2},
  {15, 3},
  {11, 2},
  {10, 5},
  {30, 0},                                                /* End of row  60 */
  {36, 0},
  {8, 2},
  {16, 3},
  {13, 2},
  {12, 5},
  {9, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {34, 1},
  {8, 2},
  {17, 3},
  {11, 2},
  {12, 4},
  {27, 1},
  {2, 4},
  {9, 1},
  {16, 0},
  {11, 2},
  {15, 3},
  {11, 2},
  {11, 5},
  {30, 0},                                                /* End of row  61 */
  {36, 0},
  {8, 2},
  {16, 3},
  {13, 2},
  {12, 5},
  {8, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {35, 1},
  {8, 2},
  {17, 3},
  {11, 2},
  {12, 4},
  {28, 1},
  {2, 4},
  {9, 1},
  {15, 0},
  {11, 2},
  {15, 3},
  {11, 2},
  {12, 5},
  {29, 0},                                                /* End of row  62 */
  {36, 0},
  {8, 2},
  {17, 3},
  {13, 2},
  {12, 5},
  {6, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {36, 1},
  {8, 2},
  {18, 3},
  {11, 2},
  {12, 4},
  {28, 1},
  {2, 4},
  {9, 1},
  {13, 0},
  {11, 2},
  {15, 3},
  {11, 2},
  {13, 5},
  {29, 0},                                                /* End of row  63 */
  {36, 0},
  {8, 2},
  {17, 3},
  {13, 2},
  {12, 5},
  {5, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {37, 1},
  {8, 2},
  {18, 3},
  {11, 2},
  {12, 4},
  {29, 1},
  {2, 4},
  {9, 1},
  {12, 0},
  {11, 2},
  {15, 3},
  {11, 2},
  {13, 5},
  {29, 0},                                                /* End of row  64 */
  {36, 0},
  {8, 2},
  {18, 3},
  {13, 2},
  {12, 5},
  {3, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {38, 1},
  {8, 2},
  {19, 3},
  {11, 2},
  {12, 4},
  {29, 1},
  {2, 4},
  {9, 1},
  {10, 0},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {29, 0},                                                /* End of row  65 */
  {36, 0},
  {8, 2},
  {18, 3},
  {13, 2},
  {12, 5},
  {2, 0},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {39, 1},
  {8, 2},
  {19, 3},
  {11, 2},
  {12, 4},
  {30, 1},
  {2, 4},
  {9, 1},
  {9, 0},
  {11, 2},
  {15, 3},
  {11, 2},
  {13, 5},
  {30, 0},                                                /* End of row  66 */
  {36, 0},
  {8, 2},
  {19, 3},
  {13, 2},
  {12, 5},
  {2, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {40, 1},
  {8, 2},
  {20, 3},
  {11, 2},
  {12, 4},
  {30, 1},
  {2, 4},
  {9, 1},
  {7, 0},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {30, 0},                                                /* End of row  67 */
  {36, 0},
  {8, 2},
  {19, 3},
  {13, 2},
  {11, 5},
  {1, 4},
  {1, 6},
  {6, 1},
  {2, 4},
  {2, 6},
  {41, 1},
  {8, 2},
  {20, 3},
  {11, 2},
  {12, 4},
  {31, 1},
  {2, 4},
  {9, 1},
  {6, 0},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {30, 0},                                                /* End of row  68 */
  {36, 0},
  {8, 2},
  {20, 3},
  {13, 2},
  {9, 5},
  {3, 4},
  {5, 1},
  {2, 4},
  {2, 6},
  {42, 1},
  {8, 2},
  {21, 3},
  {11, 2},
  {12, 4},
  {31, 1},
  {2, 4},
  {9, 1},
  {4, 0},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {31, 0},                                                /* End of row  69 */
  {36, 0},
  {8, 2},
  {20, 3},
  {13, 2},
  {8, 5},
  {4, 4},
  {4, 1},
  {2, 4},
  {2, 6},
  {43, 1},
  {8, 2},
  {21, 3},
  {11, 2},
  {12, 4},
  {32, 1},
  {2, 4},
  {9, 1},
  {3, 0},
  {11, 2},
  {15, 3},
  {10, 2},
  {15, 5},
  {31, 0},                                                /* End of row  70 */
  {36, 0},
  {8, 2},
  {21, 3},
  {13, 2},
  {6, 5},
  {6, 4},
  {2, 1},
  {2, 4},
  {2, 6},
  {44, 1},
  {8, 2},
  {22, 3},
  {11, 2},
  {12, 4},
  {32, 1},
  {2, 4},
  {9, 1},
  {1, 0},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {32, 0},                                                /* End of row  71 */
  {36, 0},
  {8, 2},
  {21, 3},
  {13, 2},
  {5, 5},
  {7, 4},
  {1, 1},
  {2, 4},
  {2, 6},
  {45, 1},
  {8, 2},
  {22, 3},
  {11, 2},
  {12, 4},
  {33, 1},
  {2, 4},
  {9, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {32, 0},                                                /* End of row  72 */
  {36, 0},
  {8, 2},
  {22, 3},
  {13, 2},
  {3, 5},
  {10, 4},
  {2, 6},
  {46, 1},
  {8, 2},
  {23, 3},
  {11, 2},
  {12, 4},
  {33, 1},
  {2, 4},
  {7, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {33, 0},                                                /* End of row  73 */
  {36, 0},
  {8, 2},
  {22, 3},
  {13, 2},
  {2, 5},
  {11, 4},
  {1, 6},
  {47, 1},
  {8, 2},
  {23, 3},
  {11, 2},
  {12, 4},
  {34, 1},
  {2, 4},
  {6, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {33, 0},                                                /* End of row  74 */
  {36, 0},
  {8, 2},
  {23, 3},
  {13, 2},
  {12, 4},
  {48, 1},
  {8, 2},
  {24, 3},
  {11, 2},
  {12, 4},
  {34, 1},
  {2, 4},
  {4, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {34, 0},                                                /* End of row  75 */
  {36, 0},
  {8, 2},
  {23, 3},
  {13, 2},
  {13, 4},
  {47, 1},
  {8, 2},
  {24, 3},
  {11, 2},
  {12, 4},
  {35, 1},
  {2, 4},
  {3, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {34, 0},                                                /* End of row  76 */
  {36, 0},
  {8, 2},
  {24, 3},
  {13, 2},
  {12, 4},
  {47, 1},
  {8, 2},
  {25, 3},
  {11, 2},
  {12, 4},
  {35, 1},
  {2, 4},
  {1, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {35, 0},                                                /* End of row  77 */
  {36, 0},
  {8, 2},
  {24, 3},
  {13, 2},
  {12, 4},
  {47, 1},
  {8, 2},
  {25, 3},
  {11, 2},
  {12, 4},
  {36, 1},
  {2, 4},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {35, 0},                                                /* End of row  78 */
  {36, 0},
  {8, 2},
  {25, 3},
  {13, 2},
  {12, 4},
  {46, 1},
  {8, 2},
  {26, 3},
  {11, 2},
  {12, 4},
  {36, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {36, 0},                                                /* End of row  79 */
  {36, 0},
  {8, 2},
  {25, 3},
  {13, 2},
  {12, 4},
  {46, 1},
  {8, 2},
  {26, 3},
  {11, 2},
  {12, 4},
  {36, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {36, 0},                                                /* End of row  80 */
  {36, 0},
  {8, 2},
  {26, 3},
  {13, 2},
  {12, 4},
  {45, 1},
  {8, 2},
  {27, 3},
  {11, 2},
  {12, 4},
  {34, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {37, 0},                                                /* End of row  81 */
  {36, 0},
  {8, 2},
  {26, 3},
  {13, 2},
  {12, 4},
  {45, 1},
  {8, 2},
  {27, 3},
  {11, 2},
  {12, 4},
  {34, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {37, 0},                                                /* End of row  82 */
  {36, 0},
  {8, 2},
  {27, 3},
  {13, 2},
  {12, 4},
  {44, 1},
  {8, 2},
  {28, 3},
  {11, 2},
  {12, 4},
  {32, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {38, 0},                                                /* End of row  83 */
  {36, 0},
  {8, 2},
  {27, 3},
  {13, 2},
  {12, 4},
  {44, 1},
  {8, 2},
  {28, 3},
  {11, 2},
  {12, 4},
  {32, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {38, 0},                                                /* End of row  84 */
  {36, 0},
  {8, 2},
  {28, 3},
  {13, 2},
  {12, 4},
  {43, 1},
  {8, 2},
  {29, 3},
  {11, 2},
  {12, 4},
  {30, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {39, 0},                                                /* End of row  85 */
  {36, 0},
  {8, 2},
  {28, 3},
  {13, 2},
  {12, 4},
  {43, 1},
  {8, 2},
  {29, 3},
  {11, 2},
  {12, 4},
  {30, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {39, 0},                                                /* End of row  86 */
  {36, 0},
  {8, 2},
  {29, 3},
  {13, 2},
  {12, 4},
  {42, 1},
  {8, 2},
  {14, 3},
  {1, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {28, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {40, 0},                                                /* End of row  87 */
  {36, 0},
  {8, 2},
  {29, 3},
  {13, 2},
  {12, 4},
  {42, 1},
  {8, 2},
  {14, 3},
  {1, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {28, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {40, 0},                                                /* End of row  88 */
  {36, 0},
  {8, 2},
  {30, 3},
  {13, 2},
  {12, 4},
  {41, 1},
  {8, 2},
  {14, 3},
  {2, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {26, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {41, 0},                                                /* End of row  89 */
  {36, 0},
  {8, 2},
  {30, 3},
  {13, 2},
  {12, 4},
  {41, 1},
  {8, 2},
  {14, 3},
  {2, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {26, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {41, 0},                                                /* End of row  90 */
  {36, 0},
  {8, 2},
  {16, 3},
  {1, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {40, 1},
  {8, 2},
  {14, 3},
  {3, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {24, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {42, 0},                                                /* End of row  91 */
  {36, 0},
  {8, 2},
  {16, 3},
  {1, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {40, 1},
  {8, 2},
  {14, 3},
  {3, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {24, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {42, 0},                                                /* End of row  92 */
  {36, 0},
  {8, 2},
  {16, 3},
  {2, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {39, 1},
  {8, 2},
  {14, 3},
  {4, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {22, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {43, 0},                                                /* End of row  93 */
  {36, 0},
  {8, 2},
  {16, 3},
  {2, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {39, 1},
  {8, 2},
  {14, 3},
  {4, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {22, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {43, 0},                                                /* End of row  94 */
  {36, 0},
  {8, 2},
  {16, 3},
  {3, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {38, 1},
  {8, 2},
  {14, 3},
  {5, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {20, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {44, 0},                                                /* End of row  95 */
  {36, 0},
  {8, 2},
  {16, 3},
  {3, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {38, 1},
  {8, 2},
  {14, 3},
  {5, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {20, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {44, 0},                                                /* End of row  96 */
  {36, 0},
  {8, 2},
  {16, 3},
  {4, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {37, 1},
  {8, 2},
  {14, 3},
  {6, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {18, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {45, 0},                                                /* End of row  97 */
  {36, 0},
  {8, 2},
  {16, 3},
  {4, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {37, 1},
  {8, 2},
  {14, 3},
  {6, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {18, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {45, 0},                                                /* End of row  98 */
  {36, 0},
  {8, 2},
  {16, 3},
  {5, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {36, 1},
  {8, 2},
  {14, 3},
  {7, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {16, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {2, 4},
  {12, 5},
  {46, 0},                                                /* End of row  99 */
  {36, 0},
  {8, 2},
  {16, 3},
  {5, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {36, 1},
  {8, 2},
  {14, 3},
  {7, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {16, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {3, 4},
  {11, 5},
  {46, 0},                                                /* End of row 100 */
  {36, 0},
  {8, 2},
  {16, 3},
  {6, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {35, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {14, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {5, 4},
  {9, 5},
  {47, 0},                                                /* End of row 101 */
  {36, 0},
  {8, 2},
  {16, 3},
  {6, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {35, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {14, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {6, 4},
  {8, 5},
  {47, 0},                                                /* End of row 102 */
  {36, 0},
  {8, 2},
  {16, 3},
  {7, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {34, 1},
  {8, 2},
  {14, 3},
  {9, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {12, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {8, 4},
  {6, 5},
  {48, 0},                                                /* End of row 103 */
  {36, 0},
  {8, 2},
  {16, 3},
  {7, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {34, 1},
  {8, 2},
  {14, 3},
  {9, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {12, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {9, 4},
  {5, 5},
  {48, 0},                                                /* End of row 104 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {33, 1},
  {8, 2},
  {14, 3},
  {10, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {10, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {11, 4},
  {3, 5},
  {49, 0},                                                /* End of row 105 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {33, 1},
  {8, 2},
  {14, 3},
  {10, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {10, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {2, 5},
  {49, 0},                                                /* End of row 106 */
  {36, 0},
  {8, 2},
  {16, 3},
  {9, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {32, 1},
  {8, 2},
  {14, 3},
  {11, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {8, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {50, 0},                                                /* End of row 107 */
  {36, 0},
  {8, 2},
  {16, 3},
  {9, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {32, 1},
  {8, 2},
  {14, 3},
  {11, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {8, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {15, 4},
  {49, 0},                                                /* End of row 108 */
  {36, 0},
  {8, 2},
  {16, 3},
  {10, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {31, 1},
  {8, 2},
  {14, 3},
  {12, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {6, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {15, 4},
  {2, 1},
  {48, 0},                                                /* End of row 109 */
  {36, 0},
  {8, 2},
  {16, 3},
  {10, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {31, 1},
  {8, 2},
  {14, 3},
  {12, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {6, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {15, 4},
  {3, 1},
  {47, 0},                                                /* End of row 110 */
  {36, 0},
  {8, 2},
  {16, 3},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {30, 1},
  {8, 2},
  {14, 3},
  {13, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {4, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {6, 1},
  {46, 0},                                                /* End of row 111 */
  {36, 0},
  {8, 2},
  {16, 3},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {30, 1},
  {8, 2},
  {14, 3},
  {13, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {4, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {7, 1},
  {45, 0},                                                /* End of row 112 */
  {36, 0},
  {8, 2},
  {16, 3},
  {12, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {29, 1},
  {8, 2},
  {14, 3},
  {14, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {2, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {16, 4},
  {7, 1},
  {44, 0},                                                /* End of row 113 */
  {36, 0},
  {8, 2},
  {16, 3},
  {12, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {29, 1},
  {8, 2},
  {14, 3},
  {14, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {2, 1},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {1, 1},
  {2, 4},
  {7, 1},
  {43, 0},                                                /* End of row 114 */
  {36, 0},
  {8, 2},
  {16, 3},
  {13, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {28, 1},
  {8, 2},
  {14, 3},
  {15, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {3, 1},
  {2, 4},
  {7, 1},
  {42, 0},                                                /* End of row 115 */
  {36, 0},
  {8, 2},
  {16, 3},
  {13, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {28, 1},
  {8, 2},
  {14, 3},
  {15, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {4, 1},
  {2, 4},
  {7, 1},
  {41, 0},                                                /* End of row 116 */
  {36, 0},
  {8, 2},
  {16, 3},
  {14, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {27, 1},
  {8, 2},
  {14, 3},
  {16, 2},
  {15, 3},
  {11, 2},
  {10, 4},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {6, 1},
  {2, 4},
  {7, 1},
  {40, 0},                                                /* End of row 117 */
  {36, 0},
  {8, 2},
  {16, 3},
  {14, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {27, 1},
  {8, 2},
  {14, 3},
  {16, 2},
  {15, 3},
  {11, 2},
  {10, 4},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {7, 1},
  {2, 4},
  {7, 1},
  {39, 0},                                                /* End of row 118 */
  {36, 0},
  {8, 2},
  {16, 3},
  {15, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {26, 1},
  {8, 2},
  {14, 3},
  {17, 2},
  {15, 3},
  {11, 2},
  {8, 4},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {9, 1},
  {2, 4},
  {7, 1},
  {38, 0},                                                /* End of row 119 */
  {35, 0},
  {1, 6},
  {8, 2},
  {16, 3},
  {15, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {26, 1},
  {8, 2},
  {14, 3},
  {17, 2},
  {15, 3},
  {11, 2},
  {8, 4},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {10, 1},
  {2, 4},
  {7, 1},
  {37, 0},                                                /* End of row 120 */
  {34, 0},
  {2, 6},
  {8, 2},
  {16, 3},
  {16, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {25, 1},
  {8, 2},
  {14, 3},
  {18, 2},
  {15, 3},
  {11, 2},
  {6, 4},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {12, 1},
  {2, 4},
  {7, 1},
  {36, 0},                                                /* End of row 121 */
  {33, 0},
  {2, 6},
  {1, 1},
  {8, 2},
  {16, 3},
  {16, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {25, 1},
  {8, 2},
  {14, 3},
  {18, 2},
  {15, 3},
  {11, 2},
  {6, 4},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {13, 1},
  {2, 4},
  {7, 1},
  {35, 0},                                                /* End of row 122 */
  {32, 0},
  {2, 6},
  {2, 1},
  {8, 2},
  {16, 3},
  {17, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {24, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {1, 4},
  {10, 2},
  {15, 3},
  {11, 2},
  {4, 4},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {15, 1},
  {2, 4},
  {7, 1},
  {34, 0},                                                /* End of row 123 */
  {31, 0},
  {2, 6},
  {3, 1},
  {8, 2},
  {16, 3},
  {17, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {24, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {1, 4},
  {10, 2},
  {15, 3},
  {11, 2},
  {4, 4},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {16, 1},
  {2, 4},
  {7, 1},
  {33, 0},                                                /* End of row 124 */
  {30, 0},
  {2, 6},
  {4, 1},
  {8, 2},
  {16, 3},
  {18, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {23, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {2, 4},
  {10, 2},
  {15, 3},
  {11, 2},
  {2, 4},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {18, 1},
  {2, 4},
  {7, 1},
  {32, 0},                                                /* End of row 125 */
  {29, 0},
  {2, 6},
  {5, 1},
  {8, 2},
  {16, 3},
  {18, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {23, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {2, 4},
  {10, 2},
  {15, 3},
  {11, 2},
  {2, 4},
  {11, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {19, 1},
  {2, 4},
  {7, 1},
  {31, 0},                                                /* End of row 126 */
  {28, 0},
  {2, 6},
  {5, 1},
  {1, 4},
  {8, 2},
  {16, 3},
  {19, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {22, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {3, 4},
  {10, 2},
  {15, 3},
  {22, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {21, 1},
  {2, 4},
  {7, 1},
  {30, 0},                                                /* End of row 127 */
  {27, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {8, 2},
  {16, 3},
  {19, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {22, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {3, 4},
  {10, 2},
  {15, 3},
  {22, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {22, 1},
  {2, 4},
  {7, 1},
  {29, 0},                                                /* End of row 128 */
  {26, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {1, 6},
  {8, 2},
  {16, 3},
  {8, 2},
  {1, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {21, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {4, 4},
  {10, 2},
  {15, 3},
  {20, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {24, 1},
  {2, 4},
  {7, 1},
  {28, 0},                                                /* End of row 129 */
  {25, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {8, 2},
  {16, 3},
  {8, 2},
  {1, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {21, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {4, 4},
  {10, 2},
  {15, 3},
  {20, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {25, 1},
  {2, 4},
  {7, 1},
  {27, 0},                                                /* End of row 130 */
  {24, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {1, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {2, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {20, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {5, 4},
  {10, 2},
  {15, 3},
  {18, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {27, 1},
  {2, 4},
  {7, 1},
  {26, 0},                                                /* End of row 131 */
  {23, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {2, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {2, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {20, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {5, 4},
  {10, 2},
  {15, 3},
  {18, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {28, 1},
  {2, 4},
  {7, 1},
  {25, 0},                                                /* End of row 132 */
  {22, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {3, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {3, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {19, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {6, 4},
  {10, 2},
  {15, 3},
  {16, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {30, 1},
  {2, 4},
  {7, 1},
  {24, 0},                                                /* End of row 133 */
  {21, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {4, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {3, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {19, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {6, 4},
  {10, 2},
  {15, 3},
  {16, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {31, 1},
  {2, 4},
  {7, 1},
  {23, 0},                                                /* End of row 134 */
  {20, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {4, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {18, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {7, 4},
  {10, 2},
  {15, 3},
  {14, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {33, 1},
  {2, 4},
  {7, 1},
  {22, 0},                                                /* End of row 135 */
  {19, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {6, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {4, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {18, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {7, 4},
  {10, 2},
  {15, 3},
  {14, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {34, 1},
  {2, 4},
  {7, 1},
  {21, 0},                                                /* End of row 136 */
  {18, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {7, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {5, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {17, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {8, 4},
  {10, 2},
  {15, 3},
  {12, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {36, 1},
  {2, 4},
  {7, 1},
  {20, 0},                                                /* End of row 137 */
  {17, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {8, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {5, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {17, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {8, 4},
  {10, 2},
  {15, 3},
  {12, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {37, 1},
  {2, 4},
  {7, 1},
  {19, 0},                                                /* End of row 138 */
  {16, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {9, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {6, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {16, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {9, 4},
  {10, 2},
  {15, 3},
  {10, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {39, 1},
  {2, 4},
  {7, 1},
  {18, 0},                                                /* End of row 139 */
  {15, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {10, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {6, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {16, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {9, 4},
  {10, 2},
  {15, 3},
  {10, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {40, 1},
  {2, 4},
  {7, 1},
  {17, 0},                                                /* End of row 140 */
  {14, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {11, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {7, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {15, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {10, 4},
  {10, 2},
  {15, 3},
  {8, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {42, 1},
  {2, 4},
  {7, 1},
  {16, 0},                                                /* End of row 141 */
  {13, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {12, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {7, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {15, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {10, 4},
  {10, 2},
  {15, 3},
  {8, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {43, 1},
  {2, 4},
  {7, 1},
  {15, 0},                                                /* End of row 142 */
  {12, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {13, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {8, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {14, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {11, 4},
  {10, 2},
  {15, 3},
  {6, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {45, 1},
  {2, 4},
  {7, 1},
  {14, 0},                                                /* End of row 143 */
  {11, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {14, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {8, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {14, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {11, 4},
  {10, 2},
  {15, 3},
  {6, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {46, 1},
  {2, 4},
  {7, 1},
  {13, 0},                                                /* End of row 144 */
  {10, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {15, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {9, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {13, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {12, 4},
  {10, 2},
  {15, 3},
  {4, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {48, 1},
  {2, 4},
  {7, 1},
  {12, 0},                                                /* End of row 145 */
  {9, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {16, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {9, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {13, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {12, 4},
  {10, 2},
  {15, 3},
  {4, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {49, 1},
  {2, 4},
  {7, 1},
  {11, 0},                                                /* End of row 146 */
  {8, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {17, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {10, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {12, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {13, 4},
  {10, 2},
  {15, 3},
  {2, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {51, 1},
  {2, 4},
  {7, 1},
  {10, 0},                                                /* End of row 147 */
  {7, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {18, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {10, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {12, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {13, 4},
  {10, 2},
  {15, 3},
  {2, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {52, 1},
  {2, 4},
  {7, 1},
  {9, 0},                                                 /* End of row 148 */
  {6, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {19, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {11, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {11, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {10, 2},
  {30, 3},
  {11, 2},
  {14, 4},
  {54, 1},
  {2, 4},
  {7, 1},
  {8, 0},                                                 /* End of row 149 */
  {5, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {20, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {11, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {11, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {10, 2},
  {30, 3},
  {11, 2},
  {14, 4},
  {55, 1},
  {2, 4},
  {7, 1},
  {7, 0},                                                 /* End of row 150 */
  {4, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {21, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {12, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {10, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {1, 1},
  {10, 2},
  {28, 3},
  {11, 2},
  {14, 4},
  {57, 1},
  {2, 4},
  {7, 1},
  {6, 0},                                                 /* End of row 151 */
  {3, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {22, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {12, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {10, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {1, 1},
  {10, 2},
  {28, 3},
  {11, 2},
  {14, 4},
  {58, 1},
  {2, 4},
  {7, 1},
  {5, 0},                                                 /* End of row 152 */
  {2, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {23, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {13, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {9, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {2, 1},
  {10, 2},
  {26, 3},
  {11, 2},
  {14, 4},
  {60, 1},
  {2, 4},
  {7, 1},
  {4, 0},                                                 /* End of row 153 */
  {1, 0},
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {24, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {13, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {9, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {2, 1},
  {10, 2},
  {26, 3},
  {11, 2},
  {14, 4},
  {61, 1},
  {2, 4},
  {7, 1},
  {3, 0},                                                 /* End of row 154 */
  {2, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {25, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {8, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {3, 1},
  {10, 2},
  {24, 3},
  {11, 2},
  {14, 4},
  {63, 1},
  {2, 4},
  {7, 1},
  {2, 0},                                                 /* End of row 155 */
  {1, 6},
  {5, 1},
  {2, 4},
  {2, 6},
  {26, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {8, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {3, 1},
  {10, 2},
  {24, 3},
  {11, 2},
  {14, 4},
  {64, 1},
  {2, 4},
  {7, 1},
  {1, 0},                                                 /* End of row 156 */
  {5, 1},
  {2, 4},
  {2, 6},
  {27, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {1, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {7, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {4, 1},
  {10, 2},
  {22, 3},
  {11, 2},
  {14, 4},
  {66, 1},
  {2, 4},
  {7, 1},                                                 /* End of row 157 */
  {4, 1},
  {2, 4},
  {2, 6},
  {28, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {1, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {7, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {4, 1},
  {10, 2},
  {22, 3},
  {11, 2},
  {14, 4},
  {67, 1},
  {2, 4},
  {6, 1},                                                 /* End of row 158 */
  {3, 1},
  {2, 4},
  {2, 6},
  {29, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {2, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {6, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {5, 1},
  {10, 2},
  {20, 3},
  {11, 2},
  {14, 4},
  {69, 1},
  {2, 4},
  {5, 1},                                                 /* End of row 159 */
  {3, 1},
  {2, 4},
  {1, 6},
  {30, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {2, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {6, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {5, 1},
  {10, 2},
  {20, 3},
  {11, 2},
  {14, 4},
  {70, 1},
  {2, 4},
  {4, 1},                                                 /* End of row 160 */
  {4, 1},
  {2, 4},
  {30, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {3, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {5, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {5, 1},
  {11, 2},
  {19, 3},
  {10, 2},
  {14, 4},
  {72, 1},
  {3, 4},
  {2, 1},                                                 /* End of row 161 */
  {5, 1},
  {2, 4},
  {29, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {3, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {5, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {5, 1},
  {11, 2},
  {18, 3},
  {11, 2},
  {14, 4},
  {72, 1},
  {3, 4},
  {2, 1},                                                 /* End of row 162 */
  {6, 1},
  {2, 4},
  {28, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {4, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {4, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {4, 1},
  {11, 2},
  {19, 3},
  {10, 2},
  {14, 4},
  {72, 1},
  {2, 4},
  {2, 6},
  {2, 1},                                                 /* End of row 163 */
  {7, 1},
  {2, 4},
  {27, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {4, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {4, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {4, 1},
  {11, 2},
  {18, 3},
  {11, 2},
  {14, 4},
  {71, 1},
  {2, 4},
  {2, 6},
  {3, 1},                                                 /* End of row 164 */
  {8, 1},
  {2, 4},
  {26, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {5, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {3, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {3, 1},
  {11, 2},
  {20, 3},
  {11, 2},
  {13, 4},
  {70, 1},
  {2, 4},
  {2, 6},
  {4, 1},                                                 /* End of row 165 */
  {9, 1},
  {2, 4},
  {25, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {5, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {3, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {3, 1},
  {11, 2},
  {20, 3},
  {11, 2},
  {13, 4},
  {69, 1},
  {2, 4},
  {2, 6},
  {5, 1},                                                 /* End of row 166 */
  {1, 0},
  {9, 1},
  {2, 4},
  {24, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {6, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {2, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {2, 1},
  {11, 2},
  {22, 3},
  {11, 2},
  {13, 4},
  {67, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {1, 0},                                                 /* End of row 167 */
  {2, 0},
  {9, 1},
  {2, 4},
  {23, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {6, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {2, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {2, 1},
  {11, 2},
  {22, 3},
  {11, 2},
  {13, 4},
  {66, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {2, 0},                                                 /* End of row 168 */
  {3, 0},
  {9, 1},
  {2, 4},
  {22, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {7, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {1, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {1, 1},
  {11, 2},
  {24, 3},
  {11, 2},
  {13, 4},
  {64, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {3, 0},                                                 /* End of row 169 */
  {4, 0},
  {9, 1},
  {2, 4},
  {21, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {7, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {1, 1},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {1, 1},
  {11, 2},
  {24, 3},
  {11, 2},
  {13, 4},
  {63, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {4, 0},                                                 /* End of row 170 */
  {5, 0},
  {9, 1},
  {2, 4},
  {20, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {8, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {11, 2},
  {26, 3},
  {11, 2},
  {13, 4},
  {61, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {5, 0},                                                 /* End of row 171 */
  {6, 0},
  {9, 1},
  {2, 4},
  {19, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {8, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {12, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {14, 4},
  {11, 2},
  {26, 3},
  {11, 2},
  {13, 4},
  {60, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {6, 0},                                                 /* End of row 172 */
  {7, 0},
  {9, 1},
  {2, 4},
  {18, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {9, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {11, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {13, 4},
  {11, 2},
  {28, 3},
  {11, 2},
  {13, 4},
  {58, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {7, 0},                                                 /* End of row 173 */
  {8, 0},
  {9, 1},
  {2, 4},
  {17, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {9, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {11, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {13, 4},
  {11, 2},
  {28, 3},
  {11, 2},
  {13, 4},
  {57, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {8, 0},                                                 /* End of row 174 */
  {9, 0},
  {9, 1},
  {2, 4},
  {16, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {10, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {10, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {12, 4},
  {11, 2},
  {30, 3},
  {11, 2},
  {13, 4},
  {55, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {9, 0},                                                 /* End of row 175 */
  {10, 0},
  {9, 1},
  {2, 4},
  {15, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {10, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {10, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {12, 4},
  {11, 2},
  {30, 3},
  {11, 2},
  {13, 4},
  {54, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {10, 0},                                                /* End of row 176 */
  {11, 0},
  {9, 1},
  {2, 4},
  {14, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {11, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {9, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {11, 4},
  {11, 2},
  {32, 3},
  {11, 2},
  {13, 4},
  {52, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {11, 0},                                                /* End of row 177 */
  {12, 0},
  {9, 1},
  {2, 4},
  {13, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {11, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {9, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {11, 4},
  {11, 2},
  {32, 3},
  {11, 2},
  {13, 4},
  {51, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {12, 0},                                                /* End of row 178 */
  {13, 0},
  {9, 1},
  {2, 4},
  {12, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {12, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {8, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {10, 4},
  {11, 2},
  {16, 3},
  {3, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {49, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {13, 0},                                                /* End of row 179 */
  {14, 0},
  {9, 1},
  {2, 4},
  {11, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {12, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {8, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {10, 4},
  {11, 2},
  {16, 3},
  {3, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {48, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {14, 0},                                                /* End of row 180 */
  {15, 0},
  {9, 1},
  {2, 4},
  {10, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {13, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {7, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {9, 4},
  {11, 2},
  {16, 3},
  {5, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {46, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {15, 0},                                                /* End of row 181 */
  {16, 0},
  {9, 1},
  {2, 4},
  {9, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {13, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {7, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {9, 4},
  {11, 2},
  {16, 3},
  {5, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {45, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {16, 0},                                                /* End of row 182 */
  {17, 0},
  {9, 1},
  {2, 4},
  {8, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {14, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {6, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {8, 4},
  {11, 2},
  {16, 3},
  {7, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {43, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {17, 0},                                                /* End of row 183 */
  {18, 0},
  {9, 1},
  {2, 4},
  {7, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {14, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {6, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {8, 4},
  {11, 2},
  {16, 3},
  {7, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {42, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {18, 0},                                                /* End of row 184 */
  {19, 0},
  {9, 1},
  {2, 4},
  {6, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {15, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {5, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {7, 4},
  {11, 2},
  {16, 3},
  {9, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {40, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {19, 0},                                                /* End of row 185 */
  {20, 0},
  {9, 1},
  {2, 4},
  {5, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {15, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {5, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {7, 4},
  {11, 2},
  {16, 3},
  {9, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {39, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {20, 0},                                                /* End of row 186 */
  {21, 0},
  {9, 1},
  {2, 4},
  {4, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {16, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {4, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {6, 4},
  {11, 2},
  {16, 3},
  {11, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {37, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {21, 0},                                                /* End of row 187 */
  {22, 0},
  {9, 1},
  {2, 4},
  {3, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {16, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {4, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {6, 4},
  {11, 2},
  {16, 3},
  {11, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {36, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {22, 0},                                                /* End of row 188 */
  {23, 0},
  {9, 1},
  {2, 4},
  {2, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {17, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {3, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {5, 4},
  {11, 2},
  {16, 3},
  {13, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {34, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {23, 0},                                                /* End of row 189 */
  {24, 0},
  {9, 1},
  {2, 4},
  {1, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {17, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {3, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {5, 4},
  {11, 2},
  {16, 3},
  {13, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {33, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {24, 0},                                                /* End of row 190 */
  {25, 0},
  {9, 1},
  {2, 4},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {18, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {2, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {4, 4},
  {11, 2},
  {16, 3},
  {15, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {31, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {25, 0},                                                /* End of row 191 */
  {26, 0},
  {9, 1},
  {1, 4},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {18, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {2, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {4, 4},
  {11, 2},
  {16, 3},
  {15, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {30, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {26, 0},                                                /* End of row 192 */
  {27, 0},
  {9, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {19, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {1, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {3, 4},
  {11, 2},
  {16, 3},
  {17, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {28, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {27, 0},                                                /* End of row 193 */
  {28, 0},
  {8, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {19, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {1, 4},
  {8, 2},
  {14, 3},
  {8, 2},
  {3, 4},
  {11, 2},
  {16, 3},
  {17, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {27, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {28, 0},                                                /* End of row 194 */
  {29, 0},
  {7, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {20, 1},
  {11, 2},
  {14, 3},
  {21, 2},
  {14, 3},
  {8, 2},
  {2, 4},
  {11, 2},
  {16, 3},
  {19, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {25, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {29, 0},                                                /* End of row 195 */
  {30, 0},
  {6, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {20, 1},
  {11, 2},
  {14, 3},
  {21, 2},
  {14, 3},
  {8, 2},
  {2, 4},
  {11, 2},
  {16, 3},
  {19, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {24, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {30, 0},                                                /* End of row 196 */
  {31, 0},
  {5, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {21, 1},
  {11, 2},
  {14, 3},
  {20, 2},
  {14, 3},
  {8, 2},
  {1, 4},
  {11, 2},
  {16, 3},
  {11, 2},
  {1, 4},
  {9, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {22, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {31, 0},                                                /* End of row 197 */
  {32, 0},
  {4, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {21, 1},
  {11, 2},
  {14, 3},
  {20, 2},
  {14, 3},
  {8, 2},
  {1, 4},
  {11, 2},
  {16, 3},
  {11, 2},
  {1, 4},
  {9, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {21, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {32, 0},                                                /* End of row 198 */
  {33, 0},
  {3, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {22, 1},
  {11, 2},
  {14, 3},
  {19, 2},
  {14, 3},
  {19, 2},
  {16, 3},
  {11, 2},
  {3, 4},
  {9, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {19, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {33, 0},                                                /* End of row 199 */
  {34, 0},
  {2, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {22, 1},
  {11, 2},
  {14, 3},
  {19, 2},
  {14, 3},
  {19, 2},
  {16, 3},
  {11, 2},
  {3, 4},
  {9, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {18, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {34, 0},                                                /* End of row 200 */
  {35, 0},
  {1, 1},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {23, 1},
  {11, 2},
  {14, 3},
  {18, 2},
  {14, 3},
  {18, 2},
  {16, 3},
  {11, 2},
  {5, 4},
  {9, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {16, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {35, 0},                                                /* End of row 201 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {23, 1},
  {11, 2},
  {14, 3},
  {18, 2},
  {14, 3},
  {18, 2},
  {16, 3},
  {11, 2},
  {5, 4},
  {9, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {15, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {36, 0},                                                /* End of row 202 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {24, 1},
  {11, 2},
  {14, 3},
  {17, 2},
  {14, 3},
  {17, 2},
  {16, 3},
  {11, 2},
  {7, 4},
  {9, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {13, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {37, 0},                                                /* End of row 203 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {24, 1},
  {11, 2},
  {14, 3},
  {17, 2},
  {14, 3},
  {17, 2},
  {16, 3},
  {11, 2},
  {7, 4},
  {9, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {12, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {38, 0},                                                /* End of row 204 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {25, 1},
  {11, 2},
  {14, 3},
  {16, 2},
  {14, 3},
  {16, 2},
  {16, 3},
  {11, 2},
  {9, 4},
  {9, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {10, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {39, 0},                                                /* End of row 205 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {25, 1},
  {11, 2},
  {14, 3},
  {16, 2},
  {14, 3},
  {16, 2},
  {16, 3},
  {11, 2},
  {9, 4},
  {9, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {9, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {40, 0},                                                /* End of row 206 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {26, 1},
  {11, 2},
  {14, 3},
  {15, 2},
  {14, 3},
  {15, 2},
  {16, 3},
  {11, 2},
  {11, 4},
  {9, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {7, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {41, 0},                                                /* End of row 207 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {26, 1},
  {11, 2},
  {14, 3},
  {15, 2},
  {14, 3},
  {15, 2},
  {16, 3},
  {11, 2},
  {11, 4},
  {9, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {6, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {42, 0},                                                /* End of row 208 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {27, 1},
  {11, 2},
  {14, 3},
  {14, 2},
  {14, 3},
  {14, 2},
  {16, 3},
  {11, 2},
  {13, 4},
  {9, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {4, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {43, 0},                                                /* End of row 209 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {27, 1},
  {11, 2},
  {14, 3},
  {14, 2},
  {14, 3},
  {14, 2},
  {16, 3},
  {11, 2},
  {13, 4},
  {9, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {3, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {44, 0},                                                /* End of row 210 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {28, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {14, 3},
  {13, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {9, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {1, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {45, 0},                                                /* End of row 211 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {28, 1},
  {11, 2},
  {14, 3},
  {13, 2},
  {14, 3},
  {13, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {9, 2},
  {15, 3},
  {11, 2},
  {15, 4},
  {2, 6},
  {5, 1},
  {46, 0},                                                /* End of row 212 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {29, 1},
  {11, 2},
  {14, 3},
  {12, 2},
  {14, 3},
  {12, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {2, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {13, 4},
  {2, 6},
  {5, 1},
  {47, 0},                                                /* End of row 213 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {29, 1},
  {11, 2},
  {14, 3},
  {12, 2},
  {14, 3},
  {12, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {2, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {5, 1},
  {48, 0},                                                /* End of row 214 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {30, 1},
  {11, 2},
  {14, 3},
  {11, 2},
  {14, 3},
  {11, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {4, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {3, 1},
  {49, 0},                                                /* End of row 215 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {30, 1},
  {11, 2},
  {14, 3},
  {11, 2},
  {14, 3},
  {11, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {4, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 4},
  {2, 1},
  {50, 0},                                                /* End of row 216 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {31, 1},
  {11, 2},
  {14, 3},
  {10, 2},
  {14, 3},
  {10, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {6, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {12, 4},
  {1, 5},
  {1, 1},
  {51, 0},                                                /* End of row 217 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {31, 1},
  {11, 2},
  {14, 3},
  {10, 2},
  {14, 3},
  {10, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {6, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {11, 4},
  {3, 5},
  {51, 0},                                                /* End of row 218 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {32, 1},
  {11, 2},
  {14, 3},
  {9, 2},
  {14, 3},
  {9, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {8, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {9, 4},
  {5, 5},
  {50, 0},                                                /* End of row 219 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {32, 1},
  {11, 2},
  {14, 3},
  {9, 2},
  {14, 3},
  {9, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {8, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {8, 4},
  {6, 5},
  {50, 0},                                                /* End of row 220 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {33, 1},
  {11, 2},
  {14, 3},
  {8, 2},
  {14, 3},
  {8, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {10, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {6, 4},
  {8, 5},
  {49, 0},                                                /* End of row 221 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {33, 1},
  {11, 2},
  {14, 3},
  {8, 2},
  {14, 3},
  {8, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {10, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {5, 4},
  {9, 5},
  {49, 0},                                                /* End of row 222 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {34, 1},
  {11, 2},
  {14, 3},
  {7, 2},
  {14, 3},
  {7, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {12, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {3, 4},
  {11, 5},
  {48, 0},                                                /* End of row 223 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {34, 1},
  {11, 2},
  {14, 3},
  {7, 2},
  {14, 3},
  {7, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {12, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {2, 4},
  {12, 5},
  {48, 0},                                                /* End of row 224 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {35, 1},
  {11, 2},
  {14, 3},
  {6, 2},
  {14, 3},
  {6, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {14, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {47, 0},                                                /* End of row 225 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {35, 1},
  {11, 2},
  {14, 3},
  {6, 2},
  {14, 3},
  {6, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {14, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {47, 0},                                                /* End of row 226 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {36, 1},
  {11, 2},
  {14, 3},
  {5, 2},
  {14, 3},
  {5, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {16, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {46, 0},                                                /* End of row 227 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {36, 1},
  {11, 2},
  {14, 3},
  {5, 2},
  {14, 3},
  {5, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {16, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {46, 0},                                                /* End of row 228 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {37, 1},
  {11, 2},
  {14, 3},
  {4, 2},
  {14, 3},
  {4, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {18, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {45, 0},                                                /* End of row 229 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {37, 1},
  {11, 2},
  {14, 3},
  {4, 2},
  {14, 3},
  {4, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {18, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {45, 0},                                                /* End of row 230 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {38, 1},
  {11, 2},
  {14, 3},
  {3, 2},
  {14, 3},
  {3, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {20, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {44, 0},                                                /* End of row 231 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {38, 1},
  {11, 2},
  {14, 3},
  {3, 2},
  {14, 3},
  {3, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {20, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {44, 0},                                                /* End of row 232 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {39, 1},
  {11, 2},
  {14, 3},
  {2, 2},
  {14, 3},
  {2, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {22, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {43, 0},                                                /* End of row 233 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 4},
  {39, 1},
  {11, 2},
  {14, 3},
  {2, 2},
  {14, 3},
  {2, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {22, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {43, 0},                                                /* End of row 234 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {1, 5},
  {13, 4},
  {40, 1},
  {11, 2},
  {14, 3},
  {1, 2},
  {14, 3},
  {1, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {24, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {42, 0},                                                /* End of row 235 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {2, 5},
  {12, 4},
  {40, 1},
  {11, 2},
  {14, 3},
  {1, 2},
  {14, 3},
  {1, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {24, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {42, 0},                                                /* End of row 236 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {3, 5},
  {11, 4},
  {41, 1},
  {11, 2},
  {44, 3},
  {11, 2},
  {15, 4},
  {26, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {41, 0},                                                /* End of row 237 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {4, 5},
  {11, 4},
  {40, 1},
  {11, 2},
  {44, 3},
  {11, 2},
  {15, 4},
  {26, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {41, 0},                                                /* End of row 238 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {5, 5},
  {11, 4},
  {40, 1},
  {11, 2},
  {42, 3},
  {11, 2},
  {15, 4},
  {28, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {40, 0},                                                /* End of row 239 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {6, 5},
  {8, 4},
  {1, 1},
  {2, 4},
  {39, 1},
  {11, 2},
  {42, 3},
  {11, 2},
  {15, 4},
  {28, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {40, 0},                                                /* End of row 240 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {7, 5},
  {7, 4},
  {2, 1},
  {2, 4},
  {39, 1},
  {11, 2},
  {40, 3},
  {11, 2},
  {15, 4},
  {30, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {39, 0},                                                /* End of row 241 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {8, 5},
  {6, 4},
  {3, 1},
  {2, 4},
  {38, 1},
  {11, 2},
  {40, 3},
  {11, 2},
  {15, 4},
  {29, 1},
  {1, 4},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {39, 0},                                                /* End of row 242 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {9, 5},
  {5, 4},
  {4, 1},
  {2, 4},
  {38, 1},
  {11, 2},
  {38, 3},
  {11, 2},
  {15, 4},
  {29, 1},
  {2, 4},
  {1, 6},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {38, 0},                                                /* End of row 243 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {10, 5},
  {4, 4},
  {5, 1},
  {2, 4},
  {37, 1},
  {11, 2},
  {38, 3},
  {11, 2},
  {15, 4},
  {28, 1},
  {2, 4},
  {2, 6},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {38, 0},                                                /* End of row 244 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {11, 5},
  {3, 4},
  {6, 1},
  {2, 4},
  {37, 1},
  {11, 2},
  {36, 3},
  {11, 2},
  {15, 4},
  {28, 1},
  {2, 4},
  {2, 6},
  {2, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {37, 0},                                                /* End of row 245 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {12, 5},
  {2, 4},
  {7, 1},
  {2, 4},
  {36, 1},
  {11, 2},
  {36, 3},
  {11, 2},
  {15, 4},
  {27, 1},
  {2, 4},
  {2, 6},
  {3, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {37, 0},                                                /* End of row 246 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {13, 5},
  {1, 4},
  {8, 1},
  {2, 4},
  {36, 1},
  {11, 2},
  {34, 3},
  {11, 2},
  {15, 4},
  {27, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {36, 0},                                                /* End of row 247 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {9, 1},
  {2, 4},
  {35, 1},
  {11, 2},
  {34, 3},
  {11, 2},
  {15, 4},
  {26, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {1, 0},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {36, 0},                                                /* End of row 248 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {1, 0},
  {9, 1},
  {2, 4},
  {35, 1},
  {11, 2},
  {32, 3},
  {11, 2},
  {15, 4},
  {26, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {2, 0},
  {10, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {35, 0},                                                /* End of row 249 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {2, 0},
  {9, 1},
  {2, 4},
  {34, 1},
  {11, 2},
  {32, 3},
  {11, 2},
  {15, 4},
  {25, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {4, 0},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {35, 0},                                                /* End of row 250 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {3, 0},
  {9, 1},
  {2, 4},
  {34, 1},
  {11, 2},
  {30, 3},
  {11, 2},
  {15, 4},
  {25, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {6, 0},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {34, 0},                                                /* End of row 251 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {4, 0},
  {9, 1},
  {2, 4},
  {33, 1},
  {11, 2},
  {30, 3},
  {11, 2},
  {15, 4},
  {24, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {7, 0},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {34, 0},                                                /* End of row 252 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {5, 0},
  {9, 1},
  {2, 4},
  {33, 1},
  {11, 2},
  {28, 3},
  {11, 2},
  {15, 4},
  {24, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {9, 0},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {33, 0},                                                /* End of row 253 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {6, 0},
  {9, 1},
  {2, 4},
  {32, 1},
  {11, 2},
  {28, 3},
  {11, 2},
  {15, 4},
  {23, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {10, 0},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {33, 0},                                                /* End of row 254 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {7, 0},
  {9, 1},
  {2, 4},
  {32, 1},
  {11, 2},
  {26, 3},
  {11, 2},
  {15, 4},
  {23, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {12, 0},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {32, 0},                                                /* End of row 255 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {8, 0},
  {9, 1},
  {2, 4},
  {31, 1},
  {11, 2},
  {26, 3},
  {11, 2},
  {15, 4},
  {22, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {13, 0},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {32, 0},                                                /* End of row 256 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {9, 0},
  {9, 1},
  {2, 4},
  {31, 1},
  {11, 2},
  {24, 3},
  {11, 2},
  {15, 4},
  {22, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {15, 0},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {31, 0},                                                /* End of row 257 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {10, 0},
  {9, 1},
  {2, 4},
  {30, 1},
  {11, 2},
  {24, 3},
  {11, 2},
  {15, 4},
  {21, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {16, 0},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {31, 0},                                                /* End of row 258 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {11, 0},
  {9, 1},
  {2, 4},
  {30, 1},
  {11, 2},
  {22, 3},
  {11, 2},
  {15, 4},
  {21, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {18, 0},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {30, 0},                                                /* End of row 259 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {12, 0},
  {9, 1},
  {2, 4},
  {29, 1},
  {11, 2},
  {22, 3},
  {11, 2},
  {15, 4},
  {20, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {19, 0},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {30, 0},                                                /* End of row 260 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {13, 0},
  {9, 1},
  {2, 4},
  {29, 1},
  {11, 2},
  {20, 3},
  {11, 2},
  {15, 4},
  {20, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {21, 0},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {29, 0},                                                /* End of row 261 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {14, 0},
  {9, 1},
  {2, 4},
  {28, 1},
  {11, 2},
  {20, 3},
  {11, 2},
  {15, 4},
  {19, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {22, 0},
  {9, 2},
  {15, 3},
  {11, 2},
  {14, 5},
  {29, 0},                                                /* End of row 262 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {15, 0},
  {9, 1},
  {2, 4},
  {28, 1},
  {11, 2},
  {18, 3},
  {11, 2},
  {15, 4},
  {19, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {24, 0},
  {9, 2},
  {15, 3},
  {10, 2},
  {14, 5},
  {29, 0},                                                /* End of row 263 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {16, 0},
  {9, 1},
  {2, 4},
  {27, 1},
  {11, 2},
  {18, 3},
  {11, 2},
  {15, 4},
  {18, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {25, 0},
  {9, 2},
  {15, 3},
  {10, 2},
  {14, 5},
  {29, 0},                                                /* End of row 264 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {17, 0},
  {9, 1},
  {2, 4},
  {27, 1},
  {11, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {18, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {27, 0},
  {9, 2},
  {14, 3},
  {10, 2},
  {15, 5},
  {28, 0},                                                /* End of row 265 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {18, 0},
  {9, 1},
  {2, 4},
  {26, 1},
  {11, 2},
  {16, 3},
  {11, 2},
  {15, 4},
  {17, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {28, 0},
  {9, 2},
  {14, 3},
  {10, 2},
  {15, 5},
  {28, 0},                                                /* End of row 266 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {19, 0},
  {9, 1},
  {2, 4},
  {26, 1},
  {11, 2},
  {14, 3},
  {11, 2},
  {15, 4},
  {17, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {30, 0},
  {9, 2},
  {13, 3},
  {10, 2},
  {16, 5},
  {27, 0},                                                /* End of row 267 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {20, 0},
  {9, 1},
  {2, 4},
  {25, 1},
  {11, 2},
  {14, 3},
  {11, 2},
  {15, 4},
  {16, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {31, 0},
  {9, 2},
  {13, 3},
  {9, 2},
  {17, 5},
  {27, 0},                                                /* End of row 268 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {21, 0},
  {9, 1},
  {2, 4},
  {25, 1},
  {11, 2},
  {12, 3},
  {11, 2},
  {15, 4},
  {16, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {33, 0},
  {9, 2},
  {11, 3},
  {10, 2},
  {17, 5},
  {27, 0},                                                /* End of row 269 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {22, 0},
  {9, 1},
  {2, 4},
  {24, 1},
  {12, 2},
  {10, 3},
  {12, 2},
  {15, 4},
  {15, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {34, 0},
  {9, 2},
  {11, 3},
  {10, 2},
  {17, 5},
  {27, 0},                                                /* End of row 270 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {23, 0},
  {9, 1},
  {2, 4},
  {24, 1},
  {12, 2},
  {8, 3},
  {12, 2},
  {15, 4},
  {15, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {36, 0},
  {9, 2},
  {8, 3},
  {11, 2},
  {18, 5},
  {27, 0},                                                /* End of row 271 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {24, 0},
  {9, 1},
  {2, 4},
  {23, 1},
  {14, 2},
  {4, 3},
  {14, 2},
  {15, 4},
  {14, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {37, 0},
  {11, 2},
  {4, 3},
  {13, 2},
  {18, 5},
  {27, 0},                                                /* End of row 272 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {25, 0},
  {9, 1},
  {2, 4},
  {23, 1},
  {30, 2},
  {15, 4},
  {14, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {39, 0},
  {26, 2},
  {19, 5},
  {27, 0},                                                /* End of row 273 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {26, 0},
  {9, 1},
  {2, 4},
  {22, 1},
  {30, 2},
  {15, 4},
  {13, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {40, 0},
  {26, 2},
  {18, 5},
  {28, 0},                                                /* End of row 274 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {27, 0},
  {9, 1},
  {2, 4},
  {22, 1},
  {28, 2},
  {15, 4},
  {13, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {42, 0},
  {24, 2},
  {19, 5},
  {28, 0},                                                /* End of row 275 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {28, 0},
  {9, 1},
  {2, 4},
  {21, 1},
  {28, 2},
  {15, 4},
  {12, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {43, 0},
  {23, 2},
  {20, 5},
  {28, 0},                                                /* End of row 276 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {29, 0},
  {9, 1},
  {2, 4},
  {21, 1},
  {26, 2},
  {15, 4},
  {12, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {45, 0},
  {21, 2},
  {20, 5},
  {29, 0},                                                /* End of row 277 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {30, 0},
  {9, 1},
  {2, 4},
  {20, 1},
  {26, 2},
  {15, 4},
  {11, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {46, 0},
  {20, 2},
  {21, 5},
  {29, 0},                                                /* End of row 278 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {31, 0},
  {9, 1},
  {2, 4},
  {20, 1},
  {24, 2},
  {15, 4},
  {11, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {48, 0},
  {18, 2},
  {21, 5},
  {30, 0},                                                /* End of row 279 */
  {36, 0},
  {8, 2},
  {16, 3},
  {8, 2},
  {14, 5},
  {32, 0},
  {9, 1},
  {2, 4},
  {20, 1},
  {22, 2},
  {16, 4},
  {10, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {51, 0},
  {14, 2},
  {23, 5},
  {30, 0},                                                /* End of row 280 */
  {50, 0},
  {32, 5},
  {33, 0},
  {9, 1},
  {2, 4},
  {20, 1},
  {20, 2},
  {16, 4},
  {10, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {55, 0},
  {8, 2},
  {25, 5},
  {31, 0},                                                /* End of row 281 */
  {50, 0},
  {32, 5},
  {34, 0},
  {9, 1},
  {2, 4},
  {21, 1},
  {16, 2},
  {18, 4},
  {9, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {61, 0},
  {28, 5},
  {31, 0},                                                /* End of row 282 */
  {50, 0},
  {32, 5},
  {35, 0},
  {9, 1},
  {2, 4},
  {22, 1},
  {12, 2},
  {19, 4},
  {9, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {62, 0},
  {27, 5},
  {32, 0},                                                /* End of row 283 */
  {50, 0},
  {32, 5},
  {36, 0},
  {9, 1},
  {2, 4},
  {23, 1},
  {8, 2},
  {20, 4},
  {9, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {64, 0},
  {26, 5},
  {32, 0},                                                /* End of row 284 */
  {50, 0},
  {32, 5},
  {37, 0},
  {9, 1},
  {2, 4},
  {24, 1},
  {25, 4},
  {9, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {66, 0},
  {23, 5},
  {34, 0},                                                /* End of row 285 */
  {50, 0},
  {32, 5},
  {38, 0},
  {9, 1},
  {2, 4},
  {25, 1},
  {21, 4},
  {10, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {67, 0},
  {23, 5},
  {34, 0},                                                /* End of row 286 */
  {50, 0},
  {32, 5},
  {39, 0},
  {9, 1},
  {2, 4},
  {26, 1},
  {17, 4},
  {11, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {69, 0},
  {20, 5},
  {36, 0},                                                /* End of row 287 */
  {50, 0},
  {32, 5},
  {40, 0},
  {9, 1},
  {2, 4},
  {27, 1},
  {13, 4},
  {12, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {70, 0},
  {20, 5},
  {36, 0},                                                /* End of row 288 */
  {50, 0},
  {32, 5},
  {41, 0},
  {9, 1},
  {2, 4},
  {50, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {72, 0},
  {17, 5},
  {38, 0},                                                /* End of row 289 */
  {50, 0},
  {32, 5},
  {42, 0},
  {9, 1},
  {2, 4},
  {48, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {74, 0},
  {14, 5},
  {40, 0},                                                /* End of row 290 */
  {50, 0},
  {32, 5},
  {43, 0},
  {9, 1},
  {2, 4},
  {46, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {129, 0},                                               /* End of row 291 */
  {50, 0},
  {32, 5},
  {44, 0},
  {9, 1},
  {2, 4},
  {44, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {130, 0},                                               /* End of row 292 */
  {50, 0},
  {32, 5},
  {45, 0},
  {9, 1},
  {2, 4},
  {42, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {131, 0},                                               /* End of row 293 */
  {50, 0},
  {32, 5},
  {46, 0},
  {9, 1},
  {2, 4},
  {40, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {132, 0},                                               /* End of row 294 */
  {129, 0},
  {9, 1},
  {2, 4},
  {38, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {133, 0},                                               /* End of row 295 */
  {130, 0},
  {9, 1},
  {2, 4},
  {36, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {134, 0},                                               /* End of row 296 */
  {131, 0},
  {9, 1},
  {2, 4},
  {34, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {135, 0},                                               /* End of row 297 */
  {132, 0},
  {9, 1},
  {2, 4},
  {32, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {136, 0},                                               /* End of row 298 */
  {133, 0},
  {9, 1},
  {2, 4},
  {30, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {137, 0},                                               /* End of row 299 */
  {134, 0},
  {9, 1},
  {2, 4},
  {28, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {138, 0},                                               /* End of row 300 */
  {135, 0},
  {9, 1},
  {2, 4},
  {26, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {139, 0},                                               /* End of row 301 */
  {136, 0},
  {9, 1},
  {2, 4},
  {24, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {140, 0},                                               /* End of row 302 */
  {137, 0},
  {9, 1},
  {2, 4},
  {22, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {141, 0},                                               /* End of row 303 */
  {138, 0},
  {9, 1},
  {2, 4},
  {20, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {142, 0},                                               /* End of row 304 */
  {139, 0},
  {9, 1},
  {2, 4},
  {18, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {143, 0},                                               /* End of row 305 */
  {140, 0},
  {9, 1},
  {2, 4},
  {16, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {144, 0},                                               /* End of row 306 */
  {141, 0},
  {9, 1},
  {2, 4},
  {14, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {145, 0},                                               /* End of row 307 */
  {142, 0},
  {9, 1},
  {2, 4},
  {12, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {146, 0},                                               /* End of row 308 */
  {143, 0},
  {9, 1},
  {2, 4},
  {10, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {147, 0},                                               /* End of row 309 */
  {144, 0},
  {9, 1},
  {2, 4},
  {8, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {148, 0},                                               /* End of row 310 */
  {145, 0},
  {9, 1},
  {2, 4},
  {6, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {149, 0},                                               /* End of row 311 */
  {146, 0},
  {9, 1},
  {2, 4},
  {4, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {150, 0},                                               /* End of row 312 */
  {147, 0},
  {9, 1},
  {2, 4},
  {2, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {151, 0},                                               /* End of row 313 */
  {148, 0},
  {9, 1},
  {4, 4},
  {2, 6},
  {5, 1},
  {152, 0},                                               /* End of row 314 */
  {149, 0},
  {9, 1},
  {2, 4},
  {2, 6},
  {5, 1},
  {153, 0},                                               /* End of row 315 */
  {150, 0},
  {9, 1},
  {2, 6},
  {5, 1},
  {154, 0},                                               /* End of row 316 */
  {151, 0},
  {7, 1},
  {2, 6},
  {5, 1},
  {155, 0},                                               /* End of row 317 */
  {152, 0},
  {12, 1},
  {156, 0},                                               /* End of row 318 */
  {153, 0},
  {10, 1},
  {157, 0},                                               /* End of row 319 */
  {154, 0},
  {8, 1},
  {158, 0},                                               /* End of row 320 */
};
#endif /* CONFIG_VIDEO_FB_SPLASHSCREEN_BPP24 */

#ifdef CONFIG_VIDEO_FB_SPLASHSCREEN_GREY
static const struct splscr_bitmap_s bitmap[] =
{
  {154, 0},
  {2, 156},
  {10, 74},
  {154, 0},                                               /* End of row   1 */
  {153, 0},
  {2, 156},
  {12, 74},
  {153, 0},                                               /* End of row   2 */
  {152, 0},
  {2, 156},
  {14, 74},
  {152, 0},                                               /* End of row   3 */
  {151, 0},
  {2, 156},
  {16, 74},
  {151, 0},                                               /* End of row   4 */
  {150, 0},
  {2, 156},
  {6, 74},
  {3, 51},
  {9, 74},
  {150, 0},                                               /* End of row   5 */
  {149, 0},
  {2, 156},
  {6, 74},
  {5, 51},
  {9, 74},
  {149, 0},                                               /* End of row   6 */
  {148, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {3, 156},
  {2, 51},
  {9, 74},
  {148, 0},                                               /* End of row   7 */
  {147, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {3, 74},
  {2, 51},
  {9, 74},
  {147, 0},                                               /* End of row   8 */
  {146, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {2, 51},
  {9, 74},
  {146, 0},                                               /* End of row   9 */
  {145, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {7, 74},
  {2, 51},
  {9, 74},
  {145, 0},                                               /* End of row  10 */
  {144, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {9, 74},
  {2, 51},
  {9, 74},
  {144, 0},                                               /* End of row  11 */
  {143, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {11, 74},
  {2, 51},
  {9, 74},
  {143, 0},                                               /* End of row  12 */
  {142, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {13, 74},
  {2, 51},
  {9, 74},
  {142, 0},                                               /* End of row  13 */
  {141, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {15, 74},
  {2, 51},
  {9, 74},
  {141, 0},                                               /* End of row  14 */
  {140, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {17, 74},
  {2, 51},
  {9, 74},
  {140, 0},                                               /* End of row  15 */
  {139, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {19, 74},
  {2, 51},
  {9, 74},
  {139, 0},                                               /* End of row  16 */
  {138, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {21, 74},
  {2, 51},
  {9, 74},
  {138, 0},                                               /* End of row  17 */
  {137, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {23, 74},
  {2, 51},
  {9, 74},
  {137, 0},                                               /* End of row  18 */
  {136, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {25, 74},
  {2, 51},
  {9, 74},
  {136, 0},                                               /* End of row  19 */
  {135, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {27, 74},
  {2, 51},
  {9, 74},
  {135, 0},                                               /* End of row  20 */
  {134, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {29, 74},
  {2, 51},
  {9, 74},
  {134, 0},                                               /* End of row  21 */
  {133, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {31, 74},
  {2, 51},
  {9, 74},
  {133, 0},                                               /* End of row  22 */
  {132, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {33, 74},
  {2, 51},
  {9, 74},
  {132, 0},                                               /* End of row  23 */
  {131, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {35, 74},
  {2, 51},
  {9, 74},
  {131, 0},                                               /* End of row  24 */
  {130, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {37, 74},
  {2, 51},
  {9, 74},
  {130, 0},                                               /* End of row  25 */
  {129, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {39, 74},
  {2, 51},
  {9, 74},
  {129, 0},                                               /* End of row  26 */
  {128, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {41, 74},
  {2, 51},
  {9, 74},
  {128, 0},                                               /* End of row  27 */
  {127, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {43, 74},
  {2, 51},
  {9, 74},
  {127, 0},                                               /* End of row  28 */
  {126, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {45, 74},
  {2, 51},
  {9, 74},
  {126, 0},                                               /* End of row  29 */
  {125, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {47, 74},
  {2, 51},
  {9, 74},
  {125, 0},                                               /* End of row  30 */
  {124, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {49, 74},
  {2, 51},
  {9, 74},
  {124, 0},                                               /* End of row  31 */
  {123, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {51, 74},
  {2, 51},
  {9, 74},
  {123, 0},                                               /* End of row  32 */
  {122, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {53, 74},
  {2, 51},
  {9, 74},
  {122, 0},                                               /* End of row  33 */
  {121, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {55, 74},
  {2, 51},
  {9, 74},
  {121, 0},                                               /* End of row  34 */
  {120, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {57, 74},
  {2, 51},
  {9, 74},
  {120, 0},                                               /* End of row  35 */
  {119, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {59, 74},
  {2, 51},
  {9, 74},
  {119, 0},                                               /* End of row  36 */
  {118, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {61, 74},
  {2, 51},
  {9, 74},
  {56, 0},
  {10, 222},
  {52, 0},                                                /* End of row  37 */
  {117, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {63, 74},
  {2, 51},
  {9, 74},
  {53, 0},
  {14, 222},
  {50, 0},                                                /* End of row  38 */
  {116, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {65, 74},
  {2, 51},
  {9, 74},
  {50, 0},
  {18, 222},
  {48, 0},                                                /* End of row  39 */
  {115, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {67, 74},
  {2, 51},
  {9, 74},
  {48, 0},
  {20, 222},
  {47, 0},                                                /* End of row  40 */
  {114, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {24, 74},
  {10, 222},
  {35, 74},
  {2, 51},
  {9, 74},
  {46, 0},
  {22, 222},
  {46, 0},                                                /* End of row  41 */
  {113, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {23, 74},
  {14, 222},
  {34, 74},
  {2, 51},
  {9, 74},
  {45, 0},
  {23, 222},
  {45, 0},                                                /* End of row  42 */
  {48, 0},
  {11, 222},
  {53, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {23, 74},
  {17, 222},
  {33, 74},
  {2, 51},
  {9, 74},
  {43, 0},
  {25, 222},
  {44, 0},                                                /* End of row  43 */
  {46, 0},
  {14, 222},
  {51, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {23, 74},
  {19, 222},
  {33, 74},
  {2, 51},
  {9, 74},
  {42, 0},
  {26, 222},
  {43, 0},                                                /* End of row  44 */
  {44, 0},
  {18, 222},
  {48, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {23, 74},
  {21, 222},
  {33, 74},
  {2, 51},
  {9, 74},
  {40, 0},
  {28, 222},
  {42, 0},                                                /* End of row  45 */
  {43, 0},
  {20, 222},
  {46, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {23, 74},
  {23, 222},
  {33, 74},
  {2, 51},
  {9, 74},
  {39, 0},
  {28, 222},
  {42, 0},                                                /* End of row  46 */
  {42, 0},
  {22, 222},
  {44, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {23, 74},
  {25, 222},
  {8, 51},
  {25, 74},
  {2, 51},
  {9, 74},
  {37, 0},
  {30, 222},
  {41, 0},                                                /* End of row  47 */
  {42, 0},
  {23, 222},
  {42, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {24, 74},
  {26, 222},
  {9, 51},
  {24, 74},
  {2, 51},
  {9, 74},
  {36, 0},
  {14, 222},
  {2, 255},
  {14, 222},
  {41, 0},                                                /* End of row  48 */
  {41, 0},
  {25, 222},
  {1, 0},
  {9, 137},
  {30, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {24, 74},
  {28, 222},
  {9, 51},
  {24, 74},
  {2, 51},
  {9, 74},
  {34, 0},
  {12, 222},
  {8, 255},
  {12, 222},
  {2, 137},
  {38, 0},                                                /* End of row  49 */
  {40, 0},
  {27, 222},
  {11, 137},
  {27, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {25, 74},
  {28, 222},
  {10, 51},
  {24, 74},
  {2, 51},
  {9, 74},
  {33, 0},
  {11, 222},
  {10, 255},
  {11, 222},
  {3, 137},
  {37, 0},                                                /* End of row  50 */
  {39, 0},
  {29, 222},
  {12, 137},
  {24, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {25, 74},
  {11, 222},
  {6, 255},
  {13, 222},
  {10, 51},
  {24, 74},
  {2, 51},
  {9, 74},
  {31, 0},
  {11, 222},
  {12, 255},
  {11, 222},
  {3, 137},
  {36, 0},                                                /* End of row  51 */
  {39, 0},
  {29, 222},
  {12, 137},
  {23, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {26, 74},
  {10, 222},
  {8, 255},
  {12, 222},
  {11, 51},
  {24, 74},
  {2, 51},
  {9, 74},
  {30, 0},
  {11, 222},
  {12, 255},
  {11, 222},
  {4, 137},
  {35, 0},                                                /* End of row  52 */
  {38, 0},
  {31, 222},
  {12, 137},
  {21, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {27, 74},
  {10, 222},
  {9, 255},
  {12, 222},
  {11, 51},
  {24, 74},
  {2, 51},
  {9, 74},
  {28, 0},
  {11, 222},
  {14, 255},
  {10, 222},
  {5, 137},
  {34, 0},                                                /* End of row  53 */
  {38, 0},
  {12, 222},
  {5, 255},
  {14, 222},
  {12, 137},
  {20, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {27, 74},
  {10, 222},
  {11, 255},
  {11, 222},
  {12, 51},
  {24, 74},
  {2, 51},
  {9, 74},
  {27, 0},
  {11, 222},
  {14, 255},
  {10, 222},
  {6, 137},
  {33, 0},                                                /* End of row  54 */
  {37, 0},
  {11, 222},
  {8, 255},
  {14, 222},
  {12, 137},
  {18, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {28, 74},
  {10, 222},
  {12, 255},
  {11, 222},
  {12, 51},
  {24, 74},
  {2, 51},
  {9, 74},
  {25, 0},
  {11, 222},
  {15, 255},
  {10, 222},
  {7, 137},
  {32, 0},                                                /* End of row  55 */
  {37, 0},
  {10, 222},
  {10, 255},
  {13, 222},
  {12, 137},
  {17, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {29, 74},
  {9, 222},
  {13, 255},
  {11, 222},
  {12, 51},
  {25, 74},
  {2, 51},
  {9, 74},
  {24, 0},
  {11, 222},
  {15, 255},
  {10, 222},
  {7, 137},
  {32, 0},                                                /* End of row  56 */
  {36, 0},
  {10, 222},
  {11, 255},
  {14, 222},
  {12, 137},
  {15, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {30, 74},
  {9, 222},
  {14, 255},
  {11, 222},
  {12, 51},
  {25, 74},
  {2, 51},
  {9, 74},
  {22, 0},
  {11, 222},
  {15, 255},
  {11, 222},
  {8, 137},
  {31, 0},                                                /* End of row  57 */
  {36, 0},
  {10, 222},
  {12, 255},
  {13, 222},
  {12, 137},
  {14, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {31, 74},
  {9, 222},
  {14, 255},
  {11, 222},
  {12, 51},
  {26, 74},
  {2, 51},
  {9, 74},
  {21, 0},
  {11, 222},
  {15, 255},
  {11, 222},
  {8, 137},
  {31, 0},                                                /* End of row  58 */
  {36, 0},
  {9, 222},
  {14, 255},
  {13, 222},
  {12, 137},
  {12, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {32, 74},
  {8, 222},
  {16, 255},
  {11, 222},
  {12, 51},
  {26, 74},
  {2, 51},
  {9, 74},
  {19, 0},
  {11, 222},
  {15, 255},
  {11, 222},
  {10, 137},
  {30, 0},                                                /* End of row  59 */
  {36, 0},
  {9, 222},
  {14, 255},
  {13, 222},
  {12, 137},
  {11, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {33, 74},
  {8, 222},
  {16, 255},
  {11, 222},
  {12, 51},
  {27, 74},
  {2, 51},
  {9, 74},
  {18, 0},
  {11, 222},
  {15, 255},
  {11, 222},
  {10, 137},
  {30, 0},                                                /* End of row  60 */
  {36, 0},
  {8, 222},
  {16, 255},
  {13, 222},
  {12, 137},
  {9, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {34, 74},
  {8, 222},
  {17, 255},
  {11, 222},
  {12, 51},
  {27, 74},
  {2, 51},
  {9, 74},
  {16, 0},
  {11, 222},
  {15, 255},
  {11, 222},
  {11, 137},
  {30, 0},                                                /* End of row  61 */
  {36, 0},
  {8, 222},
  {16, 255},
  {13, 222},
  {12, 137},
  {8, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {35, 74},
  {8, 222},
  {17, 255},
  {11, 222},
  {12, 51},
  {28, 74},
  {2, 51},
  {9, 74},
  {15, 0},
  {11, 222},
  {15, 255},
  {11, 222},
  {12, 137},
  {29, 0},                                                /* End of row  62 */
  {36, 0},
  {8, 222},
  {17, 255},
  {13, 222},
  {12, 137},
  {6, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {36, 74},
  {8, 222},
  {18, 255},
  {11, 222},
  {12, 51},
  {28, 74},
  {2, 51},
  {9, 74},
  {13, 0},
  {11, 222},
  {15, 255},
  {11, 222},
  {13, 137},
  {29, 0},                                                /* End of row  63 */
  {36, 0},
  {8, 222},
  {17, 255},
  {13, 222},
  {12, 137},
  {5, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {37, 74},
  {8, 222},
  {18, 255},
  {11, 222},
  {12, 51},
  {29, 74},
  {2, 51},
  {9, 74},
  {12, 0},
  {11, 222},
  {15, 255},
  {11, 222},
  {13, 137},
  {29, 0},                                                /* End of row  64 */
  {36, 0},
  {8, 222},
  {18, 255},
  {13, 222},
  {12, 137},
  {3, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {38, 74},
  {8, 222},
  {19, 255},
  {11, 222},
  {12, 51},
  {29, 74},
  {2, 51},
  {9, 74},
  {10, 0},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {29, 0},                                                /* End of row  65 */
  {36, 0},
  {8, 222},
  {18, 255},
  {13, 222},
  {12, 137},
  {2, 0},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {39, 74},
  {8, 222},
  {19, 255},
  {11, 222},
  {12, 51},
  {30, 74},
  {2, 51},
  {9, 74},
  {9, 0},
  {11, 222},
  {15, 255},
  {11, 222},
  {13, 137},
  {30, 0},                                                /* End of row  66 */
  {36, 0},
  {8, 222},
  {19, 255},
  {13, 222},
  {12, 137},
  {2, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {40, 74},
  {8, 222},
  {20, 255},
  {11, 222},
  {12, 51},
  {30, 74},
  {2, 51},
  {9, 74},
  {7, 0},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {30, 0},                                                /* End of row  67 */
  {36, 0},
  {8, 222},
  {19, 255},
  {13, 222},
  {11, 137},
  {1, 51},
  {1, 156},
  {6, 74},
  {2, 51},
  {2, 156},
  {41, 74},
  {8, 222},
  {20, 255},
  {11, 222},
  {12, 51},
  {31, 74},
  {2, 51},
  {9, 74},
  {6, 0},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {30, 0},                                                /* End of row  68 */
  {36, 0},
  {8, 222},
  {20, 255},
  {13, 222},
  {9, 137},
  {3, 51},
  {5, 74},
  {2, 51},
  {2, 156},
  {42, 74},
  {8, 222},
  {21, 255},
  {11, 222},
  {12, 51},
  {31, 74},
  {2, 51},
  {9, 74},
  {4, 0},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {31, 0},                                                /* End of row  69 */
  {36, 0},
  {8, 222},
  {20, 255},
  {13, 222},
  {8, 137},
  {4, 51},
  {4, 74},
  {2, 51},
  {2, 156},
  {43, 74},
  {8, 222},
  {21, 255},
  {11, 222},
  {12, 51},
  {32, 74},
  {2, 51},
  {9, 74},
  {3, 0},
  {11, 222},
  {15, 255},
  {10, 222},
  {15, 137},
  {31, 0},                                                /* End of row  70 */
  {36, 0},
  {8, 222},
  {21, 255},
  {13, 222},
  {6, 137},
  {6, 51},
  {2, 74},
  {2, 51},
  {2, 156},
  {44, 74},
  {8, 222},
  {22, 255},
  {11, 222},
  {12, 51},
  {32, 74},
  {2, 51},
  {9, 74},
  {1, 0},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {32, 0},                                                /* End of row  71 */
  {36, 0},
  {8, 222},
  {21, 255},
  {13, 222},
  {5, 137},
  {7, 51},
  {1, 74},
  {2, 51},
  {2, 156},
  {45, 74},
  {8, 222},
  {22, 255},
  {11, 222},
  {12, 51},
  {33, 74},
  {2, 51},
  {9, 74},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {32, 0},                                                /* End of row  72 */
  {36, 0},
  {8, 222},
  {22, 255},
  {13, 222},
  {3, 137},
  {10, 51},
  {2, 156},
  {46, 74},
  {8, 222},
  {23, 255},
  {11, 222},
  {12, 51},
  {33, 74},
  {2, 51},
  {7, 74},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {33, 0},                                                /* End of row  73 */
  {36, 0},
  {8, 222},
  {22, 255},
  {13, 222},
  {2, 137},
  {11, 51},
  {1, 156},
  {47, 74},
  {8, 222},
  {23, 255},
  {11, 222},
  {12, 51},
  {34, 74},
  {2, 51},
  {6, 74},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {33, 0},                                                /* End of row  74 */
  {36, 0},
  {8, 222},
  {23, 255},
  {13, 222},
  {12, 51},
  {48, 74},
  {8, 222},
  {24, 255},
  {11, 222},
  {12, 51},
  {34, 74},
  {2, 51},
  {4, 74},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {34, 0},                                                /* End of row  75 */
  {36, 0},
  {8, 222},
  {23, 255},
  {13, 222},
  {13, 51},
  {47, 74},
  {8, 222},
  {24, 255},
  {11, 222},
  {12, 51},
  {35, 74},
  {2, 51},
  {3, 74},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {34, 0},                                                /* End of row  76 */
  {36, 0},
  {8, 222},
  {24, 255},
  {13, 222},
  {12, 51},
  {47, 74},
  {8, 222},
  {25, 255},
  {11, 222},
  {12, 51},
  {35, 74},
  {2, 51},
  {1, 74},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {35, 0},                                                /* End of row  77 */
  {36, 0},
  {8, 222},
  {24, 255},
  {13, 222},
  {12, 51},
  {47, 74},
  {8, 222},
  {25, 255},
  {11, 222},
  {12, 51},
  {36, 74},
  {2, 51},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {35, 0},                                                /* End of row  78 */
  {36, 0},
  {8, 222},
  {25, 255},
  {13, 222},
  {12, 51},
  {46, 74},
  {8, 222},
  {26, 255},
  {11, 222},
  {12, 51},
  {36, 74},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {36, 0},                                                /* End of row  79 */
  {36, 0},
  {8, 222},
  {25, 255},
  {13, 222},
  {12, 51},
  {46, 74},
  {8, 222},
  {26, 255},
  {11, 222},
  {12, 51},
  {36, 74},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {36, 0},                                                /* End of row  80 */
  {36, 0},
  {8, 222},
  {26, 255},
  {13, 222},
  {12, 51},
  {45, 74},
  {8, 222},
  {27, 255},
  {11, 222},
  {12, 51},
  {34, 74},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {37, 0},                                                /* End of row  81 */
  {36, 0},
  {8, 222},
  {26, 255},
  {13, 222},
  {12, 51},
  {45, 74},
  {8, 222},
  {27, 255},
  {11, 222},
  {12, 51},
  {34, 74},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {37, 0},                                                /* End of row  82 */
  {36, 0},
  {8, 222},
  {27, 255},
  {13, 222},
  {12, 51},
  {44, 74},
  {8, 222},
  {28, 255},
  {11, 222},
  {12, 51},
  {32, 74},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {38, 0},                                                /* End of row  83 */
  {36, 0},
  {8, 222},
  {27, 255},
  {13, 222},
  {12, 51},
  {44, 74},
  {8, 222},
  {28, 255},
  {11, 222},
  {12, 51},
  {32, 74},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {38, 0},                                                /* End of row  84 */
  {36, 0},
  {8, 222},
  {28, 255},
  {13, 222},
  {12, 51},
  {43, 74},
  {8, 222},
  {29, 255},
  {11, 222},
  {12, 51},
  {30, 74},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {39, 0},                                                /* End of row  85 */
  {36, 0},
  {8, 222},
  {28, 255},
  {13, 222},
  {12, 51},
  {43, 74},
  {8, 222},
  {29, 255},
  {11, 222},
  {12, 51},
  {30, 74},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {39, 0},                                                /* End of row  86 */
  {36, 0},
  {8, 222},
  {29, 255},
  {13, 222},
  {12, 51},
  {42, 74},
  {8, 222},
  {14, 255},
  {1, 222},
  {15, 255},
  {11, 222},
  {12, 51},
  {28, 74},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {40, 0},                                                /* End of row  87 */
  {36, 0},
  {8, 222},
  {29, 255},
  {13, 222},
  {12, 51},
  {42, 74},
  {8, 222},
  {14, 255},
  {1, 222},
  {15, 255},
  {11, 222},
  {12, 51},
  {28, 74},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {40, 0},                                                /* End of row  88 */
  {36, 0},
  {8, 222},
  {30, 255},
  {13, 222},
  {12, 51},
  {41, 74},
  {8, 222},
  {14, 255},
  {2, 222},
  {15, 255},
  {11, 222},
  {12, 51},
  {26, 74},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {41, 0},                                                /* End of row  89 */
  {36, 0},
  {8, 222},
  {30, 255},
  {13, 222},
  {12, 51},
  {41, 74},
  {8, 222},
  {14, 255},
  {2, 222},
  {15, 255},
  {11, 222},
  {12, 51},
  {26, 74},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {41, 0},                                                /* End of row  90 */
  {36, 0},
  {8, 222},
  {16, 255},
  {1, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {40, 74},
  {8, 222},
  {14, 255},
  {3, 222},
  {15, 255},
  {11, 222},
  {12, 51},
  {24, 74},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {42, 0},                                                /* End of row  91 */
  {36, 0},
  {8, 222},
  {16, 255},
  {1, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {40, 74},
  {8, 222},
  {14, 255},
  {3, 222},
  {15, 255},
  {11, 222},
  {12, 51},
  {24, 74},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {42, 0},                                                /* End of row  92 */
  {36, 0},
  {8, 222},
  {16, 255},
  {2, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {39, 74},
  {8, 222},
  {14, 255},
  {4, 222},
  {15, 255},
  {11, 222},
  {12, 51},
  {22, 74},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {43, 0},                                                /* End of row  93 */
  {36, 0},
  {8, 222},
  {16, 255},
  {2, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {39, 74},
  {8, 222},
  {14, 255},
  {4, 222},
  {15, 255},
  {11, 222},
  {12, 51},
  {22, 74},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {43, 0},                                                /* End of row  94 */
  {36, 0},
  {8, 222},
  {16, 255},
  {3, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {38, 74},
  {8, 222},
  {14, 255},
  {5, 222},
  {15, 255},
  {11, 222},
  {12, 51},
  {20, 74},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {44, 0},                                                /* End of row  95 */
  {36, 0},
  {8, 222},
  {16, 255},
  {3, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {38, 74},
  {8, 222},
  {14, 255},
  {5, 222},
  {15, 255},
  {11, 222},
  {12, 51},
  {20, 74},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {44, 0},                                                /* End of row  96 */
  {36, 0},
  {8, 222},
  {16, 255},
  {4, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {37, 74},
  {8, 222},
  {14, 255},
  {6, 222},
  {15, 255},
  {11, 222},
  {12, 51},
  {18, 74},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {45, 0},                                                /* End of row  97 */
  {36, 0},
  {8, 222},
  {16, 255},
  {4, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {37, 74},
  {8, 222},
  {14, 255},
  {6, 222},
  {15, 255},
  {11, 222},
  {12, 51},
  {18, 74},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {45, 0},                                                /* End of row  98 */
  {36, 0},
  {8, 222},
  {16, 255},
  {5, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {36, 74},
  {8, 222},
  {14, 255},
  {7, 222},
  {15, 255},
  {11, 222},
  {12, 51},
  {16, 74},
  {11, 222},
  {15, 255},
  {11, 222},
  {2, 51},
  {12, 137},
  {46, 0},                                                /* End of row  99 */
  {36, 0},
  {8, 222},
  {16, 255},
  {5, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {36, 74},
  {8, 222},
  {14, 255},
  {7, 222},
  {15, 255},
  {11, 222},
  {12, 51},
  {16, 74},
  {11, 222},
  {15, 255},
  {11, 222},
  {3, 51},
  {11, 137},
  {46, 0},                                                /* End of row 100 */
  {36, 0},
  {8, 222},
  {16, 255},
  {6, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {35, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {15, 255},
  {11, 222},
  {12, 51},
  {14, 74},
  {11, 222},
  {15, 255},
  {11, 222},
  {5, 51},
  {9, 137},
  {47, 0},                                                /* End of row 101 */
  {36, 0},
  {8, 222},
  {16, 255},
  {6, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {35, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {15, 255},
  {11, 222},
  {12, 51},
  {14, 74},
  {11, 222},
  {15, 255},
  {11, 222},
  {6, 51},
  {8, 137},
  {47, 0},                                                /* End of row 102 */
  {36, 0},
  {8, 222},
  {16, 255},
  {7, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {34, 74},
  {8, 222},
  {14, 255},
  {9, 222},
  {15, 255},
  {11, 222},
  {12, 51},
  {12, 74},
  {11, 222},
  {15, 255},
  {11, 222},
  {8, 51},
  {6, 137},
  {48, 0},                                                /* End of row 103 */
  {36, 0},
  {8, 222},
  {16, 255},
  {7, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {34, 74},
  {8, 222},
  {14, 255},
  {9, 222},
  {15, 255},
  {11, 222},
  {12, 51},
  {12, 74},
  {11, 222},
  {15, 255},
  {11, 222},
  {9, 51},
  {5, 137},
  {48, 0},                                                /* End of row 104 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {33, 74},
  {8, 222},
  {14, 255},
  {10, 222},
  {15, 255},
  {11, 222},
  {12, 51},
  {10, 74},
  {11, 222},
  {15, 255},
  {11, 222},
  {11, 51},
  {3, 137},
  {49, 0},                                                /* End of row 105 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {33, 74},
  {8, 222},
  {14, 255},
  {10, 222},
  {15, 255},
  {11, 222},
  {12, 51},
  {10, 74},
  {11, 222},
  {15, 255},
  {11, 222},
  {12, 51},
  {2, 137},
  {49, 0},                                                /* End of row 106 */
  {36, 0},
  {8, 222},
  {16, 255},
  {9, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {32, 74},
  {8, 222},
  {14, 255},
  {11, 222},
  {15, 255},
  {11, 222},
  {12, 51},
  {8, 74},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 51},
  {50, 0},                                                /* End of row 107 */
  {36, 0},
  {8, 222},
  {16, 255},
  {9, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {32, 74},
  {8, 222},
  {14, 255},
  {11, 222},
  {15, 255},
  {11, 222},
  {12, 51},
  {8, 74},
  {11, 222},
  {15, 255},
  {11, 222},
  {15, 51},
  {49, 0},                                                /* End of row 108 */
  {36, 0},
  {8, 222},
  {16, 255},
  {10, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {31, 74},
  {8, 222},
  {14, 255},
  {12, 222},
  {15, 255},
  {11, 222},
  {12, 51},
  {6, 74},
  {11, 222},
  {15, 255},
  {11, 222},
  {15, 51},
  {2, 74},
  {48, 0},                                                /* End of row 109 */
  {36, 0},
  {8, 222},
  {16, 255},
  {10, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {31, 74},
  {8, 222},
  {14, 255},
  {12, 222},
  {15, 255},
  {11, 222},
  {12, 51},
  {6, 74},
  {11, 222},
  {15, 255},
  {11, 222},
  {15, 51},
  {3, 74},
  {47, 0},                                                /* End of row 110 */
  {36, 0},
  {8, 222},
  {16, 255},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {30, 74},
  {8, 222},
  {14, 255},
  {13, 222},
  {15, 255},
  {11, 222},
  {12, 51},
  {4, 74},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 51},
  {6, 74},
  {46, 0},                                                /* End of row 111 */
  {36, 0},
  {8, 222},
  {16, 255},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {30, 74},
  {8, 222},
  {14, 255},
  {13, 222},
  {15, 255},
  {11, 222},
  {12, 51},
  {4, 74},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 51},
  {7, 74},
  {45, 0},                                                /* End of row 112 */
  {36, 0},
  {8, 222},
  {16, 255},
  {12, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {29, 74},
  {8, 222},
  {14, 255},
  {14, 222},
  {15, 255},
  {11, 222},
  {12, 51},
  {2, 74},
  {11, 222},
  {15, 255},
  {11, 222},
  {16, 51},
  {7, 74},
  {44, 0},                                                /* End of row 113 */
  {36, 0},
  {8, 222},
  {16, 255},
  {12, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {29, 74},
  {8, 222},
  {14, 255},
  {14, 222},
  {15, 255},
  {11, 222},
  {12, 51},
  {2, 74},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 51},
  {1, 74},
  {2, 51},
  {7, 74},
  {43, 0},                                                /* End of row 114 */
  {36, 0},
  {8, 222},
  {16, 255},
  {13, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {28, 74},
  {8, 222},
  {14, 255},
  {15, 222},
  {15, 255},
  {11, 222},
  {12, 51},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 51},
  {3, 74},
  {2, 51},
  {7, 74},
  {42, 0},                                                /* End of row 115 */
  {36, 0},
  {8, 222},
  {16, 255},
  {13, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {28, 74},
  {8, 222},
  {14, 255},
  {15, 222},
  {15, 255},
  {11, 222},
  {12, 51},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 51},
  {4, 74},
  {2, 51},
  {7, 74},
  {41, 0},                                                /* End of row 116 */
  {36, 0},
  {8, 222},
  {16, 255},
  {14, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {27, 74},
  {8, 222},
  {14, 255},
  {16, 222},
  {15, 255},
  {11, 222},
  {10, 51},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 51},
  {6, 74},
  {2, 51},
  {7, 74},
  {40, 0},                                                /* End of row 117 */
  {36, 0},
  {8, 222},
  {16, 255},
  {14, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {27, 74},
  {8, 222},
  {14, 255},
  {16, 222},
  {15, 255},
  {11, 222},
  {10, 51},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 51},
  {7, 74},
  {2, 51},
  {7, 74},
  {39, 0},                                                /* End of row 118 */
  {36, 0},
  {8, 222},
  {16, 255},
  {15, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {26, 74},
  {8, 222},
  {14, 255},
  {17, 222},
  {15, 255},
  {11, 222},
  {8, 51},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 51},
  {9, 74},
  {2, 51},
  {7, 74},
  {38, 0},                                                /* End of row 119 */
  {35, 0},
  {1, 156},
  {8, 222},
  {16, 255},
  {15, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {26, 74},
  {8, 222},
  {14, 255},
  {17, 222},
  {15, 255},
  {11, 222},
  {8, 51},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 51},
  {10, 74},
  {2, 51},
  {7, 74},
  {37, 0},                                                /* End of row 120 */
  {34, 0},
  {2, 156},
  {8, 222},
  {16, 255},
  {16, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {25, 74},
  {8, 222},
  {14, 255},
  {18, 222},
  {15, 255},
  {11, 222},
  {6, 51},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 51},
  {12, 74},
  {2, 51},
  {7, 74},
  {36, 0},                                                /* End of row 121 */
  {33, 0},
  {2, 156},
  {1, 74},
  {8, 222},
  {16, 255},
  {16, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {25, 74},
  {8, 222},
  {14, 255},
  {18, 222},
  {15, 255},
  {11, 222},
  {6, 51},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 51},
  {13, 74},
  {2, 51},
  {7, 74},
  {35, 0},                                                /* End of row 122 */
  {32, 0},
  {2, 156},
  {2, 74},
  {8, 222},
  {16, 255},
  {17, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {24, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {1, 51},
  {10, 222},
  {15, 255},
  {11, 222},
  {4, 51},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 51},
  {15, 74},
  {2, 51},
  {7, 74},
  {34, 0},                                                /* End of row 123 */
  {31, 0},
  {2, 156},
  {3, 74},
  {8, 222},
  {16, 255},
  {17, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {24, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {1, 51},
  {10, 222},
  {15, 255},
  {11, 222},
  {4, 51},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 51},
  {16, 74},
  {2, 51},
  {7, 74},
  {33, 0},                                                /* End of row 124 */
  {30, 0},
  {2, 156},
  {4, 74},
  {8, 222},
  {16, 255},
  {18, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {23, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {2, 51},
  {10, 222},
  {15, 255},
  {11, 222},
  {2, 51},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 51},
  {18, 74},
  {2, 51},
  {7, 74},
  {32, 0},                                                /* End of row 125 */
  {29, 0},
  {2, 156},
  {5, 74},
  {8, 222},
  {16, 255},
  {18, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {23, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {2, 51},
  {10, 222},
  {15, 255},
  {11, 222},
  {2, 51},
  {11, 222},
  {15, 255},
  {11, 222},
  {14, 51},
  {19, 74},
  {2, 51},
  {7, 74},
  {31, 0},                                                /* End of row 126 */
  {28, 0},
  {2, 156},
  {5, 74},
  {1, 51},
  {8, 222},
  {16, 255},
  {19, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {22, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {3, 51},
  {10, 222},
  {15, 255},
  {22, 222},
  {15, 255},
  {11, 222},
  {14, 51},
  {21, 74},
  {2, 51},
  {7, 74},
  {30, 0},                                                /* End of row 127 */
  {27, 0},
  {2, 156},
  {5, 74},
  {2, 51},
  {8, 222},
  {16, 255},
  {19, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {22, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {3, 51},
  {10, 222},
  {15, 255},
  {22, 222},
  {15, 255},
  {11, 222},
  {14, 51},
  {22, 74},
  {2, 51},
  {7, 74},
  {29, 0},                                                /* End of row 128 */
  {26, 0},
  {2, 156},
  {5, 74},
  {2, 51},
  {1, 156},
  {8, 222},
  {16, 255},
  {8, 222},
  {1, 51},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {21, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {4, 51},
  {10, 222},
  {15, 255},
  {20, 222},
  {15, 255},
  {11, 222},
  {14, 51},
  {24, 74},
  {2, 51},
  {7, 74},
  {28, 0},                                                /* End of row 129 */
  {25, 0},
  {2, 156},
  {5, 74},
  {2, 51},
  {2, 156},
  {8, 222},
  {16, 255},
  {8, 222},
  {1, 51},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {21, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {4, 51},
  {10, 222},
  {15, 255},
  {20, 222},
  {15, 255},
  {11, 222},
  {14, 51},
  {25, 74},
  {2, 51},
  {7, 74},
  {27, 0},                                                /* End of row 130 */
  {24, 0},
  {2, 156},
  {5, 74},
  {2, 51},
  {2, 156},
  {1, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {2, 51},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {20, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {5, 51},
  {10, 222},
  {15, 255},
  {18, 222},
  {15, 255},
  {11, 222},
  {14, 51},
  {27, 74},
  {2, 51},
  {7, 74},
  {26, 0},                                                /* End of row 131 */
  {23, 0},
  {2, 156},
  {5, 74},
  {2, 51},
  {2, 156},
  {2, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {2, 51},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {20, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {5, 51},
  {10, 222},
  {15, 255},
  {18, 222},
  {15, 255},
  {11, 222},
  {14, 51},
  {28, 74},
  {2, 51},
  {7, 74},
  {25, 0},                                                /* End of row 132 */
  {22, 0},
  {2, 156},
  {5, 74},
  {2, 51},
  {2, 156},
  {3, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {3, 51},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {19, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {6, 51},
  {10, 222},
  {15, 255},
  {16, 222},
  {15, 255},
  {11, 222},
  {14, 51},
  {30, 74},
  {2, 51},
  {7, 74},
  {24, 0},                                                /* End of row 133 */
  {21, 0},
  {2, 156},
  {5, 74},
  {2, 51},
  {2, 156},
  {4, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {3, 51},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {19, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {6, 51},
  {10, 222},
  {15, 255},
  {16, 222},
  {15, 255},
  {11, 222},
  {14, 51},
  {31, 74},
  {2, 51},
  {7, 74},
  {23, 0},                                                /* End of row 134 */
  {20, 0},
  {2, 156},
  {5, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {4, 51},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {18, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {7, 51},
  {10, 222},
  {15, 255},
  {14, 222},
  {15, 255},
  {11, 222},
  {14, 51},
  {33, 74},
  {2, 51},
  {7, 74},
  {22, 0},                                                /* End of row 135 */
  {19, 0},
  {2, 156},
  {5, 74},
  {2, 51},
  {2, 156},
  {6, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {4, 51},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {18, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {7, 51},
  {10, 222},
  {15, 255},
  {14, 222},
  {15, 255},
  {11, 222},
  {14, 51},
  {34, 74},
  {2, 51},
  {7, 74},
  {21, 0},                                                /* End of row 136 */
  {18, 0},
  {2, 156},
  {5, 74},
  {2, 51},
  {2, 156},
  {7, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {5, 51},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {17, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {8, 51},
  {10, 222},
  {15, 255},
  {12, 222},
  {15, 255},
  {11, 222},
  {14, 51},
  {36, 74},
  {2, 51},
  {7, 74},
  {20, 0},                                                /* End of row 137 */
  {17, 0},
  {2, 156},
  {5, 74},
  {2, 51},
  {2, 156},
  {8, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {5, 51},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {17, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {8, 51},
  {10, 222},
  {15, 255},
  {12, 222},
  {15, 255},
  {11, 222},
  {14, 51},
  {37, 74},
  {2, 51},
  {7, 74},
  {19, 0},                                                /* End of row 138 */
  {16, 0},
  {2, 156},
  {5, 74},
  {2, 51},
  {2, 156},
  {9, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {6, 51},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {16, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {9, 51},
  {10, 222},
  {15, 255},
  {10, 222},
  {15, 255},
  {11, 222},
  {14, 51},
  {39, 74},
  {2, 51},
  {7, 74},
  {18, 0},                                                /* End of row 139 */
  {15, 0},
  {2, 156},
  {5, 74},
  {2, 51},
  {2, 156},
  {10, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {6, 51},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {16, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {9, 51},
  {10, 222},
  {15, 255},
  {10, 222},
  {15, 255},
  {11, 222},
  {14, 51},
  {40, 74},
  {2, 51},
  {7, 74},
  {17, 0},                                                /* End of row 140 */
  {14, 0},
  {2, 156},
  {5, 74},
  {2, 51},
  {2, 156},
  {11, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {7, 51},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {15, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {10, 51},
  {10, 222},
  {15, 255},
  {8, 222},
  {15, 255},
  {11, 222},
  {14, 51},
  {42, 74},
  {2, 51},
  {7, 74},
  {16, 0},                                                /* End of row 141 */
  {13, 0},
  {2, 156},
  {5, 74},
  {2, 51},
  {2, 156},
  {12, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {7, 51},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {15, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {10, 51},
  {10, 222},
  {15, 255},
  {8, 222},
  {15, 255},
  {11, 222},
  {14, 51},
  {43, 74},
  {2, 51},
  {7, 74},
  {15, 0},                                                /* End of row 142 */
  {12, 0},
  {2, 156},
  {5, 74},
  {2, 51},
  {2, 156},
  {13, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {8, 51},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {14, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {11, 51},
  {10, 222},
  {15, 255},
  {6, 222},
  {15, 255},
  {11, 222},
  {14, 51},
  {45, 74},
  {2, 51},
  {7, 74},
  {14, 0},                                                /* End of row 143 */
  {11, 0},
  {2, 156},
  {5, 74},
  {2, 51},
  {2, 156},
  {14, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {8, 51},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {14, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {11, 51},
  {10, 222},
  {15, 255},
  {6, 222},
  {15, 255},
  {11, 222},
  {14, 51},
  {46, 74},
  {2, 51},
  {7, 74},
  {13, 0},                                                /* End of row 144 */
  {10, 0},
  {2, 156},
  {5, 74},
  {2, 51},
  {2, 156},
  {15, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {9, 51},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {13, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {12, 51},
  {10, 222},
  {15, 255},
  {4, 222},
  {15, 255},
  {11, 222},
  {14, 51},
  {48, 74},
  {2, 51},
  {7, 74},
  {12, 0},                                                /* End of row 145 */
  {9, 0},
  {2, 156},
  {5, 74},
  {2, 51},
  {2, 156},
  {16, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {9, 51},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {13, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {12, 51},
  {10, 222},
  {15, 255},
  {4, 222},
  {15, 255},
  {11, 222},
  {14, 51},
  {49, 74},
  {2, 51},
  {7, 74},
  {11, 0},                                                /* End of row 146 */
  {8, 0},
  {2, 156},
  {5, 74},
  {2, 51},
  {2, 156},
  {17, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {10, 51},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {12, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {13, 51},
  {10, 222},
  {15, 255},
  {2, 222},
  {15, 255},
  {11, 222},
  {14, 51},
  {51, 74},
  {2, 51},
  {7, 74},
  {10, 0},                                                /* End of row 147 */
  {7, 0},
  {2, 156},
  {5, 74},
  {2, 51},
  {2, 156},
  {18, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {10, 51},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {12, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {13, 51},
  {10, 222},
  {15, 255},
  {2, 222},
  {15, 255},
  {11, 222},
  {14, 51},
  {52, 74},
  {2, 51},
  {7, 74},
  {9, 0},                                                 /* End of row 148 */
  {6, 0},
  {2, 156},
  {5, 74},
  {2, 51},
  {2, 156},
  {19, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {11, 51},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {11, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {14, 51},
  {10, 222},
  {30, 255},
  {11, 222},
  {14, 51},
  {54, 74},
  {2, 51},
  {7, 74},
  {8, 0},                                                 /* End of row 149 */
  {5, 0},
  {2, 156},
  {5, 74},
  {2, 51},
  {2, 156},
  {20, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {11, 51},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {11, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {14, 51},
  {10, 222},
  {30, 255},
  {11, 222},
  {14, 51},
  {55, 74},
  {2, 51},
  {7, 74},
  {7, 0},                                                 /* End of row 150 */
  {4, 0},
  {2, 156},
  {5, 74},
  {2, 51},
  {2, 156},
  {21, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {12, 51},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {10, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {14, 51},
  {1, 74},
  {10, 222},
  {28, 255},
  {11, 222},
  {14, 51},
  {57, 74},
  {2, 51},
  {7, 74},
  {6, 0},                                                 /* End of row 151 */
  {3, 0},
  {2, 156},
  {5, 74},
  {2, 51},
  {2, 156},
  {22, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {12, 51},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {10, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {14, 51},
  {1, 74},
  {10, 222},
  {28, 255},
  {11, 222},
  {14, 51},
  {58, 74},
  {2, 51},
  {7, 74},
  {5, 0},                                                 /* End of row 152 */
  {2, 0},
  {2, 156},
  {5, 74},
  {2, 51},
  {2, 156},
  {23, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {13, 51},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {9, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {14, 51},
  {2, 74},
  {10, 222},
  {26, 255},
  {11, 222},
  {14, 51},
  {60, 74},
  {2, 51},
  {7, 74},
  {4, 0},                                                 /* End of row 153 */
  {1, 0},
  {2, 156},
  {5, 74},
  {2, 51},
  {2, 156},
  {24, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {13, 51},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {9, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {14, 51},
  {2, 74},
  {10, 222},
  {26, 255},
  {11, 222},
  {14, 51},
  {61, 74},
  {2, 51},
  {7, 74},
  {3, 0},                                                 /* End of row 154 */
  {2, 156},
  {5, 74},
  {2, 51},
  {2, 156},
  {25, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {8, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {14, 51},
  {3, 74},
  {10, 222},
  {24, 255},
  {11, 222},
  {14, 51},
  {63, 74},
  {2, 51},
  {7, 74},
  {2, 0},                                                 /* End of row 155 */
  {1, 156},
  {5, 74},
  {2, 51},
  {2, 156},
  {26, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {8, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {14, 51},
  {3, 74},
  {10, 222},
  {24, 255},
  {11, 222},
  {14, 51},
  {64, 74},
  {2, 51},
  {7, 74},
  {1, 0},                                                 /* End of row 156 */
  {5, 74},
  {2, 51},
  {2, 156},
  {27, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {1, 74},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {7, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {14, 51},
  {4, 74},
  {10, 222},
  {22, 255},
  {11, 222},
  {14, 51},
  {66, 74},
  {2, 51},
  {7, 74},                                                /* End of row 157 */
  {4, 74},
  {2, 51},
  {2, 156},
  {28, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {1, 74},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {7, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {14, 51},
  {4, 74},
  {10, 222},
  {22, 255},
  {11, 222},
  {14, 51},
  {67, 74},
  {2, 51},
  {6, 74},                                                /* End of row 158 */
  {3, 74},
  {2, 51},
  {2, 156},
  {29, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {2, 74},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {6, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {14, 51},
  {5, 74},
  {10, 222},
  {20, 255},
  {11, 222},
  {14, 51},
  {69, 74},
  {2, 51},
  {5, 74},                                                /* End of row 159 */
  {3, 74},
  {2, 51},
  {1, 156},
  {30, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {2, 74},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {6, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {14, 51},
  {5, 74},
  {10, 222},
  {20, 255},
  {11, 222},
  {14, 51},
  {70, 74},
  {2, 51},
  {4, 74},                                                /* End of row 160 */
  {4, 74},
  {2, 51},
  {30, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {3, 74},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {5, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {14, 51},
  {5, 74},
  {11, 222},
  {19, 255},
  {10, 222},
  {14, 51},
  {72, 74},
  {3, 51},
  {2, 74},                                                /* End of row 161 */
  {5, 74},
  {2, 51},
  {29, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {3, 74},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {5, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {14, 51},
  {5, 74},
  {11, 222},
  {18, 255},
  {11, 222},
  {14, 51},
  {72, 74},
  {3, 51},
  {2, 74},                                                /* End of row 162 */
  {6, 74},
  {2, 51},
  {28, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {4, 74},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {4, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {14, 51},
  {4, 74},
  {11, 222},
  {19, 255},
  {10, 222},
  {14, 51},
  {72, 74},
  {2, 51},
  {2, 156},
  {2, 74},                                                /* End of row 163 */
  {7, 74},
  {2, 51},
  {27, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {4, 74},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {4, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {14, 51},
  {4, 74},
  {11, 222},
  {18, 255},
  {11, 222},
  {14, 51},
  {71, 74},
  {2, 51},
  {2, 156},
  {3, 74},                                                /* End of row 164 */
  {8, 74},
  {2, 51},
  {26, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {5, 74},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {3, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {14, 51},
  {3, 74},
  {11, 222},
  {20, 255},
  {11, 222},
  {13, 51},
  {70, 74},
  {2, 51},
  {2, 156},
  {4, 74},                                                /* End of row 165 */
  {9, 74},
  {2, 51},
  {25, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {5, 74},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {3, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {14, 51},
  {3, 74},
  {11, 222},
  {20, 255},
  {11, 222},
  {13, 51},
  {69, 74},
  {2, 51},
  {2, 156},
  {5, 74},                                                /* End of row 166 */
  {1, 0},
  {9, 74},
  {2, 51},
  {24, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {6, 74},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {2, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {14, 51},
  {2, 74},
  {11, 222},
  {22, 255},
  {11, 222},
  {13, 51},
  {67, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {1, 0},                                                 /* End of row 167 */
  {2, 0},
  {9, 74},
  {2, 51},
  {23, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {6, 74},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {2, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {14, 51},
  {2, 74},
  {11, 222},
  {22, 255},
  {11, 222},
  {13, 51},
  {66, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {2, 0},                                                 /* End of row 168 */
  {3, 0},
  {9, 74},
  {2, 51},
  {22, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {7, 74},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {1, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {14, 51},
  {1, 74},
  {11, 222},
  {24, 255},
  {11, 222},
  {13, 51},
  {64, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {3, 0},                                                 /* End of row 169 */
  {4, 0},
  {9, 74},
  {2, 51},
  {21, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {7, 74},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {1, 74},
  {8, 222},
  {14, 255},
  {8, 222},
  {14, 51},
  {1, 74},
  {11, 222},
  {24, 255},
  {11, 222},
  {13, 51},
  {63, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {4, 0},                                                 /* End of row 170 */
  {5, 0},
  {9, 74},
  {2, 51},
  {20, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {8, 74},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {8, 222},
  {14, 255},
  {8, 222},
  {14, 51},
  {11, 222},
  {26, 255},
  {11, 222},
  {13, 51},
  {61, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {5, 0},                                                 /* End of row 171 */
  {6, 0},
  {9, 74},
  {2, 51},
  {19, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {8, 74},
  {11, 222},
  {14, 255},
  {13, 222},
  {12, 51},
  {8, 222},
  {14, 255},
  {8, 222},
  {14, 51},
  {11, 222},
  {26, 255},
  {11, 222},
  {13, 51},
  {60, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {6, 0},                                                 /* End of row 172 */
  {7, 0},
  {9, 74},
  {2, 51},
  {18, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {9, 74},
  {11, 222},
  {14, 255},
  {13, 222},
  {11, 51},
  {8, 222},
  {14, 255},
  {8, 222},
  {13, 51},
  {11, 222},
  {28, 255},
  {11, 222},
  {13, 51},
  {58, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {7, 0},                                                 /* End of row 173 */
  {8, 0},
  {9, 74},
  {2, 51},
  {17, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {9, 74},
  {11, 222},
  {14, 255},
  {13, 222},
  {11, 51},
  {8, 222},
  {14, 255},
  {8, 222},
  {13, 51},
  {11, 222},
  {28, 255},
  {11, 222},
  {13, 51},
  {57, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {8, 0},                                                 /* End of row 174 */
  {9, 0},
  {9, 74},
  {2, 51},
  {16, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {10, 74},
  {11, 222},
  {14, 255},
  {13, 222},
  {10, 51},
  {8, 222},
  {14, 255},
  {8, 222},
  {12, 51},
  {11, 222},
  {30, 255},
  {11, 222},
  {13, 51},
  {55, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {9, 0},                                                 /* End of row 175 */
  {10, 0},
  {9, 74},
  {2, 51},
  {15, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {10, 74},
  {11, 222},
  {14, 255},
  {13, 222},
  {10, 51},
  {8, 222},
  {14, 255},
  {8, 222},
  {12, 51},
  {11, 222},
  {30, 255},
  {11, 222},
  {13, 51},
  {54, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {10, 0},                                                /* End of row 176 */
  {11, 0},
  {9, 74},
  {2, 51},
  {14, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {11, 74},
  {11, 222},
  {14, 255},
  {13, 222},
  {9, 51},
  {8, 222},
  {14, 255},
  {8, 222},
  {11, 51},
  {11, 222},
  {32, 255},
  {11, 222},
  {13, 51},
  {52, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {11, 0},                                                /* End of row 177 */
  {12, 0},
  {9, 74},
  {2, 51},
  {13, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {11, 74},
  {11, 222},
  {14, 255},
  {13, 222},
  {9, 51},
  {8, 222},
  {14, 255},
  {8, 222},
  {11, 51},
  {11, 222},
  {32, 255},
  {11, 222},
  {13, 51},
  {51, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {12, 0},                                                /* End of row 178 */
  {13, 0},
  {9, 74},
  {2, 51},
  {12, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {12, 74},
  {11, 222},
  {14, 255},
  {13, 222},
  {8, 51},
  {8, 222},
  {14, 255},
  {8, 222},
  {10, 51},
  {11, 222},
  {16, 255},
  {3, 222},
  {15, 255},
  {11, 222},
  {13, 51},
  {49, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {13, 0},                                                /* End of row 179 */
  {14, 0},
  {9, 74},
  {2, 51},
  {11, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {12, 74},
  {11, 222},
  {14, 255},
  {13, 222},
  {8, 51},
  {8, 222},
  {14, 255},
  {8, 222},
  {10, 51},
  {11, 222},
  {16, 255},
  {3, 222},
  {15, 255},
  {11, 222},
  {13, 51},
  {48, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {14, 0},                                                /* End of row 180 */
  {15, 0},
  {9, 74},
  {2, 51},
  {10, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {13, 74},
  {11, 222},
  {14, 255},
  {13, 222},
  {7, 51},
  {8, 222},
  {14, 255},
  {8, 222},
  {9, 51},
  {11, 222},
  {16, 255},
  {5, 222},
  {15, 255},
  {11, 222},
  {13, 51},
  {46, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {15, 0},                                                /* End of row 181 */
  {16, 0},
  {9, 74},
  {2, 51},
  {9, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {13, 74},
  {11, 222},
  {14, 255},
  {13, 222},
  {7, 51},
  {8, 222},
  {14, 255},
  {8, 222},
  {9, 51},
  {11, 222},
  {16, 255},
  {5, 222},
  {15, 255},
  {11, 222},
  {13, 51},
  {45, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {16, 0},                                                /* End of row 182 */
  {17, 0},
  {9, 74},
  {2, 51},
  {8, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {14, 74},
  {11, 222},
  {14, 255},
  {13, 222},
  {6, 51},
  {8, 222},
  {14, 255},
  {8, 222},
  {8, 51},
  {11, 222},
  {16, 255},
  {7, 222},
  {15, 255},
  {11, 222},
  {13, 51},
  {43, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {17, 0},                                                /* End of row 183 */
  {18, 0},
  {9, 74},
  {2, 51},
  {7, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {14, 74},
  {11, 222},
  {14, 255},
  {13, 222},
  {6, 51},
  {8, 222},
  {14, 255},
  {8, 222},
  {8, 51},
  {11, 222},
  {16, 255},
  {7, 222},
  {15, 255},
  {11, 222},
  {13, 51},
  {42, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {18, 0},                                                /* End of row 184 */
  {19, 0},
  {9, 74},
  {2, 51},
  {6, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {15, 74},
  {11, 222},
  {14, 255},
  {13, 222},
  {5, 51},
  {8, 222},
  {14, 255},
  {8, 222},
  {7, 51},
  {11, 222},
  {16, 255},
  {9, 222},
  {15, 255},
  {11, 222},
  {13, 51},
  {40, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {19, 0},                                                /* End of row 185 */
  {20, 0},
  {9, 74},
  {2, 51},
  {5, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {15, 74},
  {11, 222},
  {14, 255},
  {13, 222},
  {5, 51},
  {8, 222},
  {14, 255},
  {8, 222},
  {7, 51},
  {11, 222},
  {16, 255},
  {9, 222},
  {15, 255},
  {11, 222},
  {13, 51},
  {39, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {20, 0},                                                /* End of row 186 */
  {21, 0},
  {9, 74},
  {2, 51},
  {4, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {16, 74},
  {11, 222},
  {14, 255},
  {13, 222},
  {4, 51},
  {8, 222},
  {14, 255},
  {8, 222},
  {6, 51},
  {11, 222},
  {16, 255},
  {11, 222},
  {15, 255},
  {11, 222},
  {13, 51},
  {37, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {21, 0},                                                /* End of row 187 */
  {22, 0},
  {9, 74},
  {2, 51},
  {3, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {16, 74},
  {11, 222},
  {14, 255},
  {13, 222},
  {4, 51},
  {8, 222},
  {14, 255},
  {8, 222},
  {6, 51},
  {11, 222},
  {16, 255},
  {11, 222},
  {15, 255},
  {11, 222},
  {13, 51},
  {36, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {22, 0},                                                /* End of row 188 */
  {23, 0},
  {9, 74},
  {2, 51},
  {2, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {17, 74},
  {11, 222},
  {14, 255},
  {13, 222},
  {3, 51},
  {8, 222},
  {14, 255},
  {8, 222},
  {5, 51},
  {11, 222},
  {16, 255},
  {13, 222},
  {15, 255},
  {11, 222},
  {13, 51},
  {34, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {23, 0},                                                /* End of row 189 */
  {24, 0},
  {9, 74},
  {2, 51},
  {1, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {17, 74},
  {11, 222},
  {14, 255},
  {13, 222},
  {3, 51},
  {8, 222},
  {14, 255},
  {8, 222},
  {5, 51},
  {11, 222},
  {16, 255},
  {13, 222},
  {15, 255},
  {11, 222},
  {13, 51},
  {33, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {24, 0},                                                /* End of row 190 */
  {25, 0},
  {9, 74},
  {2, 51},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {18, 74},
  {11, 222},
  {14, 255},
  {13, 222},
  {2, 51},
  {8, 222},
  {14, 255},
  {8, 222},
  {4, 51},
  {11, 222},
  {16, 255},
  {15, 222},
  {15, 255},
  {11, 222},
  {13, 51},
  {31, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {25, 0},                                                /* End of row 191 */
  {26, 0},
  {9, 74},
  {1, 51},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {18, 74},
  {11, 222},
  {14, 255},
  {13, 222},
  {2, 51},
  {8, 222},
  {14, 255},
  {8, 222},
  {4, 51},
  {11, 222},
  {16, 255},
  {15, 222},
  {15, 255},
  {11, 222},
  {13, 51},
  {30, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {26, 0},                                                /* End of row 192 */
  {27, 0},
  {9, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {19, 74},
  {11, 222},
  {14, 255},
  {13, 222},
  {1, 51},
  {8, 222},
  {14, 255},
  {8, 222},
  {3, 51},
  {11, 222},
  {16, 255},
  {17, 222},
  {15, 255},
  {11, 222},
  {13, 51},
  {28, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {27, 0},                                                /* End of row 193 */
  {28, 0},
  {8, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {19, 74},
  {11, 222},
  {14, 255},
  {13, 222},
  {1, 51},
  {8, 222},
  {14, 255},
  {8, 222},
  {3, 51},
  {11, 222},
  {16, 255},
  {17, 222},
  {15, 255},
  {11, 222},
  {13, 51},
  {27, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {28, 0},                                                /* End of row 194 */
  {29, 0},
  {7, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {20, 74},
  {11, 222},
  {14, 255},
  {21, 222},
  {14, 255},
  {8, 222},
  {2, 51},
  {11, 222},
  {16, 255},
  {19, 222},
  {15, 255},
  {11, 222},
  {13, 51},
  {25, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {29, 0},                                                /* End of row 195 */
  {30, 0},
  {6, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {20, 74},
  {11, 222},
  {14, 255},
  {21, 222},
  {14, 255},
  {8, 222},
  {2, 51},
  {11, 222},
  {16, 255},
  {19, 222},
  {15, 255},
  {11, 222},
  {13, 51},
  {24, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {30, 0},                                                /* End of row 196 */
  {31, 0},
  {5, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {21, 74},
  {11, 222},
  {14, 255},
  {20, 222},
  {14, 255},
  {8, 222},
  {1, 51},
  {11, 222},
  {16, 255},
  {11, 222},
  {1, 51},
  {9, 222},
  {15, 255},
  {11, 222},
  {13, 51},
  {22, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {31, 0},                                                /* End of row 197 */
  {32, 0},
  {4, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {21, 74},
  {11, 222},
  {14, 255},
  {20, 222},
  {14, 255},
  {8, 222},
  {1, 51},
  {11, 222},
  {16, 255},
  {11, 222},
  {1, 51},
  {9, 222},
  {15, 255},
  {11, 222},
  {13, 51},
  {21, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {32, 0},                                                /* End of row 198 */
  {33, 0},
  {3, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {22, 74},
  {11, 222},
  {14, 255},
  {19, 222},
  {14, 255},
  {19, 222},
  {16, 255},
  {11, 222},
  {3, 51},
  {9, 222},
  {15, 255},
  {11, 222},
  {13, 51},
  {19, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {33, 0},                                                /* End of row 199 */
  {34, 0},
  {2, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {22, 74},
  {11, 222},
  {14, 255},
  {19, 222},
  {14, 255},
  {19, 222},
  {16, 255},
  {11, 222},
  {3, 51},
  {9, 222},
  {15, 255},
  {11, 222},
  {13, 51},
  {18, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {34, 0},                                                /* End of row 200 */
  {35, 0},
  {1, 74},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {23, 74},
  {11, 222},
  {14, 255},
  {18, 222},
  {14, 255},
  {18, 222},
  {16, 255},
  {11, 222},
  {5, 51},
  {9, 222},
  {15, 255},
  {11, 222},
  {13, 51},
  {16, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {35, 0},                                                /* End of row 201 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {23, 74},
  {11, 222},
  {14, 255},
  {18, 222},
  {14, 255},
  {18, 222},
  {16, 255},
  {11, 222},
  {5, 51},
  {9, 222},
  {15, 255},
  {11, 222},
  {13, 51},
  {15, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {36, 0},                                                /* End of row 202 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {24, 74},
  {11, 222},
  {14, 255},
  {17, 222},
  {14, 255},
  {17, 222},
  {16, 255},
  {11, 222},
  {7, 51},
  {9, 222},
  {15, 255},
  {11, 222},
  {13, 51},
  {13, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {37, 0},                                                /* End of row 203 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {24, 74},
  {11, 222},
  {14, 255},
  {17, 222},
  {14, 255},
  {17, 222},
  {16, 255},
  {11, 222},
  {7, 51},
  {9, 222},
  {15, 255},
  {11, 222},
  {13, 51},
  {12, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {38, 0},                                                /* End of row 204 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {25, 74},
  {11, 222},
  {14, 255},
  {16, 222},
  {14, 255},
  {16, 222},
  {16, 255},
  {11, 222},
  {9, 51},
  {9, 222},
  {15, 255},
  {11, 222},
  {13, 51},
  {10, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {39, 0},                                                /* End of row 205 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {25, 74},
  {11, 222},
  {14, 255},
  {16, 222},
  {14, 255},
  {16, 222},
  {16, 255},
  {11, 222},
  {9, 51},
  {9, 222},
  {15, 255},
  {11, 222},
  {13, 51},
  {9, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {40, 0},                                                /* End of row 206 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {26, 74},
  {11, 222},
  {14, 255},
  {15, 222},
  {14, 255},
  {15, 222},
  {16, 255},
  {11, 222},
  {11, 51},
  {9, 222},
  {15, 255},
  {11, 222},
  {13, 51},
  {7, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {41, 0},                                                /* End of row 207 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {26, 74},
  {11, 222},
  {14, 255},
  {15, 222},
  {14, 255},
  {15, 222},
  {16, 255},
  {11, 222},
  {11, 51},
  {9, 222},
  {15, 255},
  {11, 222},
  {13, 51},
  {6, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {42, 0},                                                /* End of row 208 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {27, 74},
  {11, 222},
  {14, 255},
  {14, 222},
  {14, 255},
  {14, 222},
  {16, 255},
  {11, 222},
  {13, 51},
  {9, 222},
  {15, 255},
  {11, 222},
  {13, 51},
  {4, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {43, 0},                                                /* End of row 209 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {27, 74},
  {11, 222},
  {14, 255},
  {14, 222},
  {14, 255},
  {14, 222},
  {16, 255},
  {11, 222},
  {13, 51},
  {9, 222},
  {15, 255},
  {11, 222},
  {13, 51},
  {3, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {44, 0},                                                /* End of row 210 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {28, 74},
  {11, 222},
  {14, 255},
  {13, 222},
  {14, 255},
  {13, 222},
  {16, 255},
  {11, 222},
  {15, 51},
  {9, 222},
  {15, 255},
  {11, 222},
  {13, 51},
  {1, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {45, 0},                                                /* End of row 211 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {28, 74},
  {11, 222},
  {14, 255},
  {13, 222},
  {14, 255},
  {13, 222},
  {16, 255},
  {11, 222},
  {15, 51},
  {9, 222},
  {15, 255},
  {11, 222},
  {15, 51},
  {2, 156},
  {5, 74},
  {46, 0},                                                /* End of row 212 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {29, 74},
  {11, 222},
  {14, 255},
  {12, 222},
  {14, 255},
  {12, 222},
  {16, 255},
  {11, 222},
  {15, 51},
  {2, 74},
  {9, 222},
  {15, 255},
  {11, 222},
  {13, 51},
  {2, 156},
  {5, 74},
  {47, 0},                                                /* End of row 213 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {29, 74},
  {11, 222},
  {14, 255},
  {12, 222},
  {14, 255},
  {12, 222},
  {16, 255},
  {11, 222},
  {15, 51},
  {2, 74},
  {9, 222},
  {15, 255},
  {11, 222},
  {14, 51},
  {5, 74},
  {48, 0},                                                /* End of row 214 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {30, 74},
  {11, 222},
  {14, 255},
  {11, 222},
  {14, 255},
  {11, 222},
  {16, 255},
  {11, 222},
  {15, 51},
  {4, 74},
  {9, 222},
  {15, 255},
  {11, 222},
  {14, 51},
  {3, 74},
  {49, 0},                                                /* End of row 215 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {30, 74},
  {11, 222},
  {14, 255},
  {11, 222},
  {14, 255},
  {11, 222},
  {16, 255},
  {11, 222},
  {15, 51},
  {4, 74},
  {9, 222},
  {15, 255},
  {11, 222},
  {14, 51},
  {2, 74},
  {50, 0},                                                /* End of row 216 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {31, 74},
  {11, 222},
  {14, 255},
  {10, 222},
  {14, 255},
  {10, 222},
  {16, 255},
  {11, 222},
  {15, 51},
  {6, 74},
  {9, 222},
  {15, 255},
  {11, 222},
  {12, 51},
  {1, 137},
  {1, 74},
  {51, 0},                                                /* End of row 217 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {31, 74},
  {11, 222},
  {14, 255},
  {10, 222},
  {14, 255},
  {10, 222},
  {16, 255},
  {11, 222},
  {15, 51},
  {6, 74},
  {9, 222},
  {15, 255},
  {11, 222},
  {11, 51},
  {3, 137},
  {51, 0},                                                /* End of row 218 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {32, 74},
  {11, 222},
  {14, 255},
  {9, 222},
  {14, 255},
  {9, 222},
  {16, 255},
  {11, 222},
  {15, 51},
  {8, 74},
  {9, 222},
  {15, 255},
  {11, 222},
  {9, 51},
  {5, 137},
  {50, 0},                                                /* End of row 219 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {32, 74},
  {11, 222},
  {14, 255},
  {9, 222},
  {14, 255},
  {9, 222},
  {16, 255},
  {11, 222},
  {15, 51},
  {8, 74},
  {9, 222},
  {15, 255},
  {11, 222},
  {8, 51},
  {6, 137},
  {50, 0},                                                /* End of row 220 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {33, 74},
  {11, 222},
  {14, 255},
  {8, 222},
  {14, 255},
  {8, 222},
  {16, 255},
  {11, 222},
  {15, 51},
  {10, 74},
  {9, 222},
  {15, 255},
  {11, 222},
  {6, 51},
  {8, 137},
  {49, 0},                                                /* End of row 221 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {33, 74},
  {11, 222},
  {14, 255},
  {8, 222},
  {14, 255},
  {8, 222},
  {16, 255},
  {11, 222},
  {15, 51},
  {10, 74},
  {9, 222},
  {15, 255},
  {11, 222},
  {5, 51},
  {9, 137},
  {49, 0},                                                /* End of row 222 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {34, 74},
  {11, 222},
  {14, 255},
  {7, 222},
  {14, 255},
  {7, 222},
  {16, 255},
  {11, 222},
  {15, 51},
  {12, 74},
  {9, 222},
  {15, 255},
  {11, 222},
  {3, 51},
  {11, 137},
  {48, 0},                                                /* End of row 223 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {34, 74},
  {11, 222},
  {14, 255},
  {7, 222},
  {14, 255},
  {7, 222},
  {16, 255},
  {11, 222},
  {15, 51},
  {12, 74},
  {9, 222},
  {15, 255},
  {11, 222},
  {2, 51},
  {12, 137},
  {48, 0},                                                /* End of row 224 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {35, 74},
  {11, 222},
  {14, 255},
  {6, 222},
  {14, 255},
  {6, 222},
  {16, 255},
  {11, 222},
  {15, 51},
  {14, 74},
  {9, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {47, 0},                                                /* End of row 225 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {35, 74},
  {11, 222},
  {14, 255},
  {6, 222},
  {14, 255},
  {6, 222},
  {16, 255},
  {11, 222},
  {15, 51},
  {14, 74},
  {9, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {47, 0},                                                /* End of row 226 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {36, 74},
  {11, 222},
  {14, 255},
  {5, 222},
  {14, 255},
  {5, 222},
  {16, 255},
  {11, 222},
  {15, 51},
  {16, 74},
  {9, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {46, 0},                                                /* End of row 227 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {36, 74},
  {11, 222},
  {14, 255},
  {5, 222},
  {14, 255},
  {5, 222},
  {16, 255},
  {11, 222},
  {15, 51},
  {16, 74},
  {9, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {46, 0},                                                /* End of row 228 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {37, 74},
  {11, 222},
  {14, 255},
  {4, 222},
  {14, 255},
  {4, 222},
  {16, 255},
  {11, 222},
  {15, 51},
  {18, 74},
  {9, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {45, 0},                                                /* End of row 229 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {37, 74},
  {11, 222},
  {14, 255},
  {4, 222},
  {14, 255},
  {4, 222},
  {16, 255},
  {11, 222},
  {15, 51},
  {18, 74},
  {9, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {45, 0},                                                /* End of row 230 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {38, 74},
  {11, 222},
  {14, 255},
  {3, 222},
  {14, 255},
  {3, 222},
  {16, 255},
  {11, 222},
  {15, 51},
  {20, 74},
  {9, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {44, 0},                                                /* End of row 231 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {38, 74},
  {11, 222},
  {14, 255},
  {3, 222},
  {14, 255},
  {3, 222},
  {16, 255},
  {11, 222},
  {15, 51},
  {20, 74},
  {9, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {44, 0},                                                /* End of row 232 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {39, 74},
  {11, 222},
  {14, 255},
  {2, 222},
  {14, 255},
  {2, 222},
  {16, 255},
  {11, 222},
  {15, 51},
  {22, 74},
  {9, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {43, 0},                                                /* End of row 233 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 51},
  {39, 74},
  {11, 222},
  {14, 255},
  {2, 222},
  {14, 255},
  {2, 222},
  {16, 255},
  {11, 222},
  {15, 51},
  {22, 74},
  {9, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {43, 0},                                                /* End of row 234 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {1, 137},
  {13, 51},
  {40, 74},
  {11, 222},
  {14, 255},
  {1, 222},
  {14, 255},
  {1, 222},
  {16, 255},
  {11, 222},
  {15, 51},
  {24, 74},
  {9, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {42, 0},                                                /* End of row 235 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {2, 137},
  {12, 51},
  {40, 74},
  {11, 222},
  {14, 255},
  {1, 222},
  {14, 255},
  {1, 222},
  {16, 255},
  {11, 222},
  {15, 51},
  {24, 74},
  {9, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {42, 0},                                                /* End of row 236 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {3, 137},
  {11, 51},
  {41, 74},
  {11, 222},
  {44, 255},
  {11, 222},
  {15, 51},
  {26, 74},
  {9, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {41, 0},                                                /* End of row 237 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {4, 137},
  {11, 51},
  {40, 74},
  {11, 222},
  {44, 255},
  {11, 222},
  {15, 51},
  {26, 74},
  {9, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {41, 0},                                                /* End of row 238 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {5, 137},
  {11, 51},
  {40, 74},
  {11, 222},
  {42, 255},
  {11, 222},
  {15, 51},
  {28, 74},
  {9, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {40, 0},                                                /* End of row 239 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {6, 137},
  {8, 51},
  {1, 74},
  {2, 51},
  {39, 74},
  {11, 222},
  {42, 255},
  {11, 222},
  {15, 51},
  {28, 74},
  {9, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {40, 0},                                                /* End of row 240 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {7, 137},
  {7, 51},
  {2, 74},
  {2, 51},
  {39, 74},
  {11, 222},
  {40, 255},
  {11, 222},
  {15, 51},
  {30, 74},
  {9, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {39, 0},                                                /* End of row 241 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {8, 137},
  {6, 51},
  {3, 74},
  {2, 51},
  {38, 74},
  {11, 222},
  {40, 255},
  {11, 222},
  {15, 51},
  {29, 74},
  {1, 51},
  {9, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {39, 0},                                                /* End of row 242 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {9, 137},
  {5, 51},
  {4, 74},
  {2, 51},
  {38, 74},
  {11, 222},
  {38, 255},
  {11, 222},
  {15, 51},
  {29, 74},
  {2, 51},
  {1, 156},
  {9, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {38, 0},                                                /* End of row 243 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {10, 137},
  {4, 51},
  {5, 74},
  {2, 51},
  {37, 74},
  {11, 222},
  {38, 255},
  {11, 222},
  {15, 51},
  {28, 74},
  {2, 51},
  {2, 156},
  {9, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {38, 0},                                                /* End of row 244 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {11, 137},
  {3, 51},
  {6, 74},
  {2, 51},
  {37, 74},
  {11, 222},
  {36, 255},
  {11, 222},
  {15, 51},
  {28, 74},
  {2, 51},
  {2, 156},
  {2, 74},
  {9, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {37, 0},                                                /* End of row 245 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {12, 137},
  {2, 51},
  {7, 74},
  {2, 51},
  {36, 74},
  {11, 222},
  {36, 255},
  {11, 222},
  {15, 51},
  {27, 74},
  {2, 51},
  {2, 156},
  {3, 74},
  {9, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {37, 0},                                                /* End of row 246 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {13, 137},
  {1, 51},
  {8, 74},
  {2, 51},
  {36, 74},
  {11, 222},
  {34, 255},
  {11, 222},
  {15, 51},
  {27, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {9, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {36, 0},                                                /* End of row 247 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 137},
  {9, 74},
  {2, 51},
  {35, 74},
  {11, 222},
  {34, 255},
  {11, 222},
  {15, 51},
  {26, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {1, 0},
  {9, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {36, 0},                                                /* End of row 248 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 137},
  {1, 0},
  {9, 74},
  {2, 51},
  {35, 74},
  {11, 222},
  {32, 255},
  {11, 222},
  {15, 51},
  {26, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {2, 0},
  {10, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {35, 0},                                                /* End of row 249 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 137},
  {2, 0},
  {9, 74},
  {2, 51},
  {34, 74},
  {11, 222},
  {32, 255},
  {11, 222},
  {15, 51},
  {25, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {4, 0},
  {9, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {35, 0},                                                /* End of row 250 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 137},
  {3, 0},
  {9, 74},
  {2, 51},
  {34, 74},
  {11, 222},
  {30, 255},
  {11, 222},
  {15, 51},
  {25, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {6, 0},
  {9, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {34, 0},                                                /* End of row 251 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 137},
  {4, 0},
  {9, 74},
  {2, 51},
  {33, 74},
  {11, 222},
  {30, 255},
  {11, 222},
  {15, 51},
  {24, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {7, 0},
  {9, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {34, 0},                                                /* End of row 252 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 137},
  {5, 0},
  {9, 74},
  {2, 51},
  {33, 74},
  {11, 222},
  {28, 255},
  {11, 222},
  {15, 51},
  {24, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {9, 0},
  {9, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {33, 0},                                                /* End of row 253 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 137},
  {6, 0},
  {9, 74},
  {2, 51},
  {32, 74},
  {11, 222},
  {28, 255},
  {11, 222},
  {15, 51},
  {23, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {10, 0},
  {9, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {33, 0},                                                /* End of row 254 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 137},
  {7, 0},
  {9, 74},
  {2, 51},
  {32, 74},
  {11, 222},
  {26, 255},
  {11, 222},
  {15, 51},
  {23, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {12, 0},
  {9, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {32, 0},                                                /* End of row 255 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 137},
  {8, 0},
  {9, 74},
  {2, 51},
  {31, 74},
  {11, 222},
  {26, 255},
  {11, 222},
  {15, 51},
  {22, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {13, 0},
  {9, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {32, 0},                                                /* End of row 256 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 137},
  {9, 0},
  {9, 74},
  {2, 51},
  {31, 74},
  {11, 222},
  {24, 255},
  {11, 222},
  {15, 51},
  {22, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {15, 0},
  {9, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {31, 0},                                                /* End of row 257 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 137},
  {10, 0},
  {9, 74},
  {2, 51},
  {30, 74},
  {11, 222},
  {24, 255},
  {11, 222},
  {15, 51},
  {21, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {16, 0},
  {9, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {31, 0},                                                /* End of row 258 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 137},
  {11, 0},
  {9, 74},
  {2, 51},
  {30, 74},
  {11, 222},
  {22, 255},
  {11, 222},
  {15, 51},
  {21, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {18, 0},
  {9, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {30, 0},                                                /* End of row 259 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 137},
  {12, 0},
  {9, 74},
  {2, 51},
  {29, 74},
  {11, 222},
  {22, 255},
  {11, 222},
  {15, 51},
  {20, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {19, 0},
  {9, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {30, 0},                                                /* End of row 260 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 137},
  {13, 0},
  {9, 74},
  {2, 51},
  {29, 74},
  {11, 222},
  {20, 255},
  {11, 222},
  {15, 51},
  {20, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {21, 0},
  {9, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {29, 0},                                                /* End of row 261 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 137},
  {14, 0},
  {9, 74},
  {2, 51},
  {28, 74},
  {11, 222},
  {20, 255},
  {11, 222},
  {15, 51},
  {19, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {22, 0},
  {9, 222},
  {15, 255},
  {11, 222},
  {14, 137},
  {29, 0},                                                /* End of row 262 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 137},
  {15, 0},
  {9, 74},
  {2, 51},
  {28, 74},
  {11, 222},
  {18, 255},
  {11, 222},
  {15, 51},
  {19, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {24, 0},
  {9, 222},
  {15, 255},
  {10, 222},
  {14, 137},
  {29, 0},                                                /* End of row 263 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 137},
  {16, 0},
  {9, 74},
  {2, 51},
  {27, 74},
  {11, 222},
  {18, 255},
  {11, 222},
  {15, 51},
  {18, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {25, 0},
  {9, 222},
  {15, 255},
  {10, 222},
  {14, 137},
  {29, 0},                                                /* End of row 264 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 137},
  {17, 0},
  {9, 74},
  {2, 51},
  {27, 74},
  {11, 222},
  {16, 255},
  {11, 222},
  {15, 51},
  {18, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {27, 0},
  {9, 222},
  {14, 255},
  {10, 222},
  {15, 137},
  {28, 0},                                                /* End of row 265 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 137},
  {18, 0},
  {9, 74},
  {2, 51},
  {26, 74},
  {11, 222},
  {16, 255},
  {11, 222},
  {15, 51},
  {17, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {28, 0},
  {9, 222},
  {14, 255},
  {10, 222},
  {15, 137},
  {28, 0},                                                /* End of row 266 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 137},
  {19, 0},
  {9, 74},
  {2, 51},
  {26, 74},
  {11, 222},
  {14, 255},
  {11, 222},
  {15, 51},
  {17, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {30, 0},
  {9, 222},
  {13, 255},
  {10, 222},
  {16, 137},
  {27, 0},                                                /* End of row 267 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 137},
  {20, 0},
  {9, 74},
  {2, 51},
  {25, 74},
  {11, 222},
  {14, 255},
  {11, 222},
  {15, 51},
  {16, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {31, 0},
  {9, 222},
  {13, 255},
  {9, 222},
  {17, 137},
  {27, 0},                                                /* End of row 268 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 137},
  {21, 0},
  {9, 74},
  {2, 51},
  {25, 74},
  {11, 222},
  {12, 255},
  {11, 222},
  {15, 51},
  {16, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {33, 0},
  {9, 222},
  {11, 255},
  {10, 222},
  {17, 137},
  {27, 0},                                                /* End of row 269 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 137},
  {22, 0},
  {9, 74},
  {2, 51},
  {24, 74},
  {12, 222},
  {10, 255},
  {12, 222},
  {15, 51},
  {15, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {34, 0},
  {9, 222},
  {11, 255},
  {10, 222},
  {17, 137},
  {27, 0},                                                /* End of row 270 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 137},
  {23, 0},
  {9, 74},
  {2, 51},
  {24, 74},
  {12, 222},
  {8, 255},
  {12, 222},
  {15, 51},
  {15, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {36, 0},
  {9, 222},
  {8, 255},
  {11, 222},
  {18, 137},
  {27, 0},                                                /* End of row 271 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 137},
  {24, 0},
  {9, 74},
  {2, 51},
  {23, 74},
  {14, 222},
  {4, 255},
  {14, 222},
  {15, 51},
  {14, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {37, 0},
  {11, 222},
  {4, 255},
  {13, 222},
  {18, 137},
  {27, 0},                                                /* End of row 272 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 137},
  {25, 0},
  {9, 74},
  {2, 51},
  {23, 74},
  {30, 222},
  {15, 51},
  {14, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {39, 0},
  {26, 222},
  {19, 137},
  {27, 0},                                                /* End of row 273 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 137},
  {26, 0},
  {9, 74},
  {2, 51},
  {22, 74},
  {30, 222},
  {15, 51},
  {13, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {40, 0},
  {26, 222},
  {18, 137},
  {28, 0},                                                /* End of row 274 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 137},
  {27, 0},
  {9, 74},
  {2, 51},
  {22, 74},
  {28, 222},
  {15, 51},
  {13, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {42, 0},
  {24, 222},
  {19, 137},
  {28, 0},                                                /* End of row 275 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 137},
  {28, 0},
  {9, 74},
  {2, 51},
  {21, 74},
  {28, 222},
  {15, 51},
  {12, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {43, 0},
  {23, 222},
  {20, 137},
  {28, 0},                                                /* End of row 276 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 137},
  {29, 0},
  {9, 74},
  {2, 51},
  {21, 74},
  {26, 222},
  {15, 51},
  {12, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {45, 0},
  {21, 222},
  {20, 137},
  {29, 0},                                                /* End of row 277 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 137},
  {30, 0},
  {9, 74},
  {2, 51},
  {20, 74},
  {26, 222},
  {15, 51},
  {11, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {46, 0},
  {20, 222},
  {21, 137},
  {29, 0},                                                /* End of row 278 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 137},
  {31, 0},
  {9, 74},
  {2, 51},
  {20, 74},
  {24, 222},
  {15, 51},
  {11, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {48, 0},
  {18, 222},
  {21, 137},
  {30, 0},                                                /* End of row 279 */
  {36, 0},
  {8, 222},
  {16, 255},
  {8, 222},
  {14, 137},
  {32, 0},
  {9, 74},
  {2, 51},
  {20, 74},
  {22, 222},
  {16, 51},
  {10, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {51, 0},
  {14, 222},
  {23, 137},
  {30, 0},                                                /* End of row 280 */
  {50, 0},
  {32, 137},
  {33, 0},
  {9, 74},
  {2, 51},
  {20, 74},
  {20, 222},
  {16, 51},
  {10, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {55, 0},
  {8, 222},
  {25, 137},
  {31, 0},                                                /* End of row 281 */
  {50, 0},
  {32, 137},
  {34, 0},
  {9, 74},
  {2, 51},
  {21, 74},
  {16, 222},
  {18, 51},
  {9, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {61, 0},
  {28, 137},
  {31, 0},                                                /* End of row 282 */
  {50, 0},
  {32, 137},
  {35, 0},
  {9, 74},
  {2, 51},
  {22, 74},
  {12, 222},
  {19, 51},
  {9, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {62, 0},
  {27, 137},
  {32, 0},                                                /* End of row 283 */
  {50, 0},
  {32, 137},
  {36, 0},
  {9, 74},
  {2, 51},
  {23, 74},
  {8, 222},
  {20, 51},
  {9, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {64, 0},
  {26, 137},
  {32, 0},                                                /* End of row 284 */
  {50, 0},
  {32, 137},
  {37, 0},
  {9, 74},
  {2, 51},
  {24, 74},
  {25, 51},
  {9, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {66, 0},
  {23, 137},
  {34, 0},                                                /* End of row 285 */
  {50, 0},
  {32, 137},
  {38, 0},
  {9, 74},
  {2, 51},
  {25, 74},
  {21, 51},
  {10, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {67, 0},
  {23, 137},
  {34, 0},                                                /* End of row 286 */
  {50, 0},
  {32, 137},
  {39, 0},
  {9, 74},
  {2, 51},
  {26, 74},
  {17, 51},
  {11, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {69, 0},
  {20, 137},
  {36, 0},                                                /* End of row 287 */
  {50, 0},
  {32, 137},
  {40, 0},
  {9, 74},
  {2, 51},
  {27, 74},
  {13, 51},
  {12, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {70, 0},
  {20, 137},
  {36, 0},                                                /* End of row 288 */
  {50, 0},
  {32, 137},
  {41, 0},
  {9, 74},
  {2, 51},
  {50, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {72, 0},
  {17, 137},
  {38, 0},                                                /* End of row 289 */
  {50, 0},
  {32, 137},
  {42, 0},
  {9, 74},
  {2, 51},
  {48, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {74, 0},
  {14, 137},
  {40, 0},                                                /* End of row 290 */
  {50, 0},
  {32, 137},
  {43, 0},
  {9, 74},
  {2, 51},
  {46, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {129, 0},                                               /* End of row 291 */
  {50, 0},
  {32, 137},
  {44, 0},
  {9, 74},
  {2, 51},
  {44, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {130, 0},                                               /* End of row 292 */
  {50, 0},
  {32, 137},
  {45, 0},
  {9, 74},
  {2, 51},
  {42, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {131, 0},                                               /* End of row 293 */
  {50, 0},
  {32, 137},
  {46, 0},
  {9, 74},
  {2, 51},
  {40, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {132, 0},                                               /* End of row 294 */
  {129, 0},
  {9, 74},
  {2, 51},
  {38, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {133, 0},                                               /* End of row 295 */
  {130, 0},
  {9, 74},
  {2, 51},
  {36, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {134, 0},                                               /* End of row 296 */
  {131, 0},
  {9, 74},
  {2, 51},
  {34, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {135, 0},                                               /* End of row 297 */
  {132, 0},
  {9, 74},
  {2, 51},
  {32, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {136, 0},                                               /* End of row 298 */
  {133, 0},
  {9, 74},
  {2, 51},
  {30, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {137, 0},                                               /* End of row 299 */
  {134, 0},
  {9, 74},
  {2, 51},
  {28, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {138, 0},                                               /* End of row 300 */
  {135, 0},
  {9, 74},
  {2, 51},
  {26, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {139, 0},                                               /* End of row 301 */
  {136, 0},
  {9, 74},
  {2, 51},
  {24, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {140, 0},                                               /* End of row 302 */
  {137, 0},
  {9, 74},
  {2, 51},
  {22, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {141, 0},                                               /* End of row 303 */
  {138, 0},
  {9, 74},
  {2, 51},
  {20, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {142, 0},                                               /* End of row 304 */
  {139, 0},
  {9, 74},
  {2, 51},
  {18, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {143, 0},                                               /* End of row 305 */
  {140, 0},
  {9, 74},
  {2, 51},
  {16, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {144, 0},                                               /* End of row 306 */
  {141, 0},
  {9, 74},
  {2, 51},
  {14, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {145, 0},                                               /* End of row 307 */
  {142, 0},
  {9, 74},
  {2, 51},
  {12, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {146, 0},                                               /* End of row 308 */
  {143, 0},
  {9, 74},
  {2, 51},
  {10, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {147, 0},                                               /* End of row 309 */
  {144, 0},
  {9, 74},
  {2, 51},
  {8, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {148, 0},                                               /* End of row 310 */
  {145, 0},
  {9, 74},
  {2, 51},
  {6, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {149, 0},                                               /* End of row 311 */
  {146, 0},
  {9, 74},
  {2, 51},
  {4, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {150, 0},                                               /* End of row 312 */
  {147, 0},
  {9, 74},
  {2, 51},
  {2, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {151, 0},                                               /* End of row 313 */
  {148, 0},
  {9, 74},
  {4, 51},
  {2, 156},
  {5, 74},
  {152, 0},                                               /* End of row 314 */
  {149, 0},
  {9, 74},
  {2, 51},
  {2, 156},
  {5, 74},
  {153, 0},                                               /* End of row 315 */
  {150, 0},
  {9, 74},
  {2, 156},
  {5, 74},
  {154, 0},                                               /* End of row 316 */
  {151, 0},
  {7, 74},
  {2, 156},
  {5, 74},
  {155, 0},                                               /* End of row 317 */
  {152, 0},
  {12, 74},
  {156, 0},                                               /* End of row 318 */
  {153, 0},
  {10, 74},
  {157, 0},                                               /* End of row 319 */
  {154, 0},
  {8, 74},
  {158, 0},                                               /* End of row 320 */
};
#endif /* CONFIG_VIDEO_FB_SPLASHSCREEN_GREY */

#ifdef CONFIG_VIDEO_FB_SPLASHSCREEN_MONO
static const struct splscr_bitmap_s bitmap[] =
{
  {154, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {155, 0},                                               /* End of row   1 */
  {153, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {157, 0},                                               /* End of row   2 */
  {152, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {153, 0},                                               /* End of row   3 */
  {151, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {152, 0},                                               /* End of row   4 */
  {150, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {151, 0},                                               /* End of row   5 */
  {149, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {152, 0},                                               /* End of row   6 */
  {148, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {148, 0},                                               /* End of row   7 */
  {147, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {151, 0},                                               /* End of row   8 */
  {146, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {146, 0},                                               /* End of row   9 */
  {145, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {152, 0},                                               /* End of row  10 */
  {144, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {145, 0},                                               /* End of row  11 */
  {143, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {144, 0},                                               /* End of row  12 */
  {142, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {142, 0},                                               /* End of row  13 */
  {141, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {144, 0},                                               /* End of row  14 */
  {140, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {140, 0},                                               /* End of row  15 */
  {139, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {143, 0},                                               /* End of row  16 */
  {138, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {139, 0},                                               /* End of row  17 */
  {137, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {138, 0},                                               /* End of row  18 */
  {136, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {136, 0},                                               /* End of row  19 */
  {135, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {138, 0},                                               /* End of row  20 */
  {134, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {135, 0},                                               /* End of row  21 */
  {133, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {133, 0},                                               /* End of row  22 */
  {132, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {134, 0},                                               /* End of row  23 */
  {131, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {132, 0},                                               /* End of row  24 */
  {130, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {133, 0},                                               /* End of row  25 */
  {129, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {130, 0},                                               /* End of row  26 */
  {128, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {129, 0},                                               /* End of row  27 */
  {127, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {127, 0},                                               /* End of row  28 */
  {126, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {129, 0},                                               /* End of row  29 */
  {125, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {125, 0},                                               /* End of row  30 */
  {124, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {128, 0},                                               /* End of row  31 */
  {123, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {124, 0},                                               /* End of row  32 */
  {122, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {123, 0},                                               /* End of row  33 */
  {121, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {9, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {121, 0},                                               /* End of row  34 */
  {120, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {124, 0},                                               /* End of row  35 */
  {119, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {10, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {119, 0},                                               /* End of row  36 */
  {118, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {63, 0},
  {10, 255},
  {52, 0},                                                /* End of row  37 */
  {117, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {53, 0},
  {14, 255},
  {50, 0},                                                /* End of row  38 */
  {116, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {54, 0},
  {5, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {6, 255},
  {48, 0},                                                /* End of row  39 */
  {115, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {49, 0},
  {4, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {47, 0},                                                /* End of row  40 */
  {114, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {11, 255},
  {4, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {47, 0},
  {3, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {10, 255},
  {46, 0},                                                /* End of row  41 */
  {113, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {5, 255},
  {1, 0},
  {9, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {45, 0},
  {8, 255},
  {1, 0},
  {14, 255},
  {45, 0},                                                /* End of row  42 */
  {48, 0},
  {11, 255},
  {53, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {46, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {4, 255},
  {44, 0},                                                /* End of row  43 */
  {46, 0},
  {14, 255},
  {51, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {15, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {43, 0},
  {12, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {3, 255},
  {43, 0},                                                /* End of row  44 */
  {44, 0},
  {5, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {48, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {6, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {41, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {8, 255},
  {42, 0},                                                /* End of row  45 */
  {43, 0},
  {4, 255},
  {1, 0},
  {15, 255},
  {46, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {8, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {9, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {42, 0},
  {9, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {2, 255},
  {42, 0},                                                /* End of row  46 */
  {42, 0},
  {3, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {3, 255},
  {44, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {14, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {37, 0},
  {5, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {7, 255},
  {41, 0},                                                /* End of row  47 */
  {42, 0},
  {8, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {8, 255},
  {42, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {3, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {43, 0},
  {2, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {4, 255},
  {41, 0},                                                /* End of row  48 */
  {41, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {30, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {10, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {11, 255},
  {9, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {34, 0},
  {29, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {38, 0},                                                /* End of row  49 */
  {40, 0},
  {13, 255},
  {1, 0},
  {13, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {28, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {6, 255},
  {1, 0},
  {14, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {38, 0},
  {4, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {15, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {1, 255},
  {37, 0},                                                /* End of row  50 */
  {39, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {25, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {4, 255},
  {6, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {31, 0},
  {2, 255},
  {1, 0},
  {31, 255},
  {1, 0},
  {1, 255},
  {37, 0},                                                /* End of row  51 */
  {39, 0},
  {10, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {24, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {11, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {34, 0},
  {9, 255},
  {1, 0},
  {15, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {35, 0},                                                /* End of row  52 */
  {38, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {22, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {17, 255},
  {1, 0},
  {6, 255},
  {9, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {29, 0},
  {5, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {34, 0},                                                /* End of row  53 */
  {38, 0},
  {9, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {20, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {13, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {28, 0},
  {2, 255},
  {1, 0},
  {24, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {33, 0},                                                /* End of row  54 */
  {37, 0},
  {5, 255},
  {1, 0},
  {14, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {19, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {5, 255},
  {1, 0},
  {27, 255},
  {9, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {28, 0},
  {8, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {33, 0},                                                /* End of row  55 */
  {37, 0},
  {2, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {17, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {6, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {24, 0},
  {4, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {33, 0},                                                /* End of row  56 */
  {36, 0},
  {26, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {15, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {7, 255},
  {1, 0},
  {16, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {4, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {26, 0},
  {2, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {31, 0},                                                /* End of row  57 */
  {36, 0},
  {4, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {15, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {14, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {31, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {21, 0},
  {6, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {31, 0},                                                /* End of row  58 */
  {36, 0},
  {2, 255},
  {1, 0},
  {29, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {12, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {7, 255},
  {6, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {26, 0},
  {5, 255},
  {1, 0},
  {28, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {31, 0},                                                /* End of row  59 */
  {36, 0},
  {25, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {11, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {25, 255},
  {1, 0},
  {9, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {19, 0},
  {2, 255},
  {1, 0},
  {27, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {30, 0},                                                /* End of row  60 */
  {36, 0},
  {4, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {25, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {10, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {4, 255},
  {1, 0},
  {24, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {17, 0},
  {9, 255},
  {1, 0},
  {17, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {30, 0},                                                /* End of row  61 */
  {36, 0},
  {2, 255},
  {1, 0},
  {26, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {8, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {33, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {15, 0},
  {4, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {30, 0},                                                /* End of row  62 */
  {36, 0},
  {25, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {7, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {3, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {16, 0},
  {2, 255},
  {1, 0},
  {26, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {29, 0},                                                /* End of row  63 */
  {36, 0},
  {5, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {10, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {6, 255},
  {1, 0},
  {24, 255},
  {1, 0},
  {6, 255},
  {6, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {12, 0},
  {27, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {30, 0},                                                /* End of row  64 */
  {36, 0},
  {2, 255},
  {1, 0},
  {30, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {2, 255},
  {1, 0},
  {32, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {14, 0},
  {5, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {24, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {29, 0},                                                /* End of row  65 */
  {36, 0},
  {6, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {28, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {5, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {10, 0},
  {2, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {31, 0},                                                /* End of row  66 */
  {36, 0},
  {3, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {12, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {5, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {31, 255},
  {6, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {8, 0},
  {7, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {31, 0},                                                /* End of row  67 */
  {36, 0},
  {1, 255},
  {1, 0},
  {30, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {1, 0},
  {27, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {4, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {6, 0},
  {4, 255},
  {1, 0},
  {32, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {30, 0},                                                /* End of row  68 */
  {36, 0},
  {6, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {5, 0},
  {1, 255},
  {5, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {36, 255},
  {1, 0},
  {3, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {10, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {2, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {31, 0},                                                /* End of row  69 */
  {36, 0},
  {4, 255},
  {1, 0},
  {28, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {25, 255},
  {1, 0},
  {8, 255},
  {8, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {7, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {33, 0},                                                /* End of row  70 */
  {36, 0},
  {31, 255},
  {1, 0},
  {10, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {2, 255},
  {1, 0},
  {31, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {11, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {5, 255},
  {1, 0},
  {31, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {32, 0},                                                /* End of row  71 */
  {36, 0},
  {2, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {29, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {25, 255},
  {1, 0},
  {8, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {16, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {33, 0},                                                /* End of row  72 */
  {36, 0},
  {5, 255},
  {1, 0},
  {28, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {3, 255},
  {1, 0},
  {32, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {1, 255},
  {14, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {8, 255},
  {1, 0},
  {27, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {34, 0},                                                /* End of row  73 */
  {36, 0},
  {3, 255},
  {1, 0},
  {27, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {42, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {33, 0},                                                /* End of row  74 */
  {36, 0},
  {36, 255},
  {1, 0},
  {7, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {4, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {24, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {4, 255},
  {14, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {34, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {34, 0},                                                /* End of row  75 */
  {36, 0},
  {1, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {25, 255},
  {1, 0},
  {10, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {38, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {35, 0},                                                /* End of row  76 */
  {36, 0},
  {4, 255},
  {1, 0},
  {34, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {4, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {44, 255},
  {3, 0},
  {1, 255},
  {10, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {37, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {35, 0},                                                /* End of row  77 */
  {36, 0},
  {35, 255},
  {1, 0},
  {9, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {27, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {6, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {36, 0},                                                /* End of row  78 */
  {36, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {26, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {7, 255},
  {4, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {40, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {27, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {36, 0},                                                /* End of row  79 */
  {36, 0},
  {41, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {33, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {36, 0},                                                /* End of row  80 */
  {36, 0},
  {4, 255},
  {1, 0},
  {31, 255},
  {1, 0},
  {10, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {33, 255},
  {1, 0},
  {9, 255},
  {8, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {33, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {37, 0},                                                /* End of row  81 */
  {36, 0},
  {2, 255},
  {1, 0},
  {36, 255},
  {1, 0},
  {7, 255},
  {2, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {34, 255},
  {1, 0},
  {4, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {5, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {38, 0},                                                /* End of row  82 */
  {36, 0},
  {6, 255},
  {1, 0},
  {35, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {39, 255},
  {1, 0},
  {7, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {31, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {38, 0},                                                /* End of row  83 */
  {36, 0},
  {36, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {7, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {33, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {1, 255},
  {12, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {38, 0},                                                /* End of row  84 */
  {36, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {43, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {6, 255},
  {1, 0},
  {41, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {6, 255},
  {1, 0},
  {26, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {39, 0},                                                /* End of row  85 */
  {36, 0},
  {38, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {5, 255},
  {1, 0},
  {36, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {5, 0},
  {1, 255},
  {9, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {40, 0},                                                /* End of row  86 */
  {36, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {33, 255},
  {1, 0},
  {8, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {1, 0},
  {36, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {3, 255},
  {1, 0},
  {24, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {41, 0},                                                /* End of row  87 */
  {36, 0},
  {39, 255},
  {1, 0},
  {10, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {43, 255},
  {1, 0},
  {5, 255},
  {3, 0},
  {1, 255},
  {9, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {28, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {40, 0},                                                /* End of row  88 */
  {36, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {38, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {5, 255},
  {1, 0},
  {40, 255},
  {1, 0},
  {3, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {7, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {41, 0},                                                /* End of row  89 */
  {36, 0},
  {42, 255},
  {1, 0},
  {8, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {16, 255},
  {1, 0},
  {9, 255},
  {2, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {26, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {42, 0},                                                /* End of row  90 */
  {36, 0},
  {3, 255},
  {1, 0},
  {35, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {2, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {6, 255},
  {1, 0},
  {36, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {6, 255},
  {1, 0},
  {30, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {43, 0},                                                /* End of row  91 */
  {36, 0},
  {6, 255},
  {1, 0},
  {38, 255},
  {1, 0},
  {6, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {41, 255},
  {1, 0},
  {5, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {17, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {42, 0},                                                /* End of row  92 */
  {36, 0},
  {2, 255},
  {1, 0},
  {39, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {5, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {9, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {37, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {43, 0},                                                /* End of row  93 */
  {36, 0},
  {25, 255},
  {1, 0},
  {24, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {41, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {1, 255},
  {9, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {44, 0},                                                /* End of row  94 */
  {36, 0},
  {4, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {35, 255},
  {1, 0},
  {10, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {4, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {7, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {3, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {16, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {45, 0},                                                /* End of row  95 */
  {36, 0},
  {2, 255},
  {1, 0},
  {38, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {4, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {6, 255},
  {1, 0},
  {26, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {45, 0},                                                /* End of row  96 */
  {36, 0},
  {25, 255},
  {1, 0},
  {29, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {7, 255},
  {1, 0},
  {40, 255},
  {1, 0},
  {5, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {46, 0},                                                /* End of row  97 */
  {36, 0},
  {4, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {36, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {7, 255},
  {2, 0},
  {1, 255},
  {9, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {45, 0},                                                /* End of row  98 */
  {36, 0},
  {2, 255},
  {1, 0},
  {24, 255},
  {1, 0},
  {28, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {27, 255},
  {1, 0},
  {3, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {33, 255},
  {1, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {47, 0},                                                /* End of row  99 */
  {36, 0},
  {25, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {5, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {3, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {5, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {6, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {46, 0},                                                /* End of row 100 */
  {36, 0},
  {5, 255},
  {1, 0},
  {47, 255},
  {1, 0},
  {3, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {17, 255},
  {1, 0},
  {31, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {10, 255},
  {1, 0},
  {17, 255},
  {1, 0},
  {8, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {47, 0},                                                /* End of row 101 */
  {36, 0},
  {2, 255},
  {1, 0},
  {26, 255},
  {1, 0},
  {15, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {8, 255},
  {7, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {29, 255},
  {1, 0},
  {17, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {3, 255},
  {9, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {33, 255},
  {1, 0},
  {2, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {48, 0},                                                /* End of row 102 */
  {36, 0},
  {6, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {25, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {6, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {17, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {49, 0},                                                /* End of row 103 */
  {36, 0},
  {3, 255},
  {1, 0},
  {24, 255},
  {1, 0},
  {29, 255},
  {7, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {46, 255},
  {1, 0},
  {2, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {37, 255},
  {9, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {48, 0},                                                /* End of row 104 */
  {36, 0},
  {1, 255},
  {1, 0},
  {45, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {5, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {1, 255},
  {10, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {6, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {50, 0},                                                /* End of row 105 */
  {36, 0},
  {6, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {25, 255},
  {1, 0},
  {2, 255},
  {7, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {7, 0},
  {3, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {6, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {3, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {17, 255},
  {1, 0},
  {9, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {50, 0},                                                /* End of row 106 */
  {36, 0},
  {4, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {31, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {27, 255},
  {1, 0},
  {26, 255},
  {1, 0},
  {4, 255},
  {7, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {26, 255},
  {1, 0},
  {3, 255},
  {6, 0},
  {1, 255},
  {57, 0},                                                /* End of row 107 */
  {36, 0},
  {48, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {5, 255},
  {7, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {24, 255},
  {1, 0},
  {17, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {30, 255},
  {1, 0},
  {5, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {50, 0},                                                /* End of row 108 */
  {36, 0},
  {2, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {17, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {26, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {28, 255},
  {1, 0},
  {7, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {8, 0},
  {5, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {1, 255},
  {16, 0},
  {1, 255},
  {48, 0},                                                /* End of row 109 */
  {36, 0},
  {5, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {16, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {5, 255},
  {7, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {25, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {27, 255},
  {3, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {10, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {51, 0},                                                /* End of row 110 */
  {36, 0},
  {3, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {26, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {5, 255},
  {15, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {46, 0},                                                /* End of row 111 */
  {36, 0},
  {31, 255},
  {1, 0},
  {30, 255},
  {7, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {24, 255},
  {1, 0},
  {37, 255},
  {2, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {8, 255},
  {1, 0},
  {28, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {51, 0},                                                /* End of row 112 */
  {36, 0},
  {1, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {6, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {6, 255},
  {1, 0},
  {24, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {14, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {45, 0},                                                /* End of row 113 */
  {36, 0},
  {4, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {3, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {6, 255},
  {1, 0},
  {46, 255},
  {1, 0},
  {9, 255},
  {8, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {3, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {3, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {44, 0},                                                /* End of row 114 */
  {36, 0},
  {27, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {8, 0},
  {8, 255},
  {1, 0},
  {28, 255},
  {3, 0},
  {1, 255},
  {12, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {43, 0},                                                /* End of row 115 */
  {36, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {2, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {6, 255},
  {1, 0},
  {47, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {2, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {3, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {41, 0},                                                /* End of row 116 */
  {36, 0},
  {25, 255},
  {1, 0},
  {26, 255},
  {1, 0},
  {12, 255},
  {7, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {30, 255},
  {2, 0},
  {1, 255},
  {7, 0},
  {7, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {8, 255},
  {2, 0},
  {1, 255},
  {11, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {42, 0},                                                /* End of row 117 */
  {36, 0},
  {4, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {24, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {27, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {4, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {37, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {40, 0},                                                /* End of row 118 */
  {36, 0},
  {2, 255},
  {1, 0},
  {32, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {2, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {6, 255},
  {1, 0},
  {17, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {10, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {16, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {10, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {38, 0},                                                /* End of row 119 */
  {35, 0},
  {1, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {27, 255},
  {12, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {27, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {3, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {37, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {43, 0},                                                /* End of row 120 */
  {34, 0},
  {1, 255},
  {1, 0},
  {58, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {4, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {17, 255},
  {1, 0},
  {31, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {5, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {10, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {37, 0},                                                /* End of row 121 */
  {33, 0},
  {1, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {2, 255},
  {9, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {23, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {3, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {9, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {36, 0},                                                /* End of row 122 */
  {32, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {17, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {25, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {30, 255},
  {1, 0},
  {27, 255},
  {1, 0},
  {8, 255},
  {4, 0},
  {8, 255},
  {1, 0},
  {24, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {34, 0},                                                /* End of row 123 */
  {31, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {29, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {10, 255},
  {13, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {28, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {30, 255},
  {1, 0},
  {6, 255},
  {8, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {36, 0},                                                /* End of row 124 */
  {30, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {26, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {24, 255},
  {1, 0},
  {6, 255},
  {2, 0},
  {9, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {32, 0},                                                /* End of row 125 */
  {29, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {3, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {9, 255},
  {17, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {4, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {10, 255},
  {2, 0},
  {9, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {4, 255},
  {2, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {35, 0},                                                /* End of row 126 */
  {28, 0},
  {1, 255},
  {6, 0},
  {34, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {4, 255},
  {3, 0},
  {6, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {5, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {31, 0},                                                /* End of row 127 */
  {27, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {8, 255},
  {14, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {23, 255},
  {1, 0},
  {6, 255},
  {3, 0},
  {4, 255},
  {1, 0},
  {25, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {27, 255},
  {2, 0},
  {1, 255},
  {12, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {30, 0},                                                /* End of row 128 */
  {26, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {5, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {30, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {26, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {28, 0},                                                /* End of row 129 */
  {25, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {32, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {16, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {13, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {4, 255},
  {1, 0},
  {26, 255},
  {4, 0},
  {26, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {26, 255},
  {1, 0},
  {5, 255},
  {2, 0},
  {1, 255},
  {12, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {31, 0},                                                /* End of row 130 */
  {24, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {27, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {4, 255},
  {1, 0},
  {33, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {7, 255},
  {1, 0},
  {15, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {4, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {26, 0},                                                /* End of row 131 */
  {23, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {7, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {3, 255},
  {10, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {1, 0},
  {28, 255},
  {5, 0},
  {65, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {27, 0},                                                /* End of row 132 */
  {22, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {32, 255},
  {3, 0},
  {4, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {7, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {4, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {25, 0},                                                /* End of row 133 */
  {21, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {4, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {25, 255},
  {1, 0},
  {3, 255},
  {8, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {7, 255},
  {1, 0},
  {15, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {26, 255},
  {1, 0},
  {31, 255},
  {2, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {26, 0},                                                /* End of row 134 */
  {20, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {25, 255},
  {1, 0},
  {6, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {10, 255},
  {1, 0},
  {16, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {27, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {30, 255},
  {1, 0},
  {24, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {4, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {22, 0},                                                /* End of row 135 */
  {19, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {5, 255},
  {1, 0},
  {25, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {5, 255},
  {1, 0},
  {29, 255},
  {1, 0},
  {2, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {5, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {4, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {25, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {9, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {23, 0},                                                /* End of row 136 */
  {18, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {9, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {6, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {8, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {24, 255},
  {1, 0},
  {6, 255},
  {7, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {21, 0},                                                /* End of row 137 */
  {17, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {7, 0},
  {5, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {6, 255},
  {5, 0},
  {26, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {6, 255},
  {8, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {27, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {33, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {19, 0},                                                /* End of row 138 */
  {16, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {32, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {4, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {24, 255},
  {1, 0},
  {4, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {23, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {32, 255},
  {15, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {21, 0},                                                /* End of row 139 */
  {15, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {3, 255},
  {1, 0},
  {24, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {28, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {2, 255},
  {8, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {6, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {16, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {17, 0},                                                /* End of row 140 */
  {14, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {5, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {6, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {25, 255},
  {1, 0},
  {4, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {29, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {9, 255},
  {17, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {21, 0},                                                /* End of row 141 */
  {13, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {3, 0},
  {32, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {26, 255},
  {1, 0},
  {11, 255},
  {8, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {7, 255},
  {1, 0},
  {22, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {3, 255},
  {1, 0},
  {47, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {15, 0},                                                /* End of row 142 */
  {12, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {3, 255},
  {1, 0},
  {26, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {4, 255},
  {3, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {17, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {17, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {3, 255},
  {18, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {21, 0},                                                /* End of row 143 */
  {11, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {25, 255},
  {1, 0},
  {6, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {6, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {17, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {2, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {30, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {3, 255},
  {1, 0},
  {43, 255},
  {1, 0},
  {9, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {13, 0},                                                /* End of row 144 */
  {10, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {25, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {31, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {1, 255},
  {9, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {25, 255},
  {1, 0},
  {4, 255},
  {8, 0},
  {1, 255},
  {3, 0},
  {27, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {20, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {18, 0},                                                /* End of row 145 */
  {9, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {4, 255},
  {9, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {9, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {16, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {36, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {12, 0},                                                /* End of row 146 */
  {8, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {26, 255},
  {1, 0},
  {6, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {8, 255},
  {1, 0},
  {16, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {4, 255},
  {11, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {30, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {2, 255},
  {1, 0},
  {50, 255},
  {17, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {11, 0},                                                /* End of row 147 */
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {24, 255},
  {1, 0},
  {1, 255},
  {10, 0},
  {3, 255},
  {1, 0},
  {25, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {8, 0},
  {9, 255},
  {1, 0},
  {15, 255},
  {1, 0},
  {17, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {9, 0},                                                 /* End of row 148 */
  {6, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {2, 255},
  {1, 0},
  {25, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {5, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {6, 255},
  {10, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {6, 255},
  {1, 0},
  {16, 255},
  {1, 0},
  {6, 255},
  {7, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {4, 255},
  {1, 0},
  {46, 255},
  {10, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {10, 0},                                                /* End of row 149 */
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {17, 255},
  {1, 0},
  {6, 255},
  {11, 0},
  {27, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {3, 255},
  {1, 0},
  {25, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {32, 255},
  {1, 0},
  {10, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {8, 0},                                                 /* End of row 150 */
  {4, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {3, 255},
  {1, 0},
  {28, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {24, 255},
  {1, 0},
  {6, 255},
  {8, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {25, 255},
  {1, 0},
  {4, 255},
  {8, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {42, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {11, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {7, 0},                                                 /* End of row 151 */
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {4, 0},
  {9, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {9, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {4, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {15, 255},
  {1, 0},
  {6, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {40, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {9, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {8, 0},                                                 /* End of row 152 */
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {6, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {3, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {4, 255},
  {6, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {26, 255},
  {1, 0},
  {1, 255},
  {11, 0},
  {1, 255},
  {4, 0},
  {38, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {10, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},                                                 /* End of row 153 */
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {33, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {6, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {5, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {41, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {8, 0},                                                 /* End of row 154 */
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {4, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {1, 255},
  {9, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {27, 255},
  {1, 0},
  {6, 255},
  {3, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {6, 255},
  {12, 0},
  {1, 255},
  {4, 0},
  {2, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {27, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {11, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {9, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},                                                 /* End of row 155 */
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {6, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {7, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {10, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {30, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {46, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},                                                 /* End of row 156 */
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {5, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {4, 0},
  {32, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {15, 0},
  {1, 255},
  {2, 0},
  {4, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {27, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {13, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},                                                 /* End of row 157 */
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {3, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {4, 255},
  {5, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {9, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {2, 255},
  {1, 0},
  {30, 255},
  {1, 0},
  {9, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},                                                 /* End of row 158 */
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {26, 255},
  {1, 0},
  {6, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {9, 255},
  {1, 0},
  {15, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {5, 255},
  {1, 0},
  {24, 255},
  {15, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {30, 255},
  {1, 0},
  {3, 255},
  {14, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},                                               /* End of row 159 */
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {27, 255},
  {1, 0},
  {4, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {26, 255},
  {1, 0},
  {3, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {8, 255},
  {1, 0},
  {25, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},                                                 /* End of row 160 */
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {1, 0},
  {25, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {24, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {3, 255},
  {13, 0},
  {1, 255},
  {2, 0},
  {4, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {15, 255},
  {1, 0},
  {6, 255},
  {14, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {27, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {6, 0},                                                 /* End of row 161 */
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {5, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {6, 255},
  {4, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {4, 0},
  {6, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {7, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {28, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {29, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},                                                 /* End of row 162 */
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {24, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {27, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {2, 255},
  {11, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {4, 255},
  {12, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {33, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {8, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},                                               /* End of row 163 */
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {27, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {5, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {6, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {23, 255},
  {1, 0},
  {6, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {7, 0},
  {5, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {7, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},                                                 /* End of row 164 */
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {6, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {32, 255},
  {1, 0},
  {5, 255},
  {14, 0},
  {8, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {1, 255},
  {13, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {33, 255},
  {1, 0},
  {3, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {1, 0},                                                 /* End of row 165 */
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {24, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {4, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {17, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {3, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {25, 255},
  {1, 0},
  {6, 255},
  {2, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {2, 0},                                                 /* End of row 166 */
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {28, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {38, 255},
  {5, 0},
  {1, 255},
  {7, 0},
  {24, 255},
  {1, 0},
  {6, 255},
  {12, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {25, 255},
  {1, 0},
  {9, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {9, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},                                                 /* End of row 167 */
  {7, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {5, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {5, 255},
  {10, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {4, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {6, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {5, 255},
  {1, 0},
  {24, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {6, 0},
  {6, 255},
  {1, 0},
  {31, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {9, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {4, 0},
  {3, 255},
  {4, 0},
  {1, 255},
  {2, 0},                                                 /* End of row 168 */
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {3, 255},
  {1, 0},
  {27, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {9, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {4, 255},
  {3, 0},
  {1, 255},
  {9, 0},
  {2, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {42, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},                                                 /* End of row 169 */
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {25, 255},
  {1, 0},
  {6, 255},
  {9, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {15, 255},
  {1, 0},
  {6, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {6, 255},
  {1, 0},
  {29, 255},
  {1, 0},
  {9, 255},
  {6, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {8, 0},                                                 /* End of row 170 */
  {9, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {4, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {28, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {4, 255},
  {1, 0},
  {25, 255},
  {6, 0},
  {1, 255},
  {6, 0},
  {4, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {29, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {4, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {6, 0},                                                 /* End of row 171 */
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {30, 255},
  {13, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {4, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {26, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {45, 255},
  {1, 0},
  {2, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {7, 0},                                                 /* End of row 172 */
  {10, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {25, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {7, 255},
  {4, 0},
  {1, 255},
  {6, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {16, 255},
  {1, 0},
  {6, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {30, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {9, 0},                                                 /* End of row 173 */
  {8, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {3, 255},
  {14, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {7, 255},
  {1, 0},
  {26, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {28, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {3, 0},
  {43, 255},
  {1, 0},
  {6, 255},
  {7, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {8, 0},                                                 /* End of row 174 */
  {16, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {33, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {17, 255},
  {1, 0},
  {10, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {4, 255},
  {5, 0},
  {1, 255},
  {6, 0},
  {5, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {36, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {10, 0},                                                /* End of row 175 */
  {10, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {6, 255},
  {15, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {30, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {1, 255},
  {7, 0},
  {7, 255},
  {1, 0},
  {15, 255},
  {1, 0},
  {6, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {38, 255},
  {1, 0},
  {9, 255},
  {7, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {13, 0},                                                /* End of row 176 */
  {13, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {4, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {30, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {3, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {2, 255},
  {4, 0},
  {1, 255},
  {6, 0},
  {8, 255},
  {1, 0},
  {45, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {12, 0},                                                /* End of row 177 */
  {14, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {7, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {1, 255},
  {14, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {30, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {3, 255},
  {1, 0},
  {41, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {10, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {14, 0},                                                /* End of row 178 */
  {15, 0},
  {1, 255},
  {10, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {8, 255},
  {1, 0},
  {29, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {5, 255},
  {1, 0},
  {17, 255},
  {1, 0},
  {6, 255},
  {10, 0},
  {7, 255},
  {1, 0},
  {48, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {15, 0},                                                /* End of row 179 */
  {14, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {28, 255},
  {1, 0},
  {3, 255},
  {14, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {27, 255},
  {1, 0},
  {5, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {3, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {10, 255},
  {1, 0},
  {36, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {4, 255},
  {9, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {17, 0},                                                /* End of row 180 */
  {16, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {5, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {24, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {6, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {16, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {3, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {6, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {1, 255},
  {9, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {25, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {15, 0},                                                /* End of row 181 */
  {18, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {14, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {33, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {10, 255},
  {1, 0},
  {40, 255},
  {1, 0},
  {7, 255},
  {9, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {2, 255},
  {5, 0},
  {1, 255},
  {16, 0},                                                /* End of row 182 */
  {19, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {33, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {28, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {30, 255},
  {8, 0},
  {3, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {17, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {5, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {11, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {17, 0},                                                /* End of row 183 */
  {18, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {4, 255},
  {7, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {6, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {16, 255},
  {1, 0},
  {11, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {23, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {31, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {2, 255},
  {4, 0},
  {1, 255},
  {18, 0},                                                /* End of row 184 */
  {20, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {25, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {27, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {23, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {7, 0},
  {3, 255},
  {1, 0},
  {30, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {4, 255},
  {2, 0},
  {1, 255},
  {19, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {19, 0},                                                /* End of row 185 */
  {22, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {4, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {24, 255},
  {6, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {28, 255},
  {5, 0},
  {4, 255},
  {1, 0},
  {25, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {31, 255},
  {1, 0},
  {27, 255},
  {1, 0},
  {2, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {23, 0},                                                /* End of row 186 */
  {23, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {28, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {5, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {5, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {17, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {26, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {1, 255},
  {13, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {2, 255},
  {4, 0},
  {1, 255},
  {22, 0},                                                /* End of row 187 */
  {22, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {5, 255},
  {14, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {11, 255},
  {1, 0},
  {15, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {2, 255},
  {4, 0},
  {2, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {6, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {3, 255},
  {1, 0},
  {30, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {16, 255},
  {1, 0},
  {9, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {23, 0},                                                /* End of row 188 */
  {24, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {32, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {8, 255},
  {2, 0},
  {6, 255},
  {1, 0},
  {24, 255},
  {5, 0},
  {9, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {26, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {1, 255},
  {11, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {28, 0},                                                /* End of row 189 */
  {26, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {5, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {14, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {32, 255},
  {1, 0},
  {5, 255},
  {3, 0},
  {26, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {5, 255},
  {1, 0},
  {60, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {24, 0},                                                /* End of row 190 */
  {27, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {1, 0},
  {29, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {16, 255},
  {1, 0},
  {6, 255},
  {4, 0},
  {3, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {1, 255},
  {9, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {28, 0},                                                /* End of row 191 */
  {28, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {4, 255},
  {4, 0},
  {1, 255},
  {9, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {10, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {8, 255},
  {2, 0},
  {28, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {24, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {6, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {26, 0},                                                /* End of row 192 */
  {27, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {25, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {4, 255},
  {3, 0},
  {6, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {28, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {27, 0},                                                /* End of row 193 */
  {29, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {3, 255},
  {1, 0},
  {28, 255},
  {3, 0},
  {1, 255},
  {9, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {26, 255},
  {1, 0},
  {11, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {15, 255},
  {1, 0},
  {6, 255},
  {2, 0},
  {3, 255},
  {1, 0},
  {32, 255},
  {1, 0},
  {24, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {5, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {30, 0},                                                /* End of row 194 */
  {31, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {3, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {3, 255},
  {1, 0},
  {24, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {25, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {6, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {26, 255},
  {7, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {32, 0},                                                /* End of row 195 */
  {32, 0},
  {1, 255},
  {3, 0},
  {4, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {5, 255},
  {2, 0},
  {1, 255},
  {10, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {25, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {4, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {27, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {4, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {30, 0},                                                /* End of row 196 */
  {31, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {29, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {6, 0},
  {3, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {25, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {32, 255},
  {1, 0},
  {2, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {32, 0},                                                /* End of row 197 */
  {33, 0},
  {1, 255},
  {2, 0},
  {7, 255},
  {1, 0},
  {17, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {9, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {38, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {4, 255},
  {2, 0},
  {1, 255},
  {10, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {33, 0},                                                /* End of row 198 */
  {35, 0},
  {6, 255},
  {1, 0},
  {26, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {5, 255},
  {1, 0},
  {28, 255},
  {1, 0},
  {26, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {4, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {27, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {2, 255},
  {38, 0},                                                /* End of row 199 */
  {36, 0},
  {3, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {4, 255},
  {3, 0},
  {1, 255},
  {11, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {11, 255},
  {1, 0},
  {15, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {17, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {30, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {26, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {34, 0},                                                /* End of row 200 */
  {35, 0},
  {2, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {24, 255},
  {1, 0},
  {33, 255},
  {1, 0},
  {27, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {4, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {4, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {6, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {37, 0},                                                /* End of row 201 */
  {36, 0},
  {32, 255},
  {4, 0},
  {1, 255},
  {10, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {29, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {11, 255},
  {1, 0},
  {28, 255},
  {5, 0},
  {7, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {8, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {38, 0},                                                /* End of row 202 */
  {36, 0},
  {5, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {17, 255},
  {1, 0},
  {31, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {26, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {39, 0},                                                /* End of row 203 */
  {36, 0},
  {2, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {5, 255},
  {5, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {11, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {38, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {26, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {43, 0},                                                /* End of row 204 */
  {36, 0},
  {6, 255},
  {1, 0},
  {25, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {30, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {3, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {7, 255},
  {4, 0},
  {1, 255},
  {9, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {40, 0},                                                /* End of row 205 */
  {36, 0},
  {4, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {6, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {32, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {15, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {24, 255},
  {1, 0},
  {9, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {24, 255},
  {1, 0},
  {4, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {7, 0},
  {2, 255},
  {45, 0},                                                /* End of row 206 */
  {36, 0},
  {2, 255},
  {1, 0},
  {29, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {3, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {36, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {3, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {32, 255},
  {1, 0},
  {2, 255},
  {13, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {41, 0},                                                /* End of row 207 */
  {36, 0},
  {27, 255},
  {1, 0},
  {4, 255},
  {7, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {15, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {28, 255},
  {1, 0},
  {7, 255},
  {11, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {6, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {44, 0},                                                /* End of row 208 */
  {36, 0},
  {5, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {8, 0},
  {3, 255},
  {1, 0},
  {50, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {8, 255},
  {1, 0},
  {26, 255},
  {11, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {45, 0},                                                /* End of row 209 */
  {36, 0},
  {2, 255},
  {1, 0},
  {29, 255},
  {11, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {17, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {36, 255},
  {13, 0},
  {4, 255},
  {1, 0},
  {24, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {46, 0},                                                /* End of row 210 */
  {36, 0},
  {6, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {5, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {29, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {6, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {9, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {7, 0},
  {2, 255},
  {50, 0},                                                /* End of row 211 */
  {36, 0},
  {3, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {6, 255},
  {12, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {27, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {17, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {24, 255},
  {1, 0},
  {9, 255},
  {15, 0},
  {4, 255},
  {1, 0},
  {24, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {47, 0},                                                /* End of row 212 */
  {36, 0},
  {30, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {6, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {16, 255},
  {1, 0},
  {62, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {26, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {3, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {7, 0},
  {2, 255},
  {52, 0},                                                /* End of row 213 */
  {36, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {4, 255},
  {11, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {32, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {17, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {13, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {27, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {49, 0},                                                /* End of row 214 */
  {36, 0},
  {25, 255},
  {1, 0},
  {6, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {1, 0},
  {24, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {9, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {4, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {11, 0},
  {1, 255},
  {49, 0},                                                /* End of row 215 */
  {36, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {1, 255},
  {10, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {47, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {10, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {25, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {4, 255},
  {7, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {50, 0},                                                /* End of row 216 */
  {36, 0},
  {28, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {9, 255},
  {1, 0},
  {16, 255},
  {1, 0},
  {26, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {24, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {6, 255},
  {1, 0},
  {28, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {52, 0},                                                /* End of row 217 */
  {36, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {6, 255},
  {14, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {16, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {6, 255},
  {8, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {2, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {51, 0},                                                /* End of row 218 */
  {36, 0},
  {32, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {84, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {4, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {50, 0},                                                /* End of row 219 */
  {36, 0},
  {7, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {12, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {3, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {17, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {11, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {26, 255},
  {1, 0},
  {8, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {50, 0},                                                /* End of row 220 */
  {36, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {39, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {29, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {50, 0},                                                /* End of row 221 */
  {36, 0},
  {32, 255},
  {13, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {27, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {24, 255},
  {1, 0},
  {6, 255},
  {12, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {26, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {49, 0},                                                /* End of row 222 */
  {36, 0},
  {3, 255},
  {1, 0},
  {24, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {17, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {24, 255},
  {1, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {24, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {49, 0},                                                /* End of row 223 */
  {36, 0},
  {6, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {6, 255},
  {13, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {5, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {42, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {6, 255},
  {16, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {5, 255},
  {1, 0},
  {24, 255},
  {1, 0},
  {4, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {48, 0},                                                /* End of row 224 */
  {36, 0},
  {1, 255},
  {1, 0},
  {27, 255},
  {1, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {40, 255},
  {1, 0},
  {27, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {1, 0},
  {28, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {48, 0},                                                /* End of row 225 */
  {36, 0},
  {4, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {4, 255},
  {5, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {4, 0},
  {2, 255},
  {1, 0},
  {26, 255},
  {1, 0},
  {17, 255},
  {1, 0},
  {26, 255},
  {1, 0},
  {3, 255},
  {15, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {47, 0},                                                /* End of row 226 */
  {36, 0},
  {7, 255},
  {1, 0},
  {17, 255},
  {1, 0},
  {6, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {15, 255},
  {1, 0},
  {41, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {5, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {8, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {47, 0},                                                /* End of row 227 */
  {36, 0},
  {2, 255},
  {1, 0},
  {27, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {7, 0},
  {7, 255},
  {1, 0},
  {37, 255},
  {1, 0},
  {28, 255},
  {1, 0},
  {1, 255},
  {14, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {46, 0},                                                /* End of row 228 */
  {36, 0},
  {5, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {4, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {37, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {3, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {25, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {45, 0},                                                /* End of row 229 */
  {36, 0},
  {25, 255},
  {1, 0},
  {6, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {36, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {5, 255},
  {4, 0},
  {1, 255},
  {10, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {3, 255},
  {1, 0},
  {26, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {46, 0},                                                /* End of row 230 */
  {36, 0},
  {2, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {24, 255},
  {9, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {27, 255},
  {1, 0},
  {15, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {6, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {44, 0},                                                /* End of row 231 */
  {36, 0},
  {5, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {14, 255},
  {1, 0},
  {36, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {11, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {8, 255},
  {1, 0},
  {27, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {45, 0},                                                /* End of row 232 */
  {36, 0},
  {3, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {6, 255},
  {10, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {6, 255},
  {1, 0},
  {60, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {44, 0},                                                /* End of row 233 */
  {36, 0},
  {32, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {59, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {4, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {5, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {43, 0},                                                /* End of row 234 */
  {36, 0},
  {1, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {3, 255},
  {10, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {7, 255},
  {1, 0},
  {51, 255},
  {1, 0},
  {8, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {29, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {43, 0},                                                /* End of row 235 */
  {36, 0},
  {4, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {57, 255},
  {8, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {42, 0},                                                /* End of row 236 */
  {36, 0},
  {29, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {5, 0},
  {4, 255},
  {1, 0},
  {52, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {9, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {7, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {42, 0},                                                /* End of row 237 */
  {36, 0},
  {2, 255},
  {1, 0},
  {24, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {58, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {3, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {41, 0},                                                /* End of row 238 */
  {36, 0},
  {5, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {9, 255},
  {1, 0},
  {45, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {10, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {29, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {40, 0},                                                /* End of row 239 */
  {36, 0},
  {30, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {52, 255},
  {1, 0},
  {5, 255},
  {7, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {4, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {17, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {40, 0},                                                /* End of row 240 */
  {36, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {4, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {53, 255},
  {1, 0},
  {8, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {29, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {40, 0},                                                /* End of row 241 */
  {36, 0},
  {25, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {48, 255},
  {1, 0},
  {3, 255},
  {7, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {39, 0},                                                /* End of row 242 */
  {36, 0},
  {3, 255},
  {1, 0},
  {28, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {48, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {4, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {4, 255},
  {1, 0},
  {27, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {38, 0},                                                /* End of row 243 */
  {36, 0},
  {6, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {53, 255},
  {9, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {39, 0},                                                /* End of row 244 */
  {36, 0},
  {1, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {3, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {40, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {38, 0},                                                /* End of row 245 */
  {36, 0},
  {4, 255},
  {1, 0},
  {27, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {59, 255},
  {8, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {3, 0},
  {6, 255},
  {1, 0},
  {25, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {37, 0},                                                /* End of row 246 */
  {36, 0},
  {7, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {5, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {36, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {9, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {3, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {37, 0},                                                /* End of row 247 */
  {36, 0},
  {2, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {1, 0},
  {53, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {36, 0},                                                /* End of row 248 */
  {36, 0},
  {5, 255},
  {1, 0},
  {24, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {6, 255},
  {1, 0},
  {40, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {13, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {2, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {29, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {36, 0},                                                /* End of row 249 */
  {36, 0},
  {27, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {34, 255},
  {1, 0},
  {9, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {25, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {35, 0},                                                /* End of row 250 */
  {36, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {48, 255},
  {1, 0},
  {3, 255},
  {3, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {8, 0},
  {3, 255},
  {1, 0},
  {27, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {34, 0},                                                /* End of row 251 */
  {36, 0},
  {4, 255},
  {1, 0},
  {25, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {34, 255},
  {1, 0},
  {6, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {10, 0},
  {6, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {35, 0},                                                /* End of row 252 */
  {36, 0},
  {28, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {32, 255},
  {1, 0},
  {8, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {12, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {10, 0},
  {28, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {34, 0},                                                /* End of row 253 */
  {36, 0},
  {2, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {9, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {43, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {8, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {11, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {33, 0},                                                /* End of row 254 */
  {36, 0},
  {5, 255},
  {1, 0},
  {26, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {10, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {44, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {10, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {15, 0},
  {29, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {32, 0},                                                /* End of row 255 */
  {36, 0},
  {3, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {9, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {6, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {29, 255},
  {1, 0},
  {8, 255},
  {10, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {13, 0},
  {8, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {33, 0},                                                /* End of row 256 */
  {36, 0},
  {7, 255},
  {1, 0},
  {17, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {10, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {36, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {4, 0},
  {1, 255},
  {15, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {31, 0},                                                /* End of row 257 */
  {36, 0},
  {1, 255},
  {1, 0},
  {30, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {13, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {9, 255},
  {1, 0},
  {26, 255},
  {1, 0},
  {9, 255},
  {10, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {18, 0},
  {35, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {31, 0},                                                /* End of row 258 */
  {36, 0},
  {4, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {14, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {4, 255},
  {1, 0},
  {35, 255},
  {1, 0},
  {3, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {9, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {2, 255},
  {4, 0},
  {1, 255},
  {18, 0},
  {4, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {30, 0},                                                /* End of row 259 */
  {36, 0},
  {7, 255},
  {1, 0},
  {17, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {14, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {28, 255},
  {1, 0},
  {7, 255},
  {13, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {19, 0},
  {2, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {10, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {30, 0},                                                /* End of row 260 */
  {36, 0},
  {2, 255},
  {1, 0},
  {27, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {14, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {4, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {24, 0},
  {29, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {30, 0},                                                /* End of row 261 */
  {36, 0},
  {5, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {17, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {42, 255},
  {15, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {23, 0},
  {4, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {29, 0},                                                /* End of row 262 */
  {36, 0},
  {25, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {16, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {6, 255},
  {1, 0},
  {24, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {4, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {26, 0},
  {30, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {30, 0},                                                /* End of row 263 */
  {36, 0},
  {2, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {17, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {28, 255},
  {1, 0},
  {1, 255},
  {15, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {27, 0},
  {1, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {29, 0},                                                /* End of row 264 */
  {36, 0},
  {5, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {20, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {4, 255},
  {1, 0},
  {24, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {4, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {30, 0},
  {3, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {28, 0},                                                /* End of row 265 */
  {36, 0},
  {3, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {19, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {10, 255},
  {1, 0},
  {27, 255},
  {4, 0},
  {1, 255},
  {10, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {28, 0},
  {5, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {29, 0},                                                /* End of row 266 */
  {36, 0},
  {32, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {20, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {4, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {30, 0},
  {32, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {28, 0},                                                /* End of row 267 */
  {36, 0},
  {1, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {24, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {33, 255},
  {6, 0},
  {1, 255},
  {9, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {31, 0},
  {1, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {16, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {27, 0},                                                /* End of row 268 */
  {36, 0},
  {4, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {21, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {25, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {4, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {35, 0},
  {3, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {28, 0},                                                /* End of row 269 */
  {36, 0},
  {32, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {24, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {9, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {36, 0},
  {23, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {27, 0},                                                /* End of row 270 */
  {36, 0},
  {2, 255},
  {1, 0},
  {25, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {24, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {22, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {5, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {41, 0},
  {4, 255},
  {1, 0},
  {14, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {28, 0},                                                /* End of row 271 */
  {36, 0},
  {5, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {28, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {4, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {2, 255},
  {10, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {37, 0},
  {2, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {16, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {27, 0},                                                /* End of row 272 */
  {36, 0},
  {29, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {25, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {10, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {41, 0},
  {15, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {27, 0},                                                /* End of row 273 */
  {36, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {20, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {30, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {14, 255},
  {10, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {4, 0},
  {1, 255},
  {40, 0},
  {4, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {28, 0},                                                /* End of row 274 */
  {36, 0},
  {25, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {28, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {7, 255},
  {1, 0},
  {10, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {5, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {43, 0},
  {13, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {29, 0},                                                /* End of row 275 */
  {36, 0},
  {3, 255},
  {1, 0},
  {27, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {29, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {3, 255},
  {1, 0},
  {11, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {2, 255},
  {12, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {46, 0},
  {1, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {28, 0},                                                /* End of row 276 */
  {36, 0},
  {6, 255},
  {1, 0},
  {21, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {31, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {7, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {6, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {4, 0},
  {1, 255},
  {45, 0},
  {7, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {29, 0},                                                /* End of row 277 */
  {36, 0},
  {1, 255},
  {1, 0},
  {23, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {32, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {5, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {3, 255},
  {5, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {46, 0},
  {3, 255},
  {1, 0},
  {12, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {29, 0},                                                /* End of row 278 */
  {36, 0},
  {4, 255},
  {1, 0},
  {25, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {34, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {17, 255},
  {1, 0},
  {4, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {51, 0},
  {7, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {30, 0},                                                /* End of row 279 */
  {36, 0},
  {7, 255},
  {1, 0},
  {19, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {32, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {5, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {5, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {52, 0},
  {2, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {31, 0},                                                /* End of row 280 */
  {51, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {34, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {17, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {57, 0},
  {6, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {32, 0},                                                /* End of row 281 */
  {50, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {38, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {7, 0},
  {6, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {5, 255},
  {10, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {62, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {31, 0},                                                /* End of row 282 */
  {51, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {36, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {1, 0},
  {8, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {63, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {33, 0},                                                /* End of row 283 */
  {50, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {37, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {4, 255},
  {1, 0},
  {3, 255},
  {4, 0},
  {1, 255},
  {10, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {66, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {32, 0},                                                /* End of row 284 */
  {50, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {42, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {11, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {6, 0},
  {2, 255},
  {4, 0},
  {1, 255},
  {66, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {35, 0},                                                /* End of row 285 */
  {51, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {38, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {16, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {68, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {34, 0},                                                /* End of row 286 */
  {50, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {44, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {72, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {36, 0},                                                /* End of row 287 */
  {50, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {41, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {15, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {72, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {37, 0},                                                /* End of row 288 */
  {51, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {43, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {73, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {39, 0},                                                /* End of row 289 */
  {50, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {47, 0},
  {1, 255},
  {9, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {9, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {78, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {41, 0},                                                /* End of row 290 */
  {50, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {43, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {130, 0},                                               /* End of row 291 */
  {51, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {47, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {131, 0},                                               /* End of row 292 */
  {50, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {46, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {133, 0},                                               /* End of row 293 */
  {50, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {47, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {132, 0},                                               /* End of row 294 */
  {130, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {133, 0},                                               /* End of row 295 */
  {132, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {136, 0},                                               /* End of row 296 */
  {133, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {137, 0},                                               /* End of row 297 */
  {132, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {139, 0},                                               /* End of row 298 */
  {136, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {138, 0},                                               /* End of row 299 */
  {134, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {140, 0},                                               /* End of row 300 */
  {136, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {139, 0},                                               /* End of row 301 */
  {139, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {141, 0},                                               /* End of row 302 */
  {137, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {145, 0},                                               /* End of row 303 */
  {139, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {143, 0},                                               /* End of row 304 */
  {140, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {144, 0},                                               /* End of row 305 */
  {143, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {147, 0},                                               /* End of row 306 */
  {141, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {145, 0},                                               /* End of row 307 */
  {147, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {6, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {147, 0},                                               /* End of row 308 */
  {143, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {148, 0},                                               /* End of row 309 */
  {146, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {149, 0},                                               /* End of row 310 */
  {149, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {155, 0},                                               /* End of row 311 */
  {146, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {151, 0},                                               /* End of row 312 */
  {150, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {152, 0},                                               /* End of row 313 */
  {148, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {153, 0},                                               /* End of row 314 */
  {150, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {158, 0},                                               /* End of row 315 */
  {152, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {154, 0},                                               /* End of row 316 */
  {153, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {157, 0},                                               /* End of row 317 */
  {152, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {159, 0},                                               /* End of row 318 */
  {154, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {158, 0},                                               /* End of row 319 */
  {155, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {159, 0},                                               /* End of row 320 */
};
#endif /* CONFIG_VIDEO_FB_SPLASHSCREEN_MONO */

const struct palette_bitmap_s g_splscr =
{
  320,                 /* width in pixels                                   */
  320,                 /* height in pixels                                  */
  palette,             /* Colour palette                                    */
  bitmap,              /* Pointer to the start of the RLE data              */
};

/****************************************************************************
 * Private Functions
 ****************************************************************************/
