/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.urlfilter.domain;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.MethodHandles;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.net.URLFilter;
import org.apache.nutch.plugin.Extension;
import org.apache.nutch.plugin.PluginRepository;
import org.apache.nutch.util.URLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainURLFilter
implements URLFilter {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static String attributeFile = null;
    private Configuration conf;
    private Set<String> domainSet = new LinkedHashSet<String>();

    private void readConfiguration(Reader configReader) throws IOException {
        BufferedReader reader = new BufferedReader(configReader);
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (!StringUtils.isNotBlank((CharSequence)line) || line.startsWith("#")) continue;
            this.domainSet.add(StringUtils.lowerCase((String)line.trim()));
        }
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        String pluginName = "urlfilter-domain";
        Extension[] extensions = PluginRepository.get((Configuration)conf).getExtensionPoint(URLFilter.class.getName()).getExtensions();
        for (int i = 0; i < extensions.length; ++i) {
            Extension extension = extensions[i];
            if (!extension.getDescriptor().getPluginId().equals(pluginName)) continue;
            attributeFile = extension.getAttribute("file");
            break;
        }
        if (attributeFile != null && attributeFile.trim().isEmpty()) {
            attributeFile = null;
        }
        if (attributeFile != null) {
            LOG.info("Attribute \"file\" is defined for plugin {} as {}", (Object)pluginName, (Object)attributeFile);
        }
        String stringRules = conf.get("urlfilter.domain.rules");
        String file = conf.get("urlfilter.domain.file", attributeFile);
        Reader reader = null;
        if (stringRules != null) {
            reader = new StringReader(stringRules);
        } else {
            LOG.info("Reading {} rules file {}", (Object)pluginName, (Object)file);
            reader = conf.getConfResourceAsReader(file);
        }
        try {
            if (reader == null) {
                reader = new FileReader(file);
            }
            this.readConfiguration(reader);
        }
        catch (IOException e) {
            LOG.error("Error reading {} rule file {}", new Object[]{pluginName, file, e});
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    public String filter(String url) {
        if (this.domainSet.size() == 0) {
            return url;
        }
        try {
            String domain = URLUtil.getDomainName((String)url);
            String host = URLUtil.getHost((String)url);
            String suffix = URLUtil.getDomainSuffix((String)url);
            if (this.domainSet.contains(suffix) || this.domainSet.contains(domain) || this.domainSet.contains(host)) {
                return url;
            }
            return null;
        }
        catch (Exception e) {
            LOG.error("Could not apply filter on url: {}", (Object)url, (Object)e);
            return null;
        }
    }
}

