/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath.functions;

import javax.xml.transform.TransformerException;
import net.sourceforge.htmlunit.xpath.XPathContext;
import net.sourceforge.htmlunit.xpath.functions.FunctionOneArg;
import net.sourceforge.htmlunit.xpath.functions.WrongNumberArgsException;
import net.sourceforge.htmlunit.xpath.objects.XString;
import net.sourceforge.htmlunit.xpath.res.XPATHMessages;
import net.sourceforge.htmlunit.xpath.xml.dtm.DTM;

public class FunctionDef1Arg
extends FunctionOneArg {
    protected int getArg0AsNode(XPathContext xctxt) throws TransformerException {
        return null == this.m_arg0 ? xctxt.getCurrentNode() : this.m_arg0.asNode(xctxt);
    }

    protected XString getArg0AsString(XPathContext xctxt) throws TransformerException {
        if (null == this.m_arg0) {
            int currentNode = xctxt.getCurrentNode();
            if (-1 == currentNode) {
                return XString.EMPTYSTRING;
            }
            DTM dtm = xctxt.getDTM(currentNode);
            return dtm.getStringValue(currentNode);
        }
        return this.m_arg0.execute(xctxt).xstr();
    }

    protected double getArg0AsNumber(XPathContext xctxt) throws TransformerException {
        if (null == this.m_arg0) {
            int currentNode = xctxt.getCurrentNode();
            if (-1 == currentNode) {
                return 0.0;
            }
            DTM dtm = xctxt.getDTM(currentNode);
            XString str = dtm.getStringValue(currentNode);
            return str.toDouble();
        }
        return this.m_arg0.execute(xctxt).num();
    }

    @Override
    public void checkNumberArgs(int argNum) throws WrongNumberArgsException {
        if (argNum > 1) {
            this.reportWrongNumberArgs();
        }
    }

    @Override
    protected void reportWrongNumberArgs() throws WrongNumberArgsException {
        throw new WrongNumberArgsException(XPATHMessages.createXPATHMessage("ER_ZERO_OR_ONE", null));
    }

    @Override
    public boolean canTraverseOutsideSubtree() {
        return null != this.m_arg0 && super.canTraverseOutsideSubtree();
    }
}

