/*
 * Decompiled with CFR 0.152.
 */
package org.archive.format.gzip;

import com.google.common.io.CountingOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.archive.format.gzip.GZIPConstants;
import org.archive.format.gzip.GZIPFooter;
import org.archive.format.gzip.GZIPHeader;
import org.archive.util.StreamCopy;
import org.archive.util.io.CRCInputStream;

public class GZIPMemberWriter
implements GZIPConstants {
    private static final int MAX_RAM_BUFFER = 0x100000;
    private byte[] slRecordName = SL_RECORD;
    public int maxBuffer = 0x100000;
    private CountingOutputStream out;

    public GZIPMemberWriter(OutputStream out) {
        this.out = new CountingOutputStream(out);
    }

    public void write(InputStream is) throws IOException {
        CRCInputStream crc = new CRCInputStream(is);
        GZIPHeader gzHeader = new GZIPHeader();
        gzHeader.writeBytes((OutputStream)this.out);
        Deflater deflater = new Deflater(-1, true);
        DeflaterOutputStream deflateOut = new DeflaterOutputStream((OutputStream)this.out, deflater);
        StreamCopy.copy(crc, deflateOut);
        deflateOut.finish();
        GZIPFooter gzFooter = new GZIPFooter(crc.getCRCValue(), crc.getByteCount());
        gzFooter.writeBytes((OutputStream)this.out);
        this.out.flush();
    }

    public long getBytesWritten() {
        return this.out.getCount();
    }
}

