/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.metrics;

import com.tdunning.math.stats.TDigest;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

public class LatencyTracker {
    private static final double DEFAULT_COMPRESSION = 100.0;
    private final TDigest digest = TDigest.createDigest((double)100.0);
    private final String group;
    private final String prefix;
    private long count = 0L;
    private long sum = 0L;

    public LatencyTracker(String group, String prefix) {
        this.group = group;
        this.prefix = prefix;
    }

    public void record(long latencyMs) {
        this.digest.add((double)latencyMs);
        ++this.count;
        this.sum += latencyMs;
    }

    public long getCount() {
        return this.count;
    }

    public long getSum() {
        return this.sum;
    }

    public long getPercentile(double quantile) {
        if (this.count == 0L) {
            return 0L;
        }
        return (long)this.digest.quantile(quantile);
    }

    public void emitCounters(TaskInputOutputContext<?, ?, ?, ?> context) {
        context.getCounter(this.group, this.prefix + "_count_total").setValue(this.count);
        context.getCounter(this.group, this.prefix + "_sum_ms").setValue(this.sum);
        if (this.count > 0L) {
            context.getCounter(this.group, this.prefix + "_p50_ms").setValue((long)this.digest.quantile(0.5));
            context.getCounter(this.group, this.prefix + "_p95_ms").setValue((long)this.digest.quantile(0.95));
            context.getCounter(this.group, this.prefix + "_p99_ms").setValue((long)this.digest.quantile(0.99));
        } else {
            context.getCounter(this.group, this.prefix + "_p50_ms").setValue(0L);
            context.getCounter(this.group, this.prefix + "_p95_ms").setValue(0L);
            context.getCounter(this.group, this.prefix + "_p99_ms").setValue(0L);
        }
    }
}

