/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.myfaces.tobago.model.SortedColumn;

public class SortedColumnList
implements Serializable {
    private final int max;
    private final boolean showNumbers;
    private final List<SortedColumn> list;
    private int toBeSortedLevel;

    public SortedColumnList(int max) {
        this.max = Math.max(max, 1);
        this.showNumbers = max > 1;
        this.list = new ArrayList<SortedColumn>(max);
        this.toBeSortedLevel = 0;
    }

    public boolean isEmpty() {
        return this.list.size() == 0;
    }

    public SortedColumn getFirst() {
        return this.list.size() > 0 ? this.list.get(0) : null;
    }

    public void updateSortState(String columnId) {
        if (this.getFirst() != null && Objects.equals(this.getFirst().getId(), columnId)) {
            this.getFirst().toggle();
            this.toBeSortedLevel = Math.max(1, this.toBeSortedLevel);
        } else {
            int index = this.indexOf(columnId);
            if (index >= 0) {
                this.list.remove(index);
                --this.toBeSortedLevel;
            }
            this.list.add(0, new SortedColumn(columnId, true));
            ++this.toBeSortedLevel;
            this.checkSize();
        }
    }

    @Deprecated(since="5.3.0", forRemoval=true)
    public void add(String columnId, boolean ascending) {
        this.list.add(new SortedColumn(columnId, ascending));
        ++this.toBeSortedLevel;
        this.checkSize();
    }

    public SortedColumn get(int index) {
        return this.list.get(index);
    }

    private void checkSize() {
        while (this.size() > this.max) {
            this.list.remove(this.size() - 1);
        }
        if (this.toBeSortedLevel > this.max) {
            this.toBeSortedLevel = this.max;
        }
    }

    public int size() {
        return this.list.size();
    }

    public void clear() {
        this.list.clear();
    }

    public void sorted() {
        this.toBeSortedLevel = 0;
    }

    public int indexOf(String id) {
        for (int i = 0; i < this.size(); ++i) {
            SortedColumn sortedColumn = this.list.get(i);
            if (!Objects.equals(sortedColumn.getId(), id)) continue;
            return i;
        }
        return -1;
    }

    public boolean isShowNumbers() {
        return this.showNumbers;
    }

    public int getToBeSortedLevel() {
        return this.toBeSortedLevel;
    }

    @Deprecated(since="5.9.1", forRemoval=true)
    public void setToBeSortedLevel(int toBeSortedLevel) {
        this.toBeSortedLevel = toBeSortedLevel;
    }
}

