/*
 * Decompiled with CFR 0.152.
 */
package ucar.httpservices;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import org.apache.http.auth.AuthScope;
import org.apache.http.client.CredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.httpservices.Escape;
import ucar.httpservices.HTTPAuthScope;
import ucar.httpservices.HTTPException;
import ucar.httpservices.HTTPSSLProvider;
import ucar.httpservices.HTTPSession;

public class HTTPAuthStore
implements Serializable {
    public static Logger log = LoggerFactory.getLogger(HTTPSession.class);
    public static final String DEFAULT_SCHEME = "Basic";
    public static final String ANY_PRINCIPAL = null;
    public static boolean TESTING = false;
    public static HTTPAuthStore DEFAULT = new HTTPAuthStore(true);
    protected List<Entry> rows;
    protected boolean isdefault;
    static int nwriters = 0;
    static int nreaders = 0;
    static boolean stop = false;

    static boolean equivalent(Entry e1, Entry e2) {
        if (e1 == null ^ e2 == null) {
            return false;
        }
        if (e1 == e2) {
            return true;
        }
        AuthScope a1 = e1.scope;
        AuthScope a2 = e2.scope;
        if (!HTTPAuthScope.identical(a1, a2)) {
            return false;
        }
        if (e1.principal == ANY_PRINCIPAL || e2.principal == ANY_PRINCIPAL) {
            return true;
        }
        return e1.principal.equals(e2.principal);
    }

    public static synchronized HTTPAuthStore getDefault() {
        return DEFAULT;
    }

    public HTTPAuthStore() {
        this(false);
    }

    public HTTPAuthStore(boolean isdefault) {
        String kpath;
        this.isdefault = isdefault;
        this.rows = new ArrayList<Entry>();
        if (isdefault && (kpath = System.getProperty("keystore")) != null) {
            String tpath = System.getProperty("truststore");
            String kpwd = System.getProperty("keystorepassword");
            String tpwd = System.getProperty("truststorepassword");
            kpath = kpath.trim();
            if (tpath != null) {
                tpath = tpath.trim();
            }
            if (kpwd != null) {
                kpwd = kpwd.trim();
            }
            if (tpwd != null) {
                tpwd = tpwd.trim();
            }
            if (kpath.length() == 0) {
                kpath = null;
            }
            if (tpath != null && tpath.length() == 0) {
                tpath = null;
            }
            if (kpwd != null && kpwd.length() == 0) {
                kpwd = null;
            }
            if (tpwd != null && tpwd.length() == 0) {
                tpwd = null;
            }
            HTTPSSLProvider creds = new HTTPSSLProvider(kpath, kpwd, tpath, tpwd);
            try {
                AuthScope scope = new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "SSL");
                this.insert(new Entry(ANY_PRINCIPAL, scope, creds));
            }
            catch (HTTPException he) {
                log.error("HTTPAuthStore: could not insert default SSL data");
            }
        }
    }

    public synchronized CredentialsProvider insert(String principal, AuthScope scope, CredentialsProvider provider) throws HTTPException {
        return this.insert(new Entry(principal, scope, provider));
    }

    public synchronized CredentialsProvider insert(Entry entry) throws HTTPException {
        Entry found = null;
        if (entry == null) {
            throw new HTTPException("HTTPAuthStore.insert: invalid entry: " + entry);
        }
        for (Entry e : this.rows) {
            if (!HTTPAuthStore.equivalent(e, entry)) continue;
            found = e;
            break;
        }
        CredentialsProvider old = null;
        if (found != null) {
            old = entry.provider;
            found.provider = entry.provider;
        } else {
            Entry newentry = new Entry(ANY_PRINCIPAL, entry.scope, entry.provider);
            this.rows.add(newentry);
        }
        return old;
    }

    public synchronized Entry remove(Entry entry) throws HTTPException {
        Entry found = null;
        if (entry == null) {
            throw new HTTPException("HTTPAuthStore.remove: invalid entry: " + entry);
        }
        for (Entry e : this.rows) {
            if (!HTTPAuthStore.equivalent(e, entry)) continue;
            found = e;
            break;
        }
        if (found != null) {
            this.rows.remove(found);
        }
        return found;
    }

    public synchronized void clear() {
        this.rows.clear();
    }

    public synchronized List<Entry> getAllRows() {
        return this.rows;
    }

    public synchronized List<Entry> search(String principal, AuthScope scope) {
        List<Object> matches = this.isdefault || DEFAULT == null ? new ArrayList() : DEFAULT.search(principal, scope);
        if (scope == null || this.rows.size() == 0) {
            return matches;
        }
        for (Entry e : this.getAllRows()) {
            if (principal != ANY_PRINCIPAL && e.principal.equals(principal) || !HTTPAuthScope.equivalent(scope, e.scope)) continue;
            matches.add(e);
        }
        Collections.sort(matches);
        return matches;
    }

    private void acquirewriteaccess() throws HTTPException {
        ++nwriters;
        while (nwriters > 1) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                if (!stop) continue;
                throw new HTTPException("interrupted");
            }
        }
        while (nreaders > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                if (!stop) continue;
                throw new HTTPException("interrupted");
            }
        }
    }

    private void releasewriteaccess() {
        --nwriters;
        this.notify();
    }

    private void acquirereadaccess() throws HTTPException {
        ++nreaders;
        while (nwriters > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                if (!stop) continue;
                throw new HTTPException("interrupted");
            }
        }
    }

    private void releasereadaccess() {
        if (--nreaders == 0) {
            this.notify();
        }
    }

    public void print(PrintStream p) throws IOException {
        this.print(new PrintWriter((Writer)new OutputStreamWriter((OutputStream)p, Escape.utf8Charset), true));
    }

    public void print(PrintWriter p) throws IOException {
        List<Entry> elist = this.getAllRows();
        for (int i = 0; i < elist.size(); ++i) {
            Entry e = elist.get(i);
            p.printf("[%02d] %s%n", i, e.toString());
        }
    }

    public synchronized void serialize(OutputStream ostream, String password) throws HTTPException {
        try {
            byte[] deskey = password.getBytes(Escape.utf8Charset);
            DESKeySpec desKeySpec = new DESKeySpec(deskey);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey secretKey = keyFactory.generateSecret(desKeySpec);
            Cipher desCipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
            desCipher.init(1, secretKey);
            BufferedOutputStream bos = new BufferedOutputStream(ostream);
            CipherOutputStream cos = new CipherOutputStream(bos, desCipher);
            ObjectOutputStream oos = new ObjectOutputStream(cos);
            oos.writeInt(this.getAllRows().size());
            for (Entry e : this.getAllRows()) {
                oos.writeObject(e);
            }
            oos.flush();
            oos.close();
        }
        catch (Exception e) {
            throw new HTTPException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deserialize(InputStream istream, String password) throws HTTPException {
        ObjectInputStream ois = null;
        try {
            ois = HTTPAuthStore.openobjectstream(istream, password);
            List<Entry> entries = HTTPAuthStore.getDeserializedEntries(ois);
            for (Entry e : entries) {
                this.insert(e);
            }
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static ObjectInputStream openobjectstream(InputStream istream, String password) throws HTTPException {
        try {
            byte[] key = password.getBytes(Escape.utf8Charset);
            DESKeySpec desKeySpec = new DESKeySpec(key);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey secretKey = keyFactory.generateSecret(desKeySpec);
            Cipher desCipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
            desCipher.init(2, secretKey);
            BufferedInputStream bis = new BufferedInputStream(istream);
            CipherInputStream cis = new CipherInputStream(bis, desCipher);
            ObjectInputStream ois = new ObjectInputStream(cis);
            return ois;
        }
        catch (Exception e) {
            throw new HTTPException(e);
        }
    }

    public static HTTPAuthStore getDeserializedStore(ObjectInputStream ois) throws HTTPException {
        List<Entry> entries = HTTPAuthStore.getDeserializedEntries(ois);
        HTTPAuthStore store = new HTTPAuthStore();
        store.rows = entries;
        return store;
    }

    protected static List<Entry> getDeserializedEntries(ObjectInputStream ois) throws HTTPException {
        try {
            ArrayList<Entry> entries = new ArrayList<Entry>();
            int count = ois.readInt();
            for (int i = 0; i < count; ++i) {
                Entry e = (Entry)ois.readObject();
                entries.add(e);
            }
            return entries;
        }
        catch (Exception e) {
            throw new HTTPException(e);
        }
    }

    public static class Entry
    implements Serializable,
    Comparable<Entry> {
        public String principal;
        public AuthScope scope;
        public CredentialsProvider provider;

        public Entry(String principal, AuthScope scope, CredentialsProvider provider) {
            this.principal = principal;
            this.scope = scope;
            this.provider = provider;
        }

        public String toString() {
            String p = this.principal == ANY_PRINCIPAL ? "*" : this.principal;
            return String.format("%s@%s{%s}", p, this.scope.toString(), this.provider.toString());
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            oos.writeObject(this.principal);
            HTTPAuthScope.serializeScope(this.scope, oos);
            if (this.provider instanceof Serializable) {
                oos.writeObject(this.provider);
            } else {
                oos.writeObject(this.provider.getClass());
            }
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            try {
                this.principal = (String)ois.readObject();
                this.scope = HTTPAuthScope.deserializeScope(ois);
                Object o = ois.readObject();
                this.provider = o instanceof Class ? (CredentialsProvider)((Class)o).newInstance() : (CredentialsProvider)o;
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        @Override
        public int compareTo(Entry e2) {
            Entry e1 = this;
            if (e1 == null || e2 == null || e1.scope == null || e2.scope == null) {
                throw new NullPointerException();
            }
            String p1 = e1.principal;
            String p2 = e2.principal;
            if (p1 == ANY_PRINCIPAL || p2 == ANY_PRINCIPAL) {
                return 0;
            }
            return p1.compareTo(p2);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            return this.compareTo((Entry)o) == 0;
        }

        public int hashCode() {
            return this.principal.hashCode();
        }
    }
}

