/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.StringTokenizer;
import opennlp.tools.ml.model.Event;
import opennlp.tools.util.ObjectStream;

public class FileEventStream
implements ObjectStream<Event> {
    protected final BufferedReader reader;

    public FileEventStream(String fileName, String encoding) throws IOException {
        this(encoding == null ? new FileReader(fileName) : new InputStreamReader((InputStream)new FileInputStream(fileName), encoding));
    }

    public FileEventStream(String fileName) throws IOException {
        this(fileName, null);
    }

    public FileEventStream(Reader reader) throws IOException {
        this.reader = new BufferedReader(reader);
    }

    public FileEventStream(File file) throws IOException {
        this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
    }

    @Override
    public Event read() throws IOException {
        String line = this.reader.readLine();
        if (line != null) {
            StringTokenizer st = new StringTokenizer(line);
            String outcome = st.nextToken();
            int count = st.countTokens();
            String[] context = new String[count];
            for (int ci = 0; ci < count; ++ci) {
                context[ci] = st.nextToken();
            }
            return new Event(outcome, context);
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public static String toLine(Event event) {
        StringBuilder sb = new StringBuilder();
        sb.append(event.getOutcome());
        String[] context = event.getContext();
        int cl = context.length;
        for (int ci = 0; ci < cl; ++ci) {
            sb.append(" ").append(context[ci]);
        }
        sb.append(System.getProperty("line.separator"));
        return sb.toString();
    }

    @Override
    public void reset() throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

